/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.extension.CSmart;
import constraints.extension.Extension;
import constraints.extension.structures.Table;
import constraints.extension.structures.TableSmart;
import constraints.intension.Intension;
import dashboard.Control;
import dashboard.Input;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.TreeEvaluator;
import problem.Problem;
import problem.Remodeler;
import utility.Kit;
import variables.Variable;

public final class Features {
    private final Problem problem;
    public final List<Variable> collectedVarsAtInit = new ArrayList<Variable>();
    public final List<Constraint> collectedCtrsAtInit = new ArrayList<Constraint>();
    public final Map<String, String> collectedTuples = new HashMap<String, String>();
    protected final Repartitioner<Integer> varDegrees;
    protected final Repartitioner<Integer> domSizes;
    protected final Repartitioner<Integer> ctrArities;
    protected final Repartitioner<Integer> tableSizes;
    protected final Repartitioner<String> ctrTypes;
    public int nIsolatedVars;
    public int nFixedVars;
    public int nSymbolicVars;
    public int nRemovedUnaryCtrs;
    public int nConvertedConstraints;
    public int nSpecificCtrs;
    public int nMergedCtrs;
    public int nDiscardedCtrs;
    public int nAddedCtrs;
    public long nEffectiveFilterings;
    public int nSharedBinaryRepresentations;
    private Map<String, String> mapForAutomorphismIdentification = new LinkedHashMap<String, String>();
    private Map<String, String> mapForAllDifferentIdentification = new LinkedHashMap<String, String>();
    public TreeEvaluator.ExternFunctionArity1 externFunctionArity1;
    public TreeEvaluator.ExternFunctionArity2 externFunctionArity2;
    public int nValuesRemovedAtConstructionTime;
    private Set<String> discardedVars = new HashSet<String>();

    public final boolean mustDiscard(IVar x) {
        boolean mustDiscard;
        Object[] selectedVars = this.problem.head.control.variables.selectedVars;
        if (selectedVars.length == 0) {
            return false;
        }
        int num = this.collectedVarsAtInit.size() + this.discardedVars.size();
        boolean bl = mustDiscard = Arrays.binarySearch(selectedVars, selectedVars[0] instanceof Integer ? Integer.valueOf(num) : x.id()) < 0;
        if (mustDiscard) {
            this.discardedVars.add(x.id());
        }
        return mustDiscard;
    }

    public final boolean mustDiscard(IVar[] scp) {
        if (this.problem.head.control.variables.selectedVars.length == 0) {
            return false;
        }
        boolean mustDiscard = Stream.of(scp).map(x -> x.id()).anyMatch(id -> this.discardedVars.contains(id));
        if (mustDiscard) {
            ++this.nDiscardedCtrs;
        }
        return mustDiscard;
    }

    public int nDomTypes() {
        return (int)Stream.of(this.problem.variables).mapToInt(x -> x.dom.typeIdentifier()).distinct().count();
    }

    private void printNumber(int n) {
        if (this.problem.head.control.general.verbose > 1) {
            int nDigits = (int)Math.log10(n) + 1;
            IntStream.range(0, nDigits).forEach(i -> System.out.print("\b"));
            System.out.print(n + 1 + "");
        }
    }

    public final int addCollectedVariable(Variable x) {
        if (this.collectedVarsAtInit.isEmpty()) {
            System.out.print("  Loading variables...");
        }
        this.printNumber(this.collectedVarsAtInit.size());
        int num = this.collectedVarsAtInit.size();
        this.collectedVarsAtInit.add(x);
        this.domSizes.add(x.dom.initSize());
        return num;
    }

    public final int addCollectedConstraint(Constraint c) {
        if (this.collectedCtrsAtInit.isEmpty()) {
            System.out.println("\n  Loading constraints...");
        }
        this.printNumber(this.collectedCtrsAtInit.size());
        int num = this.collectedCtrsAtInit.size();
        this.collectedCtrsAtInit.add(c);
        this.ctrArities.add(c.scp.length);
        if (c.scp.length == 1 && !(c instanceof Extension.Extension1)) {
            if (c instanceof Extension || c instanceof Intension) {
                this.ctrTypes.add(c.getClass().getSimpleName() + "1");
            }
        } else {
            this.ctrTypes.add(c.getClass().getSimpleName() + (c instanceof Extension ? "-" + c.extStructure().getClass().getSimpleName() : ""));
        }
        if (c instanceof CSmart) {
            this.tableSizes.add(((TableSmart)c.extStructure()).smartTuples.length);
        }
        if (c instanceof Extension && c.extStructure() instanceof Table) {
            this.tableSizes.add(((Table)c.extStructure()).tuples.length);
        }
        return num;
    }

    public int maxDomSize() {
        return this.domSizes.last();
    }

    public int maxVarDegree() {
        return this.varDegrees.last();
    }

    public int minCtrArity() {
        return this.ctrArities.first();
    }

    public int maxCtrArity() {
        return this.ctrArities.last();
    }

    protected Features(Problem problem) {
        this.problem = problem;
        boolean verbose = problem.head.control.general.verbose > 1;
        this.varDegrees = new Repartitioner(verbose);
        this.domSizes = new Repartitioner(verbose);
        this.ctrArities = new Repartitioner(verbose);
        this.ctrTypes = new Repartitioner(true);
        this.tableSizes = new Repartitioner(verbose);
    }

    public boolean hasSharedExtensionStructures() {
        return Stream.of(this.problem.constraints).anyMatch(c -> c.extStructure() != null && c.extStructure().firstRegisteredCtr() != c);
    }

    public boolean hasSharedConflictsStructures() {
        return Stream.of(this.problem.constraints).anyMatch(c -> c.conflictsStructure != null && c.conflictsStructure.firstRegisteredCtr() != c);
    }

    protected void addToMapForAutomorphismIdentification(Remodeler.DeducingAutomorphism automorphismIdentification) {
        automorphismIdentification.putInMap(this.mapForAutomorphismIdentification);
    }

    protected void addToMapForAllDifferentIdentification(Remodeler.DeducingAllDifferent dad) {
        this.mapForAllDifferentIdentification.put("nCliques", dad.nBuiltCliques + "");
    }

    public MapAtt instanceAttributes(int instanceNumber) {
        MapAtt m = new MapAtt("Instance");
        m.put("name", this.problem.name());
        m.putIf("number", instanceNumber, Input.nInstancesToSolve > 1);
        Control.SettingVars settings = this.problem.head.control.variables;
        if (settings.selectedVars.length > 0 || settings.instantiatedVars.length > 0 || settings.priorityVars.length > 0) {
            m.separator();
            m.putIf("selection", Stream.of(settings.selectedVars).map(o -> o.toString()).collect(Collectors.joining(",")), settings.selectedVars.length > 0);
            m.putIf("instantiation", IntStream.range(0, settings.instantiatedVars.length).mapToObj(i -> settings.instantiatedVars[i] + "=" + settings.instantiatedVals[i]).collect(Collectors.joining(",")), settings.instantiatedVars.length > 0);
            m.putIf("priority", Stream.of(settings.priorityVars).map(o -> o.toString()).collect(Collectors.joining(",")), settings.priorityVars.length > 0);
            m.putWhenPositive("nStrictPriorityVars", settings.nStrictPriorityVars);
        }
        return m;
    }

    public MapAtt domainsAttributes() {
        MapAtt m = new MapAtt("Domains");
        m.put("nTypes", this.nDomTypes());
        m.put("nValues", Variable.nValidValuesFor(this.problem.variables));
        m.putWhenPositive("nRemovedValuesAtConstruction", this.nValuesRemovedAtConstructionTime);
        m.putWhenPositive("nPurged", this.problem.nValuesRemoved);
        m.put("sizes", this.domSizes);
        return m;
    }

    public MapAtt variablesAttributes() {
        MapAtt m = new MapAtt("Variables");
        m.put("count", this.problem.variables.length);
        m.putWhenPositive("nDiscarded", this.discardedVars.size());
        m.putWhenPositive("nIsolated", this.nIsolatedVars);
        m.putWhenPositive("nFixed", this.nFixedVars);
        m.putWhenPositive("nSymb", this.nSymbolicVars);
        m.putWhenPositive("nAux", this.problem.nAuxVariables);
        m.put("degrees", this.varDegrees);
        return m;
    }

    public MapAtt ctrsAttributes() {
        MapAtt m = new MapAtt("Constraints");
        m.put("count", this.problem.constraints.length);
        m.putWhenPositive("nRemovedUnary", this.nRemovedUnaryCtrs);
        m.putWhenPositive("nConverted", this.nConvertedConstraints);
        m.putWhenPositive("nSpecific", this.nSpecificCtrs);
        m.putWhenPositive("nMerged", this.nMergedCtrs);
        m.putWhenPositive("nDiscarded", this.nDiscardedCtrs);
        m.putWhenPositive("nAdded", this.nAddedCtrs);
        m.put("arities", this.ctrArities);
        m.putIf("distribution", this.ctrTypes, true, true);
        if (((Repartitioner)this.tableSizes).repartition.size() > 0) {
            m.separator();
            m.put("tables", this.tableSizes);
            m.put("nTotalTuples", this.tableSizes.cumulatedSum());
        }
        m.putIf("automorphism", this.mapForAutomorphismIdentification.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(" ")), this.mapForAutomorphismIdentification.size() > 0, true);
        m.putIf("alldiffIdent", this.mapForAllDifferentIdentification.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(" ")), this.mapForAllDifferentIdentification.size() > 0, true);
        int nConflictsStructures = 0;
        int nSharedConflictsStructures = 0;
        int nUnbuiltConflictsStructures = 0;
        int nExtensionStructures = 0;
        int nSharedExtensionStructures = 0;
        int nEvaluationManagers = 0;
        int nSharedEvaluationManagers = 0;
        for (Constraint c : this.problem.constraints) {
            if (c instanceof Extension) {
                if (c.extStructure().firstRegisteredCtr() == c) {
                    ++nExtensionStructures;
                } else {
                    ++nSharedExtensionStructures;
                }
            }
            if (c instanceof Intension) {
                if (((Intension)c).treeEvaluator.firstRegisteredCtr() == c) {
                    ++nEvaluationManagers;
                } else {
                    ++nSharedEvaluationManagers;
                }
            }
            if (c.conflictsStructure == null) {
                ++nUnbuiltConflictsStructures;
                continue;
            }
            if (c.conflictsStructure.firstRegisteredCtr() == c) {
                ++nConflictsStructures;
                continue;
            }
            ++nSharedConflictsStructures;
        }
        if (nExtensionStructures > 0 || nEvaluationManagers > 0 || nConflictsStructures > 0 || this.nSharedBinaryRepresentations > 0) {
            m.separator();
            m.putIf("nExtStructures", "(" + nExtensionStructures + ",shared:" + nSharedExtensionStructures + ")", nExtensionStructures > 0);
            m.putIf("nIntStructures", "(" + nEvaluationManagers + ",shared:" + nSharedEvaluationManagers + ")", nEvaluationManagers > 0);
            m.putIf("nCftStructures", "(" + nConflictsStructures + ",shared:" + nSharedConflictsStructures + (nUnbuiltConflictsStructures > 0 ? ",unbuilt:" + nUnbuiltConflictsStructures : "") + ")", nConflictsStructures > 0);
            m.putWhenPositive("sharedBins", this.nSharedBinaryRepresentations);
        }
        m.separator();
        m.put("wck", this.problem.head.instanceStopwatch.wckTimeInSeconds());
        m.put("cpu", this.problem.head.stopwatch.cpuTimeInSeconds());
        m.put("mem", Kit.memoryInMb());
        return m;
    }

    public MapAtt objsAttributes() {
        MapAtt m = new MapAtt("Objective");
        m.put("way", (this.problem.optimizer.minimization ? Types.TypeOptimization.MINIMIZE : Types.TypeOptimization.MAXIMIZE).shortName());
        Kit.control(this.problem.optimizer.ctr != null);
        m.put("type", this.problem.optimizer.ctr.getClass().getSimpleName());
        m.put("bounds", this.problem.optimizer.clb.limit() + ".." + this.problem.optimizer.cub.limit());
        return m;
    }

    public static class MapAtt {
        public static final String SEPARATOR = "separator";
        private String name;
        private List<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>();

        public MapAtt(String name) {
            this.name = name;
        }

        public MapAtt putIf(String key, Object value, boolean condition, boolean separation) {
            if (condition) {
                if (separation) {
                    this.separator();
                }
                this.entries.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
            }
            return this;
        }

        public MapAtt putIf(String key, Object value, boolean condition) {
            return this.putIf(key, value, condition, false);
        }

        public MapAtt putWhenPositive(String key, Number value) {
            return this.putIf(key, value, value.doubleValue() > 0.0);
        }

        public MapAtt put(String key, Object value) {
            return this.putIf(key, value, true);
        }

        public MapAtt separator() {
            return this.putIf(SEPARATOR, null, true);
        }

        public List<Map.Entry<String, Object>> entries() {
            return this.entries.stream().filter(e -> e.getKey() != SEPARATOR).collect(Collectors.toCollection(ArrayList::new));
        }

        public String toString() {
            String s = (this.name.equals("Run") ? "" : "  " + Kit.preprint(this.name, "\u001b[94m") + "\n") + "  " + "  ";
            boolean sep = true;
            for (int i = 0; i < this.entries.size(); ++i) {
                Map.Entry<String, Object> e = this.entries.get(i);
                if (e.getKey() == SEPARATOR) {
                    s = s + "\n    ";
                    sep = true;
                    continue;
                }
                if (!sep) {
                    s = s + "  ";
                }
                s = s + e.getKey() + "=" + e.getValue();
                sep = false;
            }
            return s;
        }
    }

    public static class Repartitioner<T extends Comparable<? super T>> {
        private static final int DEFAULT_MAX_VALUE = 8;
        private final int maxElementsToDisplay;
        private final Map<T, Integer> repartition = new HashMap<T, Integer>();
        private List<T> sortedKeys;

        public void add(T value) {
            Integer nb;
            if (this.sortedKeys != null) {
                this.sortedKeys = null;
            }
            this.repartition.put(value, (nb = this.repartition.get(value)) == null ? 1 : nb + 1);
        }

        private void freeze() {
            Kit.control(this.sortedKeys == null);
            this.sortedKeys = new ArrayList<T>(this.repartition.keySet());
            Collections.sort(this.sortedKeys);
        }

        public T first() {
            if (this.sortedKeys == null) {
                this.freeze();
            }
            return (T)(this.sortedKeys.size() == 0 ? null : (Comparable)this.sortedKeys.get(0));
        }

        public T last() {
            if (this.sortedKeys == null) {
                this.freeze();
            }
            return (T)(this.sortedKeys.size() == 0 ? null : (Comparable)this.sortedKeys.get(this.sortedKeys.size() - 1));
        }

        public int size() {
            return this.repartition.size();
        }

        private Repartitioner(int maxElementsToDisplay) {
            this.maxElementsToDisplay = maxElementsToDisplay;
        }

        public Repartitioner(boolean verbose) {
            this(verbose ? Integer.MAX_VALUE : 8);
        }

        public Repartitioner() {
            this(8);
        }

        public long cumulatedSum() {
            return this.repartition.entrySet().stream().mapToLong(e -> (Integer)e.getValue() * (Integer)e.getKey()).sum();
        }

        public String toString() {
            if (this.sortedKeys == null) {
                this.freeze();
            }
            String SEP = "#";
            String JOIN = ",";
            if (this.sortedKeys.size() <= this.maxElementsToDisplay) {
                return "[" + this.sortedKeys.stream().map(k -> k + SEP + this.repartition.get(k)).collect(Collectors.joining(JOIN)) + "]";
            }
            String s1 = IntStream.range(0, 4).mapToObj(i -> this.sortedKeys.get(i) + SEP + this.repartition.get(this.sortedKeys.get(i))).collect(Collectors.joining(JOIN));
            String s2 = IntStream.range(this.sortedKeys.size() - 4, this.sortedKeys.size()).mapToObj(i -> this.sortedKeys.get(i) + SEP + this.repartition.get(this.sortedKeys.get(i))).collect(Collectors.joining(JOIN));
            return "[" + s1 + "..." + s2 + "]";
        }
    }
}

