/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Size;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.modeler.entities.ModelingEntity;
import org.xcsp.modeler.implementation.ProblemIMP;

public final class VarEntities {
    private ProblemIMP imp;
    public List<VarEntity> allEntities = new ArrayList<VarEntity>();
    public List<VarAlone> varAlones = new ArrayList<VarAlone>();
    public List<VarArray> varArrays = new ArrayList<VarArray>();
    public Map<IVar, VarAlone> varToVarAlone = new LinkedHashMap<IVar, VarAlone>();
    public Map<IVar, VarArray> varToVarArray = new LinkedHashMap<IVar, VarArray>();
    public Map<VarEntity, Integer> buildTimes = new HashMap<VarEntity, Integer>();

    public VarEntities(ProblemIMP imp) {
        this.imp = imp;
    }

    public void newVarAloneEntity(String id, IVar var, String note, Types.TypeClass ... classes) {
        int limit;
        VarAlone va = new VarAlone(id, var, note, classes);
        this.allEntities.add(va);
        this.varAlones.add(va);
        this.varToVarAlone.put(var, va);
        int n = limit = this.imp.stackLoops.size() > 0 ? this.imp.stackLoops.peek() : -1;
        if (limit != -1) {
            this.buildTimes.put(va, limit);
        }
    }

    public VarArray buildVarArray(String id, Size size, Object vars, String note, Types.TypeClass ... classes) {
        if (size instanceof Size.Size1D) {
            return new VarArray1D(id, (IVar[])vars, note, classes);
        }
        if (size instanceof Size.Size2D) {
            return new VarArray2D(id, (IVar[][])vars, note, classes);
        }
        if (size instanceof Size.Size3D) {
            return new VarArray3D(id, (IVar[][][])vars, note, classes);
        }
        if (size instanceof Size.Size4D) {
            return new VarArray4D(id, (IVar[][][][])vars, note, classes);
        }
        return new VarArray5D(id, (IVar[][][][][])vars, note, classes);
    }

    public void newVarArrayEntity(String id, Size size, Object vars, String note, Types.TypeClass ... classes) {
        int limit;
        VarArray va = this.buildVarArray(id, size, vars, note, classes);
        this.allEntities.add(va);
        this.varArrays.add(va);
        if (va.flatVars != null) {
            Stream.of(va.flatVars).forEach(x -> {
                VarArray varArray2 = this.varToVarArray.put((IVar)x, va);
            });
        }
        int n = limit = this.imp.stackLoops.size() > 0 ? this.imp.stackLoops.peek() : -1;
        if (limit != -1) {
            this.buildTimes.put(va, limit);
        }
    }

    private String expand(String compactForm) {
        Utilities.control(compactForm.indexOf(32) == -1, "The specified string must correspond to a single token; bad form : " + compactForm);
        if (compactForm.endsWith(")")) {
            return compactForm;
        }
        int pos = compactForm.indexOf("[");
        if (pos == -1) {
            VarAlone va = this.varAlones.stream().filter(a -> a.id.equals(compactForm)).findAny().orElse(null);
            Utilities.control(va != null, "An object VarAlone should have been found");
            return compactForm;
        }
        String prefix = compactForm.substring(0, pos);
        String suffix = compactForm.substring(pos);
        VarArray va = this.varArrays.stream().filter(a -> a.id.equals(prefix)).findAny().orElse(null);
        Utilities.control(va != null, "Pb with " + compactForm);
        ArrayList<String> list = new ArrayList<String>();
        while (suffix.length() > 0) {
            pos = suffix.indexOf("]");
            list.add(suffix.substring(1, pos));
            suffix = suffix.substring(pos + 1);
        }
        String[] tokens = list.toArray(new String[0]);
        Utilities.control(tokens.length == va.sizes.length, String.valueOf(prefix) + " ");
        int[] mins = new int[tokens.length];
        int[] maxs = new int[tokens.length];
        int[] sizes = new int[tokens.length];
        int i2 = 0;
        while (i2 < tokens.length) {
            if (tokens[i2].length() == 0) {
                mins[i2] = 0;
                maxs[i2] = va.sizes[i2] - 1;
            } else if (Utilities.isInteger(tokens[i2])) {
                mins[i2] = maxs[i2] = Integer.parseInt(tokens[i2]);
            } else {
                StringTokenizer st = new StringTokenizer(tokens[i2], "..");
                mins[i2] = Integer.parseInt(st.nextToken());
                maxs[i2] = Integer.parseInt(st.nextToken());
            }
            sizes[i2] = maxs[i2] - mins[i2] + 1;
            ++i2;
        }
        String s = "";
        EnumerationCartesian ec = new EnumerationCartesian(sizes);
        while (ec.hasNext()) {
            int[] t = ec.next();
            s = String.valueOf(s) + prefix + IntStream.range(0, t.length).mapToObj(i -> "[" + (mins[i] + t[i]) + "]").collect(Collectors.joining()) + " ";
        }
        return s.trim();
    }

    private StringBuilder handlePart(StringBuilder sb, List<IVar> list, boolean preserveOrder) {
        if (list.size() == 1) {
            return sb.append(" " + list.get(0).id());
        }
        if (list.size() == 2) {
            return sb.append(" " + list.get(0).id() + " " + list.get(1).id());
        }
        IVar[] t = (IVar[])list.stream().toArray(IVar[]::new);
        String compactFromOneArray = this.varArrays.stream().map(va -> va.compactFormOf(t)).filter(s -> s != null).findFirst().orElse(null);
        if (compactFromOneArray != null && (!preserveOrder || this.expand(compactFromOneArray).equals(Stream.of(t).map(x -> x.id()).collect(Collectors.joining(" "))))) {
            return sb.append(" " + compactFromOneArray);
        }
        if (list.size() > 0) {
            SequenceOfSuccessiveVariables sequence = null;
            for (IVar var : list) {
                if (sequence == null) {
                    sequence = new SequenceOfSuccessiveVariables(var);
                    continue;
                }
                if (sequence.canBeExtendedWith(var.id())) continue;
                sb.append(" " + sequence.toString());
                sequence = new SequenceOfSuccessiveVariables(var);
            }
            sb.append(" " + sequence.toString());
        }
        return sb;
    }

    private String compact(IVar[] vars, boolean preserveOrder) {
        Utilities.control(vars != null && vars.length > 0, "The array is empty");
        if (vars.length == 1) {
            return vars[0].id();
        }
        if (vars.length == 2) {
            return String.valueOf(vars[0].id()) + " " + vars[1].id();
        }
        StringBuilder sb = new StringBuilder();
        if (preserveOrder) {
            ArrayList<IVar> list = new ArrayList<IVar>();
            list.add(vars[0]);
            String prefix = vars[0].idPrefix();
            int i = 1;
            while (i <= vars.length) {
                if (i == vars.length || !prefix.equals(vars[i].idPrefix())) {
                    this.handlePart(sb, list, preserveOrder);
                    list.clear();
                    if (i < vars.length) {
                        list.add(vars[i]);
                        prefix = vars[i].idPrefix();
                    }
                } else {
                    list.add(vars[i]);
                }
                ++i;
            }
        } else {
            Map<String, List<IVar>> byPrefixId = Stream.of(vars).collect(Collectors.groupingBy(x -> x.idPrefix()));
            for (List<IVar> list : byPrefixId.values()) {
                this.handlePart(sb, list, preserveOrder);
            }
        }
        return sb.toString().trim();
    }

    public String compact(IVar[] vars) {
        return this.compact(vars, false);
    }

    public String compactOrdered(IVar[] vars) {
        return this.compact(vars, true);
    }

    public String[] compact(IVar[][] vars) {
        return (String[])Stream.of(vars).map(t -> this.compact((IVar[])t)).toArray(String[]::new);
    }

    public String[] compactOrdered(IVar[][] vars) {
        return (String[])Stream.of(vars).map(t -> this.compactOrdered((IVar[])t)).toArray(String[]::new);
    }

    public String compactMatrix(IVar[][] matrix) {
        String s = this.compactOrdered(Utilities.collect(IVar.class, new Object[]{matrix}));
        if (s.indexOf(" ") == -1) {
            return s;
        }
        return Stream.of(matrix).map(t -> "(" + Stream.of(t).map(x -> x.toString()).collect(Collectors.joining(",")) + ")").collect(Collectors.joining(""));
    }

    public int nVarsIn(String s) {
        return this.expand(s).split(" ").length;
    }

    private final class SequenceOfSuccessiveVariables {
        private IVar firstVar;
        private String prefix;
        private int[] starts;
        private int posMod = -1;
        private int stopMod;

        SequenceOfSuccessiveVariables(IVar var) {
            this.firstVar = var;
            String id = var.id();
            if (id.indexOf(91) != -1) {
                this.prefix = id.substring(0, id.indexOf(91));
                this.starts = Utilities.splitToInts(id.substring(id.indexOf(91)), "\\[|\\]");
            }
        }

        int differJustAt(int[] t) {
            int pos = -1;
            int i = 0;
            while (i < this.starts.length) {
                if (this.starts[i] != t[i]) {
                    if (pos == -1) {
                        pos = i;
                    } else {
                        return -1;
                    }
                }
                ++i;
            }
            return pos;
        }

        boolean canBeExtendedWith(String id) {
            if (id.indexOf(91) == -1 || this.prefix == null || !this.prefix.equals(id.substring(0, id.indexOf(91)))) {
                return false;
            }
            int[] t = Utilities.splitToInts(id.substring(id.indexOf(91)), "\\[|\\]");
            int pos = this.differJustAt(t);
            if (pos == -1) {
                return false;
            }
            if (this.posMod == -1) {
                if (t[pos] != this.starts[pos] + 1) {
                    return false;
                }
                this.posMod = pos;
                this.stopMod = t[pos];
            } else {
                if (pos != this.posMod) {
                    return false;
                }
                if (t[pos] != this.stopMod + 1) {
                    return false;
                }
                this.stopMod = t[pos];
            }
            return true;
        }

        public String toString() {
            if (this.prefix == null) {
                return this.firstVar.id();
            }
            String s = this.prefix;
            int i = 0;
            while (i < this.starts.length) {
                s = this.posMod != i ? String.valueOf(s) + "[" + this.starts[i] + "]" : (this.starts[this.posMod] == 0 && VarEntities.this.varToVarArray.get(this.firstVar) != null && this.stopMod == VarEntities.this.varToVarArray.get((Object)this.firstVar).sizes[this.posMod] - 1 ? String.valueOf(s) + "[]" : String.valueOf(s) + "[" + this.starts[i] + ".." + this.stopMod + "]");
                ++i;
            }
            return s;
        }
    }

    public final class VarAlone
    extends VarEntity {
        public final IVar var;

        protected VarAlone(String id, IVar var, String note, Types.TypeClass ... classes) {
            super(id, note, classes);
            this.var = var;
        }

        @Override
        public Types.TypeVar getType() {
            return this.var instanceof IVar.Var ? Types.TypeVar.integer : (this.var instanceof IVar.VarSymbolic ? Types.TypeVar.symbolic : null);
        }
    }

    public abstract class VarArray
    extends VarEntity {
        public final int[] sizes;
        final int[] mins;
        final int[] maxs;
        public Object vars;
        public final IVar[] flatVars;

        public String getStringSize() {
            StringBuilder sb = new StringBuilder();
            int[] nArray = this.sizes;
            int n = this.sizes.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                sb.append("[" + s + "]");
                ++n2;
            }
            return sb.toString();
        }

        public String getEmptyStringSize() {
            StringBuilder sb = new StringBuilder();
            int[] nArray = this.sizes;
            int n = this.sizes.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                sb.append("[]");
                ++n2;
            }
            return sb.toString();
        }

        @Override
        public Types.TypeVar getType() {
            return this.flatVars[0] instanceof IVar.Var ? Types.TypeVar.integer : (this.flatVars[0] instanceof IVar.VarSymbolic ? Types.TypeVar.symbolic : null);
        }

        protected VarArray(String id, int[] sizes, String note, Types.TypeClass[] classes, Object vars) {
            super(id, note, classes);
            this.sizes = sizes;
            this.mins = new int[sizes.length];
            this.maxs = new int[sizes.length];
            this.vars = vars;
            this.flatVars = Utilities.collect(IVar.class, vars);
            Utilities.control(Utilities.isRegular(vars), "Not regular arrays");
        }

        private int updateWith(int increment, int dimension, int i) {
            this.mins[dimension] = Math.min(this.mins[dimension], i);
            this.maxs[dimension] = Math.max(this.maxs[dimension], i);
            return increment;
        }

        protected void updateRanges(IVar[] t) {
            IVar[] iVarArray = t;
            int n = t.length;
            int n2 = 0;
            while (n2 < n) {
                IVar x = iVarArray[n2];
                int[] dims = Utilities.splitToInts(x.id().substring(x.id().indexOf(91)), "\\[|\\]");
                int i = 0;
                while (i < dims.length) {
                    this.updateWith(0, i, dims[i]);
                    ++i;
                }
                ++n2;
            }
        }

        protected String compactFormOf(IVar[] t) {
            assert (IntStream.range(0, t.length).noneMatch(i -> IntStream.range(i + 1, t.length).anyMatch(j -> t[i] == t[j])));
            if (this.flatVars != null && Utilities.indexOf(t[0], this.flatVars) == -1) {
                return null;
            }
            Arrays.fill(this.mins, Integer.MAX_VALUE);
            Arrays.fill(this.maxs, -1);
            this.updateRanges(t);
            int size = 1;
            int i2 = 0;
            while (i2 < this.mins.length) {
                size *= this.maxs[i2] - this.mins[i2] + 1;
                ++i2;
            }
            if (size != t.length) {
                return null;
            }
            String s = this.id;
            int i3 = 0;
            while (i3 < this.mins.length) {
                s = String.valueOf(s) + "[" + (this.mins[i3] == 0 && this.maxs[i3] == this.sizes[i3] - 1 ? "" : (this.mins[i3] == this.maxs[i3] ? String.valueOf(this.mins[i3]) : String.valueOf(this.mins[i3]) + ".." + this.maxs[i3])) + "]";
                ++i3;
            }
            return s;
        }
    }

    class VarArray1D
    extends VarArray {
        public VarArray1D(String id, IVar[] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length}, note, classes, vars);
        }
    }

    class VarArray2D
    extends VarArray {
        protected VarArray2D(String id, IVar[][] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length, vars[0].length}, note, classes, vars);
        }
    }

    class VarArray3D
    extends VarArray {
        protected VarArray3D(String id, IVar[][][] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length, vars[0].length, vars[0][0].length}, note, classes, vars);
        }
    }

    class VarArray4D
    extends VarArray {
        protected VarArray4D(String id, IVar[][][][] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length, vars[0].length, vars[0][0].length, vars[0][0][0].length}, note, classes, vars);
        }
    }

    class VarArray5D
    extends VarArray {
        protected VarArray5D(String id, IVar[][][][][] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length, vars[0].length, vars[0][0].length, vars[0][0][0].length, vars[0][0][0][0].length}, note, classes, vars);
        }
    }

    public abstract class VarEntity
    extends ModelingEntity {
        protected VarEntity(String id, String note, Types.TypeClass[] classes) {
            super(id, note, classes);
        }

        public abstract Types.TypeVar getType();
    }
}

