/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.api;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.FunctionalInterfaces;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Size;
import org.xcsp.common.Types;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.Transition;
import org.xcsp.common.structures.Transitions;
import org.xcsp.modeler.api.ProblemAPIBase;
import org.xcsp.modeler.api.ProblemAPIOnVals;
import org.xcsp.modeler.api.ProblemAPIOnVars;
import org.xcsp.modeler.api.ProblemAPISymbolic;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ObjEntities;

public interface ProblemAPI
extends ProblemAPIOnVars,
ProblemAPIOnVals,
ProblemAPISymbolic {
    public static final /* synthetic */ boolean $assertionsDisabled;

    default public Domains.Dom dom(int[] values, FunctionalInterfaces.Intx1Predicate p) {
        this.control(values.length > 0, "At least one value must be specified");
        values = IntStream.of(values).sorted().distinct().filter(v -> p == null || p.test(v)).toArray();
        return new Domains.Dom(values);
    }

    default public Domains.Dom dom(int[] values) {
        if (values == null || values.length == 0) {
            System.out.println("Empty domain when calling dom(). Is that correct?");
            return null;
        }
        return this.dom(values, null);
    }

    default public Domains.Dom dom(int value, int ... otherValues) {
        return this.dom(IntStream.range(0, otherValues.length + 1).map(i -> i == 0 ? value : otherValues[i - 1]).toArray());
    }

    default public Domains.Dom dom(Collection<Integer> values) {
        return this.dom(values.stream().mapToInt(i -> i).toArray());
    }

    default public Domains.Dom dom(IntStream values) {
        return this.dom(values.toArray());
    }

    default public Domains.Dom dom(int[][] m) {
        return this.dom(Stream.of(m).map(t -> Arrays.stream(t)).flatMapToInt(i -> i).toArray());
    }

    default public Domains.Dom dom(Range range) {
        assert (range.length() > 0);
        return range.length() == 1 ? this.dom(range.start, new int[0]) : (range.length() == 2 ? this.dom(range.start, range.start + 1) : (range.step == 1 ? new Domains.Dom(range.start, range.stop - 1) : new Domains.Dom(range.toArray())));
    }

    default public Size.Size1D size(int length) {
        this.control(length > 0, "The specified length must be strictly positive");
        return Size.Size1D.build(length);
    }

    default public Size.Size2D size(int length0, int length1) {
        this.control(length0 > 0 && length1 > 0, "The specified lengths must be strictly positive");
        return Size.Size2D.build(length0, length1);
    }

    default public Size.Size3D size(int length0, int length1, int length2) {
        this.control(length0 > 0 && length1 > 0 && length2 > 0, "The specified lengths must be strictly positive");
        return Size.Size3D.build(length0, length1, length2);
    }

    default public Size.Size4D size(int length0, int length1, int length2, int length3) {
        this.control(length0 > 0 && length1 > 0 && length2 > 0 && length3 > 0, "The specified lengths must be strictly positive");
        return Size.Size4D.build(length0, length1, length2, length3);
    }

    default public Size.Size5D size(int length0, int length1, int length2, int length3, int length4) {
        this.control(length0 > 0 && length1 > 0 && length2 > 0 && length3 > 0 && length4 > 0, "The specified lengths must be strictly positive");
        return Size.Size5D.build(length0, length1, length2, length3, length4);
    }

    default public Range range(int startInclusive, int endExclusive, int step) {
        return new Range(startInclusive, endExclusive, step);
    }

    default public Range rangeClosed(int startInclusive, int endInclusive, int step) {
        return this.range(startInclusive, endInclusive + 1, step);
    }

    default public Range range(int startInclusive, int endExclusive) {
        return new Range(startInclusive, endExclusive);
    }

    default public Range rangeClosed(int startInclusive, int endInclusive) {
        return this.range(startInclusive, endInclusive + 1);
    }

    default public Range range(int length) {
        return new Range(length);
    }

    default public IVar.Var var(String id, Domains.Dom dom, String note, Types.TypeClass ... classes) {
        IVar.Var x = this.imp().buildVarInteger(id, dom);
        if (x != null) {
            this.imp().varEntities.newVarAloneEntity(id, x, note, classes);
        }
        return x;
    }

    default public IVar.Var var(String id, Domains.Dom dom, Types.TypeClass ... classes) {
        return this.var(id, dom, (String)null, classes);
    }

    default public IVar.Var[] array(String id, Size.Size1D size, FunctionalInterfaces.IntToDom f, String note, Types.TypeClass ... classes) {
        IVar.Var[] t = this.imp().fill(id, size, f, (IVar.Var[])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, t, note, classes);
        return t;
    }

    default public IVar.Var[] array(String id, Size.Size1D size, FunctionalInterfaces.IntToDom f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[] array(String id, Size.Size1D size, Domains.Dom dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i) -> dom, note, classes);
    }

    default public IVar.Var[] array(String id, Size.Size1D size, Domains.Dom dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i) -> dom, (String)null, classes);
    }

    default public IVar.Var[][] array(String id, Size.Size2D size, FunctionalInterfaces.Intx2ToDom f, String note, Types.TypeClass ... classes) {
        IVar.Var[][] m = this.imp().fill(id, size, f, (IVar.Var[][])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, m, note, classes);
        return m;
    }

    default public IVar.Var[][] array(String id, Size.Size2D size, FunctionalInterfaces.Intx2ToDom f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[][] array(String id, Size.Size2D size, Domains.Dom dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j) -> dom, note, classes);
    }

    default public IVar.Var[][] array(String id, Size.Size2D size, Domains.Dom dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j) -> dom, (String)null, classes);
    }

    default public IVar.Var[][][] array(String id, Size.Size3D size, FunctionalInterfaces.Intx3ToDom f, String note, Types.TypeClass ... classes) {
        IVar.Var[][][] m = this.imp().fill(id, size, f, (IVar.Var[][][])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, m, note, classes);
        return m;
    }

    default public IVar.Var[][][] array(String id, Size.Size3D size, FunctionalInterfaces.Intx3ToDom f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[][][] array(String id, Size.Size3D size, Domains.Dom dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k) -> dom, note, classes);
    }

    default public IVar.Var[][][] array(String id, Size.Size3D size, Domains.Dom dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k) -> dom, (String)null, classes);
    }

    default public IVar.Var[][][][] array(String id, Size.Size4D size, FunctionalInterfaces.Intx4ToDom f, String note, Types.TypeClass ... classes) {
        IVar.Var[][][][] m = this.imp().fill(id, size, f, (IVar.Var[][][][])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, m, note, classes);
        return m;
    }

    default public IVar.Var[][][][] array(String id, Size.Size4D size, FunctionalInterfaces.Intx4ToDom f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[][][][] array(String id, Size.Size4D size, Domains.Dom dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k, int l) -> dom, note, classes);
    }

    default public IVar.Var[][][][] array(String id, Size.Size4D size, Domains.Dom dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k, int l) -> dom, (String)null, classes);
    }

    default public IVar.Var[][][][][] array(String id, Size.Size5D size, FunctionalInterfaces.Intx5ToDom f, String note, Types.TypeClass ... classes) {
        IVar.Var[][][][][] q = this.imp().fill(id, size, f, (IVar.Var[][][][][])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, q, note, classes);
        return q;
    }

    default public IVar.Var[][][][][] array(String id, Size.Size5D size, FunctionalInterfaces.Intx5ToDom f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[][][][][] array(String id, Size.Size5D size, Domains.Dom dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k, int l, int m) -> dom, note, classes);
    }

    default public IVar.Var[][][][][] array(String id, Size.Size5D size, Domains.Dom dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k, int l, int m) -> dom, (String)null, classes);
    }

    default public CtrEntities.CtrEntity ctrFalse(IVar.Var[] scp) {
        return this.extension(scp, (int[][])new int[0][], POSITIVE);
    }

    default public CtrEntities.CtrEntity ctrTrue(IVar.Var[] scp) {
        return this.extension(scp, (int[][])new int[0][], NEGATIVE);
    }

    default public CtrEntities.CtrEntity intension(XNodeParent<IVar> tree) {
        return this.imp().intension(tree);
    }

    default public XNodeParent<IVar> abs(Object operand) {
        return XNodeParent.abs(operand);
    }

    default public XNodeParent<IVar> neg(Object operand) {
        return XNodeParent.neg(operand);
    }

    default public XNodeParent<IVar> sqr(Object operand) {
        return XNodeParent.sqr(operand);
    }

    default public XNodeParent<IVar> add(Object ... operands) {
        return XNodeParent.add(operands);
    }

    default public XNodeParent<IVar> sub(Object operand1, Object operand2) {
        return XNodeParent.sub(operand1, operand2);
    }

    default public XNodeParent<IVar> mul(Object ... operands) {
        return XNodeParent.mul(operands);
    }

    default public XNodeParent<IVar> div(Object operand1, Object operand2) {
        return XNodeParent.div(operand1, operand2);
    }

    default public XNodeParent<IVar> mod(Object operand1, Object operand2) {
        return XNodeParent.mod(operand1, operand2);
    }

    default public XNodeParent<IVar> pow(Object operand1, Object operand2) {
        return XNodeParent.pow(operand1, operand2);
    }

    default public XNodeParent<IVar> min(Object ... operands) {
        return XNodeParent.min(operands);
    }

    default public XNodeParent<IVar> max(Object ... operands) {
        return XNodeParent.max(operands);
    }

    default public XNodeParent<IVar> dist(Object operand1, Object operand2) {
        return XNodeParent.dist(operand1, operand2);
    }

    default public XNodeParent<IVar> lt(Object operand1, Object operand2) {
        return XNodeParent.lt(operand1, operand2);
    }

    default public XNodeParent<IVar> le(Object operand1, Object operand2) {
        return XNodeParent.le(operand1, operand2);
    }

    default public XNodeParent<IVar> ge(Object operand1, Object operand2) {
        return XNodeParent.ge(operand1, operand2);
    }

    default public XNodeParent<IVar> gt(Object operand1, Object operand2) {
        return XNodeParent.gt(operand1, operand2);
    }

    default public XNodeParent<IVar> ne(Object ... operands) {
        return XNodeParent.ne(operands);
    }

    default public XNodeParent<IVar> eq(Object ... operands) {
        return XNodeParent.eq(operands);
    }

    default public XNode<IVar> set(Object ... operands) {
        return XNodeParent.set(operands);
    }

    default public XNode<IVar> set(int[] operands) {
        return XNodeParent.set(operands);
    }

    default public XNodeParent<IVar> in(Object var, Object set) {
        return XNodeParent.in(var, set);
    }

    default public XNodeParent<IVar> notin(Object var, Object set) {
        return XNodeParent.notin(var, set);
    }

    default public XNodeParent<IVar> not(Object operand) {
        return XNodeParent.not(operand);
    }

    default public XNodeParent<IVar> and(Object ... operands) {
        return operands.length == 1 && operands[0] instanceof Stream ? XNodeParent.and(((Stream)operands[0]).toArray()) : XNodeParent.and(operands);
    }

    default public XNodeParent<IVar> or(Object ... operands) {
        return operands.length == 1 && operands[0] instanceof Stream ? XNodeParent.or(((Stream)operands[0]).toArray()) : XNodeParent.or(operands);
    }

    default public XNodeParent<IVar> xor(Object ... operands) {
        return XNodeParent.xor(operands);
    }

    default public XNodeParent<IVar> iff(Object ... operands) {
        return XNodeParent.iff(operands);
    }

    default public XNodeParent<IVar> imp(Object operand1, Object operand2) {
        return XNodeParent.imp(operand1, operand2);
    }

    default public XNodeParent<IVar> ifThenElse(Object operand1, Object operand2, Object operand3) {
        return XNodeParent.ifThenElse(operand1, operand2, operand3);
    }

    default public XNodeParent<IVar> knightAttack(IVar x, IVar y, int order) {
        XNodeParent<IVar> rowDist = this.dist(this.div(x, order), this.div(y, order));
        XNodeParent<IVar> colDist = this.dist(this.mod(x, order), this.mod(y, order));
        return this.or(this.and(this.eq(rowDist, 1), this.eq(colDist, 2)), this.and(this.eq(rowDist, 2), this.eq(colDist, 1)));
    }

    default public XNodeParent<IVar> queenAttack(IVar x, IVar y, int order) {
        XNodeParent<IVar> rowDist = this.dist(this.div(x, order), this.div(y, order));
        XNodeParent<IVar> colDist = this.dist(this.mod(x, order), this.mod(y, order));
        return this.and(this.ne(x, y), this.or(this.eq(this.mod(x, order), this.mod(y, order)), this.eq(this.div(x, order), this.div(y, order)), this.eq(rowDist, colDist)));
    }

    default public CtrEntities.CtrEntity lessThan(Object operand1, Object operand2) {
        return this.intension(this.lt(operand1, operand2));
    }

    default public CtrEntities.CtrEntity lessEqual(Object operand1, Object operand2) {
        return this.intension(this.le(operand1, operand2));
    }

    default public CtrEntities.CtrEntity greaterEqual(Object operand1, Object operand2) {
        return this.intension(this.ge(operand1, operand2));
    }

    default public CtrEntities.CtrEntity greaterThan(Object operand1, Object operand2) {
        return this.intension(this.gt(operand1, operand2));
    }

    default public CtrEntities.CtrEntity equal(Object ... operands) {
        return this.intension(this.eq(operands));
    }

    default public CtrEntities.CtrEntity different(Object ... operands) {
        return this.intension(this.ne(operands));
    }

    @Deprecated
    default public CtrEntities.CtrEntity notEqual(Object ... operands) {
        return this.different(operands);
    }

    default public CtrEntities.CtrEntity belong(Object operand1, Object operand2) {
        return this.intension(this.in(operand1, operand2));
    }

    @Deprecated
    default public CtrEntities.CtrEntity imply(Object operand1, Object operand2) {
        return this.implication(operand1, operand2);
    }

    default public CtrEntities.CtrEntity implication(Object operand1, Object operand2) {
        return this.intension(this.imp(operand1, operand2));
    }

    default public CtrEntities.CtrEntity equivalence(Object ... operands) {
        return this.intension(this.iff(operands));
    }

    default public CtrEntities.CtrEntity conjunction(Object ... operands) {
        return this.intension(this.and(operands));
    }

    default public CtrEntities.CtrEntity disjunction(Object ... operands) {
        return this.intension(this.or(operands));
    }

    default public Stream<XNode<IVar>> treesFrom(IVar[] t, Function<IVar, XNode<IVar>> f) {
        return Stream.of(t).filter(x -> x != null).map(x -> (XNode)f.apply((IVar)x));
    }

    default public Stream<XNode<IVar>> treesFrom(IntStream stream, Function<Integer, XNode<IVar>> f) {
        return stream.mapToObj(x -> (XNode)f.apply(x));
    }

    default public Stream<XNode<IVar>> treesFrom(Collection<Integer> c, Function<Integer, XNode<IVar>> f) {
        return this.treesFrom(c.stream().filter(x -> x != null).mapToInt(i -> i), f);
    }

    default public Stream<XNode<IVar>> treesFrom(int[] t, Function<Integer, XNode<IVar>> f) {
        return this.treesFrom(IntStream.of(t), f);
    }

    default public Stream<XNode<IVar>> treesFrom(Range r, Function<Integer, XNode<IVar>> f) {
        return this.treesFrom(r.stream(), f);
    }

    default public CtrEntities.CtrAlone extension(XNodeParent<IVar> tree) {
        return this.imp().extension(tree);
    }

    default public CtrEntities.CtrAlone extensionDisjunction(List<XNodeParent<IVar>> trees) {
        return this.imp().extensionDisjunction(trees);
    }

    default public CtrEntities.CtrAlone extensionDisjunction(XNodeParent<IVar> ... trees) {
        return this.extensionDisjunction(Arrays.asList(trees));
    }

    default public CtrEntities.CtrEntity extension(IVar.Var[] scp, int[][] tuples, Boolean positive) {
        return this.imp().extension(scp, tuples, (boolean)positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var[] scp, int[] ... tuples) {
        return this.extension(scp, tuples, POSITIVE);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var[] scp, Collection<int[]> tuples, Boolean positive) {
        return this.extension(scp, (int[][])tuples.toArray((T[])new int[0][]), positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var[] scp, Collection<int[]> tuples) {
        return this.extension(scp, tuples, POSITIVE);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var[] scp, Table table) {
        return this.extension(scp, table.toArray(), table.positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var x, int[] values, Boolean positive) {
        return this.extension((IVar.Var[])this.vars(x, new IVar.Var[0]), this.dub(values), positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var x, int ... values) {
        return this.extension(x, values, POSITIVE);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var x, Table table) {
        return this.extension((IVar.Var[])this.vars(x, new IVar.Var[0]), table.toArray(), table.positive);
    }

    default public CtrEntities.CtrEntity regular(IVar.Var[] scp, Automaton automaton) {
        return this.imp().regular(scp, automaton);
    }

    default public CtrEntities.CtrEntity mdd(IVar.Var[] scp, Transitions transitions) {
        return this.imp().mdd(scp, transitions.toArray());
    }

    default public CtrEntities.CtrEntity mdd(IVar.Var[] scp, Transition[] transitions) {
        return this.imp().mdd(scp, transitions);
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.Var[] list) {
        return this.imp().allDifferent((IVar.Var[])this.imp().distinctSorted(list));
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.Var x, IVar.Var ... others) {
        return this.allDifferent((IVar.Var[])this.vars(x, new Object[]{others}));
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.Var[] ... list) {
        return this.allDifferent((IVar.Var[])this.vars(list));
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.Var[][][] list) {
        return this.allDifferent((IVar.Var[])this.vars(list));
    }

    @Deprecated
    default public CtrEntities.CtrEntity allDifferentExcept(IVar.Var[] list, int ... exceptValues) {
        return this.allDifferent(list, exceptValues);
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.Var[] list, int ... exceptValues) {
        return this.imp().allDifferent(list, exceptValues);
    }

    default public CtrEntities.CtrEntity allDifferentList(IVar.Var[] ... lists) {
        return this.imp().allDifferentList(lists);
    }

    default public CtrEntities.CtrEntity allDifferentMatrix(IVar.Var[][] matrix) {
        return this.imp().allDifferentMatrix(matrix);
    }

    default public CtrEntities.CtrEntity allDifferent(XNode<IVar>[] trees) {
        return this.imp().allDifferent(trees);
    }

    default public CtrEntities.CtrEntity allDifferent(Stream<XNode<IVar>> trees) {
        XNode[] atrees = (XNode[])trees.toArray(XNode[]::new);
        return this.imp().allDifferent(atrees);
    }

    default public CtrEntities.CtrEntity allEqual(IVar.Var ... list) {
        return this.imp().allEqual(list);
    }

    default public CtrEntities.CtrEntity allEqual(IVar.Var[][] list) {
        return this.allEqual((IVar.Var[])this.vars(list));
    }

    default public CtrEntities.CtrEntity allEqualList(IVar.Var[] ... lists) {
        return this.imp().allEqualList(lists);
    }

    default public CtrEntities.CtrEntity ordered(IVar.Var[] list, int[] lengths, Types.TypeOperatorRel operator) {
        this.control(list.length == lengths.length || list.length == lengths.length + 1, "The size of list must be the size of lengths (possibly, plus 1)");
        return this.imp().ordered(list, list.length == lengths.length ? Arrays.copyOf(lengths, list.length - 1) : lengths, operator);
    }

    default public CtrEntities.CtrEntity ordered(IVar.Var[] list, IVar.Var[] lengths, Types.TypeOperatorRel operator) {
        this.control(list.length == lengths.length || list.length == lengths.length + 1, "The size of list must be the size of lengths (possibly, plus 1)");
        return this.imp().ordered(list, list.length == lengths.length ? Arrays.copyOf(lengths, list.length - 1) : lengths, operator);
    }

    default public CtrEntities.CtrEntity ordered(IVar.Var[] list, Types.TypeOperatorRel operator) {
        return this.ordered(list, new int[list.length - 1], operator);
    }

    default public CtrEntities.CtrEntity strictlyIncreasing(IVar.Var ... list) {
        return this.ordered(list, STRICTLY_INCREASING);
    }

    default public CtrEntities.CtrEntity increasing(IVar.Var ... list) {
        return this.ordered(list, INCREASING);
    }

    default public CtrEntities.CtrEntity decreasing(IVar.Var ... list) {
        return this.ordered(list, DECREASING);
    }

    default public CtrEntities.CtrEntity strictlyDecreasing(IVar.Var ... list) {
        return this.ordered(list, STRICTLY_DECREASING);
    }

    default public CtrEntities.CtrEntity lex(IVar.Var[][] lists, Types.TypeOperatorRel operator) {
        return this.imp().lex(lists, operator);
    }

    default public CtrEntities.CtrEntity strictlyIncreasing(IVar.Var[] ... lists) {
        return this.lex(lists, STRICTLY_INCREASING);
    }

    default public CtrEntities.CtrEntity increasing(IVar.Var[] ... lists) {
        return this.lex(lists, INCREASING);
    }

    default public CtrEntities.CtrEntity decreasing(IVar.Var[] ... lists) {
        return this.lex(lists, DECREASING);
    }

    default public CtrEntities.CtrEntity strictlyDecreasing(IVar.Var[] ... lists) {
        return this.lex(lists, STRICTLY_DECREASING);
    }

    default public CtrEntities.CtrEntity lexMatrix(IVar.Var[][] matrix, Types.TypeOperatorRel operator) {
        return this.imp().lexMatrix(matrix, operator);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Condition condition) {
        return this.imp().sum(list, coeffs, condition);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Condition condition) {
        IVar.Var[] t = (IVar.Var[])this.clean(list);
        return this.sum(t, this.repeat(1, t.length), condition);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Range coeffs, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(list, this.vals(coeffs), op, limit);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(list, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(list, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Types.TypeConditionOperatorSet op, Range range) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Types.TypeConditionOperatorSet op, Range range) {
        return this.sum(list, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Types.TypeConditionOperatorSet op, int[] set) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Types.TypeConditionOperatorSet op, int[] set) {
        return this.sum(list, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Condition condition) {
        return this.imp().sum(list, coeffs, condition);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients: " + list.length + " vs " + coeffs.length);
        return this.sum(list, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Types.TypeConditionOperatorSet op, Range range) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Types.TypeConditionOperatorSet op, int[] set) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, int[] coeffs, Condition condition) {
        return this.imp().sum(trees, coeffs == null ? this.repeat(1, trees.length) : coeffs, condition);
    }

    default public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, Condition condition) {
        return this.sum(trees, null, condition);
    }

    default public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(trees, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(trees, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(trees, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, int[] coeffs, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(trees, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(Stream<XNode<IVar>> trees, int[] coeffs, Condition condition) {
        XNode[] atrees = (XNode[])trees.toArray(XNode[]::new);
        return this.sum(atrees, coeffs, condition);
    }

    default public CtrEntities.CtrEntity sum(Stream<XNode<IVar>> trees, Condition condition) {
        return this.sum(trees, null, condition);
    }

    default public CtrEntities.CtrEntity sum(Stream<XNode<IVar>> trees, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(trees, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(Stream<XNode<IVar>> trees, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(trees, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(Stream<XNode<IVar>> trees, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(trees, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(Stream<XNode<IVar>> trees, int[] coeffs, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(trees, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Condition condition) {
        return this.imp().count((IVar.Var[])this.clean(list), values, condition);
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Types.TypeConditionOperatorRel op, int limit) {
        return this.count(list, values, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int value, Types.TypeConditionOperatorRel op, int limit) {
        return this.count(list, this.vals(value), this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.count(list, values, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int value, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.count(list, this.vals(value), this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Types.TypeConditionOperatorSet op, Range range) {
        return this.count(list, values, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int value, Types.TypeConditionOperatorSet op, Range range) {
        return this.count(list, this.vals(value), this.condition(op, range));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Types.TypeConditionOperatorSet op, int[] set) {
        return this.count(list, values, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int value, Types.TypeConditionOperatorSet op, int[] set) {
        return this.count(list, this.vals(value), this.condition(op, set));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Condition condition) {
        return this.imp().count((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), condition);
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Types.TypeConditionOperatorRel op, int limit) {
        return this.count(list, values, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var value, Types.TypeConditionOperatorRel op, int limit) {
        return this.count(list, (IVar.Var[])this.vars(value, new IVar.Var[0]), this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.count(list, values, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var value, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.count(list, (IVar.Var[])this.vars(value, new IVar.Var[0]), this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Types.TypeConditionOperatorSet op, Range range) {
        return this.count(list, values, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var value, Types.TypeConditionOperatorSet op, Range range) {
        return this.count(list, (IVar.Var[])this.vars(value, new IVar.Var[0]), this.condition(op, range));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Types.TypeConditionOperatorSet op, int[] set) {
        return this.count(list, values, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var value, Types.TypeConditionOperatorSet op, int[] set) {
        return this.count(list, (IVar.Var[])this.vars(value, new IVar.Var[0]), this.condition(op, set));
    }

    default public CtrEntities.CtrEntity atLeast(IVar.Var[] list, int value, int k) {
        return this.count(list, value, GE, k);
    }

    default public CtrEntities.CtrEntity atMost(IVar.Var[] list, int value, int k) {
        return this.count(list, value, LE, k);
    }

    default public CtrEntities.CtrEntity exactly(IVar.Var[] list, int value, int k) {
        return this.count(list, value, EQ, k);
    }

    default public CtrEntities.CtrEntity among(IVar.Var[] list, int[] values, int k) {
        return this.count(list, values, EQ, k);
    }

    default public CtrEntities.CtrEntity atLeast(IVar.Var[] list, int value, IVar.Var k) {
        return this.count(list, value, GE, k);
    }

    default public CtrEntities.CtrEntity atMost(IVar.Var[] list, int value, IVar.Var k) {
        return this.count(list, value, LE, k);
    }

    default public CtrEntities.CtrEntity exactly(IVar.Var[] list, int value, IVar.Var k) {
        return this.count(list, value, EQ, k);
    }

    default public CtrEntities.CtrEntity among(IVar.Var[] list, int[] values, IVar.Var k) {
        return this.count(list, values, EQ, k);
    }

    default public CtrEntities.CtrEntity atLeast1(IVar.Var[] list, int value) {
        return this.atLeast(list, value, 1);
    }

    default public CtrEntities.CtrEntity atMost1(IVar.Var[] list, int value) {
        return this.atMost(list, value, 1);
    }

    default public CtrEntities.CtrEntity exactly1(IVar.Var[] list, int value) {
        return this.exactly(list, value, 1);
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition) {
        return this.imp().nValues(list, condition);
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorRel op, int limit) {
        return this.nValues(list, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.nValues(list, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorSet op, Range range) {
        return this.nValues(list, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorSet op, int[] set) {
        return this.nValues(list, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition, int ... exceptValues) {
        return this.imp().nValues(list, condition);
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorRel op, int limit, int ... exceptValues) {
        return this.nValues(list, this.condition(op, limit), exceptValues);
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorRel op, IVar.Var limit, int ... exceptValues) {
        return this.nValues(list, this.condition(op, limit), exceptValues);
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorSet op, Range range, int ... exceptValues) {
        return this.nValues(list, this.condition(op, range), exceptValues);
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorSet op, int[] set, int ... exceptValues) {
        return this.nValues(list, this.condition(op, set), exceptValues);
    }

    default public CtrEntities.CtrEntity notAllEqual(IVar.Var ... list) {
        return this.nValues(list, this.condition(GT, 1L));
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, ProblemAPIBase.Occurrences occurrences) {
        if (occurrences instanceof ProblemAPIBase.Occurrences.OccurrencesInt) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, this.repeat(((ProblemAPIBase.Occurrences.OccurrencesInt)occurrences).occurs, values.length));
        }
        if (occurrences instanceof ProblemAPIBase.Occurrences.OccurrencesInt1D) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, ((ProblemAPIBase.Occurrences.OccurrencesInt1D)occurrences).occurs);
        }
        if (occurrences instanceof ProblemAPIBase.Occurrences.OccurrencesIntRange) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, this.repeat(((ProblemAPIBase.Occurrences.OccurrencesIntRange)occurrences).occursMin, values.length), this.repeat(((ProblemAPIBase.Occurrences.OccurrencesIntRange)occurrences).occursMax, values.length));
        }
        if (occurrences instanceof ProblemAPIBase.Occurrences.OccurrencesIntRange1D) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, ((ProblemAPIBase.Occurrences.OccurrencesIntRange1D)occurrences).occursMin, ((ProblemAPIBase.Occurrences.OccurrencesIntRange1D)occurrences).occursMax);
        }
        return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, (IVar.Var[])this.clean(((ProblemAPIBase.Occurrences.OccurrencesVar1D)occurrences).occurs));
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, ProblemAPIBase.Occurrences occurrences) {
        return this.cardinality(list, values, false, occurrences);
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, Range values, ProblemAPIBase.Occurrences occurrences) {
        return this.cardinality(list, this.vals(values), occurrences);
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, ProblemAPIBase.Occurrences occurrences) {
        if (occurrences instanceof ProblemAPIBase.Occurrences.OccurrencesInt) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, this.repeat(((ProblemAPIBase.Occurrences.OccurrencesInt)occurrences).occurs, values.length));
        }
        if (occurrences instanceof ProblemAPIBase.Occurrences.OccurrencesInt1D) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, ((ProblemAPIBase.Occurrences.OccurrencesInt1D)occurrences).occurs);
        }
        if (occurrences instanceof ProblemAPIBase.Occurrences.OccurrencesIntRange) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, this.repeat(((ProblemAPIBase.Occurrences.OccurrencesIntRange)occurrences).occursMin, values.length), this.repeat(((ProblemAPIBase.Occurrences.OccurrencesIntRange)occurrences).occursMax, values.length));
        }
        if (occurrences instanceof ProblemAPIBase.Occurrences.OccurrencesIntRange1D) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, ((ProblemAPIBase.Occurrences.OccurrencesIntRange1D)occurrences).occursMin, ((ProblemAPIBase.Occurrences.OccurrencesIntRange1D)occurrences).occursMax);
        }
        return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, (IVar.Var[])this.clean(((ProblemAPIBase.Occurrences.OccurrencesVar1D)occurrences).occurs));
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, ProblemAPIBase.Occurrences occurs) {
        return this.cardinality(list, values, false, occurs);
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, Condition condition) {
        return this.imp().maximum((IVar.Var[])this.clean(list), condition);
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, IVar.Var value) {
        return this.maximum(list, this.condition(EQ, value));
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, ProblemAPIBase.Index index) {
        return this.imp().maximum(list, 0, index.var, index.rank);
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, int startIndex, ProblemAPIBase.Index index, Condition condition) {
        return this.imp().maximum(list, startIndex, index.var, index.rank, condition);
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, IVar.Var index, Condition condition) {
        return this.maximum(list, 0, this.index(index), condition);
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, Condition condition) {
        return this.imp().minimum(list, condition);
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, IVar.Var value) {
        return this.minimum(list, this.condition(EQ, value));
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, ProblemAPIBase.Index index) {
        return this.imp().minimum(list, 0, index.var, index.rank);
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, int startIndex, ProblemAPIBase.Index index, Condition condition) {
        return this.imp().minimum(list, startIndex, index.var, index.rank, condition);
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, IVar.Var index, Condition condition) {
        return this.minimum(list, 0, this.index(index), condition);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, Condition condition) {
        return this.imp().element(list, condition);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, int startIndex, ProblemAPIBase.Index index, Condition condition) {
        return this.imp().element(list, startIndex, index.var, index.rank, condition);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, IVar.Var index, Condition condition) {
        return this.element(list, this.startIndex(0), this.index(index), condition);
    }

    default public CtrEntities.CtrEntity element(int[] list, int startIndex, ProblemAPIBase.Index index, Condition condition) {
        return this.imp().element(list, startIndex, index.var, index.rank, condition);
    }

    default public CtrEntities.CtrEntity element(int[] list, IVar.Var index, Condition condition) {
        return this.element(list, this.startIndex(0), this.index(index), condition);
    }

    default public CtrEntities.CtrEntity element(int[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, Condition condition) {
        return this.imp().element(matrix, startRowIndex, rowIndex, startColIndex, colIndex, condition);
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex) {
        return this.imp().channel(list, startIndex);
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list) {
        return this.channel(list, this.startIndex(0));
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list1, int startIndex1, IVar.Var[] list2, int startIndex2) {
        this.control(list1.length <= list2.length, "The size of the first list must be less than or equal to the size of the second list");
        return this.imp().channel(list1, startIndex1, list2, startIndex2);
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list1, IVar.Var[] list2) {
        return this.channel(list1, this.startIndex(0), list2, this.startIndex(0));
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex, IVar.Var value) {
        return this.imp().channel(list, startIndex, value);
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list, IVar.Var value) {
        return this.channel(list, this.startIndex(0), value);
    }

    default public CtrEntities.CtrEntity stretch(IVar.Var[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        return this.imp().stretch(list, values, widthsMin, widthsMax, patterns);
    }

    default public CtrEntities.CtrEntity stretch(IVar.Var[] list, int[] values, int[] widthsMin, int[] widthsMax) {
        return this.stretch(list, values, widthsMin, widthsMax, null);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, int[] lengths, boolean zeroIgnored) {
        return this.imp().noOverlap(origins, lengths, zeroIgnored);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, int ... lengths) {
        return this.noOverlap(origins, lengths, true);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var x1, IVar.Var x2, int length1, int length2) {
        this.control(length1 > 0 && length2 > 0, "It is not relevant to have a length which is not strictly positive");
        return this.noOverlap((IVar.Var[])this.vars(x1, x2), this.vals(length1, length2));
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, IVar.Var[] lengths, boolean zeroIgnored) {
        return this.imp().noOverlap(origins, lengths, zeroIgnored);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, IVar.Var ... lengths) {
        return this.noOverlap(origins, lengths, true);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var x1, IVar.Var x2, IVar.Var length1, IVar.Var length2) {
        return this.noOverlap((IVar.Var[])this.vars(x1, x2), (IVar.Var[])this.vars(length1, length2));
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, int[][] lengths, boolean zeroIgnored) {
        return this.imp().noOverlap(origins, lengths, zeroIgnored);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, int[] ... lengths) {
        return this.noOverlap(origins, lengths, true);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, IVar.Var[][] lengths, boolean zeroIgnored) {
        return this.imp().noOverlap(origins, lengths, zeroIgnored);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, IVar.Var[] ... lengths) {
        return this.noOverlap(origins, lengths, true);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        return this.imp().cumulative(origins, lengths, ends, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, int[] heights, Condition condition) {
        return this.cumulative(origins, lengths, null, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, int[] heights, long limit) {
        return this.cumulative(origins, lengths, null, heights, this.condition(LE, limit));
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        return this.imp().cumulative(origins, lengths, ends, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, int[] heights, Condition condition) {
        return this.cumulative(origins, lengths, null, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, int[] heights, long limit) {
        return this.cumulative(origins, lengths, null, heights, this.condition(LE, limit));
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        return this.imp().cumulative(origins, lengths, ends, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] heights, Condition condition) {
        return this.cumulative(origins, lengths, null, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] heights, long limit) {
        return this.cumulative(origins, lengths, null, heights, this.condition(LE, limit));
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        return this.imp().cumulative(origins, lengths, ends, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] heights, Condition condition) {
        return this.cumulative(origins, lengths, null, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] heights, long limit) {
        return this.cumulative(origins, lengths, null, heights, this.condition(LE, limit));
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex) {
        return this.imp().circuit(list, startIndex);
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list) {
        return this.circuit(list, 0);
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, int size) {
        return this.imp().circuit(list, startIndex, size);
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, IVar.Var size) {
        return this.imp().circuit(list, startIndex, size);
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list, IVar.Var size) {
        return this.circuit(list, 0, size);
    }

    default public CtrEntities.CtrEntity clause(IVar.Var[] list, Boolean[] phases) {
        this.control(Stream.of(list).noneMatch(x -> x == null) && Stream.of(phases).noneMatch(x -> x == null), "No null values is allowed in the specified arrays.");
        return this.imp().clause(list, phases);
    }

    default public CtrEntities.CtrEntity clause(IVar.Var[] pos, IVar.Var[] neg) {
        this.control(Stream.of(pos).noneMatch(x -> x == null) && Stream.of(neg).noneMatch(x -> x == null), "No null values is allowed in the specified arrays.");
        Boolean[] phases = (Boolean[])IntStream.range(0, pos.length + neg.length).mapToObj(i -> i < pos.length).toArray(Boolean[]::new);
        return this.clause((IVar.Var[])this.vars(pos, new Object[]{neg}), phases);
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[] list, int ... values) {
        list = list == null ? list : (IVar.Var[])this.clean(list);
        this.control(list == null && values.length == 0 || list.length == values.length, "The length of list is different from the length of values");
        if (values.length == 0) {
            return this.imp().dummyConstraint("A constraint instantiation with a scope of 0 variable.");
        }
        return this.imp().instantiation(list, values);
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[] list, Range values) {
        return this.instantiation(list, values.toArray());
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[] list, IntStream values) {
        return this.instantiation(list, values.toArray());
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[] list, Collection<Integer> values) {
        return this.instantiation(list, values.stream().mapToInt(i -> i));
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[] list, int value) {
        IVar.Var[] varArray = list = list == null ? list : (IVar.Var[])this.clean(list);
        if (list == null || list.length == 0) {
            return this.imp().dummyConstraint("A constraint instantiation with a scope of 0 variable.");
        }
        return this.instantiation(list, this.repeat(value, list.length));
    }

    default public CtrEntities.CtrEntity instantiation(Stream<IVar.Var> list, IntStream values) {
        return this.instantiation((IVar.Var[])this.vars(list), values.toArray());
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[] list, int[] values, FunctionalInterfaces.Intx1Predicate p) {
        if (list == null || values == null) {
            return this.imp().dummyConstraint("A constraint instantiation with a scope of 0 variable.");
        }
        return this.instantiation(this.select(list, p), this.selectFromIndexing(values, p));
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[][] list, int[][] values, FunctionalInterfaces.Intx2Predicate p) {
        if (list == null || values == null) {
            return this.imp().dummyConstraint("A constraint instantiation with a scope of 0 variable.");
        }
        return this.instantiation(this.select(list, p), this.selectFromIndexing(values, p));
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[][][] list, int[][][] values, FunctionalInterfaces.Intx3Predicate p) {
        return this.instantiation(this.select(list, p), this.selectFromIndexing(values, p));
    }

    default public CtrEntities.CtrEntity slide(IVar[] list, Range range, IntFunction<CtrEntities.CtrEntity> template) {
        this.control(range.start == 0 && range.length() > 0, "Bad form of range");
        return this.imp().slide(list, range, template);
    }

    default public CtrEntities.CtrEntity ifThen(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2) {
        return this.imp().ifThen(c1, c2);
    }

    default public CtrEntities.CtrEntity ifThenElse(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2, CtrEntities.CtrEntity c3) {
        return this.imp().ifThenElse(c1, c2, c3);
    }

    default public ObjEntities.ObjEntity minimize(IVar x) {
        return this.imp().minimize(x);
    }

    default public ObjEntities.ObjEntity maximize(IVar x) {
        return this.imp().maximize(x);
    }

    default public ObjEntities.ObjEntity minimize(XNode<IVar> tree) {
        return this.imp().minimize(tree);
    }

    default public ObjEntities.ObjEntity maximize(XNode<IVar> tree) {
        return this.imp().maximize(tree);
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar ... list) {
        IVar[] vars = this.vars(list, new Object[0]);
        return this.imp().minimize(type, vars);
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][] list) {
        return this.minimize(type, this.vars(list));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][][] list) {
        return this.minimize(type, this.vars(list));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar ... list) {
        IVar[] vars = this.vars(list, new Object[0]);
        return this.imp().maximize(type, vars);
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][] list) {
        return this.maximize(type, this.vars(list));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][][] list) {
        return this.maximize(type, this.vars(list));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        this.control(list.length == coeffs.length, "Size of list and coeffs are different");
        return this.imp().minimize(type, list, coeffs);
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][] list, int[][] coeffs) {
        return this.minimize(type, this.vars(list), this.vals(new Object[]{coeffs}));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][] list, int[][] coeffs, FunctionalInterfaces.Intx2Predicate p) {
        return this.minimize(type, this.select(list, p), this.selectFromIndexing(coeffs, p));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][][] list, int[][][] coeffs) {
        return this.minimize(type, this.vars(list), this.vals(new Object[]{coeffs}));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][][] list, int[][][] coeffs, FunctionalInterfaces.Intx3Predicate p) {
        return this.minimize(type, this.select(list, p), this.selectFromIndexing(coeffs, p));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        this.control(list.length == coeffs.length, "Size of list and coeffs are different");
        return this.imp().maximize(type, list, coeffs);
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][] list, int[][] coeffs) {
        return this.maximize(type, this.vars(list), this.vals(new Object[]{coeffs}));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][] list, int[][] coeffs, FunctionalInterfaces.Intx2Predicate p) {
        return this.maximize(type, this.select(list, p), this.selectFromIndexing(coeffs, p));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][][] list, int[][][] coeffs) {
        return this.maximize(type, this.vars(list), this.vals(new Object[]{coeffs}));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][][] list, int[][][] coeffs, FunctionalInterfaces.Intx3Predicate p) {
        return this.maximize(type, this.select(list, p), this.selectFromIndexing(coeffs, p));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees) {
        this.control(type.generalizable(), "the specified type must be generalizable");
        return this.imp().minimize(type, trees);
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, Stream<XNode<IVar>> trees) {
        XNode[] atrees = (XNode[])trees.toArray(XNode[]::new);
        return this.minimize(type, atrees);
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        this.control(type.generalizable(), "the specified type must be generalizable");
        this.control(trees.length == coeffs.length, "Size of trees and coeffs are different");
        return this.imp().minimize(type, trees, coeffs);
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, Stream<XNode<IVar>> trees, int[] coeffs) {
        XNode[] atrees = (XNode[])trees.toArray(XNode[]::new);
        return this.minimize(type, atrees, coeffs);
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees) {
        this.control(type.generalizable(), "the specified type must be generalizable");
        return this.imp().maximize(type, trees);
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, Stream<XNode<IVar>> trees) {
        XNode[] atrees = (XNode[])trees.toArray(XNode[]::new);
        return this.maximize(type, atrees);
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        this.control(type.generalizable(), "the specified type must be generalizable");
        this.control(trees.length == coeffs.length, "Size of trees and coeffs are different");
        return this.imp().maximize(type, trees, coeffs);
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, Stream<XNode<IVar>> trees, int[] coeffs) {
        XNode[] atrees = (XNode[])trees.toArray(XNode[]::new);
        return this.maximize(type, atrees, coeffs);
    }

    public void model();

    default public void prettyDisplay(String[] values) {
    }

    default public void decisionVariables(IVar[] list) {
        this.imp().decisionVariables(list);
    }

    default public void decisionVariables(IVar[][] list) {
        this.imp().decisionVariables(this.vars(list));
    }
}

