/*
 * Decompiled with CFR 0.152.
 */
package optimization;

import dashboard.Input;
import optimization.Optimizable;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public abstract class Optimizer {
    private static Long sharedMinBound = Long.MIN_VALUE;
    private static Long sharedMaxBound = Long.MAX_VALUE;
    public final Problem problem;
    public final boolean minimization;
    public final Optimizable clb;
    public final Optimizable cub;
    public final Optimizable ctr;
    public long minBound;
    public long maxBound;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean possiblyUpdateSharedBounds() {
        if (!Input.multiThreads) {
            return false;
        }
        boolean modified = false;
        Long l = sharedMinBound;
        synchronized (l) {
            if (this.minBound > sharedMinBound) {
                sharedMinBound = this.minBound;
                modified = true;
            }
        }
        l = sharedMaxBound;
        synchronized (l) {
            if (this.maxBound < sharedMaxBound) {
                sharedMaxBound = this.maxBound;
                modified = true;
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean possiblyUpdateLocalBounds() {
        if (!Input.multiThreads) {
            return false;
        }
        boolean modified = false;
        Long l = sharedMinBound;
        synchronized (l) {
            if (sharedMinBound > this.minBound) {
                this.minBound = sharedMinBound;
                modified = true;
            }
        }
        l = sharedMaxBound;
        synchronized (l) {
            if (sharedMaxBound < this.maxBound) {
                this.maxBound = sharedMaxBound;
                modified = true;
            }
        }
        if (modified) {
            Kit.log.fine("New Bounds updated from other workers : " + this.stringBounds());
            this.problem.solver.restarter.forceRootPropagation = true;
        }
        return modified;
    }

    public Optimizer(Problem pb, Types.TypeOptimization opt, Optimizable clb, Optimizable cub) {
        this.problem = pb;
        Kit.control(opt != null && clb != null && cub != null);
        this.minimization = opt == Types.TypeOptimization.MINIMIZE;
        this.clb = clb;
        this.cub = cub;
        this.ctr = opt == Types.TypeOptimization.MINIMIZE ? cub : clb;
        this.minBound = clb.limit();
        this.maxBound = cub.limit();
    }

    public final long value() {
        assert (Variable.areAllFixed(this.problem.variables) && this.clb.objectiveValue() == this.cub.objectiveValue());
        return this.cub.objectiveValue();
    }

    protected abstract void shiftLimitWhenSuccess();

    protected abstract void shiftLimitWhenFailure();

    public void afterRun() {
        Kit.control(this.problem.head.control.general.framework == Types.TypeFramework.COP);
        if (this.problem.solver.solRecorder.lastSolutionRun == this.problem.solver.restarter.numRun) {
            if (this.minimization) {
                this.maxBound = this.problem.solver.solRecorder.bestBound - 1L;
                this.cub.limit(this.maxBound);
            } else {
                this.minBound = this.problem.solver.solRecorder.bestBound + 1L;
                this.clb.limit(this.minBound);
            }
            this.possiblyUpdateLocalBounds();
            Kit.control(this.minBound - 1L <= this.maxBound || this.problem.head.control.optimization.ub != Long.MAX_VALUE, () -> " minB=" + this.minBound + " maxB=" + this.maxBound);
            this.possiblyUpdateSharedBounds();
            if (this.minBound > this.maxBound) {
                this.problem.solver.stopping = Enums.EStopping.FULL_EXPLORATION;
            } else {
                this.shiftLimitWhenSuccess();
            }
        } else if (this.problem.solver.stopping == Enums.EStopping.FULL_EXPLORATION) {
            boolean clb_changed = this.clb.limit() != this.minBound;
            boolean cub_changed = this.cub.limit() != this.maxBound;
            Kit.control(!clb_changed || !cub_changed);
            if (!clb_changed && !cub_changed) {
                if (this.minimization) {
                    this.minBound = this.cub.limit() + 1L;
                    this.clb.limit(this.minBound);
                } else {
                    this.maxBound = this.clb.limit() - 1L;
                    this.cub.limit(this.maxBound);
                }
            } else if (cub_changed) {
                this.minBound = this.cub.limit() + 1L;
                this.clb.limit(this.minBound);
                this.cub.limit(this.maxBound);
            } else {
                this.maxBound = this.clb.limit() - 1L;
                this.cub.limit(this.maxBound);
                this.clb.limit(this.minBound);
            }
            if (this.minBound <= this.maxBound) {
                this.problem.solver.stopping = null;
                Kit.control(this.problem.features.nValuesRemovedAtConstructionTime == 0, () -> "Not handled for the moment");
                this.problem.solver.restarter.forceRootPropagation = true;
                this.problem.solver.restoreProblem();
                if (this.problem.solver.nogoodRecorder != null) {
                    this.problem.solver.nogoodRecorder.reset();
                }
                this.shiftLimitWhenFailure();
            }
        }
    }

    public final String stringBounds() {
        return (this.minBound == Long.MIN_VALUE ? "-infty" : Long.valueOf(this.minBound)) + ".." + (this.maxBound == Long.MAX_VALUE ? "+infty" : Long.valueOf(this.maxBound));
    }

    public String toString() {
        return this.minimization ? Types.TypeOptimization.MINIMIZE.shortName() + " " + this.cub : Types.TypeOptimization.MAXIMIZE.shortName() + " " + this.clb.toString();
    }

    public static final class OptimizerDichotomic
    extends Optimizer {
        public OptimizerDichotomic(Problem pb, Types.TypeOptimization opt, Optimizable clb, Optimizable cub) {
            super(pb, opt, clb, cub);
        }

        @Override
        protected void shiftLimitWhenSuccess() {
            long offset = (this.maxBound - this.minBound) / 2L;
            if (this.minimization) {
                this.cub.limit(this.maxBound - offset);
            } else {
                this.clb.limit(this.minBound + offset);
            }
        }

        @Override
        protected void shiftLimitWhenFailure() {
            long offset = (this.maxBound - this.minBound) / 2L;
            if (this.minimization) {
                this.cub.limit(this.maxBound - offset);
            } else {
                this.clb.limit(this.minBound + offset);
            }
        }
    }

    public static final class OptimizerIncreasing
    extends Optimizer {
        boolean first = true;

        public OptimizerIncreasing(Problem pb, Types.TypeOptimization opt, Optimizable clb, Optimizable cub) {
            super(pb, opt, clb, cub);
        }

        @Override
        protected void shiftLimitWhenSuccess() {
            if (this.first) {
                if (this.minimization) {
                    this.cub.limit(this.minBound);
                } else {
                    this.clb.limit(this.maxBound);
                }
            } else {
                throw new AssertionError((Object)"should never be called again");
            }
            this.first = false;
        }

        @Override
        protected void shiftLimitWhenFailure() {
            if (this.minimization) {
                this.cub.limit(this.minBound);
            } else {
                this.clb.limit(this.maxBound);
            }
        }
    }

    public static final class OptimizerDecreasing
    extends Optimizer {
        public OptimizerDecreasing(Problem pb, Types.TypeOptimization opt, Optimizable clb, Optimizable cub) {
            super(pb, opt, clb, cub);
        }

        @Override
        protected void shiftLimitWhenSuccess() {
        }

        @Override
        protected void shiftLimitWhenFailure() {
            throw new AssertionError((Object)"should not be called");
        }
    }
}

