/*
 * Decompiled with CFR 0.152.
 */
package learning;

import dashboard.Control;
import interfaces.Observers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import learning.Nogood;
import org.xcsp.common.Utilities;
import solver.DecisionRecorder;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class NogoodRecorder {
    private final Solver solver;
    private final DecisionRecorder dr;
    private final Control.SettingLearning settings;
    private Nogood[] nogoods;
    public int nNogoods;
    private final WatchCell[][] pws;
    private final WatchCell[][] nws;
    private WatchCell free;
    public final SymmetryHandler symmetryHandler;
    private int[] tmp;

    public static NogoodRecorder buildFor(Solver solver) {
        if (solver.head.control.solving.enableSearch && solver.head.control.learning.nogood != Enums.ELearningNogood.NO && solver.propagation.queue != null) {
            return new NogoodRecorder(solver);
        }
        return null;
    }

    public boolean checkValues(int[] t) {
        block0: for (int i = 0; i < this.nNogoods; ++i) {
            for (int d : this.nogoods[i].decisions) {
                int a;
                int x = this.dr.numIn(d);
                if (t[x] != (a = this.dr.idxIn(d))) continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean checkIndexes(int[] t) {
        return this.checkValues(t);
    }

    private boolean canBeWatched(int decision) {
        assert (decision != 0);
        Variable x = this.dr.varIn(decision);
        int a = this.dr.idxIn(decision);
        return decision > 0 ? x.dom.present(a) : x.dom.size() > 1 || !x.dom.present(a);
    }

    private boolean canFindAnotherWatchFor(Nogood nogood, boolean firstWatch) {
        int i;
        int[] decs = nogood.decisions;
        int start = nogood.getWatchedPosition(firstWatch);
        for (i = start + 1; i < decs.length; ++i) {
            if (nogood.isPositionWatched(i) || !this.canBeWatched(decs[i])) continue;
            this.addWatchFor(nogood, i, firstWatch);
            return true;
        }
        for (i = 0; i < start; ++i) {
            if (nogood.isPositionWatched(i) || !this.canBeWatched(decs[i])) continue;
            this.addWatchFor(nogood, i, firstWatch);
            return true;
        }
        return false;
    }

    private boolean dealWithInference(int inferenceDecision) {
        Variable x = this.dr.varIn(inferenceDecision);
        int a = this.dr.idxIn(inferenceDecision);
        this.solver.propagation.currFilteringCtr = null;
        Domain dom = x.dom;
        if (inferenceDecision > 0) {
            return dom.reduceTo(a);
        }
        return dom.removeIfPresent(a);
    }

    private boolean checkWatchesOf(WatchCell[] watchCells, int a, int watchedDecision) {
        WatchCell previous = null;
        WatchCell current = watchCells[a];
        while (current != null) {
            Nogood nogood = current.nogood;
            int watchedDecision2 = nogood.getSecondWatchedDecision(watchedDecision);
            if (!this.dr.varIn((int)watchedDecision2).dom.present(this.dr.idxIn(watchedDecision2))) {
                previous = current;
                current = current.nextCell;
                continue;
            }
            if (this.canFindAnotherWatchFor(nogood, nogood.isDecisionWatchedByFirstWatch(watchedDecision))) {
                WatchCell tmp = current.nextCell;
                if (previous == null) {
                    watchCells[a] = current.nextCell;
                } else {
                    previous.nextCell = current.nextCell;
                }
                current.nextCell = this.free;
                this.free = current;
                current = tmp;
                continue;
            }
            previous = current;
            current = current.nextCell;
            if (this.dealWithInference(nogood.getSecondWatchedDecision(watchedDecision))) continue;
            return false;
        }
        assert (this.controlWatches());
        return true;
    }

    public boolean checkWatchesOf(Variable x, int a, boolean positive) {
        return positive ? this.checkWatchesOf(this.pws[x.num], a, this.dr.positiveDecisionFor(x.num, a)) : this.checkWatchesOf(this.nws[x.num], a, this.dr.negativeDecisionFor(x.num, a));
    }

    public boolean runPropagator(Variable x) {
        return x.dom.size() != 1 || this.checkWatchesOf(x, x.dom.first(), false);
    }

    public void reset() {
        this.nNogoods = 0;
        Kit.fill(this.pws, null);
        Kit.fill(this.nws, null);
        Kit.control(this.symmetryHandler == null);
    }

    public NogoodRecorder(Solver solver) {
        this.solver = solver;
        this.dr = solver.decRecorder;
        this.settings = solver.head.control.learning;
        this.nogoods = new Nogood[this.settings.nogoodBaseLimit];
        this.pws = (WatchCell[][])Stream.of(solver.problem.variables).map(x -> new WatchCell[x.dom.initSize()]).toArray(x$0 -> new WatchCell[x$0][]);
        this.nws = (WatchCell[][])Stream.of(solver.problem.variables).map(x -> new WatchCell[x.dom.initSize()]).toArray(x$0 -> new WatchCell[x$0][]);
        this.tmp = new int[solver.problem.variables.length];
        this.symmetryHandler = this.settings.nogood == Enums.ELearningNogood.RST_SYM ? new SymmetryHandler(solver.problem.variables.length) : null;
        solver.propagation.queue.nogoodRecorder = this;
    }

    private void addWatchFor(Nogood nogood, int position, boolean firstWatch) {
        int decision = nogood.decisions[position];
        WatchCell[] cells = decision > 0 ? this.pws[this.dr.numIn(decision)] : this.nws[this.dr.numIn(decision)];
        int a = this.dr.idxIn(decision);
        if (this.free == null) {
            cells[a] = new WatchCell(nogood, cells[a]);
        } else {
            WatchCell cell = this.free;
            this.free = this.free.nextCell;
            cell.nogood = nogood;
            cell.nextCell = cells[a];
            cells[a] = cell;
        }
        nogood.setWatchedPosition(position, firstWatch);
    }

    private void addNogood(int[] decs, boolean toBeSorted) {
        if (this.nNogoods < this.nogoods.length) {
            decs = toBeSorted ? Kit.sort(decs) : decs;
            Nogood nogood = new Nogood(decs);
            this.nogoods[this.nNogoods++] = nogood;
            Nogood nogood2 = nogood;
            this.addWatchFor(nogood2, decs.length - 2, true);
            this.addWatchFor(nogood2, decs.length - 1, false);
            if (this.symmetryHandler != null) {
                this.symmetryHandler.addNogood(decs);
            }
        }
    }

    public void addNogoodsOfCurrentBranch() {
        if (!this.settings.nogood.isRstType() || this.dr.decisions.size() < 2) {
            return;
        }
        int nMetPositiveDecisions = 0;
        for (int i = 0; i <= this.dr.decisions.limit; ++i) {
            int d = this.dr.decisions.dense[i];
            if (d > 0) {
                this.tmp[nMetPositiveDecisions++] = d;
                continue;
            }
            if (nMetPositiveDecisions > 0) {
                int[] currentNogood = new int[nMetPositiveDecisions + 1];
                if (this.settings.nogood == Enums.ELearningNogood.RST_MIN && this.dr.isFailedAssignment(i)) {
                    int j;
                    boolean bottomUp = true;
                    if (bottomUp) {
                        for (j = 0; j < nMetPositiveDecisions; ++j) {
                            currentNogood[j] = this.tmp[nMetPositiveDecisions - j - 1];
                        }
                    } else {
                        for (j = 0; j < nMetPositiveDecisions; ++j) {
                            currentNogood[j] = this.tmp[j];
                        }
                    }
                    currentNogood[currentNogood.length - 1] = -d;
                    int[] minimizedNogood = this.solver.nogoodMinimizer.extractMinimalNogoodFrom(currentNogood);
                    if (minimizedNogood != null) {
                        if (minimizedNogood.length == 0) {
                            Kit.log.fine("Empty nogood => Inconistency");
                            return;
                        }
                        this.addNogood(minimizedNogood, this.symmetryHandler != null);
                    }
                } else {
                    for (int j = 0; j < nMetPositiveDecisions; ++j) {
                        currentNogood[j] = -this.tmp[j];
                    }
                    currentNogood[nMetPositiveDecisions] = d;
                    this.addNogood(currentNogood, this.symmetryHandler != null);
                }
                if (this.symmetryHandler == null) continue;
                this.symmetryHandler.handleSymmetricNaryNogoods(currentNogood);
                continue;
            }
            if (this.symmetryHandler == null) continue;
            this.symmetryHandler.handleSymmetricUnaryNogoods(d);
        }
        assert (this.controlWatches());
    }

    private boolean control(WatchCell[][] watches, boolean positive) {
        for (int i = 0; i < watches.length; ++i) {
            for (int j = 0; j < watches[i].length; ++j) {
                WatchCell cell = watches[i][j];
                while (cell != null) {
                    if (!cell.nogood.isDecisionWatched(positive ? this.dr.positiveDecisionFor(i, j) : this.dr.negativeDecisionFor(i, j))) {
                        Kit.log.warning("nogood = " + cell.nogood + " does not watch");
                        return false;
                    }
                    cell = cell.nextCell;
                }
            }
        }
        return true;
    }

    private boolean controlNogood(int wdec, Nogood nogood) {
        WatchCell firstCell;
        WatchCell cell = firstCell = wdec > 0 ? this.pws[this.dr.numIn(wdec)][this.dr.idxIn(wdec)] : this.nws[this.dr.numIn(wdec)][this.dr.idxIn(wdec)];
        while (cell != null) {
            if (cell.nogood == nogood) {
                return true;
            }
            cell = cell.nextCell;
        }
        return false;
    }

    protected boolean controlWatches() {
        if (!this.control(this.pws, true) || !this.control(this.nws, false)) {
            return false;
        }
        for (int i = 0; i < this.nNogoods; ++i) {
            if (this.nogoods[i] == null || this.controlNogood(this.nogoods[i].getWatchedDecision(true), this.nogoods[i]) && this.controlNogood(this.nogoods[i].getWatchedDecision(false), this.nogoods[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Nogoods = {\n");
        IntStream.range(0, this.nNogoods).forEach(i -> sb.append(this.nogoods[i].toString(this.dr)).append("\n"));
        return sb.append("}").toString();
    }

    private class SymmetryHandler
    implements Observers.ObserverRuns {
        private Map<Integer, Integer>[] mapOfSymmetryGroupGenerators;
        private Set<int[]>[] nogoodsSetsBySize;
        private int[][] tmps;
        private Set<Integer> decisionsToBePerformedAtNextRun = new HashSet<Integer>();
        private final int unaryLimit;
        private final int nonunaryLimit;
        private List<Integer> unaryNogoodsToHandle = new ArrayList<Integer>();
        private LinkedList<int[]> naryNogoodsToHandle = new LinkedList();

        @Override
        public void beforeRun() {
            boolean effective = false;
            for (int decision : this.decisionsToBePerformedAtNextRun) {
                Variable x = NogoodRecorder.this.dr.varIn(decision);
                int a = NogoodRecorder.this.dr.idxIn(decision);
                if (!x.dom.present(a)) continue;
                x.dom.removeElementary(a);
                Kit.log.info("Remove Unary sym nogood : " + NogoodRecorder.this.dr.stringOf(decision));
                if (x.dom.size() == 0) {
                    ((NogoodRecorder)NogoodRecorder.this).solver.stopping = Enums.EStopping.FULL_EXPLORATION;
                    break;
                }
                effective = true;
            }
            this.decisionsToBePerformedAtNextRun.clear();
            if (((NogoodRecorder)NogoodRecorder.this).solver.stopping != Enums.EStopping.FULL_EXPLORATION && effective && !((NogoodRecorder)NogoodRecorder.this).solver.propagation.runInitially()) {
                ((NogoodRecorder)NogoodRecorder.this).solver.stopping = Enums.EStopping.FULL_EXPLORATION;
            }
        }

        private SymmetryHandler(int nVariables) {
            this.mapOfSymmetryGroupGenerators = new Map[((NogoodRecorder)NogoodRecorder.this).solver.problem.symmetryGroupGenerators.size()];
            int cnt = 0;
            for (List<int[]> generator : ((NogoodRecorder)NogoodRecorder.this).solver.problem.symmetryGroupGenerators) {
                this.mapOfSymmetryGroupGenerators[cnt] = new HashMap<Integer, Integer>();
                HashMap<Integer, Integer> map = this.mapOfSymmetryGroupGenerators[cnt];
                for (int[] cycle : generator) {
                    for (int i = 0; i < cycle.length; ++i) {
                        map.put(cycle[i], cycle[(i + 1) % cycle.length]);
                    }
                }
                ++cnt;
            }
            this.nogoodsSetsBySize = new TreeSet[nVariables + 1];
            this.tmps = new int[nVariables + 1][];
            this.unaryLimit = ((NogoodRecorder)NogoodRecorder.this).settings.unarySymmetryLimit;
            this.nonunaryLimit = ((NogoodRecorder)NogoodRecorder.this).settings.nonunarySymmetryLimit;
        }

        private void addNogood(int[] decs) {
            assert (NogoodRecorder.this.nNogoods < NogoodRecorder.this.nogoods.length);
            (this.nogoodsSetsBySize[decs.length] == null ? (this.nogoodsSetsBySize[decs.length] = new TreeSet<int[]>(Utilities.lexComparatorInt)) : this.nogoodsSetsBySize[decs.length]).add(decs);
        }

        private void handleSymmetricUnaryNogoods(int decision) {
            this.unaryNogoodsToHandle.clear();
            this.unaryNogoodsToHandle.add(decision);
            for (int i = 0; i < this.unaryLimit && this.unaryNogoodsToHandle.size() != 0; ++i) {
                int pickedDecision = this.unaryNogoodsToHandle.remove(this.unaryNogoodsToHandle.size() - 1);
                int a = NogoodRecorder.this.dr.idxIn(pickedDecision);
                int x = NogoodRecorder.this.dr.numIn(pickedDecision);
                for (Map<Integer, Integer> map : this.mapOfSymmetryGroupGenerators) {
                    int symmetricDecision;
                    Integer y = map.get(x);
                    if (y == null || this.decisionsToBePerformedAtNextRun.contains(symmetricDecision = NogoodRecorder.this.dr.negativeDecisionFor(y, a))) continue;
                    this.decisionsToBePerformedAtNextRun.add(symmetricDecision);
                    this.unaryNogoodsToHandle.add(symmetricDecision);
                }
            }
        }

        private void handleSymmetricNaryNogoods(int[] initialNogood) {
            this.naryNogoodsToHandle.clear();
            this.naryNogoodsToHandle.add(initialNogood);
            int currentSpace = 0;
            while (currentSpace < this.nonunaryLimit && this.naryNogoodsToHandle.size() != 0) {
                int[] nArray;
                int[] pickedNogood = this.naryNogoodsToHandle.poll();
                assert (Kit.isIncreasing(pickedNogood));
                if (this.tmps[pickedNogood.length] == null) {
                    this.tmps[pickedNogood.length] = new int[pickedNogood.length];
                    nArray = this.tmps[pickedNogood.length];
                } else {
                    nArray = this.tmps[pickedNogood.length];
                }
                int[] currentSymmetricNogood = nArray;
                for (Map<Integer, Integer> map : this.mapOfSymmetryGroupGenerators) {
                    boolean changed = false;
                    for (int j = 0; j < pickedNogood.length; ++j) {
                        int a = NogoodRecorder.this.dr.idxIn(pickedNogood[j]);
                        int x = NogoodRecorder.this.dr.numIn(pickedNogood[j]);
                        Integer y = map.get(x);
                        if (y != null) {
                            currentSymmetricNogood[j] = NogoodRecorder.this.dr.negativeDecisionFor(y, a);
                            changed = true;
                            continue;
                        }
                        currentSymmetricNogood[j] = NogoodRecorder.this.dr.negativeDecisionFor(x, a);
                    }
                    if (!changed) continue;
                    Arrays.sort(currentSymmetricNogood);
                    if (this.nogoodsSetsBySize[currentSymmetricNogood.length].contains(currentSymmetricNogood)) continue;
                    int[] symmetricNogood = (int[])currentSymmetricNogood.clone();
                    NogoodRecorder.this.addNogood(symmetricNogood, false);
                    this.naryNogoodsToHandle.add(symmetricNogood);
                    currentSpace += symmetricNogood.length * symmetricNogood.length;
                }
            }
        }
    }

    private class WatchCell {
        private Nogood nogood;
        private WatchCell nextCell;

        private WatchCell(Nogood nogood, WatchCell nextCell) {
            this.nogood = nogood;
            this.nextCell = nextCell;
        }
    }
}

