/*
 * Decompiled with CFR 0.152.
 */
package interfaces;

import constraints.Constraint;
import variables.Variable;

public interface Observers {

    public static interface ObserverBacktracking {
        public void restoreBefore(int var1);

        public static interface ObserverBacktrackingUnsystematic
        extends ObserverBacktracking {
        }

        public static interface ObserverBacktrackingSystematic
        extends ObserverBacktracking {
        }
    }

    public static interface ObserverConflicts {
        public void whenWipeout(Constraint var1, Variable var2);
    }

    public static interface ObserverDomainReduction {
        public void afterRemoval(Variable var1, int var2);

        public void afterRemovals(Variable var1, int var2);
    }

    public static interface ObserverAssignment {
        public void afterAssignment(Variable var1, int var2);

        public void afterUnassignment(Variable var1);
    }

    public static interface ObserverRuns {
        default public void beforeRun() {
        }

        default public void afterRun() {
        }
    }

    public static interface ObserverSearch {
        default public void beforeSolving() {
        }

        default public void beforePreprocessing() {
        }

        default public void afterPreprocessing() {
        }

        default public void beforeSearch() {
        }

        default public void afterSearch() {
        }

        default public void afterSolving() {
        }
    }

    public static interface ObserverConstruction {
        default public void beforeAnyConstruction() {
        }

        default public void afterProblemConstruction() {
        }

        default public void afterSolverConstruction() {
        }
    }
}

