/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import heuristics.HeuristicVariables;
import interfaces.Observers;
import interfaces.Tags;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import solver.Solver;
import utility.Kit;
import variables.Variable;

public abstract class HeuristicVariablesFixed
extends HeuristicVariables
implements Observers.ObserverRuns {
    private int nbRunsBeforeReinitializing = Integer.MAX_VALUE;
    private Variable[] ordering;

    @Override
    public final void beforeRun() {
        if (this.solver.restarter.numRun != 0 && this.solver.restarter.numRun % this.nbRunsBeforeReinitializing == 0) {
            this.buildOrdering();
        }
    }

    @Override
    public final void afterRun() {
    }

    private void buildOrdering() {
        Map<Variable, Double> map = Stream.of(this.solver.problem.variables).collect(Collectors.toMap(x -> x, x -> this.scoreOptimizedOf((Variable)x)));
        map = Kit.sort(map, (e1, e2) -> (Double)e1.getValue() < (Double)e2.getValue() ? -1 : ((Double)e1.getValue() > (Double)e2.getValue() ? 1 : ((Variable)e1.getKey()).num - ((Variable)e2.getKey()).num));
        this.ordering = (Variable[])map.entrySet().stream().map(e -> (Variable)e.getKey()).toArray(Variable[]::new);
        Kit.log.info("Static order of variables : " + Kit.join((Object)this.ordering, new String[0]));
    }

    public HeuristicVariablesFixed(Solver solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
        this.buildOrdering();
    }

    @Override
    protected Variable bestUnpriorityVar() {
        int i;
        assert (this.solver.problem.priorityVars.length == 0);
        int n = i = this.solver.propagation.performingProperSearch ? 0 : this.solver.futVars.nDiscarded();
        while (i < this.ordering.length) {
            if (this.ordering[i].isFuture()) {
                return this.ordering[i];
            }
            ++i;
        }
        throw new AssertionError();
    }

    public static final class Srand
    extends HeuristicVariablesFixed {
        public Srand(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            return this.solver.head.random.nextDouble();
        }
    }

    public static final class Lexico
    extends HeuristicVariablesFixed {
        public Lexico(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            return -x.num;
        }
    }

    public static final class Deg
    extends HeuristicVariablesFixed
    implements Tags.TagMaximize {
        public Deg(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            return x.deg();
        }
    }
}

