/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import dashboard.Control;
import heuristics.Heuristic;
import interfaces.Observers;
import java.util.Set;
import java.util.stream.Stream;
import propagation.GIC;
import solver.Solver;
import utility.Kit;
import utility.Reflector;
import variables.DomainInfinite;
import variables.Variable;

public abstract class HeuristicVariables
extends Heuristic {
    protected final Solver solver;
    protected Variable[] priorityVars;
    private int nStrictlyPriorityVars;
    protected Control.SettingVarh settings;
    protected BestScoredVariable bestScoredVariable;

    public static HeuristicVariables buildFor(Solver solver) {
        Set<Class<?>> classes = solver.head.handlerClasses.map.get(HeuristicVariables.class);
        if (solver.head.control.solving.enableSearch || solver.propagation instanceof GIC.GIC2) {
            return (HeuristicVariables)Reflector.buildObject(solver.head.control.varh.heuristic, classes, solver, solver.head.control.varh.anti);
        }
        return null;
    }

    public final void setPriorityVars(Variable[] priorityVars, int nbStrictPriorityVars) {
        this.priorityVars = priorityVars;
        this.nStrictlyPriorityVars = nbStrictPriorityVars;
    }

    public final void resetPriorityVars() {
        this.priorityVars = new Variable[0];
        this.nStrictlyPriorityVars = 0;
    }

    public HeuristicVariables(Solver solver, boolean antiHeuristic) {
        super(antiHeuristic);
        this.solver = solver;
        Control.SettingVars settingVars = solver.head.control.variables;
        if (settingVars.priorityVars.length > 0) {
            this.priorityVars = (Variable[])Stream.of(settingVars.priorityVars).map(o -> solver.problem.findVarWithNumOrId(o)).toArray(Variable[]::new);
            this.nStrictlyPriorityVars = settingVars.nStrictPriorityVars;
        } else {
            this.priorityVars = solver.problem.priorityVars;
            this.nStrictlyPriorityVars = solver.problem.nStrictPriorityVars;
        }
        this.settings = solver.head.control.varh;
        this.bestScoredVariable = new BestScoredVariable(solver.head.control.varh.discardAux);
    }

    public abstract double scoreOf(Variable var1);

    public final double scoreOptimizedOf(Variable x) {
        if (x.dom instanceof DomainInfinite) {
            return this.scoreCoeff == -1 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        return this.scoreOf(x) * (double)this.scoreCoeff;
    }

    private Variable bestPriorityVar() {
        int nPast = this.solver.futVars.nDiscarded();
        if (nPast < this.priorityVars.length) {
            Variable x;
            if (nPast < this.nStrictlyPriorityVars) {
                return this.priorityVars[nPast];
            }
            if (this.settings.lc > 0 && (x = this.solver.lastConflict.lastConflictPriorityVar()) != null && Kit.isPresent(x, this.priorityVars)) {
                return x;
            }
            Variable bestVar = null;
            double bestScore = Double.NEGATIVE_INFINITY;
            for (int i = this.nStrictlyPriorityVars; i < this.priorityVars.length; ++i) {
                double score;
                if (this.priorityVars[i].assigned() || !((score = this.scoreOptimizedOf(this.priorityVars[i])) > bestScore)) continue;
                bestVar = this.priorityVars[i];
                bestScore = score;
            }
            return bestVar;
        }
        return null;
    }

    protected abstract Variable bestUnpriorityVar();

    public final Variable bestVar() {
        Variable x = this.bestPriorityVar();
        return x != null ? x : this.bestUnpriorityVar();
    }

    public static final class Memory
    extends HeuristicVariables
    implements Observers.ObserverRuns {
        private int[] order;
        private int nOrdered;
        private int posLastConflict = -1;

        @Override
        public void beforeRun() {
            this.nOrdered = 0;
        }

        public Memory(Solver solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
            this.order = new int[solver.problem.variables.length];
            Kit.control(!solver.head.control.varh.discardAux);
        }

        @Override
        protected final Variable bestUnpriorityVar() {
            int pos = -1;
            for (int i = 0; i < this.nOrdered; ++i) {
                if (this.solver.problem.variables[this.order[i]].assigned()) continue;
                pos = i;
                break;
            }
            if (pos != -1) {
                if (this.posLastConflict > pos) {
                    Kit.control(this.posLastConflict < this.nOrdered);
                    int vid = this.order[pos];
                    this.order[pos] = this.order[this.posLastConflict];
                    this.order[this.posLastConflict] = vid;
                }
                this.posLastConflict = pos;
            } else {
                this.bestScoredVariable.reset(false);
                this.solver.futVars.execute(x -> this.bestScoredVariable.update((Variable)x, this.scoreOptimizedOf((Variable)x)));
                pos = this.posLastConflict = this.nOrdered;
                this.order[this.nOrdered++] = this.bestScoredVariable.variable.num;
            }
            return this.solver.problem.variables[this.order[pos]];
        }

        @Override
        public double scoreOf(Variable x) {
            return x.ddeg() / x.dom.size();
        }
    }

    public static class BestScoredVariable {
        public Variable variable;
        public double score;
        public boolean minimization;
        private boolean discardAux;

        public BestScoredVariable(boolean discardAux) {
            this.discardAux = discardAux;
        }

        public BestScoredVariable() {
            this(false);
        }

        public BestScoredVariable reset(boolean minimization) {
            this.variable = null;
            this.score = minimization ? Double.MAX_VALUE : Double.NEGATIVE_INFINITY;
            this.minimization = minimization;
            return this;
        }

        public boolean update(Variable x, double s) {
            if (this.discardAux && x.isSolverAux()) {
                assert (x.id().startsWith("_ax_"));
                return false;
            }
            if (this.minimization) {
                if (s < this.score) {
                    this.variable = x;
                    this.score = s;
                    return true;
                }
            } else if (s > this.score) {
                this.variable = x;
                this.score = s;
                return true;
            }
            return false;
        }
    }
}

