/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import constraints.Constraint;
import heuristics.HeuristicValues;
import optimization.Optimizable;
import sets.SetDense;
import solver.Solver;
import utility.Kit;
import variables.Variable;

public abstract class HeuristicValuesDynamic
extends HeuristicValues {
    public HeuristicValuesDynamic(Variable x, boolean antiHeuristic) {
        super(x, antiHeuristic);
    }

    @Override
    public int identifyBestValueIndex() {
        assert (this.dx.size() != 0) : "The domain is empty";
        int best = this.dx.first();
        double bestScore = this.scoreOf(best) * (double)this.scoreCoeff;
        int a = this.dx.next(best);
        while (a != -1) {
            double score = this.scoreOf(a) * (double)this.scoreCoeff;
            if (score > bestScore) {
                best = a;
                bestScore = score;
            }
            a = this.dx.next(a);
        }
        return best;
    }

    public static final class Occurrences
    extends HeuristicValuesDynamic {
        public Occurrences(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
        }

        @Override
        public double scoreOf(int a) {
            int v = this.x.dom.toVal(a);
            int cnt = 0;
            for (Variable y : this.x.problem.variables) {
                if (!y.dom.onlyContainsValue(v)) continue;
                ++cnt;
            }
            return cnt;
        }
    }

    public static final class Failures
    extends HeuristicValuesDynamic {
        private int[] nDecisions;

        public Failures(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
            this.nDecisions = Kit.repeat(1, this.dx.initSize());
        }

        @Override
        public double scoreOf(int a) {
            return (double)this.x.failed[a] / (double)this.nDecisions[a];
        }

        @Override
        public int identifyBestValueIndex() {
            int a;
            int n = a = super.identifyBestValueIndex();
            this.nDecisions[n] = this.nDecisions[n] + 1;
            return a;
        }
    }

    public static final class Conflicts
    extends HeuristicValuesDynamic {
        public Conflicts(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
        }

        @Override
        public double scoreOf(int a) {
            assert (this.x.isFuture() && this.dx.present(a));
            long nConflicts = 0L;
            for (Constraint c : this.x.ctrs) {
                nConflicts += c.nConflictsFor(c.positionOf(this.x), a);
            }
            return nConflicts;
        }
    }

    public static final class Bivs2
    extends Bivs {
        public Bivs2(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
        }

        @Override
        public int identifyBestValueIndex() {
            int aLast;
            this.inconsistent.clear();
            int n = aLast = this.solver.solRecorder.found == 0L ? -1 : this.solver.solRecorder.lastSolution[this.x.num];
            if (this.settings.bivsStoppedAtFirstSolution && this.solver.solRecorder.found > 0L || this.dx.size() > this.settings.bivsLimit) {
                if (aLast != -1 && this.dx.present(aLast)) {
                    return aLast;
                }
                return this.dx.first();
            }
            int best = this.dx.first();
            double bestScore = this.scoreOf(best) * (double)this.scoreCoeff;
            int a = this.dx.next(best);
            while (a != -1) {
                double score = this.scoreOf(a) * (double)this.scoreCoeff;
                if (score > bestScore || score == bestScore && a == aLast) {
                    best = a;
                    bestScore = score;
                }
                a = this.dx.next(a);
            }
            return best;
        }
    }

    public static class Bivs
    extends HeuristicValuesDynamic {
        Solver solver;
        Optimizable c;
        boolean lbBased;
        int nTests;
        public SetDense inconsistent;

        public Bivs(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
            Kit.control(x.problem.optimizer != null);
            this.scoreCoeff = x.problem.optimizer.minimization ? -1 : 1;
            this.lbBased = x.problem.head.control.valh.bivsOptimistic == x.problem.optimizer.minimization;
            this.solver = x.problem.solver;
            this.c = x.problem.optimizer.ctr;
            this.inconsistent = new SetDense(x.dom.initSize());
        }

        @Override
        public int identifyBestValueIndex() {
            this.inconsistent.clear();
            if (this.settings.bivsStoppedAtFirstSolution && this.solver.solRecorder.found > 0L || this.dx.size() > this.settings.bivsLimit) {
                return this.dx.first();
            }
            return super.identifyBestValueIndex();
        }

        @Override
        public double scoreOf(int a) {
            this.solver.assign(this.x, a);
            boolean consistent = this.solver.propagation.runAfterAssignment(this.x);
            long score = 0L;
            if (!consistent) {
                this.inconsistent.add(a);
                score = this.scoreCoeff == -1 ? Long.MAX_VALUE : Long.MIN_VALUE;
            } else {
                score = this.lbBased ? this.c.minCurrentObjectiveValue() : this.c.maxCurrentObjectiveValue();
            }
            this.solver.backtrack(this.x);
            ++this.nTests;
            return score;
        }
    }
}

