/*
 * Decompiled with CFR 0.152.
 */
package heuristics;

import heuristics.Heuristic;
import interfaces.Tags;
import propagation.Queue;
import variables.Variable;

public abstract class HeuristicRevisions
extends Heuristic {
    protected final Queue queue;

    public HeuristicRevisions(Queue queue, boolean antiHeuristic) {
        super(antiHeuristic);
        this.queue = queue;
    }

    public abstract int bestPosition();

    public static abstract class HeuristicRevisionsDynamic
    extends HeuristicRevisions {
        public HeuristicRevisionsDynamic(Queue queue, boolean antiHeuristic) {
            super(queue, antiHeuristic);
        }

        protected abstract double scoreOf(Variable var1);

        @Override
        public int bestPosition() {
            int pos = 0;
            double bestScore = this.scoreOf(this.queue.var(0)) * (double)this.scoreCoeff;
            for (int i = 1; i <= this.queue.limit; ++i) {
                double score = this.scoreOf(this.queue.var(i)) * (double)this.scoreCoeff;
                if (!(score > bestScore)) continue;
                pos = i;
                bestScore = score;
            }
            return pos;
        }

        public static final class Lexico
        extends HeuristicRevisionsDynamic {
            public Lexico(Queue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.num;
            }
        }

        public static final class WdegOnDom
        extends HeuristicRevisionsDynamic
        implements Tags.TagMaximize {
            public WdegOnDom(Queue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.wdegOnDom();
            }
        }

        public static final class Wdeg
        extends HeuristicRevisionsDynamic
        implements Tags.TagMaximize {
            public Wdeg(Queue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.wdeg();
            }
        }

        public static final class DdegOnDom
        extends HeuristicRevisionsDynamic
        implements Tags.TagMaximize {
            public DdegOnDom(Queue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.ddegOnDom();
            }
        }

        public static final class Ddeg
        extends HeuristicRevisionsDynamic
        implements Tags.TagMaximize {
            public Ddeg(Queue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.ddeg();
            }
        }

        public static final class Dom
        extends HeuristicRevisionsDynamic {
            public Dom(Queue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.dom.size();
            }
        }
    }

    public static abstract class HeuristicRevisionsDirect
    extends HeuristicRevisions {
        public HeuristicRevisionsDirect(Queue queue, boolean dummy) {
            super(queue, dummy);
        }

        public static final class Rand
        extends HeuristicRevisionsDirect {
            public Rand(Queue queue, boolean dummy) {
                super(queue, dummy);
            }

            @Override
            public int bestPosition() {
                return this.queue.propagation.solver.head.random.nextInt(this.queue.size());
            }
        }

        public static final class Last
        extends HeuristicRevisionsDirect {
            public Last(Queue queue, boolean dummy) {
                super(queue, dummy);
            }

            @Override
            public int bestPosition() {
                return this.queue.limit;
            }
        }

        public static final class First
        extends HeuristicRevisionsDirect {
            public First(Queue queue, boolean dummy) {
                super(queue, dummy);
            }

            @Override
            public int bestPosition() {
                return 0;
            }
        }
    }
}

