/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import constraints.Constraint;
import constraints.extension.structures.Bits;
import constraints.extension.structures.Matrix;
import dashboard.Input;
import heuristics.HeuristicRevisions;
import heuristics.HeuristicValues;
import heuristics.HeuristicValuesDirect;
import heuristics.HeuristicValuesDynamic;
import heuristics.HeuristicVariables;
import heuristics.HeuristicVariablesDynamic;
import interfaces.Tags;
import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import main.Head;
import main.HeadExtraction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.Compiler;
import propagation.GAC;
import propagation.Reviser;
import propagation.SAC;
import solver.Restarter;
import solver.SolutionRecorder;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import variables.Variable;

public class Control {
    public final String settingsFilename = staticUserSettingsFilename;
    public final ControlPanelSettings settings = new ControlPanelSettings(this.settingsFilename);
    public final SettingXml xml = new SettingXml();
    public final SettingGeneral general = new SettingGeneral();
    public final SettingProblem problem = new SettingProblem();
    public final SettingVars variables = new SettingVars();
    public final SettingCtrs constraints = new SettingCtrs();
    public final SettingGlobal global = new SettingGlobal();
    public final SettingExtension extension = new SettingExtension();
    public final SettingOptimization optimization = new SettingOptimization();
    public final SettingPropagation propagation = new SettingPropagation();
    public final SettingShaving shaving = new SettingShaving();
    public final SettingLNS lns = new SettingLNS();
    public final SettingSolving solving = new SettingSolving();
    public final SettingRestarts restarts = new SettingRestarts();
    public final SettingLearning learning = new SettingLearning();
    public final SettingExtraction extraction = new SettingExtraction();
    public final SettingVarh varh = new SettingVarh();
    public final SettingValh valh = new SettingValh();
    public final SettingRevh revh = new SettingRevh();
    public final SettingLocalSearch localSearch = new SettingLocalSearch();
    public final SettingExperimental experimental = new SettingExperimental();
    public final SettingHardCoding hardCoding = new SettingHardCoding();
    public final boolean mustBuildConflictStructures;
    public static final String DEFAULT_CONFIGURATION = "defaultConfiguration";
    public static final String CONFIGURATION = "configuration";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String ALL = "all";
    private static String staticUserSettingsFilename;

    public void toCSP() {
        if (this.general.nSearchedSolutions == -1L) {
            this.general.nSearchedSolutions = 1L;
        }
        this.general.framework = Types.TypeFramework.CSP;
    }

    public void toCOP() {
        if (this.general.nSearchedSolutions == -1L) {
            this.general.nSearchedSolutions = Long.MAX_VALUE;
        }
        this.general.framework = Types.TypeFramework.COP;
    }

    private Control() {
        int verbose;
        this.mustBuildConflictStructures = this.settings.addB(3, "constraints", "mustBuildConflictStructures", "mbcs", !this.propagation.reviser.equals(Reviser.class.getSimpleName()) || this.valh.heuristic.equals(HeuristicValuesDynamic.Conflicts.class.getSimpleName()), "");
        if (this.general.trace.length() > 0 && this.general.verbose < 1) {
            this.general.verbose = 1;
        }
        Kit.control(0 <= (verbose = this.general.verbose) && verbose <= 3, () -> "Verbose must be in 0..3");
        Kit.log.setLevel(verbose == 0 ? Level.CONFIG : (verbose == 1 ? Level.FINE : (verbose == 2 ? Level.FINER : Level.FINEST)));
        if (this.general.conditionForSatisfaction.trim().length() != 0) {
            String s = this.general.conditionForSatisfaction;
            Kit.control(s.matches("\\((lt|le|ge|gt|ne|eq),\\d+\\)"), () -> "Bad form of the condition for satisfaction : " + s);
        }
        Kit.control(0 <= this.lns.pFreeze && this.lns.pFreeze < 100, () -> "percentageOfVariablesToFreeze should be between 0 and 100 (excluded)");
        Kit.control(this.learning.nogood != Enums.ELearningNogood.RST_SYM);
        Kit.control(this.optimization.lb <= this.optimization.ub);
        this.settings.controlKeys();
        if (this.general.makeExceptionsVisible) {
            Compiler.ev = true;
        }
        if (this.general.noPrintColors) {
            Kit.useColors = false;
        }
        if (this.general.framework == Types.TypeFramework.MAXCSP) {
            this.optimization.lb = 0L;
        }
    }

    public static synchronized Control buildControlPanelFor(String userSettingsFilename) {
        staticUserSettingsFilename = userSettingsFilename;
        return new Control();
    }

    public static void main(String[] args) {
        Integer maximumPriority;
        Integer n = maximumPriority = args.length != 2 ? null : Kit.parseInteger(args[1]);
        if (args.length != 2 || maximumPriority == null || maximumPriority < 1 || maximumPriority > 3) {
            System.out.println("\tTool used to generate a default settings file.");
            System.out.println("\tUsage : " + Control.class.getName() + " <outputFileName> <maximumPriority>");
            System.out.println("\n\toutputFileName : name of the generated settings file.");
            System.out.println("\n\tmaximumPriority : only parameters with a priority value lower than this number (between 1 and 3) are generated");
        } else {
            new File(Kit.getPathOf(args[0])).mkdirs();
            ControlPanelSettings.saveControlPanelSettings(Control.buildControlPanelFor(null), args[0] + (args[0].endsWith(".xml") ? "" : ".xml"), maximumPriority);
        }
    }

    public static final class ControlPanelSettings {
        private UserSettings userSettings;
        private List<Setting<?>> settings = new ArrayList();

        public ControlPanelSettings(String settingsFilename) {
            this.userSettings = new UserSettings(settingsFilename);
        }

        private <T> Setting<T> add(Setting<T> setting) {
            Kit.control(setting.shortcut != null, () -> "A shortcut must be given");
            for (Setting<?> p : this.settings) {
                Kit.control(((Setting)p).shortcut == null || !((Setting)p).shortcut.equals(setting.shortcut), () -> "The parameters " + p.key() + " and " + setting.key() + " with the same shortcut " + setting.shortcut);
                Kit.control(!p.key().equals(setting.key()), () -> "The parameters " + p.key() + " and " + setting.key() + " with the same value");
            }
            this.settings.add(setting);
            Kit.control(setting.priority >= 1 && setting.priority <= 4 && setting.tag != null && setting.attribute != null && setting.defaultValue != null && setting.value != null);
            return setting;
        }

        public int addI(int priority, String tag, String attribute, String shortcut, int defaultValue, String description) {
            return (Integer)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)Integer.valueOf((int)defaultValue), (String)description)).value;
        }

        public long addL(int priority, String tag, String attribute, String shortcut, long defaultValue, String description) {
            return (Long)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)Long.valueOf((long)defaultValue), (String)description)).value;
        }

        public double addD(int priority, String tag, String attribute, String shortcut, double defaultValue, String description) {
            return (Double)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)Double.valueOf((double)defaultValue), (String)description)).value;
        }

        public boolean addB(int priority, String tag, String attribute, String shortcut, boolean defaultValue, String description) {
            return (Boolean)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)Boolean.valueOf((boolean)defaultValue), (String)description)).value;
        }

        public String addS(int priority, String tag, String attribute, String shortcut, String defaultValue, String description) {
            return (String)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, (Object)defaultValue, (String)description)).value;
        }

        public String addS(int priority, String tag, String attribute, String shortcut, Class<?> defaultValue, Class<?> root, String description) {
            return (String)this.add((ControlPanelSettings)this.new Setting<T>((int)priority, (String)tag, (String)attribute, (String)shortcut, defaultValue, root, (String)description)).value;
        }

        public <T extends Enum<T>> T addE(int priority, String tag, String attribute, String shortcut, T defaultValue, String description) {
            return (T)((Enum)this.add(new SettingEnum<T>((ControlPanelSettings)this, (int)priority, (String)tag, (String)attribute, (String)shortcut, defaultValue, (String)description)).value);
        }

        public void controlKeys() {
            String k = Input.argsForCp.keySet().stream().filter(key -> this.settings.stream().noneMatch(s -> s.key().equals(key) || ((Setting)s).shortcut.equals(key))).findFirst().orElse(null);
            Kit.control(k == null, () -> "The parameter " + k + " is unknown");
        }

        public void display() {
            try (Scanner scanner1 = new Scanner(Head.class.getResource("/displayPart1.txt").openStream());
                 Scanner scanner2 = new Scanner(Head.class.getResourceAsStream("/displayPart2.txt"));){
                while (scanner1.hasNext()) {
                    System.out.println(scanner1.nextLine());
                }
                String tag = null;
                for (Setting<?> setting : this.settings) {
                    String string;
                    if (((Setting)setting).priority == 4 || ((Setting)setting).priority == 4) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!((Setting)setting).tag.equals(tag)) {
                        tag = ((Setting)setting).tag;
                        string = "\n  " + tag + "\n";
                    } else {
                        string = "";
                    }
                    System.out.print(stringBuilder.append(string).append(setting).toString());
                }
                System.out.println();
                while (scanner2.hasNext()) {
                    System.out.println(scanner2.nextLine());
                }
            }
            catch (Exception e) {
                Kit.exit("Error while loading display files", e);
            }
        }

        public static void saveControlPanelSettings(Control cp, String outputFilename, int maximumPriority) {
            Document document = Kit.createNewDocument();
            Node root = document.appendChild(document.createElement(Control.CONFIGURATION));
            for (Setting<?> setting : cp.settings.settings) {
                if (((Setting)setting).priority > maximumPriority) continue;
                NodeList list = document.getElementsByTagName(((Setting)setting).tag);
                if (list.getLength() == 0) {
                    root.appendChild(document.createElement(((Setting)setting).tag));
                    list = document.getElementsByTagName(((Setting)setting).tag);
                }
                Kit.control(list.getLength() == 1);
                Object value = setting.defaultValue;
                if (value instanceof Number) {
                    Number n = (Number)setting.defaultValue;
                    value = n.longValue() == Long.MIN_VALUE || n.intValue() == Integer.MIN_VALUE ? Control.MIN : (n.longValue() == Long.MAX_VALUE || n.intValue() == Integer.MAX_VALUE ? Control.MAX : value);
                }
                ((Element)list.item(0)).setAttribute(((Setting)setting).attribute.trim(), value.toString());
            }
            Utilities.save(document, outputFilename);
            try {
                Runtime.getRuntime().exec("xmlindent -i 2 -w " + outputFilename).waitFor();
            }
            catch (Exception e) {
                Utilities.exit("Pb when Indenting File " + outputFilename + " " + e);
            }
        }

        public static final class SettingEnum<T extends Enum<T>>
        extends Setting<T> {
            final /* synthetic */ ControlPanelSettings this$0;

            private SettingEnum(int priority, String tag, String attribute, String shortcut, T defaultValue, String description) {
                this.this$0 = this$0;
                super(priority, tag, attribute, shortcut, defaultValue, description);
                this.value = Enum.valueOf(defaultValue.getClass(), ((ControlPanelSettings)this$0).userSettings.stringFor(shortcut, tag, attribute, defaultValue).toUpperCase());
            }
        }

        private class Setting<T> {
            private int priority;
            private String tag;
            private String attribute;
            private String shortcut;
            private String description;
            T defaultValue;
            T value;
            private Class<?> root;
            private final String[] experimentalNames = Kit.sort(new String[]{Enums.EExtraction.MAX_CSP.name(), Enums.EExtraction.INC.name(), Enums.EExtraction.INC_FIRST.name()});

            private T getValue(String shortcut, String tag, String attribute, T defaultValue) {
                if (defaultValue == null) {
                    return null;
                }
                Class<?> clazz = defaultValue.getClass();
                if (defaultValue instanceof Integer) {
                    return (T)clazz.cast(ControlPanelSettings.this.userSettings.intFor(shortcut, tag, attribute, (Integer)defaultValue));
                }
                if (defaultValue instanceof Long) {
                    return (T)clazz.cast(ControlPanelSettings.this.userSettings.longFor(shortcut, tag, attribute, (Long)defaultValue));
                }
                if (defaultValue instanceof Double) {
                    return (T)clazz.cast(ControlPanelSettings.this.userSettings.doubleFor(shortcut, tag, attribute, (Double)defaultValue));
                }
                if (defaultValue instanceof Boolean) {
                    return (T)clazz.cast(ControlPanelSettings.this.userSettings.booleanFor(shortcut, tag, attribute, (Boolean)defaultValue));
                }
                if (defaultValue instanceof String) {
                    return (T)clazz.cast(ControlPanelSettings.this.userSettings.stringFor(shortcut, tag, attribute, defaultValue));
                }
                if (defaultValue instanceof Enum) {
                    // empty if block
                }
                return null;
            }

            private Setting(int priority, String tag, String attribute, String shortcut, T defaultValue, String description) {
                this.priority = priority;
                this.tag = tag;
                this.attribute = attribute;
                this.shortcut = shortcut;
                this.defaultValue = defaultValue;
                this.value = this.getValue(shortcut, tag, attribute, defaultValue);
                this.description = description;
            }

            private Setting(int priority, String tag, String attribute, String shortcut, Class<?> defaultValue, Class<?> root, String description) {
                this(priority, tag, attribute, shortcut, defaultValue == null ? "" : defaultValue.getName().substring(defaultValue.getName().lastIndexOf(".") + 1), description);
                this.root = root;
            }

            String key() {
                return this.tag + "/" + this.attribute;
            }

            public String toString() {
                String s = new String();
                s = s + "    -" + this.key() + (this.shortcut != null ? " -" + this.shortcut : "") + "\n";
                s = s + "\t" + (this.description == null || this.description.length() == 0 ? "Description is missing..." : this.description) + "\n";
                s = s + "\tDefault value is : " + (this.defaultValue instanceof String && ((String)this.defaultValue).length() == 0 ? "\"\" (empty string)" : this.defaultValue) + "\n";
                if (this.root != null) {
                    s = s + "\tPossible String values are : ";
                    for (AnnotatedElement annotatedElement : Reflector.searchClassesInheritingFrom(this.root)) {
                        if (Tags.TagExperimental.class.isAssignableFrom((Class<?>)annotatedElement)) continue;
                        s = s + ((Class)annotatedElement).getSimpleName() + " ";
                    }
                    s = s + "\n";
                }
                if (this.value instanceof Enum) {
                    s = s + "\tPossible Enum values are : ";
                    for (AnnotatedElement annotatedElement : this.value.getClass().getDeclaredFields()) {
                        if (!((Field)annotatedElement).isEnumConstant() || Arrays.binarySearch(this.experimentalNames, ((Field)annotatedElement).getName()) >= 0) continue;
                        s = s + ((Field)annotatedElement).getName() + " ";
                    }
                    s = s + "\n";
                }
                return s;
            }
        }

        private static class UserSettings {
            private Document document;
            private XPath xPath;

            private UserSettings(String userSettingsFilename) {
                if (userSettingsFilename == null) {
                    userSettingsFilename = Input.userSettingsFilename;
                }
                if (userSettingsFilename != null && !userSettingsFilename.equals(Control.DEFAULT_CONFIGURATION)) {
                    this.document = Kit.load(new File(userSettingsFilename));
                    this.xPath = XPathFactory.newInstance().newXPath();
                }
            }

            private String stringFor(String shortcut, String tag, String att, Object defaultValue) {
                String value;
                String string = value = shortcut == null ? null : Input.argsForCp.get(shortcut);
                if (value != null) {
                    return value.length() == 0 && !(defaultValue instanceof String) ? defaultValue.toString() : value;
                }
                value = Input.argsForCp.get((tag != null ? tag + "/" : "") + att);
                if (value != null) {
                    return value;
                }
                if (this.document == null) {
                    return defaultValue.toString();
                }
                try {
                    NodeList nodes = (NodeList)this.xPath.compile("//" + (tag != null ? tag : "*") + "/@" + att).evaluate(this.document, XPathConstants.NODESET);
                    Kit.control(nodes.getLength() <= 1, () -> "Problem with several possibilities for " + tag + " " + att);
                    if (nodes.getLength() == 0) {
                        return defaultValue.toString();
                    }
                    value = nodes.item(0).getNodeValue();
                    return value.length() == 0 && !(defaultValue instanceof String) ? defaultValue.toString() : value;
                }
                catch (XPathExpressionException e) {
                    Kit.exit("problem xpath", e);
                    return (String)Kit.exit("Problem with " + tag + " and " + att + " and " + defaultValue);
                }
            }

            private Number numberFor(String shortcut, String tag, String att, Object defaultValue, boolean longValue) {
                String s = this.stringFor(shortcut, tag, att, defaultValue).toLowerCase();
                if (s.equals(Control.MIN)) {
                    return longValue ? (Number)Long.MIN_VALUE : (Number)Integer.MIN_VALUE;
                }
                if (s.equals(Control.MAX) || s.equals(Control.ALL)) {
                    return longValue ? (Number)Long.MAX_VALUE : (Number)Integer.MAX_VALUE;
                }
                char lastCharacter = s.charAt(s.length() - 1);
                Long baseValue = Kit.parseLong(Character.isDigit(lastCharacter) ? s : s.substring(0, s.length() - 1));
                Kit.control(baseValue != null, () -> "An integer/long value was expected for " + tag + "/" + att);
                double value = Character.isDigit(lastCharacter) ? (double)baseValue.longValue() : (lastCharacter == 'k' || lastCharacter == 's' ? (double)(baseValue * 1000L) : (lastCharacter == 'm' ? (double)(baseValue * 1000000L) : (Double)Kit.exit("Bad character for " + tag + " " + att)));
                Kit.control(longValue && -9.223372036854776E18 <= value && value <= 9.223372036854776E18 || !longValue && -2.147483648E9 <= value && value <= 2.147483647E9);
                return longValue ? (Number)new Long((long)value) : (Number)new Integer((int)value);
            }

            private int intFor(String shortcut, String tag, String att, Integer defaultValue) {
                return (Integer)this.numberFor(shortcut, tag, att, defaultValue, false);
            }

            private Long longFor(String shortcut, String tag, String att, Long defaultValue) {
                return (Long)this.numberFor(shortcut, tag, att, defaultValue, true);
            }

            private double doubleFor(String shortcut, String tag, String att, Double defaultValue) {
                Double d = Utilities.toDouble(this.stringFor(shortcut, tag, att, defaultValue));
                Kit.control(d != null, () -> "A double value was expected for " + tag + "/" + att);
                return d;
            }

            private boolean booleanFor(String shortcut, String tag, String att, Boolean defaultValue) {
                Boolean b = Utilities.toBoolean(this.stringFor(shortcut, tag, att, defaultValue));
                Kit.control(b != null, () -> "A boolean value was expected for " + tag + "/" + att);
                return b;
            }
        }
    }

    public class SettingHardCoding
    extends SettingGroup {
        public final String classForDecompositionSolver = "Decomposer2";

        public SettingHardCoding() {
            this.classForDecompositionSolver = "Decomposer2";
        }
    }

    public class SettingExperimental
    extends SettingGroup {
        public final boolean testB;
        public int testI1;
        public int testI2;
        public int testI3;

        public SettingExperimental() {
            this.testB = this.addB("testB", "test", false, "", 4);
            this.testI1 = this.addI("testI1", "testI1", 0, "", 4);
            this.testI2 = this.addI("testI2", "testI2", 0, "", 4);
            this.testI3 = this.addI("testI3", "testI3", 0, "", 4);
        }
    }

    public class SettingLocalSearch
    extends SettingGroup {
        public final int tabuListSize;
        public final double thresholdForRandomVariableSelection;
        public final double thresholdForRandomValueSelection;

        public SettingLocalSearch() {
            this.tabuListSize = this.addI("tabuListSize", "tabs", 5, "", new int[0]);
            this.thresholdForRandomVariableSelection = this.addD("thresholdForRandomVariableSelection", "trvars", 0.0, "", new int[0]);
            this.thresholdForRandomValueSelection = this.addD("thresholdForRandomValueSelection", "trvals", 0.0, "", new int[0]);
        }
    }

    public class SettingRevh
    extends SettingGroup {
        public final String clazz;
        public final boolean anti;

        public SettingRevh() {
            this.clazz = this.addS("clazz", "revh", HeuristicRevisions.HeuristicRevisionsDynamic.Dom.class, HeuristicRevisions.class, "class for the revision ordering heuristic", new int[0]);
            this.anti = this.addB("anti", "anti_revh", false, "must we follow the anti heuristic?", new int[0]);
        }
    }

    public class SettingValh
    extends SettingGroup {
        String s1;
        public String heuristic;
        public final boolean anti;
        public boolean runProgressSaving;
        public boolean solutionSaving;
        public final int solutionSavingGap;
        public String warmStart;
        public boolean bivsStoppedAtFirstSolution;
        public boolean bivsOptimistic;
        public final int bivsDistance;
        public final int bivsLimit;
        public final boolean optValHeuristic;

        public SettingValh() {
            this.s1 = "The name of the class that selects the next value to be assigned to the last selected variable.\n\tAn example is valh=First that indicates that at each step the next value to be assigned is the first value in the current domain (a kind of lexicographic order).";
            this.heuristic = this.addS("heuristic", "valh", HeuristicValuesDirect.First.class, HeuristicValues.class, "name of the class used for selecting values", new int[0]);
            this.anti = this.addB("anti", "anti_valh", false, "must we follow the anti heuristic?", new int[0]);
            this.runProgressSaving = this.addB("runProgressSaving", "rps", false, "", new int[0]);
            this.solutionSaving = this.addB("solutionSaving", "sos", true, "", new int[0]);
            this.solutionSavingGap = this.addI("solutionSavingGap", "sosg", Integer.MAX_VALUE, "", new int[0]);
            this.warmStart = this.addS("warmStart", "warm", "", "", new int[0]).trim();
            this.bivsStoppedAtFirstSolution = this.addB("bivsStoppedAtFirstSolution", "bivs_s", true, "", new int[0]);
            this.bivsOptimistic = this.addB("bivsOptimistic", "bivs_o", true, "", new int[0]);
            this.bivsDistance = this.addI("bivsDistance", "bivs_d", 2, "0: only if in the objective constraint, 1: if at distance 0 or 1, 2: any varriable", new int[0]);
            this.bivsLimit = this.addI("bivsLimit", "bivs_l", Integer.MAX_VALUE, "", new int[0]);
            this.optValHeuristic = this.addB("optValHeuristic", "ovh", false, "", new int[0]);
        }
    }

    public class SettingVarh
    extends SettingGroup {
        public String heuristic;
        public final boolean anti;
        public int lc;
        public final Enums.EWeighting weighting;
        public final Enums.ESingleton singleton;
        public final boolean discardAux;

        public SettingVarh() {
            this.heuristic = this.addS("heuristic", "varh", HeuristicVariablesDynamic.Wdeg.class, HeuristicVariables.class, "name of the class used for selecting variables", new int[0]);
            this.anti = this.addB("anti", "anti_varh", false, "must we follow the anti heuristic?", new int[0]);
            this.lc = this.addI("lc", "lc", 2, "value for lc (last conflict); 0 if not activated", new int[0]);
            this.weighting = this.addE("weighting", "wt", Enums.EWeighting.CACD, "how to manage weights for wdeg variants", new int[0]);
            this.singleton = this.addE("singleton", "sing", Enums.ESingleton.LAST, "how to manage singleton variables during search", new int[0]);
            this.discardAux = this.addB("discardAux", "da", false, "must we discard auxiliary variables introduced by the solver?", new int[0]);
        }
    }

    public class SettingExtraction
    extends SettingGroup {
        String s;
        public final Enums.EExtraction method;
        public final int nCores;

        public SettingExtraction() {
            this.s = "\n\tValid only with the command: java " + HeadExtraction.class.getName();
            this.method = this.addE("method", "e_m", Enums.EExtraction.VAR, "method for extracting unsatisfiable cores." + this.s, new int[0]);
            this.nCores = this.addI("nCores", "e_nc", 1, "number of unsatifiable cores to be extracted." + this.s, new int[0]);
        }
    }

    public class SettingLearning
    extends SettingGroup {
        String s_ng;
        String s_bgbl;
        String s_ps;
        String s_pso;
        public Enums.ELearningNogood nogood;
        public final int nogoodBaseLimit;
        public final int nogoodArityLimit;
        public final int unarySymmetryLimit;
        public final int nonunarySymmetryLimit;
        public final Enums.ELearningIps state;
        public final String stateOperators;
        public final int compressionLevelForStateEquivalence;
        public final int compressionLimitForStateEquivalence;

        public SettingLearning() {
            this.s_ng = "Indicates the way nogoods are collected.\nBy default, this is nogood recording from restarts.";
            this.s_bgbl = "The limit, in term of number of nogoods, for the base.";
            this.s_ps = "Indicates the way partial states are collected.\nBy default, no such learning.";
            this.s_pso = "Indicates which operators are used to extract partial states: a sequence of 5 bits is used.";
            this.nogood = this.addE("nogood", "l_ng", Enums.ELearningNogood.RST, this.s_ng, new int[0]);
            this.nogoodBaseLimit = this.addI("nogoodBaseLimit", "l_ngbl", 200000, this.s_bgbl, new int[0]);
            this.nogoodArityLimit = this.addI("nogoodArityLimit", "l_ngal", Integer.MAX_VALUE, "", 4);
            this.unarySymmetryLimit = this.addI("unarySymmetryLimit", "l_usl", Integer.MAX_VALUE, "", 4);
            this.nonunarySymmetryLimit = this.addI("nonunarySymmetryLimit", "l_nsl", 2000, "", 4);
            this.state = this.addE("state", "l_ps", Enums.ELearningIps.NO, this.s_ps, new int[0]);
            this.stateOperators = this.addS("stateOperators", "l_pso", "11011", this.s_pso, new int[0]).trim();
            this.compressionLevelForStateEquivalence = this.addI("compressionLevelForStateEquivalence", "l_clevel", 0, "", 4);
            this.compressionLimitForStateEquivalence = this.addI("compressionLimitForStateEquivalence", "l_climit", 300, "", 4);
        }
    }

    public class SettingRestarts
    extends SettingGroup {
        String s_n;
        String s_c;
        String s_f;
        String s_m;
        String s_rrp;
        String s_rrc;
        public int nRunsLimit;
        public long cutoff;
        public double factor;
        public final Enums.ERestartsMeasure measure;
        public int nRestartsResetPeriod;
        public final int nRestartsResetCoefficient;
        public final int varhResetPeriod;
        public final int varhSolResetPeriod;
        public boolean restartAfterSolution;
        public boolean luby;

        public SettingRestarts() {
            this.s_n = "The maximal number of runs (restarts) to be performed.\n\tA value strictly greater than 1 is relevant only if a cutoff value is given.";
            this.s_c = "The number of the counter (number of backtracks, number of failed assignments, ...) before the solver restarts.\n\tWhen no value is given, the cutoff is set to Integer.MAX_VALUE.";
            this.s_f = "The geometric increasing factor of the number (e.g. the number of failed assignments) used to break successive runs.";
            this.s_m = "The kind of events to be counted so as to force restarts when the cutoff is reached.";
            this.s_rrp = "Period, in term of number of restarts, for resetting restart data.";
            this.s_rrc = "Coefficient used for increasing the cutoff, when restart data are reset";
            this.nRunsLimit = this.addI("nRunsLimit", "r_n", Integer.MAX_VALUE, this.s_n, new int[0]);
            this.cutoff = this.addL("cutoff", "r_c", 10L, this.s_c, new int[0]);
            this.factor = this.addD("factor", "r_f", 1.1, this.s_f, new int[0]);
            this.measure = this.addE("measure", "r_m", Enums.ERestartsMeasure.FAILED, this.s_m, new int[0]);
            this.nRestartsResetPeriod = this.addI("nRestartsResetPeriod", "r_rrp", 90, this.s_rrp, new int[0]);
            this.nRestartsResetCoefficient = this.addI("nRestartsResetCoefficient", "r_rrc", 2, this.s_rrc, new int[0]);
            this.varhResetPeriod = this.addI("varhResetPeriod", "r_rp", Integer.MAX_VALUE, "", new int[0]);
            this.varhSolResetPeriod = this.addI("varhSolResetPeriod", "r_srp", 30, "", new int[0]);
            this.restartAfterSolution = this.addB("restartAfterSolution", "ras", false, "", new int[0]);
            this.luby = this.addB("luby", "r_luby", false, "", new int[0]);
        }
    }

    public class SettingSolving
    extends SettingGroup {
        String s_class;
        String s_branching;
        public String clazz;
        public boolean enablePrepro;
        public boolean enableSearch;
        public final Enums.EBranching branching;

        public SettingSolving() {
            this.s_class = "The name of the class used to explore the search space.\n\tTypically, this is " + Solver.class.getSimpleName();
            this.s_branching = "The branching scheme used for search.\n\tPossible values are bin for binary branching, non for non-binary (or d-way) branching, and res for restricted binarybranching.";
            this.clazz = this.addS("clazz", "s_class", Solver.class, this.s_class, new int[0]);
            this.enablePrepro = this.addB("enablePrepro", "prepro", true, "must we perform preprocessing?", new int[0]);
            this.enableSearch = this.addB("enableSearch", "search", true, "must we perform search?", new int[0]);
            this.branching = this.addE("branching", "branching", Enums.EBranching.BIN, this.s_branching, new int[0]);
        }
    }

    public class SettingLNS
    extends SettingGroup {
        public final boolean enabled;
        public final String heuristic;
        public final int nFreeze;
        public final int pFreeze;

        public SettingLNS() {
            this.enabled = this.addB("enabled", "lns_e", false, "LNS activated if true", new int[0]);
            this.heuristic = this.addS("heuristic", "lns_h", Restarter.RestarterLNS.HeuristicFreezing.Rand.class, "class to be used when freezing", new int[0]);
            this.nFreeze = this.addI("nFreeze", "lns_n", 0, "number of variables to freeze when restarting.", new int[0]);
            this.pFreeze = this.addI("pFreeze", "lns_p", 10, "percentage of variables to freeze when restarting.", new int[0]);
        }
    }

    public class SettingShaving
    extends SettingGroup {
        public int parameter;
        public final double eligibilityThreshod;
        public final int limitedPropagationSamplingSize;
        public final double ratio;
        public final double alpha;

        public SettingShaving() {
            this.parameter = this.addI("parameter", "s_p", 1, "", 4);
            this.eligibilityThreshod = this.addD("eligibilityThreshod", "s_et", 3.0, "", 4);
            this.limitedPropagationSamplingSize = this.addI("limitedPropagationSamplingSize", "s_lpss", 100, "", 4);
            this.ratio = this.addD("ratio", "s_r", 0.0, "", new int[0]);
            this.alpha = this.addD("alpha", "s_a", 0.0, "", new int[0]);
        }
    }

    public class SettingPropagation
    extends SettingGroup {
        String s_pv;
        String s_uaq;
        String q1;
        String q2;
        String q3;
        public String clazz;
        public final int variant;
        public final boolean useAuxiliaryQueues;
        public String reviser;
        public boolean residues;
        public boolean bitResidues;
        public final boolean multidirectionality;
        public final int futureLimitation;
        public final int spaceLimitation;
        public final int arityLimitForGACGuaranteed;
        public boolean strongOnlyAtPreprocessing;
        public final boolean strongOnlyWhenACEffective;
        public final boolean strongOnlyWhenNotSingleton;
        public final String classForSACSelector;
        public final int weakCutoff;
        public final String classForFailedValues;

        public SettingPropagation() {
            this.s_pv = "Variant for a second order consistency";
            this.s_uaq = "If enabled, queues of constraints are used in addition to the queue of variables. The purpose is to propagate less often the most costly constraints.";
            this.q1 = "For intension constraints, control the effort for (G)AC.\n\tGAC is not enforced if the current number of future variables is more than the specified value.";
            this.q2 = "For intension constraints, control the effort for (G)AC.\n\tGAC is not enforced if the size of the current Cartesian product is more than than 2 up the specified value.";
            this.q3 = "For intension constraints, GAC is guaranteed to be enforced if the arity is not more than the specified value.";
            this.clazz = this.addS("clazz", "p", GAC.class, "name of the class to be used for propagation (for example, FC or SAC3)", new int[0]);
            this.variant = this.addI("variant", "pv", 0, this.s_pv, 4);
            this.useAuxiliaryQueues = this.addB("useAuxiliaryQueues", "uaq", false, this.s_uaq, new int[0]);
            this.reviser = this.addS("reviser", "reviser", Reviser.Reviser3.class, Reviser.class, "class to be used for performing revisions", new int[0]);
            this.residues = this.addB("residues", "res", true, "Must we use redidues (GAC3rm)?", new int[0]);
            this.bitResidues = this.addB("bitResidues", "bres", true, "Must we use bit resides (GAC3bit+rm)?", new int[0]);
            this.multidirectionality = this.addB("multidirectionality", "mul", true, "", new int[0]);
            this.futureLimitation = this.addI("futureLimitation", "fl", -1, this.q1, new int[0]);
            this.spaceLimitation = this.addI("spaceLimitation", "sl", 20, this.q2, new int[0]);
            this.arityLimitForGACGuaranteed = this.addI("arityLimitForGACGuaranteed", "aggac", 2, this.q3, new int[0]);
            this.strongOnlyAtPreprocessing = this.addB("strongOnlyAtPreprocessing", "sop", false, "", new int[0]);
            this.strongOnlyWhenACEffective = this.addB("strongOnlyWhenACEffective", "soe", false, "", new int[0]);
            this.strongOnlyWhenNotSingleton = this.addB("strongOnlyWhenNotSingleton", "sons", true, "", new int[0]);
            this.classForSACSelector = this.addS("classForSACSelector", "csac", SAC.QueueForSAC3.CellIterator.class, "", new int[0]);
            this.weakCutoff = this.addI("weakCutoff", "wc", 15, "", new int[0]);
            this.classForFailedValues = this.addS("classForFailedValues", "fvc", "", "", 4);
        }
    }

    public class SettingOptimization
    extends SettingGroup {
        public long lb;
        public long ub;
        public final Enums.EOptimizationStrategy strategy;

        public SettingOptimization() {
            this.lb = this.addL("lb", "lb", Long.MIN_VALUE, "initial lower bound", new int[0]);
            this.ub = this.addL("ub", "ub", Long.MAX_VALUE, "initial upper bound", new int[0]);
            this.strategy = this.addE("strategy", "os", Enums.EOptimizationStrategy.DECREASING, "optimization strategy", new int[0]);
        }
    }

    public class SettingExtension
    extends SettingGroup {
        String s_positive;
        String s_negative;
        public final Enums.EExtension positive;
        public final Enums.EExtension negative;
        public final boolean validForBinary;
        public final String classBinary;
        public final String classTernary;
        public final int arityLimitForSwitchingToPositive;
        public final int arityLimitForSwitchingToNegative;
        public final boolean decremental;
        public final int variant;
        public final int arityLimitForConvertingIntension;
        public final int spaceLimitForConvertingIntension;

        public SettingExtension() {
            this.s_positive = "For (non-binary) constraints defined in extension, there are many ways of representing and propagating them.\n\tWe have v for GAC-valid, a for GAC-allowed, va for GAC-valid+allowed, str1 for simple tabular reduction, str2 and mdd...";
            this.s_negative = "For non-binary constraints defined in extension, representation of negative table constraints...";
            this.positive = this.addE("positive", "positive", Enums.EExtension.CT, this.s_positive, new int[0]);
            this.negative = this.addE("negative", "negative", Enums.EExtension.V, this.s_negative, new int[0]);
            this.validForBinary = this.addB("validForBinary", "vfor2", true, "", new int[0]);
            this.classBinary = this.addS("classBinary", "cfor2", Bits.class, "", new int[0]);
            this.classTernary = this.addS("classTernary", "cfor3", Matrix.Matrix3D.class, "", new int[0]);
            this.arityLimitForSwitchingToPositive = this.addI("arityLimitForSwitchingToPositive", "ntop", -1, "", new int[0]);
            this.arityLimitForSwitchingToNegative = this.addI("arityLimitForSwitchingToNegative", "pton", -1, "", new int[0]);
            this.decremental = this.addB("decremental", "exd", true, "", new int[0]);
            this.variant = this.addI("variant", "exv", 0, "", new int[0]);
            this.arityLimitForConvertingIntension = this.addI("arityLimitForConvertingIntension", "alc", 0, "", new int[0]);
            this.spaceLimitForConvertingIntension = this.addI("spaceLimitForConvertingIntension", "plc", 20, "", new int[0]);
        }

        public boolean mustReverse(int arity, boolean positive) {
            return positive && arity <= this.arityLimitForSwitchingToNegative || !positive && arity <= this.arityLimitForSwitchingToPositive;
        }

        public boolean convertingIntension(Variable[] vars) {
            return vars.length <= this.arityLimitForConvertingIntension && Constraint.howManyVarsWithin(vars, this.spaceLimitForConvertingIntension) == Integer.MAX_VALUE;
        }
    }

    public class SettingGlobal
    extends SettingGroup {
        String s1;
        String s;
        String r1;
        String r2;
        String r3;
        public final boolean priorityType0;
        public final int typeAllDifferent;
        public final int typeDistinctVectors;
        public final int typeAllEqual;
        public final int typeNotAllEqual;
        public final int typeOrdered;
        public final int typeNoOverlap;
        public final boolean redundNoOverlap;
        public final int typeBinpacking;
        public final boolean basicTable;
        public final boolean jokerTable;
        public final boolean smartTable;

        public SettingGlobal() {
            this.s1 = "Type 0 for propagators will be the priority choice in case of export.";
            this.s = "Allows the user to select the propagator for ";
            this.r1 = "When set to yes, some global constraints are encoded into classical table constraintss.";
            this.r2 = "When set to yes, some global constraints are encoded into joker table constraintss.";
            this.r3 = "When set to yes, some global constraints are encoded into smart table constraints.";
            this.priorityType0 = this.addB("priorityType0", "g_pt0", true, this.s1, new int[0]);
            this.typeAllDifferent = this.addI("typeAllDifferent", "g_ad", 0, this.s + "allDifferent", new int[0]);
            this.typeDistinctVectors = this.addI("typeDistinctVectors", "g_dv", 0, this.s + "distinctvectors", new int[0]);
            this.typeAllEqual = this.addI("typeAllEqual", "g_ae", 0, this.s + "allEqual", new int[0]);
            this.typeNotAllEqual = this.addI("typeNotAllEqual", "g_nae", 0, this.s + "notAllEqual", new int[0]);
            this.typeOrdered = this.addI("typeOrdered", "g_ord", 1, this.s + "odered", new int[0]);
            this.typeNoOverlap = this.addI("typeNoOverlap", "g_no", 0, this.s + "noOverlap", new int[0]);
            this.redundNoOverlap = this.addB("redundNoOverlap", "r_no", true, "", new int[0]);
            this.typeBinpacking = this.addI("typeBinpacking", "g_bp", 0, this.s + "binPacking", new int[0]);
            this.basicTable = this.addB("basicTable", "bt", false, this.r1, new int[0]);
            this.jokerTable = this.addB("jokerTable", "jt", false, this.r2, new int[0]);
            this.smartTable = this.addB("smartTable", "st", false, this.r3, new int[0]);
        }
    }

    public class SettingCtrs
    extends SettingGroup {
        String s_ignoreType;
        String s_ignoreArity;
        String r2;
        String r5;
        public boolean preserveUnaryCtrs;
        public int decomposeIntention;
        public boolean viewForSum;
        public boolean intensionToExtensionUnaryCtrs;
        public final Types.TypeCtr ignoredCtrType;
        public final int ignoreCtrArity;
        public boolean ignorePrimitives;
        public final int inferAllDifferentNb;
        public final int inferAllDifferentSize;
        public final boolean recognizePermutations;
        public final int arityLimitForVapArrayLb;
        public final int arityLimitForVapArrayUb;

        public SettingCtrs() {
            this.s_ignoreType = "Ignore all constraints of this type. Works for XCSP3";
            this.s_ignoreArity = "Ignore all constraints of this arity. Works for XCSP3";
            this.r2 = "When > 0, redundant allDifferent constraints are sought (at most as the given value) and posted (if any) to improve the filtering capability of the solver.\n\tTry this on a pigeons instance.";
            this.r5 = "Create Permutation constraints instead of classic AllDifferent when possible. Less filtering but may be faster.";
            this.preserveUnaryCtrs = this.addB("preserveUnaryCtrs", "puc", true, "", new int[0]);
            this.decomposeIntention = this.addI("decomposeIntention", "di", 1, "0: no decomposition, 1: conditional decomposition, 2: forced decompostion", new int[0]);
            this.viewForSum = this.addB("viewForSum", "vs", false, "", new int[0]);
            this.intensionToExtensionUnaryCtrs = this.addB("intensionToExtensionUnaryCtrs", "ieuc", true, "", new int[0]);
            this.ignoredCtrType = Types.valueOf(Types.TypeCtr.class, this.addS("ignoreCtrType", "ignoreType", "", this.s_ignoreType, new int[0]));
            this.ignoreCtrArity = this.addI("ignoreCtrArity", "ignoreArity", -1, this.s_ignoreArity, new int[0]);
            this.ignorePrimitives = this.addB("ignorePrimitives", "ip", false, "", new int[0]);
            this.inferAllDifferentNb = this.addI("inferAllDifferentNb", "iad", 0, this.r2, new int[0]);
            this.inferAllDifferentSize = this.addI("inferAllDifferentSize", "iadsz", 5, "", new int[0]);
            this.recognizePermutations = this.addB("recognizePermutations", "perm", false, this.r5, new int[0]);
            this.arityLimitForVapArrayLb = this.addI("arityLimitForVapArrayLb", "alvalb", 2, "", new int[0]);
            this.arityLimitForVapArrayUb = this.addI("arityLimitForVapArrayUb", "alvaub", 10000, "", new int[0]);
        }
    }

    public class SettingVars
    extends SettingGroup {
        String s_sel;
        String s_ins;
        String s_pr1;
        String s_pr2;
        String s_riv;
        protected final String selection;
        protected final String instantiation;
        protected final String priority1;
        protected final String priority2;
        public final boolean reduceIsolatedVars;
        public final Object[] selectedVars;
        public final Object[] instantiatedVars;
        public final int[] instantiatedVals;
        private final Object[] priority1Vars;
        private final Object[] priority2Vars;
        public final Object[] priorityVars;
        public final int nStrictPriorityVars;

        public SettingVars() {
            this.s_sel = "Allows us to give a list of variable that will form the subproblem to be solved.\n\tThis list is composed of a sequence of tokens separated by commas (no whitespace).\n\tEach token is a variable id a variable number or an interval of the form i..j with i and j integers.\n\tFor example, -sel=2..10,31,-4 will denote the list 2 3 5 6 7 8 9 10 31.\n\tThis is only valid for a XCSP instance.";
            this.s_ins = "Allows us to give an instantiation of variables for the problem to be solved.\n\tThis instantiation is given under the form vars:values.\n\tvars is a sequence of variable ids or numbers separated by commas (no whitespace).\n\tvalues is a sequence of integers (the values for variables) separated by commas (no whitespace).\n\tFor example, -ins=x2,x4,x9:1,11,4 will denote the instantiation {x2=1,x4=11,x9=4}.";
            this.s_pr1 = "Allows us to give a list of variables that will become strict priority variables (to be used by the variable ordering heuristic).\n\tThis list is composed of a sequence of strings (ids of variables) or integers (numbers of variables) separated by commas (no whitespace).\n\tFor example, -pr1=2,8,1,10 will denote the list 2 8 1 10.";
            this.s_pr2 = "Allows us to give a list of variables that will become (non strict) priority variables.\n\tThis list is composed of a sequence of tokens separated by commas (no whitespace).\n\tEach token is variable id, a variable number (integer) or an interval of the form i..j with i and j integers..\n\tFor example, -pr2=2..10,31,-4 will denote the list 2 3 5 6 7 8 9 10 31.";
            this.s_riv = "When set to true, only keep one arbitrary value in the domain of each variable involved in no constraint.";
            this.selection = this.addS("selection", "sel", "", this.s_sel, new int[0]);
            this.instantiation = this.addS("instantiation", "ins", "", this.s_ins, new int[0]);
            this.priority1 = this.addS("priority1", "pr1", "", this.s_pr1, new int[0]);
            this.priority2 = this.addS("priority2", "pr2", "", this.s_pr2, new int[0]);
            this.reduceIsolatedVars = this.addB("reduceIsolatedVars", "riv", true, this.s_riv, new int[0]);
            this.selectedVars = this.readSelectionList(this.selection);
            this.instantiatedVars = (Object[])this.splitSelection(true);
            this.instantiatedVals = (int[])this.splitSelection(false);
            this.priority1Vars = this.readSelectionList(this.priority1);
            this.priority2Vars = this.readSelectionList(this.priority2);
            this.priorityVars = this.controlAndFinalizeVariablesLists(this.priority1Vars, this.priority2Vars);
            this.nStrictPriorityVars = this.instantiatedVars.length + this.priority1Vars.length;
        }

        private Object[] readSelectionList(String s) {
            if (s == null || s.trim().length() == 0) {
                return new Object[0];
            }
            String msg = "Badly formed list. For example, you cannot mix ids and numbers of variables in the same list.";
            HashSet<Object> set = new HashSet<Object>();
            for (String token : s.split(",")) {
                if (token.contains("..")) {
                    Kit.control(token.matches("-?\\d+\\.\\.\\d+"), () -> msg + " Pb with " + token);
                    Kit.control(set.isEmpty() || set.iterator().next() instanceof Integer, () -> msg);
                    int[] t = Utilities.toIntegers(token.split("\\.\\."));
                    for (int num = Math.abs(t[0]); num <= t[1]; ++num) {
                        if (t[0] >= 0) {
                            set.add(num);
                            continue;
                        }
                        set.remove(num);
                    }
                    continue;
                }
                Integer num = Kit.parseInteger(token);
                if (num != null) {
                    Kit.control(set.isEmpty() || set.iterator().next() instanceof Integer, () -> msg);
                    if (num >= 0) {
                        set.add(num);
                        continue;
                    }
                    set.remove(-num.intValue());
                    continue;
                }
                Kit.control(set.isEmpty() || set.iterator().next() instanceof String, () -> msg);
                set.add(token);
            }
            return Kit.sort(set.toArray(new Object[set.size()]));
        }

        private Object splitSelection(boolean left) {
            if (this.instantiation.trim().length() == 0) {
                return left ? new Object[]{} : (Object[])new int[0];
            }
            String[] t = this.instantiation.trim().split(":");
            Kit.control(t.length == 2, () -> this.instantiation);
            return left ? this.readSelectionList(t[0]) : (Object[])Utilities.toIntegers(t[1].split(","));
        }

        private Object[] controlAndFinalizeVariablesLists(Object[] priority1Vars, Object[] priority2Vars) {
            Object[] t = Kit.concat(this.instantiatedVars, priority1Vars, priority2Vars);
            if (t.length > 0) {
                Kit.control(Stream.of(t).distinct().count() == (long)t.length, () -> "Two variables are identical in your lists (-sel -pr1 -pr2)");
                Kit.control(this.selectedVars.length == 0 || Stream.of(t).allMatch(o -> Arrays.binarySearch(this.selectedVars, o) >= 0), () -> "One variable present in one of your list -ins -pr1 or -pr2 is not present in your selection (-sel).");
            }
            return t;
        }
    }

    public class SettingProblem
    extends SettingGroup {
        String s_data;
        String s_dataFormat;
        String s_dataexport;
        String s_variant;
        String s_sb;
        String s_sbv;
        String s_cg;
        String s_be;
        public final String data;
        public final String dataFormat;
        public final boolean dataexport;
        public final String variant;
        public final boolean shareBitVectors;
        public final Enums.EBinaryEncoding binaryEncoding;
        public final Enums.ESymmetryBreaking symmetryBreaking;

        public SettingProblem() {
            this.s_data = "Parameter similar to the one defined for " + Compiler.class.getName();
            this.s_dataFormat = "Parameter similar to the one defined for " + Compiler.class.getName();
            this.s_dataexport = "Parameter similar to the one defined for " + Compiler.class.getName();
            this.s_variant = "Parameter similar to the one defined for " + Compiler.class.getName();
            this.s_sb = "Allows us to post (if possible) symmetry breaking constraints using the method described in [Lecoutre and Tabary 2009].\n\tSaucy is required to run the different methods.";
            this.s_sbv = "Try to save space by sharing bit vectors.";
            this.s_cg = "Add binary constraints to get a complete constraint graph.";
            this.s_be = "Transforms a CN only involving (non-binary) extensional constraints into a binary CN.\n\tCurrently, only works for XCSP2. To be implemented for XCSP3 for just the hidden encoding.";
            this.data = this.addS("data", "data", "", this.s_data, new int[0]);
            this.dataFormat = this.addS("dataFormat", "dataFormat", "", this.s_dataFormat, new int[0]);
            this.dataexport = this.addB("dataexport", "dataexport", false, this.s_dataexport, new int[0]);
            this.variant = this.addS("variant", "variant", "", this.s_variant, new int[0]);
            this.shareBitVectors = this.addB("shareBitVectors", "sbv", false, this.s_sbv, 4);
            this.binaryEncoding = this.addE("binaryEncoding", "be", Enums.EBinaryEncoding.NO, this.s_be, 4);
            this.symmetryBreaking = this.addE("symmetryBreaking", "sb", Enums.ESymmetryBreaking.NO, this.s_sb, new int[0]);
        }

        public boolean isSymmetryBreaking() {
            return this.symmetryBreaking != Enums.ESymmetryBreaking.NO;
        }
    }

    public class SettingGeneral
    extends SettingGroup {
        String s_framework;
        String s_s;
        String s_timeout;
        String s_verbose;
        String s_trace;
        String s_seed;
        String s_ev;
        String s_ea;
        String l_cfs;
        String s_cfs;
        String s_rs;
        public Types.TypeFramework framework;
        public long nSearchedSolutions;
        public final long timeout;
        public int verbose;
        public int jsonLimit;
        public final boolean jsonAux;
        public boolean xmlCompact;
        public boolean xmlAllSolutions;
        public final String trace;
        public final long seed;
        public final boolean makeExceptionsVisible;
        public final boolean enableAnnotations;
        public final int limitForSatisfaction;
        public final String conditionForSatisfaction;
        public final boolean recordSolutions;
        public final boolean noPrintColors;

        public SettingGeneral() {
            this.s_framework = "The kind of problem instance to be solved (the specified value is case-insensitive).";
            this.s_s = "The number of solutions that must be found before the solver stops.\n\tFor all solutions, use -s=all or -s=max.";
            this.s_timeout = "The number of milliseconds that are passed before the solver stops.\n\tYou can use the letter s as a suffix to denote seconds as e.g., -t=10s.\n\tFor no timeout, use -t= or -t=max.";
            this.s_verbose = "Displays more or less precise information concerning the problem instance and the solution(s) found.\n\tThe specified value must belong  in {0,1,2,3}.\n\tThis mode is used as follows.\n\t0 : only some global statistics are listed ;\n\t1 : in addition, solutions are  shown ;\n\t2 : in addition, additionnal information about the problem instance to be solved is given ;\n\t3 : in addition, for each constraint, allowed or unallowed tuples are displayed.";
            this.s_trace = "Displays every decision taken during search with -trace.\n\tYou can control the trace with a required min depth and/or max depth as eg -trace=10-20.";
            this.s_seed = "The seed that can be used for some random-based methods.";
            this.s_ev = "Makes exceptions visible.";
            this.s_ea = "Enables annotations (currently, mainly concerns priority variables).";
            this.l_cfs = "Only valid if a COP is loaded and if the framework is set to CSP by the user.\n\tIn that case, the objective is turned into a constraint specified by this limit.";
            this.s_cfs = "Only valid if a COP is loaded and if the framework is set to CSP by the user.\n\tIn that case, the objective is turned into a constraint specified by this condition.\t The condition has the form (operator,value) as e.g., (lt,10). Currently, not operative, so must be implemented for XCSP3";
            this.s_rs = "Records all found solutions in a list of " + SolutionRecorder.class.getName();
            this.framework = null;
            this.nSearchedSolutions = this.addL("nSearchedSolutions", "s", -1L, this.s_s, new int[0]);
            this.timeout = this.addL("timeout", "t", Long.MAX_VALUE, this.s_timeout, new int[0]);
            this.verbose = this.addI("verbose", "v", 0, this.s_verbose, new int[0]);
            this.jsonLimit = this.addI("jsonLimit", "jsonLimit", 1000, "", new int[0]);
            this.jsonAux = this.addB("jsonAux", "jsonAux", false, "", new int[0]);
            this.xmlCompact = this.addB("xmlCompact", "xmlCompact", true, "", new int[0]);
            this.xmlAllSolutions = this.addB("xmlAllSolutions", "xas", false, "", new int[0]);
            this.trace = this.addS("trace", "trace", "", this.s_trace, new int[0]);
            this.seed = this.addL("seed", "seed", 0L, this.s_seed, new int[0]);
            this.makeExceptionsVisible = this.addB("makeExceptionsVisible", "ev", false, this.s_ev, new int[0]);
            this.enableAnnotations = this.addB("enableAnnotations", "ea", false, this.s_ea, new int[0]);
            this.limitForSatisfaction = this.addI("limitForSatisfaction", "lfs", Integer.MAX_VALUE, this.l_cfs, new int[0]);
            this.conditionForSatisfaction = this.addS("conditionForSatisfaction", "cfs", "", this.s_cfs, 4);
            this.recordSolutions = this.addB("recordSolutions", "rs", false, this.s_rs, 4);
            this.noPrintColors = this.addB("noPrintColors", "npc", false, "", 4);
        }
    }

    public class SettingXml
    extends SettingGroup {
        String s_dc;
        String s_dir;
        public final String discardedClasses;
        public final String dirForCampaign;
        public final boolean primitiveUnaryInSolver;
        public final boolean primitiveBinaryInSolver;
        public final boolean primitiveTernaryInSolver;
        public final boolean recognizeLogicInSolver;
        public final boolean recognizeExtremumInSolver;
        public final boolean recognizeSumInSolver;

        public SettingXml() {
            this.s_dc = "Names of classes (tags) to discard (use comma as separator if several classes). Effective iff an XCSP3 file is loaded.";
            this.s_dir = "Indicates the name of a directory where results (XML files) for a campaign will be stored.\n\tIf the value is the empty string, results are not saved.";
            this.discardedClasses = this.addS("discardedClasses", "dc", "", this.s_dc, new int[0]);
            this.dirForCampaign = this.addS("dirForCampaign", "dir", "", this.s_dir, new int[0]);
            this.primitiveUnaryInSolver = this.addB("primitiveUnaryInSolver", "p1sol", true, "", 4);
            this.primitiveBinaryInSolver = this.addB("primitiveBinaryInSolver", "p2sol", true, "", 4);
            this.primitiveTernaryInSolver = this.addB("primitiveTernarnyInSolver", "p3sol", true, "", 4);
            this.recognizeLogicInSolver = this.addB("primitiveLogicInSolver", "rlsol", true, "", 4);
            this.recognizeExtremumInSolver = this.addB("recognizeExtremumInSolver", "resol", true, "", 4);
            this.recognizeSumInSolver = this.addB("recognizeSumInSolver", "rssol", true, "", 4);
        }
    }

    class SettingGroup {
        protected static final int HIDDEN = 4;
        protected static final int TO_IMPLEMENT = 4;

        SettingGroup() {
        }

        protected String tag() {
            return this.getClass().getSimpleName().substring(0, 1).toLowerCase() + this.getClass().getSimpleName().substring(1);
        }

        private int pr(int[] t) {
            return t.length == 0 ? 1 : (t.length == 1 ? t[0] : (Integer)Kit.exit("Only zero or one priority value expected"));
        }

        protected int addI(String attribute, String shortcut, int defaultValue, String description, int ... priority) {
            return Control.this.settings.addI(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected long addL(String attribute, String shortcut, long defaultValue, String description, int ... priority) {
            return Control.this.settings.addL(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected double addD(String attribute, String shortcut, double defaultValue, String description, int ... priority) {
            return Control.this.settings.addD(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected boolean addB(String attribute, String shortcut, boolean defaultValue, String description, int ... priority) {
            return Control.this.settings.addB(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected String addS(String attribute, String shortcut, String defaultValue, String description, int ... priority) {
            return Control.this.settings.addS(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected String addS(String attribute, String shortcut, Class<?> defaultValue, Class<?> root, String description, int ... priority) {
            return Control.this.settings.addS(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, root, description);
        }

        private Class<?> getLastButOneSuperclassOf(Class<?> clazz) {
            for (Class<?> superclass = clazz.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
                clazz = superclass;
            }
            return clazz;
        }

        protected String addS(String attribute, String shortcut, Class<?> defaultValue, String description, int ... priority) {
            return this.addS(attribute, shortcut, defaultValue, this.getLastButOneSuperclassOf(defaultValue), description, new int[0]);
        }

        protected <T extends Enum<T>> T addE(String attribute, String shortcut, T defaultValue, String description, int ... priority) {
            return Control.this.settings.addE(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }
    }
}

