/*
 * Decompiled with CFR 0.152.
 */
package constraints.intension;

import constraints.Constraint;
import constraints.intension.Primitive;
import interfaces.Tags;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class PrimitiveLogic
extends Primitive
implements Tags.TagAC,
Tags.TagNotSymmetric {
    Variable x;
    Variable[] list;
    Domain dx;

    public PrimitiveLogic(Problem pb, Variable x, Variable[] list) {
        super(pb, (Variable[])pb.api.vars(x, list));
        this.x = x;
        this.dx = x.dom;
        this.list = list;
        this.control(list.length > 1 && !Kit.isPresent(x, list) && Variable.areAllInitiallyBoolean(this.scp), "Variables must be 01");
    }

    public static abstract class PrimitiveLogicEq
    extends PrimitiveLogic {
        public static Constraint buildFrom(Problem pb, Variable x, Types.TypeLogicalOperator op, Variable[] list) {
            switch (op) {
                case OR: {
                    return list.length == 2 ? new LogEqOr2(pb, x, list) : new LogEqOr(pb, x, list);
                }
                case AND: {
                    return list.length == 2 ? new LogEqAnd2(pb, x, list) : new LogEqAnd(pb, x, list);
                }
            }
            return null;
        }

        public PrimitiveLogicEq(Problem pb, Variable x, Variable[] list) {
            super(pb, x, list);
        }

        public static final class LogEqOr
        extends PrimitiveLogicEq
        implements Tags.TagFilteringCompleteAtEachCall {
            private Variable sentinel1;
            private Variable sentinel2;

            @Override
            public final boolean checkValues(int[] t) {
                if (t[0] == 0) {
                    for (int v : t) {
                        if (v != 1) continue;
                        return false;
                    }
                    return true;
                }
                for (int i = 1; i < t.length; ++i) {
                    if (t[i] != 1) continue;
                    return true;
                }
                return false;
            }

            private Variable findSentinel(Variable other) {
                for (Variable y : this.list) {
                    if (y == other || y.dom.last() != 1) continue;
                    return y;
                }
                return null;
            }

            public LogEqOr(Problem pb, Variable x, Variable[] list) {
                super(pb, x, list);
                this.sentinel1 = list[0];
                this.sentinel2 = list[1];
            }

            @Override
            public boolean runPropagator(Variable evt) {
                for (Variable y2 : this.list) {
                    if (y2.dom.first() != 1) continue;
                    return this.dx.removeIfPresent(0) && this.entailed();
                }
                assert (Stream.of(this.list).allMatch(y -> y.dom.first() == 0)) : "0 should be present in the domain of every variable of the list";
                if (this.dx.last() == 0) {
                    for (Variable y2 : this.list) {
                        y2.dom.removeIfPresent(1);
                    }
                    return this.entailed();
                }
                if (this.dx.first() == 1) {
                    Variable y3;
                    if (this.sentinel1.dom.last() == 0) {
                        y3 = this.findSentinel(this.sentinel2);
                        if (y3 == null) {
                            return this.sentinel2.dom.remove(0) && this.entailed();
                        }
                        this.sentinel1 = y3;
                    }
                    if (this.sentinel2.dom.last() == 0) {
                        y3 = this.findSentinel(this.sentinel1);
                        if (y3 == null) {
                            return this.sentinel1.dom.remove(0) && this.entailed();
                        }
                        this.sentinel2 = y3;
                    }
                    return true;
                }
                if (this.sentinel1.dom.last() == 1 || this.sentinel2.dom.last() == 1) {
                    return true;
                }
                for (Variable y2 : this.list) {
                    if (y2.dom.last() != 1) continue;
                    this.sentinel1 = y2;
                    return true;
                }
                return this.dx.remove(1) && this.entailed();
            }
        }

        public static final class LogEqOr2
        extends PrimitiveLogicEq
        implements Tags.TagFilteringCompleteAtEachCall {
            Variable y;
            Variable z;
            Domain dy;
            Domain dz;

            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 0 ? t[1] == 0 && t[2] == 0 : t[1] == 1 || t[2] == 1;
            }

            public LogEqOr2(Problem pb, Variable x, Variable[] list) {
                super(pb, x, list);
                this.control(list.length == 2);
                this.y = list[0];
                this.z = list[1];
                this.dy = this.y.dom;
                this.dz = this.z.dom;
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.last() == 0) {
                    return this.dy.removeIfPresent(1) && this.dz.removeIfPresent(1) && this.entailed();
                }
                if (!this.dy.present(0) || !this.dz.present(0)) {
                    return this.dx.removeIfPresent(0) && this.entailed();
                }
                if (this.dy.size() == 1 && this.dz.size() == 1) {
                    return this.dx.remove(1) && this.entailed();
                }
                if (this.dx.size() == 2) {
                    return true;
                }
                if (this.dy.size() == 2 && this.dz.size() == 2) {
                    return true;
                }
                if (this.dy.size() == 2) {
                    return this.dy.remove(0) && this.entailed();
                }
                return this.dz.remove(0) && this.entailed();
            }
        }

        public static final class LogEqAnd
        extends PrimitiveLogicEq
        implements Tags.TagFilteringCompleteAtEachCall {
            private Variable sentinel1;
            private Variable sentinel2;

            @Override
            public final boolean checkValues(int[] t) {
                if (t[0] == 0) {
                    for (int i = 1; i < t.length; ++i) {
                        if (t[i] != 0) continue;
                        return true;
                    }
                    return false;
                }
                for (int v : t) {
                    if (v != 0) continue;
                    return false;
                }
                return true;
            }

            private Variable findSentinel(Variable other) {
                for (Variable y : this.list) {
                    if (y == other || y.dom.first() != 0) continue;
                    return y;
                }
                return null;
            }

            public LogEqAnd(Problem pb, Variable x, Variable[] list) {
                super(pb, x, list);
                this.sentinel1 = list[0];
                this.sentinel2 = list[1];
            }

            @Override
            public boolean runPropagator(Variable evt) {
                for (Variable y2 : this.list) {
                    if (y2.dom.last() != 0) continue;
                    return this.dx.removeIfPresent(1) && this.entailed();
                }
                assert (Stream.of(this.list).allMatch(y -> y.dom.last() == 1)) : "1 should be present in the domain of every variable of the list";
                if (this.dx.first() == 1) {
                    for (Variable y2 : this.list) {
                        y2.dom.removeIfPresent(0);
                    }
                    return this.entailed();
                }
                if (this.dx.last() == 0) {
                    Variable y3;
                    if (this.sentinel1.dom.first() == 1) {
                        y3 = this.findSentinel(this.sentinel2);
                        if (y3 == null) {
                            return this.sentinel2.dom.remove(1) && this.entailed();
                        }
                        this.sentinel1 = y3;
                    }
                    if (this.sentinel2.dom.first() == 1) {
                        y3 = this.findSentinel(this.sentinel1);
                        if (y3 == null) {
                            return this.sentinel1.dom.remove(1) && this.entailed();
                        }
                        this.sentinel2 = y3;
                    }
                    return true;
                }
                if (this.sentinel1.dom.first() == 0 || this.sentinel2.dom.first() == 0) {
                    return true;
                }
                for (Variable y2 : this.list) {
                    if (y2.dom.first() != 0) continue;
                    this.sentinel1 = y2;
                    return true;
                }
                return this.dx.remove(0) && this.entailed();
            }
        }

        public static final class LogEqAnd2
        extends PrimitiveLogicEq
        implements Tags.TagFilteringCompleteAtEachCall {
            Variable y;
            Variable z;
            Domain dy;
            Domain dz;

            @Override
            public final boolean checkValues(int[] t) {
                return t[0] == 0 ? t[1] == 0 || t[2] == 0 : t[1] == 1 && t[2] == 1;
            }

            public LogEqAnd2(Problem pb, Variable x, Variable[] list) {
                super(pb, x, list);
                this.control(list.length == 2);
                this.y = list[0];
                this.z = list[1];
                this.dy = this.y.dom;
                this.dz = this.z.dom;
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.first() == 1) {
                    return this.dy.removeIfPresent(0) && this.dz.removeIfPresent(0) && this.entailed();
                }
                if (!this.dy.present(1) || !this.dz.present(1)) {
                    return this.dx.removeIfPresent(1) && this.entailed();
                }
                if (this.dy.size() == 1 && this.dz.size() == 1) {
                    return this.dx.remove(0) && this.entailed();
                }
                if (this.dx.size() == 2) {
                    return true;
                }
                if (this.dy.size() == 2 && this.dz.size() == 2) {
                    return true;
                }
                if (this.dy.size() == 2) {
                    return this.dy.remove(1) && this.entailed();
                }
                return this.dz.remove(1) && this.entailed();
            }
        }
    }
}

