/*
 * Decompiled with CFR 0.152.
 */
package constraints.intension;

import constraints.Constraint;
import interfaces.FilteringSpecific;
import interfaces.Tags;
import java.util.stream.Stream;
import problem.Problem;
import variables.Domain;
import variables.Variable;

public abstract class Primitive
extends Constraint
implements FilteringSpecific {
    protected final void defineKey(Object ... datas) {
        StringBuilder sb = this.signature().append(' ').append(this.getClass().getSimpleName());
        Stream.of(datas).forEach(data -> sb.append(' ').append(data.toString()));
        this.key = sb.toString();
    }

    public Primitive(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.defineKey(new Object[0]);
    }

    public static final class Disjonctive2D
    extends Primitive
    implements Tags.TagAC {
        final Variable x1;
        final Variable x2;
        final Variable y1;
        final Variable y2;
        final int w1;
        final int w2;
        final int h1;
        final int h2;
        final Domain dx1;
        final Domain dx2;
        final Domain dy1;
        final Domain dy2;

        @Override
        public boolean checkValues(int[] t) {
            return t[0] + this.w1 <= t[1] || t[1] + this.w2 <= t[0] || t[2] + this.h1 <= t[3] || t[3] + this.h2 <= t[2];
        }

        public Disjonctive2D(Problem pb, Variable x1, Variable x2, Variable y1, Variable y2, int w1, int w2, int h1, int h2) {
            super(pb, new Variable[]{x1, x2, y1, y2});
            this.control(this.scp.length == 4);
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
            this.w1 = w1;
            this.w2 = w2;
            this.h1 = h1;
            this.h2 = h2;
            this.dx1 = x1.dom;
            this.dx2 = x2.dom;
            this.dy1 = y1.dom;
            this.dy2 = y2.dom;
            this.defineKey(w1, w2, h1, h2);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            boolean by;
            int minx1 = this.dx1.firstValue() + this.w1;
            int minx2 = this.dx2.firstValue() + this.w2;
            int miny1 = this.dy1.firstValue() + this.h1;
            int miny2 = this.dy2.firstValue() + this.h2;
            boolean bx1 = minx1 <= this.dx2.lastValue();
            boolean bx2 = minx2 <= this.dx1.lastValue();
            boolean by1 = miny1 <= this.dy2.lastValue();
            boolean by2 = miny2 <= this.dy1.lastValue();
            boolean bx = bx1 || bx2;
            boolean bl = by = by1 || by2;
            if (bx && by) {
                return true;
            }
            if (!bx && !by) {
                return false;
            }
            if (bx) {
                return this.dx1.removeValuesInRange(this.dx2.lastValue() - this.w1 + 1, minx2) && this.dx2.removeValuesInRange(this.dx1.lastValue() - this.w2 + 1, minx1);
            }
            return this.dy1.removeValuesInRange(this.dy2.lastValue() - this.h1 + 1, miny2) && this.dy2.removeValuesInRange(this.dy1.lastValue() - this.h2 + 1, miny1);
        }
    }

    public static final class DisjonctiveVar
    extends Primitive
    implements Tags.TagAC {
        final Variable x1;
        final Variable x2;
        final Variable w1;
        final Variable w2;
        final Domain dx1;
        final Domain dx2;
        final Domain dw1;
        final Domain dw2;

        @Override
        public boolean checkValues(int[] t) {
            return t[0] + t[2] <= t[1] || t[1] + t[3] <= t[0];
        }

        public DisjonctiveVar(Problem pb, Variable x1, Variable x2, Variable w1, Variable w2) {
            super(pb, new Variable[]{x1, x2, w1, w2});
            this.x1 = x1;
            this.x2 = x2;
            this.w1 = w1;
            this.w2 = w2;
            this.dx1 = x1.dom;
            this.dx2 = x2.dom;
            this.dw1 = w1.dom;
            this.dw2 = w2.dom;
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            boolean b2;
            int min1 = this.dx1.firstValue() + this.dw1.firstValue();
            int min2 = this.dx2.firstValue() + this.dw2.firstValue();
            int max1 = this.dx2.lastValue() - this.dw1.firstValue();
            int max2 = this.dx1.lastValue() - this.dw2.firstValue();
            boolean b1 = min1 <= this.dx2.lastValue();
            boolean bl = b2 = min2 <= this.dx1.lastValue();
            if (!b1 && !b2) {
                return false;
            }
            if (!b2) {
                return this.dx2.removeValuesLT(min1) && this.dx1.removeValuesGT(max1) && this.dw1.removeValuesGT(this.dx2.lastValue() - this.dx1.firstValue());
            }
            if (!b1) {
                return this.dx1.removeValuesLT(min2) && this.dx2.removeValuesGT(max2) && this.dw2.removeValuesGT(this.dx1.lastValue() - this.dx2.firstValue());
            }
            return this.dx1.removeValuesInRange(max1 + 1, min2) && this.dx2.removeValuesInRange(max2 + 1, min1);
        }
    }
}

