/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import optimization.Optimizable;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.TreeEvaluator;
import org.xcsp.common.predicates.XNode;
import problem.Problem;
import utility.Kit;
import variables.Domain;
import variables.DomainInfinite;
import variables.Variable;

public abstract class Sum
extends Constraint.CtrGlobal
implements Tags.TagFilteringCompleteAtEachCall {
    protected long limit;
    protected long min;
    protected long max;
    protected long minComputableObjectiveValue;
    protected long maxComputableObjectiveValue;

    public final long limit() {
        return this.limit;
    }

    public final void limit(long newLimit) {
        this.limit = newLimit;
        this.control(this.minComputableObjectiveValue - 1L <= this.limit && this.limit <= this.maxComputableObjectiveValue + 1L);
    }

    public Sum(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.control(scp.length > 1);
    }

    protected boolean controlFCLevel() {
        int singletonPosition = -1;
        for (int i = 0; i < this.scp.length; ++i) {
            if (this.scp[i].dom.size() == 1) {
                this.vals[i] = this.scp[i].dom.uniqueValue();
                continue;
            }
            if (singletonPosition == -1) {
                singletonPosition = i;
                continue;
            }
            return true;
        }
        if (singletonPosition == -1) {
            return this.checkValues(this.vals);
        }
        Domain dom = this.scp[singletonPosition].dom;
        int a = dom.first();
        while (a != -1) {
            this.vals[singletonPosition] = dom.toVal(a);
            this.control(this.checkValues(this.vals), () -> "pb with " + Kit.join((Object)this.vals, new String[0]));
            a = dom.next(a);
        }
        return true;
    }

    public static abstract class SumViewWeighted
    extends Sum {
        public final XNode<IVar>[] trees;
        public final int[] coeffs;
        final View[] views;

        public static SumViewWeighted buildFrom(Problem pb, XNode<IVar>[] trees, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
            switch (op) {
                case LT: {
                    return new SumViewWeightedLE(pb, trees, coeffs, limit - 1L);
                }
                case LE: {
                    return new SumViewWeightedLE(pb, trees, coeffs, limit);
                }
                case GE: {
                    return new SumViewWeightedGE(pb, trees, coeffs, limit);
                }
                case GT: {
                    return new SumViewWeightedGE(pb, trees, coeffs, limit + 1L);
                }
                case EQ: {
                    return new SumViewWeightedEQ(pb, trees, coeffs, limit);
                }
            }
            throw new AssertionError();
        }

        public static long weightedSum(int[] t, View[] views, int[] coeffs) {
            assert (t.length == coeffs.length && t.length == coeffs.length);
            long sum = 0L;
            for (int i = 0; i < t.length; ++i) {
                sum += (long)(coeffs[i] * views[i].evaluate(t[i]));
            }
            return sum;
        }

        public static long minPossibleSum(View[] views, int[] coeffs) {
            BigInteger sum = BigInteger.valueOf(0L);
            for (int i = 0; i < views.length; ++i) {
                sum = views[i] instanceof View.ViewVariable ? sum.add(BigInteger.valueOf(coeffs[i]).multiply(BigInteger.valueOf(coeffs[i] >= 0 ? (long)views[i].dom.toVal(0) : (long)views[i].dom.toVal(views[i].dom.initSize() - 1)))) : sum.add(BigInteger.valueOf(coeffs[i]).multiply(BigInteger.valueOf(coeffs[i] >= 0 ? 0L : 1L)));
            }
            return sum.longValueExact();
        }

        public static long maxPossibleSum(View[] views, int[] coeffs) {
            BigInteger sum = BigInteger.valueOf(0L);
            for (int i = 0; i < views.length; ++i) {
                sum = views[i] instanceof View.ViewVariable ? sum.add(BigInteger.valueOf(coeffs[i]).multiply(BigInteger.valueOf(coeffs[i] >= 0 ? (long)views[i].dom.toVal(views[i].dom.initSize() - 1) : (long)views[i].dom.toVal(0)))) : sum.add(BigInteger.valueOf(coeffs[i]).multiply(BigInteger.valueOf(coeffs[i] >= 0 ? 1L : 0L)));
            }
            return sum.longValueExact();
        }

        public long minComputableObjectiveValue() {
            return SumViewWeighted.minPossibleSum(this.views, this.coeffs);
        }

        public long maxComputableObjectiveValue() {
            return SumViewWeighted.maxPossibleSum(this.views, this.coeffs);
        }

        public long minCurrentObjectiveValue() {
            long sum = 0L;
            for (int i = 0; i < this.views.length; ++i) {
                sum += (long)(this.coeffs[i] * (this.coeffs[i] >= 0 ? this.views[i].minValue() : this.views[i].maxValue()));
            }
            return sum;
        }

        public long maxCurrentObjectiveValue() {
            long sum = 0L;
            for (int i = 0; i < this.views.length; ++i) {
                sum += (long)(this.coeffs[i] * (this.coeffs[i] >= 0 ? this.views[i].maxValue() : this.views[i].minValue()));
            }
            return sum;
        }

        protected long currWeightedSum() {
            long sum = 0L;
            for (int i = 0; i < this.views.length; ++i) {
                sum += (long)(this.views[i].uniqueValue() * this.coeffs[i]);
            }
            return sum;
        }

        public SumViewWeighted(Problem pb, XNode<IVar>[] trees, int[] coeffs, long limit) {
            super(pb, Utilities.collect(Variable.class, Stream.of(trees).map(tree -> tree.vars())));
            this.trees = trees;
            this.coeffs = coeffs;
            this.views = (View[])Stream.of(trees).map(tree -> tree.type == Types.TypeExpr.VAR ? new View.ViewVariable((XNode<IVar>)tree) : new View.ViewTree01((XNode<IVar>)tree)).toArray(View[]::new);
            this.minComputableObjectiveValue = this.minComputableObjectiveValue();
            this.maxComputableObjectiveValue = this.maxComputableObjectiveValue();
            this.control(this.minComputableObjectiveValue <= this.maxComputableObjectiveValue);
            this.limit(limit);
            this.defineKey(Kit.join((Object)coeffs, new String[0]), limit);
            this.control(IntStream.range(0, coeffs.length).allMatch(i -> coeffs[i] != 0 && (i == 0 || coeffs[i - 1] <= coeffs[i])));
        }

        protected void recomputeBounds() {
            this.max = 0L;
            this.min = 0L;
            for (int i = 0; i < this.views.length; ++i) {
                int coeff;
                this.min += (long)(coeff * ((coeff = this.coeffs[i]) >= 0 ? this.views[i].minValue() : this.views[i].maxValue()));
                this.max += (long)(coeff * (coeff >= 0 ? this.views[i].maxValue() : this.views[i].minValue()));
            }
        }

        public static final class SumViewWeightedEQ
        extends SumViewWeighted
        implements Tags.TagNotAC {
            @Override
            public boolean checkValues(int[] t) {
                return SumViewWeightedEQ.weightedSum(t, this.views, this.coeffs) == this.limit;
            }

            public SumViewWeightedEQ(Problem pb, XNode<IVar>[] trees, int[] coeffs, long limit) {
                super(pb, trees, coeffs, limit);
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.limit < this.min || this.limit > this.max) {
                    return x.dom.fail();
                }
                if (this.futvars.size() > 0) {
                    int lastModified = this.futvars.limit;
                    int i = this.futvars.limit;
                    do {
                        int coeff;
                        int p = this.futvars.dense[i];
                        View view = this.views[p];
                        int sizeBefore = view.dom.size();
                        if (sizeBefore <= 1) continue;
                        this.min -= (long)(coeff * ((coeff = this.coeffs[p]) >= 0 ? view.minValue() : view.maxValue()));
                        this.max -= (long)(coeff * (coeff >= 0 ? view.maxValue() : view.minValue()));
                        if (!view.removeValues(Types.TypeOperatorRel.LT, this.limit - this.max, coeff) || !view.removeValues(Types.TypeOperatorRel.GT, this.limit - this.min, coeff)) {
                            return false;
                        }
                        if (sizeBefore != view.dom.size()) {
                            lastModified = i;
                        }
                        this.min += (long)(coeff * (coeff >= 0 ? view.minValue() : view.maxValue()));
                        this.max += (long)(coeff * (coeff >= 0 ? view.maxValue() : view.minValue()));
                    } while (lastModified != (i = i > 0 ? i - 1 : this.futvars.limit));
                }
                assert (this.controlFCLevel());
                return true;
            }
        }

        public static class SumViewWeightedGE
        extends SumViewWeighted
        implements Tags.TagAC,
        Optimizable {
            @Override
            public boolean checkValues(int[] t) {
                return SumViewWeightedGE.weightedSum(t, this.views, this.coeffs) >= this.limit;
            }

            @Override
            public long objectiveValue() {
                return this.currWeightedSum();
            }

            public SumViewWeightedGE(Problem pb, XNode<IVar>[] trees, int[] coeffs, long limit) {
                super(pb, trees, coeffs, limit);
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.min >= this.limit) {
                    return this.entailed();
                }
                if (this.max < this.limit) {
                    return x == null ? false : x.dom.fail();
                }
                for (int i = this.futvars.limit; i >= 0; --i) {
                    int p = this.futvars.dense[i];
                    View view = this.views[p];
                    if (view.dom.size() == 1) continue;
                    int coeff = this.coeffs[this.futvars.dense[i]];
                    if (coeff >= 0) {
                        this.min -= (long)(view.minValue() * coeff);
                        view.removeValues(Types.TypeOperatorRel.LT, this.limit - (this.max - (long)(view.maxValue() * coeff)), coeff);
                        assert (view.dom.size() > 0);
                        this.min += (long)(view.minValue() * coeff);
                    } else {
                        this.min -= (long)(view.maxValue() * coeff);
                        view.removeValues(Types.TypeOperatorRel.LT, this.limit - (this.max - (long)(view.minValue() * coeff)), coeff);
                        assert (view.dom.size() > 0);
                        this.min += (long)(view.maxValue() * coeff);
                    }
                    if (this.min < this.limit) continue;
                    return this.entailed();
                }
                return true;
            }
        }

        public static final class SumViewWeightedLE
        extends SumViewWeighted
        implements Tags.TagAC,
        Optimizable {
            @Override
            public boolean checkValues(int[] t) {
                return SumViewWeightedLE.weightedSum(t, this.views, this.coeffs) <= this.limit;
            }

            @Override
            public long objectiveValue() {
                return this.currWeightedSum();
            }

            public SumViewWeightedLE(Problem pb, XNode<IVar>[] trees, int[] coeffs, long limit) {
                super(pb, trees, coeffs, limit);
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.max <= this.limit) {
                    return this.entailed();
                }
                if (this.min > this.limit) {
                    return x == null ? false : x.dom.fail();
                }
                for (int i = this.futvars.limit; i >= 0; --i) {
                    int p = this.futvars.dense[i];
                    View view = this.views[p];
                    if (view.dom.size() == 1) continue;
                    int coeff = this.coeffs[p];
                    if (coeff >= 0) {
                        this.max -= (long)(view.maxValue() * coeff);
                        view.removeValues(Types.TypeOperatorRel.GT, this.limit - (this.min - (long)(view.minValue() * coeff)), coeff);
                        assert (view.dom.size() > 0);
                        this.max += (long)(view.maxValue() * coeff);
                    } else {
                        this.max -= (long)(view.minValue() * coeff);
                        view.removeValues(Types.TypeOperatorRel.GT, this.limit - (this.min - (long)(view.maxValue() * coeff)), coeff);
                        assert (view.dom.size() > 0);
                        this.max += (long)(view.minValue() * coeff);
                    }
                    if (this.max > this.limit) continue;
                    return this.entailed();
                }
                return true;
            }
        }

        static abstract class View {
            protected Variable var;
            protected Domain dom;

            protected View(XNode<IVar> tree) {
                this.var = (Variable)tree.vars()[0];
                this.dom = this.var.dom;
            }

            abstract int evaluate(int var1);

            abstract int minValue();

            abstract int maxValue();

            abstract int uniqueValue();

            abstract boolean removeValuesLE(int var1);

            abstract boolean removeValuesGE(int var1);

            boolean removeValues(Types.TypeOperatorRel type, long limit, int coeff) {
                assert (coeff != 0 && limit != Long.MIN_VALUE && limit != Long.MAX_VALUE);
                if (type == Types.TypeOperatorRel.LT) {
                    type = Types.TypeOperatorRel.LE;
                    --limit;
                } else if (type == Types.TypeOperatorRel.GT) {
                    type = Types.TypeOperatorRel.GE;
                    ++limit;
                }
                if (coeff < 0) {
                    coeff = -coeff;
                    type = type.arithmeticInversion();
                    limit = -limit;
                }
                long newLimit = Math.abs(limit) / (long)coeff * (long)(limit < 0L ? -1 : 1);
                if (limit > 0L && type == Types.TypeOperatorRel.GE && limit % (long)coeff != 0L) {
                    ++newLimit;
                }
                if (limit < 0L && type == Types.TypeOperatorRel.LE && -limit % (long)coeff != 0L) {
                    --newLimit;
                }
                return type == Types.TypeOperatorRel.LE ? this.removeValuesLE(Kit.trunc(newLimit)) : this.removeValuesGE(Kit.trunc(newLimit));
            }

            static class ViewTree01
            extends View {
                boolean[] supports;
                int[] neg;
                int[] pos;
                int residue0 = -1;
                int residue1 = -1;

                ViewTree01(XNode<IVar> tree) {
                    super(tree);
                    assert (tree.type.isPredicateOperator() && tree.vars().length == 1);
                    this.supports = new boolean[this.dom.initSize()];
                    int[] tmp = new int[1];
                    TreeEvaluator te = new TreeEvaluator(tree);
                    for (int a2 = 0; a2 < this.supports.length; ++a2) {
                        tmp[0] = this.dom.toVal(a2);
                        this.supports[a2] = te.evaluate(tmp) == 1L;
                    }
                    this.neg = IntStream.range(0, this.supports.length).filter(a -> !this.supports[a]).toArray();
                    this.pos = IntStream.range(0, this.supports.length).filter(a -> this.supports[a]).toArray();
                }

                @Override
                int evaluate(int v) {
                    return this.supports[this.dom.toIdx(v)] ? 1 : 0;
                }

                @Override
                int minValue() {
                    assert (this.dom.size() > 0);
                    if (this.residue0 != -1 && this.dom.present(this.residue0)) {
                        return 0;
                    }
                    if (this.dom.size() < this.neg.length) {
                        int a = this.dom.first();
                        while (a != -1) {
                            if (!this.supports[a]) {
                                this.residue0 = a;
                                return 0;
                            }
                            a = this.dom.next(a);
                        }
                    } else {
                        for (int a : this.neg) {
                            if (!this.dom.present(a)) continue;
                            this.residue0 = a;
                            return 0;
                        }
                    }
                    return 1;
                }

                @Override
                int maxValue() {
                    assert (this.dom.size() > 0);
                    if (this.residue1 != -1 && this.dom.present(this.residue1)) {
                        return 1;
                    }
                    if (this.dom.size() < this.pos.length) {
                        int a = this.dom.first();
                        while (a != -1) {
                            if (this.supports[a]) {
                                this.residue1 = a;
                                return 1;
                            }
                            a = this.dom.next(a);
                        }
                    } else {
                        for (int a : this.pos) {
                            if (!this.dom.present(a)) continue;
                            this.residue1 = a;
                            return 1;
                        }
                    }
                    return 0;
                }

                @Override
                int uniqueValue() {
                    return this.supports[this.dom.unique()] ? 1 : 0;
                }

                @Override
                boolean removeValuesLE(int limit) {
                    if (limit < 0) {
                        return true;
                    }
                    if (limit >= 1) {
                        return this.dom.fail();
                    }
                    assert (limit == 0);
                    int sizeBefore = this.dom.size();
                    for (int a : this.neg) {
                        if (!this.dom.present(a)) continue;
                        this.dom.removeElementary(a);
                    }
                    return this.dom.afterElementaryCalls(sizeBefore);
                }

                @Override
                boolean removeValuesGE(int limit) {
                    if (limit > 1) {
                        return true;
                    }
                    if (limit <= 0) {
                        return this.dom.fail();
                    }
                    assert (limit == 1);
                    int sizeBefore = this.dom.size();
                    for (int a : this.pos) {
                        if (!this.dom.present(a)) continue;
                        this.dom.removeElementary(a);
                    }
                    return this.dom.afterElementaryCalls(sizeBefore);
                }
            }

            static class ViewVariable
            extends View {
                ViewVariable(XNode<IVar> tree) {
                    super(tree);
                    assert (tree.type == Types.TypeExpr.VAR);
                }

                @Override
                int evaluate(int v) {
                    return v;
                }

                @Override
                int minValue() {
                    return this.dom.firstValue();
                }

                @Override
                int maxValue() {
                    return this.dom.lastValue();
                }

                @Override
                int uniqueValue() {
                    return this.dom.uniqueValue();
                }

                @Override
                boolean removeValuesLE(int limit) {
                    return this.dom.removeValuesLE(limit);
                }

                @Override
                boolean removeValuesGE(int limit) {
                    return this.dom.removeValuesGE(limit);
                }
            }
        }
    }

    public static abstract class SumWeighted
    extends Sum {
        public final int[] coeffs;

        public static SumWeighted buildFrom(Problem pb, Variable[] vs, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
            switch (op) {
                case LT: {
                    return new SumWeightedLE(pb, vs, coeffs, limit - 1L);
                }
                case LE: {
                    return new SumWeightedLE(pb, vs, coeffs, limit);
                }
                case GE: {
                    return new SumWeightedGE(pb, vs, coeffs, limit);
                }
                case GT: {
                    return new SumWeightedGE(pb, vs, coeffs, limit + 1L);
                }
                case EQ: {
                    return new SumWeightedEQ(pb, vs, coeffs, limit);
                }
                case NE: {
                    return new SumWeightedNE(pb, vs, coeffs, limit);
                }
            }
            throw new AssertionError();
        }

        public static long weightedSum(int[] t, int[] coeffs) {
            assert (t.length == coeffs.length);
            long sum = 0L;
            for (int i = 0; i < t.length; ++i) {
                sum += (long)(coeffs[i] * t[i]);
            }
            return sum;
        }

        public static long minPossibleSum(Variable[] scp, int[] coeffs) {
            BigInteger sum = BigInteger.valueOf(0L);
            for (int i = 0; i < scp.length; ++i) {
                sum = sum.add(BigInteger.valueOf(coeffs[i]).multiply(BigInteger.valueOf(coeffs[i] >= 0 ? (long)scp[i].dom.toVal(0) : (long)scp[i].dom.toVal(scp[i].dom.initSize() - 1))));
            }
            return sum.longValueExact();
        }

        public static long maxPossibleSum(Variable[] scp, int[] coeffs) {
            BigInteger sum = BigInteger.valueOf(0L);
            for (int i = 0; i < scp.length; ++i) {
                sum = sum.add(BigInteger.valueOf(coeffs[i]).multiply(BigInteger.valueOf(coeffs[i] >= 0 ? (long)scp[i].dom.toVal(scp[i].dom.initSize() - 1) : (long)scp[i].dom.toVal(0))));
            }
            return sum.longValueExact();
        }

        public long minComputableObjectiveValue() {
            return SumWeighted.minPossibleSum(this.scp, this.coeffs);
        }

        public long maxComputableObjectiveValue() {
            return SumWeighted.maxPossibleSum(this.scp, this.coeffs);
        }

        public long minCurrentObjectiveValue() {
            long sum = 0L;
            for (int i = 0; i < this.scp.length; ++i) {
                sum += (long)(this.coeffs[i] * (this.coeffs[i] >= 0 ? this.scp[i].dom.firstValue() : this.scp[i].dom.lastValue()));
            }
            return sum;
        }

        public long maxCurrentObjectiveValue() {
            long sum = 0L;
            for (int i = 0; i < this.scp.length; ++i) {
                sum += (long)(this.coeffs[i] * (this.coeffs[i] >= 0 ? this.scp[i].dom.lastValue() : this.scp[i].dom.firstValue()));
            }
            return sum;
        }

        protected long currWeightedSum() {
            long sum = 0L;
            for (int i = 0; i < this.scp.length; ++i) {
                sum += (long)(this.scp[i].dom.uniqueValue() * this.coeffs[i]);
            }
            return sum;
        }

        public SumWeighted(Problem pb, Variable[] scp, int[] coeffs, long limit) {
            super(pb, scp);
            this.coeffs = coeffs;
            this.minComputableObjectiveValue = this.minComputableObjectiveValue();
            this.maxComputableObjectiveValue = this.maxComputableObjectiveValue();
            this.control(this.minComputableObjectiveValue <= this.maxComputableObjectiveValue);
            this.limit(limit);
            this.defineKey(Kit.join((Object)coeffs, new String[0]), limit);
            this.control(IntStream.range(0, coeffs.length).allMatch(i -> coeffs[i] != 0 && (i == 0 || coeffs[i - 1] <= coeffs[i])), "" + Kit.join((Object)coeffs, new String[0]));
        }

        @Override
        public int[] symmetryMatching() {
            int[] symmetryMatching = new int[this.scp.length];
            int color = 1;
            for (int i = 0; i < symmetryMatching.length; ++i) {
                if (symmetryMatching[i] != 0) continue;
                for (int j = i + 1; j < symmetryMatching.length; ++j) {
                    if (symmetryMatching[j] != 0 || this.coeffs[i] != this.coeffs[j]) continue;
                    symmetryMatching[j] = color;
                }
                symmetryMatching[i] = color++;
            }
            return symmetryMatching;
        }

        protected void recomputeBounds() {
            this.max = 0L;
            this.min = 0L;
            for (int i = 0; i < this.scp.length; ++i) {
                int coeff;
                Domain dom = this.scp[i].dom;
                this.min += (long)(coeff * ((coeff = this.coeffs[i]) >= 0 ? dom.firstValue() : dom.lastValue()));
                this.max += (long)(coeff * (coeff >= 0 ? dom.lastValue() : dom.firstValue()));
            }
        }

        public static final class SumWeightedNE
        extends SumWeighted
        implements Tags.TagAC {
            private Variable sentinel1;
            private Variable sentinel2;

            @Override
            public boolean checkValues(int[] t) {
                return SumWeightedNE.weightedSum(t, this.coeffs) != this.limit;
            }

            public SumWeightedNE(Problem pb, Variable[] scp, int[] coeffs, long limit) {
                super(pb, scp, coeffs, limit);
                this.control(scp.length >= 2 && !Arrays.stream(scp).anyMatch(x -> x.dom.size() == 1));
                this.sentinel1 = scp[0];
                this.sentinel2 = scp[scp.length - 1];
            }

            private Variable findAnotherSentinel() {
                for (Variable x : this.scp) {
                    if (x == this.sentinel1 || x == this.sentinel2 || x.dom.size() <= 1) continue;
                    return x;
                }
                return null;
            }

            private boolean filterDomainOf(Variable sentinel) {
                assert (sentinel.dom.size() > 1 && Stream.of(this.scp).filter(x -> x != sentinel).allMatch(x -> x.dom.size() == 1));
                int p = -1;
                long sum = 0L;
                for (int i = 0; i < this.scp.length; ++i) {
                    if (this.scp[i] != sentinel) {
                        sum += (long)(this.scp[i].dom.uniqueValue() * this.coeffs[i]);
                        continue;
                    }
                    p = i;
                }
                long v = (this.limit - sum) / (long)this.coeffs[p];
                this.control(v * (long)this.coeffs[p] + sum == this.limit);
                if ((this.limit - sum) % (long)this.coeffs[p] == 0L && Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                    sentinel.dom.removeValueIfPresent((int)v);
                }
                return true;
            }

            @Override
            public boolean runPropagator(Variable x) {
                Variable y;
                if (this.sentinel1.dom.size() == 1) {
                    y = this.findAnotherSentinel();
                    if (y == null) {
                        return this.sentinel2.dom.size() == 1 ? this.currWeightedSum() != this.limit || x.dom.fail() : this.filterDomainOf(this.sentinel2);
                    }
                    this.sentinel1 = y;
                }
                if (this.sentinel2.dom.size() == 1) {
                    y = this.findAnotherSentinel();
                    if (y == null) {
                        return this.filterDomainOf(this.sentinel1);
                    }
                    this.sentinel2 = y;
                }
                return true;
            }
        }

        public static final class SumWeightedEQ
        extends SumWeighted {
            private boolean guaranteedGAC;
            int cnt = 0;

            @Override
            public boolean checkValues(int[] t) {
                return SumWeightedEQ.weightedSum(t, this.coeffs) == this.limit;
            }

            public SumWeightedEQ(Problem pb, Variable[] scp, int[] coeffs, long limit) {
                super(pb, scp, coeffs, limit);
                this.guaranteedGAC = Stream.of(scp).allMatch(x -> x.dom.initSize() <= 2);
            }

            @Override
            public boolean isGuaranteedAC() {
                return this.guaranteedGAC;
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.limit < this.min || this.limit > this.max) {
                    return x.dom.fail();
                }
                if (this.futvars.size() > 0) {
                    int lastModified = this.futvars.limit;
                    int i = this.futvars.limit;
                    do {
                        int coeff;
                        Domain dom;
                        int sizeBefore;
                        if ((sizeBefore = (dom = this.scp[this.futvars.dense[i]].dom).size()) <= 1) continue;
                        this.min -= (long)(coeff * ((coeff = this.coeffs[this.futvars.dense[i]]) >= 0 ? dom.firstValue() : dom.lastValue()));
                        this.max -= (long)(coeff * (coeff >= 0 ? dom.lastValue() : dom.firstValue()));
                        if (!dom.removeValues(Types.TypeOperatorRel.LT, this.limit - this.max, coeff) || !dom.removeValues(Types.TypeOperatorRel.GT, this.limit - this.min, coeff)) {
                            return false;
                        }
                        if (sizeBefore != dom.size()) {
                            lastModified = i;
                        }
                        this.min += (long)(coeff * (coeff >= 0 ? dom.firstValue() : dom.lastValue()));
                        this.max += (long)(coeff * (coeff >= 0 ? dom.lastValue() : dom.firstValue()));
                    } while (lastModified != (i = i > 0 ? i - 1 : this.futvars.limit));
                }
                assert (this.controlFCLevel());
                return true;
            }

            public int deduce() {
                Kit.control(this.futvars.size() == 1);
                int pos = this.futvars.dense[0];
                this.control(this.scp[pos].dom instanceof DomainInfinite, " " + this.scp[pos]);
                long sum = 0L;
                for (int i = 0; i < this.scp.length; ++i) {
                    if (i == pos) continue;
                    sum += (long)(this.scp[i].dom.uniqueValue() * this.coeffs[i]);
                }
                this.control((this.limit - sum) % (long)this.coeffs[pos] == 0L);
                long res = (this.limit - sum) / (long)this.coeffs[pos];
                this.control(Utilities.isSafeInt(res));
                this.scp[pos].dom.reduceTo((int)res);
                return (int)res;
            }
        }

        public static class SumWeightedGE
        extends SumWeighted
        implements Tags.TagAC,
        Optimizable {
            @Override
            public boolean checkValues(int[] t) {
                return SumWeightedGE.weightedSum(t, this.coeffs) >= this.limit;
            }

            @Override
            public long objectiveValue() {
                return this.currWeightedSum();
            }

            public SumWeightedGE(Problem pb, Variable[] scp, int[] coeffs, long limit) {
                super(pb, scp, coeffs, Math.max(limit, SumWeightedGE.minPossibleSum(scp, coeffs)));
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.min >= this.limit) {
                    return this.entailed();
                }
                if (this.max < this.limit) {
                    return x == null ? false : x.dom.fail();
                }
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() == 1) continue;
                    int coeff = this.coeffs[this.futvars.dense[i]];
                    if (coeff >= 0) {
                        this.min -= (long)(dom.firstValue() * coeff);
                        dom.removeValues(Types.TypeOperatorRel.LT, this.limit - (this.max - (long)(dom.lastValue() * coeff)), coeff);
                        assert (dom.size() > 0);
                        this.min += (long)(dom.firstValue() * coeff);
                    } else {
                        this.min -= (long)(dom.lastValue() * coeff);
                        dom.removeValues(Types.TypeOperatorRel.LT, this.limit - (this.max - (long)(dom.firstValue() * coeff)), coeff);
                        assert (dom.size() > 0);
                        this.min += (long)(dom.lastValue() * coeff);
                    }
                    if (this.min < this.limit) continue;
                    return this.entailed();
                }
                return true;
            }
        }

        public static final class SumWeightedLE
        extends SumWeighted
        implements Tags.TagAC,
        Optimizable {
            @Override
            public boolean checkValues(int[] t) {
                return SumWeightedLE.weightedSum(t, this.coeffs) <= this.limit;
            }

            @Override
            public long objectiveValue() {
                return this.currWeightedSum();
            }

            public SumWeightedLE(Problem pb, Variable[] scp, int[] coeffs, long limit) {
                super(pb, scp, coeffs, Math.min(limit, SumWeightedLE.maxPossibleSum(scp, coeffs)));
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.max <= this.limit) {
                    return this.entailed();
                }
                if (this.min > this.limit) {
                    return x == null ? false : x.dom.fail();
                }
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() == 1) continue;
                    int coeff = this.coeffs[this.futvars.dense[i]];
                    if (coeff >= 0) {
                        this.max -= (long)(dom.lastValue() * coeff);
                        dom.removeValues(Types.TypeOperatorRel.GT, this.limit - (this.min - (long)(dom.firstValue() * coeff)), coeff);
                        assert (dom.size() > 0);
                        this.max += (long)(dom.lastValue() * coeff);
                    } else {
                        this.max -= (long)(dom.firstValue() * coeff);
                        dom.removeValues(Types.TypeOperatorRel.GT, this.limit - (this.min - (long)(dom.lastValue() * coeff)), coeff);
                        assert (dom.size() > 0);
                        this.max += (long)(dom.firstValue() * coeff);
                    }
                    if (this.max > this.limit) continue;
                    return this.entailed();
                }
                return true;
            }
        }
    }

    public static abstract class SumSimple
    extends Sum
    implements Tags.TagSymmetric {
        public static SumSimple buildFrom(Problem pb, Variable[] scp, Types.TypeConditionOperatorRel op, long limit) {
            switch (op) {
                case LT: {
                    return new SumSimpleLE(pb, scp, limit - 1L);
                }
                case LE: {
                    return new SumSimpleLE(pb, scp, limit);
                }
                case GE: {
                    return new SumSimpleGE(pb, scp, limit);
                }
                case GT: {
                    return new SumSimpleGE(pb, scp, limit + 1L);
                }
                case EQ: {
                    return new SumSimpleEQ(pb, scp, limit);
                }
                case NE: {
                    return new SumSimpleNE(pb, scp, limit);
                }
            }
            throw new AssertionError();
        }

        public static long sum(int[] t) {
            long l = 0L;
            for (int v : t) {
                l += (long)v;
            }
            return l;
        }

        public static long minPossibleSum(Variable[] scp) {
            long sum = 0L;
            for (Variable x : scp) {
                sum += (long)x.dom.toVal(0);
            }
            return sum;
        }

        public static long maxPossibleSum(Variable[] scp) {
            long sum = 0L;
            for (Variable x : scp) {
                sum += (long)x.dom.toVal(x.dom.initSize() - 1);
            }
            return sum;
        }

        public final long minComputableObjectiveValue() {
            return SumSimple.minPossibleSum(this.scp);
        }

        public final long maxComputableObjectiveValue() {
            return SumSimple.maxPossibleSum(this.scp);
        }

        public final long minCurrentObjectiveValue() {
            long sum = 0L;
            for (Variable x : this.scp) {
                sum += (long)x.dom.firstValue();
            }
            return sum;
        }

        public final long maxCurrentObjectiveValue() {
            long sum = 0L;
            for (Variable x : this.scp) {
                sum += (long)x.dom.lastValue();
            }
            return sum;
        }

        protected final long currSum() {
            long sum = 0L;
            for (Variable x : this.scp) {
                sum += (long)x.dom.uniqueValue();
            }
            return sum;
        }

        public SumSimple(Problem pb, Variable[] scp, long limit) {
            super(pb, scp);
            this.minComputableObjectiveValue = this.minComputableObjectiveValue();
            this.maxComputableObjectiveValue = this.maxComputableObjectiveValue();
            this.control(this.minComputableObjectiveValue <= this.maxComputableObjectiveValue);
            this.limit(limit);
            this.defineKey(limit);
        }

        protected final void recomputeBounds() {
            this.max = 0L;
            this.min = 0L;
            for (Domain dom : this.doms) {
                this.min += (long)dom.firstValue();
                this.max += (long)dom.lastValue();
            }
        }

        public static final class SumSimpleEQBoolean
        extends SumSimple
        implements Tags.TagAC {
            @Override
            public final boolean checkValues(int[] t) {
                return SumSimpleEQBoolean.sum(t) == this.limit;
            }

            public SumSimpleEQBoolean(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
                this.control(Variable.areAllInitiallyBoolean(scp));
            }

            @Override
            public boolean runPropagator(Variable x) {
                int i;
                int cnt0 = 0;
                int cnt1 = 0;
                for (Variable y : this.scp) {
                    if (y.dom.size() != 1) continue;
                    if (y.dom.unique() == 0) {
                        ++cnt0;
                        continue;
                    }
                    ++cnt1;
                }
                int diff = this.scp.length - cnt0 - cnt1;
                if ((long)cnt1 > this.limit || (long)(cnt1 + diff) < this.limit) {
                    return x.dom.fail();
                }
                if ((long)cnt1 < this.limit && (long)(cnt1 + diff) > this.limit) {
                    return true;
                }
                if ((long)cnt1 == this.limit) {
                    for (i = this.futvars.limit; i >= 0; --i) {
                        Domain dom = this.scp[this.futvars.dense[i]].dom;
                        if (dom.size() == 1) continue;
                        dom.removeSafely(1);
                    }
                } else {
                    assert ((long)(cnt1 + diff) == this.limit);
                    for (i = this.futvars.limit; i >= 0; --i) {
                        Domain dom = this.scp[this.futvars.dense[i]].dom;
                        if (dom.size() == 1) continue;
                        dom.removeSafely(0);
                    }
                }
                return true;
            }
        }

        public static final class SumSimpleNE
        extends SumSimple
        implements Tags.TagAC {
            private Variable sentinel1;
            private Variable sentinel2;

            @Override
            public final boolean checkValues(int[] t) {
                return SumSimpleNE.sum(t) != this.limit;
            }

            public SumSimpleNE(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
                this.control(scp.length >= 2 && !Arrays.stream(scp).anyMatch(x -> x.dom.size() == 1));
                this.sentinel1 = scp[0];
                this.sentinel2 = scp[scp.length - 1];
            }

            private Variable findAnotherSentinel() {
                for (Variable x : this.scp) {
                    if (x == this.sentinel1 || x == this.sentinel2 || x.dom.size() <= 1) continue;
                    return x;
                }
                return null;
            }

            private boolean filterDomainOf(Variable sentinel) {
                assert (sentinel.dom.size() > 1 && Stream.of(this.scp).filter(x -> x != sentinel).allMatch(x -> x.dom.size() == 1));
                long sum = 0L;
                for (Variable x2 : this.scp) {
                    if (x2 == sentinel) continue;
                    sum += (long)x2.dom.uniqueValue();
                }
                long v = this.limit - sum;
                if (sum + v == this.limit && Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                    sentinel.dom.removeValueIfPresent((int)v);
                }
                return true;
            }

            @Override
            public boolean runPropagator(Variable x) {
                Variable y;
                if (this.sentinel1.dom.size() == 1) {
                    y = this.findAnotherSentinel();
                    if (y == null) {
                        return this.sentinel2.dom.size() == 1 ? this.currSum() != this.limit || x.dom.fail() : this.filterDomainOf(this.sentinel2);
                    }
                    this.sentinel1 = y;
                }
                if (this.sentinel2.dom.size() == 1) {
                    y = this.findAnotherSentinel();
                    if (y == null) {
                        return this.filterDomainOf(this.sentinel1);
                    }
                    this.sentinel2 = y;
                }
                return true;
            }
        }

        public static final class SumSimpleEQ
        extends SumSimple {
            private boolean ac;

            @Override
            public final boolean checkValues(int[] t) {
                return SumSimpleEQ.sum(t) == this.limit;
            }

            public SumSimpleEQ(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
                this.ac = Stream.of(scp).allMatch(x -> x.dom.initSize() <= 2);
            }

            @Override
            public boolean isGuaranteedAC() {
                return this.ac;
            }

            @Override
            public boolean runPropagator(Variable evt) {
                this.recomputeBounds();
                if (this.limit < this.min || this.limit > this.max) {
                    return evt.dom.fail();
                }
                if (this.futvars.size() > 0) {
                    int lastModified = this.futvars.limit;
                    int i = this.futvars.limit;
                    do {
                        Domain dom;
                        int sizeBefore;
                        if ((sizeBefore = (dom = this.scp[this.futvars.dense[i]].dom).size()) <= 1) continue;
                        this.min -= (long)dom.firstValue();
                        this.max -= (long)dom.lastValue();
                        if (!dom.removeValuesLT(this.limit - this.max) || !dom.removeValuesGT(this.limit - this.min)) {
                            return false;
                        }
                        if (sizeBefore != dom.size()) {
                            lastModified = i;
                        }
                        this.min += (long)dom.firstValue();
                        this.max += (long)dom.lastValue();
                    } while (lastModified != (i = i > 0 ? i - 1 : this.futvars.limit));
                }
                assert (this.controlFCLevel());
                return true;
            }

            public int deduce() {
                this.control(this.futvars.size() == 1);
                int pos = this.futvars.dense[0];
                this.control(this.scp[pos].dom instanceof DomainInfinite);
                long sum = 0L;
                for (int i = 0; i < this.scp.length; ++i) {
                    if (i == pos) continue;
                    sum += (long)this.scp[i].dom.uniqueValue();
                }
                long res = this.limit - sum;
                this.control(Utilities.isSafeInt(res));
                return (int)res;
            }
        }

        public static class SumSimpleGE
        extends SumSimple
        implements Tags.TagAC,
        Optimizable {
            @Override
            public final boolean checkValues(int[] t) {
                return SumSimpleGE.sum(t) >= this.limit;
            }

            @Override
            public long objectiveValue() {
                return this.currSum();
            }

            public SumSimpleGE(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, Math.max(limit, SumSimpleGE.minPossibleSum(scp)));
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.min >= this.limit) {
                    return this.entailed();
                }
                if (this.max < this.limit) {
                    return x == null ? false : x.dom.fail();
                }
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() == 1) continue;
                    this.min -= (long)dom.firstValue();
                    dom.removeValuesLT(this.limit - (this.max - (long)dom.lastValue()));
                    assert (dom.size() > 0);
                    this.min += (long)dom.firstValue();
                    if (this.min < this.limit) continue;
                    return this.entailed();
                }
                return true;
            }
        }

        public static class SumSimpleLE
        extends SumSimple
        implements Tags.TagAC,
        Optimizable {
            @Override
            public final boolean checkValues(int[] t) {
                return SumSimpleLE.sum(t) <= this.limit;
            }

            @Override
            public long objectiveValue() {
                return this.currSum();
            }

            public SumSimpleLE(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, Math.min(limit, SumSimpleLE.maxPossibleSum(scp)));
            }

            @Override
            public boolean runPropagator(Variable x) {
                this.recomputeBounds();
                if (this.max <= this.limit) {
                    return this.entailed();
                }
                if (this.min > this.limit) {
                    return x == null ? false : x.dom.fail();
                }
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() == 1) continue;
                    this.max -= (long)dom.lastValue();
                    dom.removeValuesGT(this.limit - (this.min - (long)dom.firstValue()));
                    assert (dom.size() > 0);
                    this.max += (long)dom.lastValue();
                    if (this.max > this.limit) continue;
                    return this.entailed();
                }
                return true;
            }

            public Variable mostImpacting() {
                int[] solution = this.problem.solver.solRecorder.lastSolution;
                ArrayList<Variable> list = new ArrayList<Variable>();
                int bestGap = Integer.MIN_VALUE;
                for (Variable x : this.scp) {
                    int gap = x.dom.toVal(solution[x.num]) - x.dom.firstValue();
                    if (gap > bestGap) {
                        list.clear();
                        list.add(x);
                        bestGap = gap;
                        continue;
                    }
                    if (gap != bestGap) continue;
                    list.add(x);
                }
                System.out.println("bestgap " + bestGap);
                Random r = this.problem.head.random;
                return (Variable)list.get(r.nextInt(list.size()));
            }
        }
    }
}

