/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import java.util.stream.IntStream;
import problem.Problem;
import sets.SetSparseReversible;
import variables.Variable;

public final class NoOverlap1
extends Constraint.CtrGlobal
implements Tags.TagNotAC {
    private int[] widths;
    private SetSparseReversible relevantTasks;
    private long volume;
    private long margin;

    @Override
    public boolean checkValues(int[] tuple) {
        for (int i = 0; i < tuple.length; ++i) {
            for (int j = i + 1; j < tuple.length; ++j) {
                if (tuple[i] + this.widths[i] <= tuple[j] || tuple[j] + this.widths[j] <= tuple[i]) continue;
                return false;
            }
        }
        return true;
    }

    public NoOverlap1(Problem pb, Variable[] origins, int[] widths) {
        super(pb, origins);
        this.control(origins.length > 1 && origins.length == widths.length);
        this.widths = widths;
        int horizon = IntStream.range(0, this.scp.length).map(i -> this.scp[i].dom.lastValue() + widths[i]).max().getAsInt();
        this.volume = IntStream.of(widths).sum();
        this.margin = (long)horizon - this.volume;
    }

    @Override
    public boolean runPropagator(Variable x) {
        int i;
        int j;
        int depth = this.problem.solver.depth();
        int smin = Integer.MAX_VALUE;
        int emax = Integer.MIN_VALUE;
        for (j = this.futvars.limit; j >= 0; --j) {
            i = this.futvars.dense[j];
            smin = Math.min(smin, this.scp[i].dom.firstValue());
            emax = Math.max(emax, this.scp[i].dom.lastValue() + this.widths[i]);
        }
        for (j = this.relevantTasks.limit; j >= 0; --j) {
            i = this.relevantTasks.dense[j];
            if (this.scp[i].dom.size() != 1 || this.scp[i].dom.lastValue() + this.widths[i] > smin && emax > this.scp[i].dom.firstValue()) continue;
            this.relevantTasks.removeAtPosition(j, depth);
        }
        return true;
    }
}

