/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import org.xcsp.common.Utilities;
import problem.Problem;
import sets.SetDense;
import variables.Domain;
import variables.Variable;

public final class NoOverlap
extends Constraint.CtrGlobal
implements Tags.TagNotAC {
    private Variable[] xs;
    private int[] widths;
    private Variable[] ys;
    private int[] heights;
    private int half;
    private SetDense overlappings;

    @Override
    public boolean checkValues(int[] tuple) {
        for (int i = 0; i < this.half; ++i) {
            for (int j = i + 1; j < this.half; ++j) {
                int xi = tuple[i];
                int xj = tuple[j];
                int yi = tuple[i + this.half];
                int yj = tuple[j + this.half];
                if (xi + this.widths[i] <= xj || xj + this.widths[j] <= xi || yi + this.heights[i] <= yj || yj + this.heights[j] <= yi) continue;
                return false;
            }
        }
        return true;
    }

    public NoOverlap(Problem pb, Variable[] xs, int[] widths, Variable[] ys, int[] heights) {
        super(pb, Utilities.collect(Variable.class, xs, ys));
        this.control(xs.length > 1 && xs.length == widths.length && ys.length == heights.length && xs.length == ys.length);
        this.control(this.scp.length == xs.length + ys.length);
        this.xs = xs;
        this.widths = widths;
        this.ys = ys;
        this.heights = heights;
        this.half = xs.length;
        this.overlappings = new SetDense(this.half);
    }

    private boolean overlap(int a, Domain dom, int b) {
        return a > dom.lastValue() && dom.firstValue() > b;
    }

    public boolean filter(Variable[] x1, int[] t1, Variable[] x2, int[] t2) {
        for (int i = 0; i < this.half; ++i) {
            Domain dom1 = x1[i].dom;
            int a = dom1.first();
            while (a != -1) {
                block13: {
                    block15: {
                        block14: {
                            int j;
                            int v = dom1.toVal(a);
                            this.overlappings.clear();
                            for (j = 0; j < this.half; ++j) {
                                if (j == i || !this.overlap(v + t1[i], x1[j].dom, v - t1[j])) continue;
                                this.overlappings.add(j);
                            }
                            if (this.overlappings.size() == 0) break block13;
                            if (this.overlappings.size() != 1) break block14;
                            j = this.overlappings.dense[0];
                            if (this.overlap(x2[i].dom.firstValue() + t2[i], x2[j].dom, x2[i].dom.lastValue() - t2[j])) break block15;
                            break block13;
                        }
                        Domain dom2 = x2[i].dom;
                        int b = dom2.first();
                        while (b != -1) {
                            block12: {
                                long volume = 0L;
                                int minX = Integer.MAX_VALUE;
                                int minY = Integer.MAX_VALUE;
                                int maxX = Integer.MIN_VALUE;
                                int maxY = Integer.MIN_VALUE;
                                int w = dom2.toVal(b);
                                for (int k = this.overlappings.limit; k >= 0; --k) {
                                    int j = this.overlappings.dense[k];
                                    if (!this.overlap(w + t2[i], x2[j].dom, w - t2[j])) {
                                        minX = Math.min(minX, x1[j].dom.firstValue());
                                        minY = Math.min(minY, x2[j].dom.firstValue());
                                        maxX = Math.max(maxX, x1[j].dom.lastValue() + t1[j]);
                                        maxY = Math.max(maxY, x2[j].dom.lastValue() + t2[j]);
                                        volume += (long)(t1[j] * t2[j]);
                                        continue;
                                    }
                                    break block12;
                                }
                                int diffX = maxX - minX + 1;
                                int diffY = maxY - minY + 1;
                                if (w < minY && minY < w + t2[i]) {
                                    diffY -= Math.min(maxY, w + t2[i]) - minY;
                                } else if (minY <= w && w < maxY) {
                                    diffY -= Math.min(maxY, w + t2[i]) - w;
                                }
                                if (volume <= (long)(diffX * diffY)) break block13;
                            }
                            b = dom2.next(b);
                        }
                    }
                    if (!dom1.remove(a)) {
                        return false;
                    }
                }
                a = dom1.next(a);
            }
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable x) {
        return this.filter(this.xs, this.widths, this.ys, this.heights) && this.filter(this.ys, this.heights, this.xs, this.widths);
    }
}

