/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import constraints.global.AllDifferent;
import constraints.global.AllEqual;
import constraints.global.NotAllEqual;
import interfaces.Tags;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import optimization.Optimizable;
import org.xcsp.common.Types;
import problem.Problem;
import sets.SetDense;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class NValues
extends Constraint.CtrGlobal
implements Tags.TagNotAC {
    protected final Variable[] list;
    protected final Set<Integer> fixedVals;
    protected final SetDense unfixedVars;
    protected final int[] sentinels;

    public NValues(Problem pb, Variable[] scp, Variable[] list) {
        super(pb, scp);
        this.list = list;
        this.fixedVals = new HashSet<Integer>(Variable.setOfvaluesIn(list).size());
        this.unfixedVars = new SetDense(list.length);
        this.sentinels = new int[list.length];
    }

    protected void initializeSets() {
        int i;
        this.fixedVals.clear();
        this.unfixedVars.clear();
        for (i = 0; i < this.list.length; ++i) {
            if (this.list[i].dom.size() == 1) {
                this.fixedVals.add(this.list[i].dom.firstValue());
                continue;
            }
            this.unfixedVars.add(i);
        }
        block1: for (i = this.unfixedVars.limit; i >= 0; --i) {
            int sentinel;
            int x = this.unfixedVars.dense[i];
            Domain dom = this.list[x].dom;
            if (dom.size() > this.fixedVals.size() || dom.presentValue(sentinel = this.sentinels[x]) && !this.fixedVals.contains(sentinel) || dom.size() > 5) continue;
            int a = dom.first();
            while (a != -1) {
                int va = dom.toVal(a);
                if (!this.fixedVals.contains(va)) {
                    this.sentinels[x] = va;
                    continue block1;
                }
                a = dom.next(a);
            }
            this.unfixedVars.removeAtPosition(i);
        }
    }

    public static abstract class NValuesVar
    extends NValues {
        protected Variable k;

        public static Constraint buildFrom(Problem pb, Variable[] scp, Types.TypeConditionOperatorRel op, Variable k) {
            Kit.control(Variable.areAllDistinct(scp));
            switch (op) {
                case EQ: {
                    return new NValuesVarEQ(pb, scp, k);
                }
            }
            return null;
        }

        public NValuesVar(Problem pb, Variable[] list, Variable k) {
            super(pb, (Variable[])pb.vars(new Object[]{list, k}), list);
            this.control(Stream.of(list).noneMatch(x -> x == k), "currently, k must not be present in the list");
            this.k = k;
        }

        public static class NValuesVarEQ
        extends NValuesVar {
            @Override
            public boolean checkValues(int[] t) {
                return IntStream.range(0, t.length - 1).map(i -> t[i]).distinct().count() == (long)t[t.length - 1];
            }

            public NValuesVarEQ(Problem pb, Variable[] list, Variable k) {
                super(pb, list, k);
            }

            @Override
            public boolean runPropagator(Variable x) {
                if (x.dom.size() == 1) {
                    this.initializeSets();
                    if (!this.k.dom.removeValuesLT(this.fixedVals.size()) || !this.k.dom.removeValuesGT(this.fixedVals.size() + this.unfixedVars.size())) {
                        return false;
                    }
                    if (this.k.dom.size() == 1) {
                        int limit = this.k.dom.uniqueValue();
                        if (this.fixedVals.size() == limit) {
                            for (int i = this.unfixedVars.limit; i >= 0; --i) {
                                if (this.list[this.unfixedVars.dense[i]].dom.removeValuesNotIn(this.fixedVals)) continue;
                                return false;
                            }
                            return this.entailed();
                        }
                        if (this.fixedVals.size() + this.unfixedVars.size() == limit) {
                            for (int i = this.unfixedVars.limit; i >= 0; --i) {
                                if (this.list[this.unfixedVars.dense[i]].dom.removeValuesIn(this.fixedVals)) continue;
                                return false;
                            }
                        }
                    }
                }
                return true;
            }
        }
    }

    public static abstract class NValuesCst
    extends NValues
    implements Optimizable {
        protected long limit;

        public static Constraint buildFrom(Problem pb, Variable[] scp, Types.TypeConditionOperatorRel op, long limit) {
            Kit.control(Variable.areAllDistinct(scp));
            switch (op) {
                case LT: {
                    return limit == 2L ? new AllEqual(pb, scp) : new NValuesCstLE(pb, scp, limit - 1L);
                }
                case LE: {
                    return limit == 1L ? new AllEqual(pb, scp) : new NValuesCstLE(pb, scp, limit);
                }
                case GE: {
                    return limit == 2L ? new NotAllEqual(pb, scp) : new NValuesCstGE(pb, scp, limit);
                }
                case GT: {
                    return limit == 1L ? new NotAllEqual(pb, scp) : new NValuesCstGE(pb, scp, limit + 1L);
                }
                case EQ: {
                    if (limit == 1L) {
                        return new AllEqual(pb, scp);
                    }
                    if (limit == (long)scp.length) {
                        return new AllDifferent.AllDifferentComplete(pb, scp);
                    }
                    return null;
                }
            }
            if (limit == 1L) {
                return new NotAllEqual(pb, scp);
            }
            return null;
        }

        @Override
        public long limit() {
            return this.limit;
        }

        @Override
        public void limit(long newLimit) {
            this.limit = newLimit;
            this.control(this.minComputableObjectiveValue() <= this.limit && this.limit <= this.maxComputableObjectiveValue());
        }

        @Override
        public long minComputableObjectiveValue() {
            return 1L;
        }

        @Override
        public long maxComputableObjectiveValue() {
            return this.list.length;
        }

        @Override
        public long minCurrentObjectiveValue() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public long maxCurrentObjectiveValue() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public long objectiveValue() {
            return Arrays.stream(this.scp).mapToInt(x -> x.dom.uniqueValue()).distinct().count();
        }

        public NValuesCst(Problem pb, Variable[] list, long k) {
            super(pb, list, list);
            this.limit(k);
            this.defineKey(k);
        }

        public static final class NValuesCstGE
        extends NValuesCst {
            @Override
            public boolean checkValues(int[] t) {
                return Arrays.stream(t).distinct().count() >= this.limit;
            }

            public NValuesCstGE(Problem pb, Variable[] list, long k) {
                super(pb, list, Math.max(k, 1L));
            }

            @Override
            public boolean runPropagator(Variable x) {
                if (x == null || x.dom.size() == 1) {
                    this.initializeSets();
                    if ((long)(this.fixedVals.size() + this.unfixedVars.size()) < this.limit) {
                        return x == null ? false : x.dom.fail();
                    }
                    if ((long)(this.fixedVals.size() + this.unfixedVars.size()) == this.limit) {
                        for (int i = this.unfixedVars.limit; i >= 0; --i) {
                            if (this.list[this.unfixedVars.dense[i]].dom.removeValuesIn(this.fixedVals)) continue;
                            return false;
                        }
                        if (this.unfixedVars.size() == 0) {
                            return this.entailed();
                        }
                    }
                }
                return true;
            }
        }

        public static final class NValuesCstLE
        extends NValuesCst {
            @Override
            public boolean checkValues(int[] t) {
                return Arrays.stream(t).distinct().count() <= this.limit;
            }

            public NValuesCstLE(Problem pb, Variable[] list, long k) {
                super(pb, list, Math.min(k, (long)list.length));
            }

            @Override
            public boolean runPropagator(Variable x) {
                if (x == null || x.dom.size() == 1) {
                    this.initializeSets();
                    if ((long)this.fixedVals.size() > this.limit) {
                        return x == null ? false : x.dom.fail();
                    }
                    if ((long)this.fixedVals.size() == this.limit) {
                        for (int i = this.unfixedVars.limit; i >= 0; --i) {
                            if (this.list[this.unfixedVars.dense[i]].dom.removeValuesNotIn(this.fixedVals)) continue;
                            return false;
                        }
                        return this.entailed();
                    }
                }
                return true;
            }
        }
    }
}

