/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import constraints.global.AllDifferent;
import constraints.global.Cardinality;
import interfaces.Observers;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import sets.SetSparse;
import sets.SetSparseReversible;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class Matcher
implements Observers.ObserverConstruction {
    protected final Constraint ctr;
    protected final Variable[] scp;
    protected final int arity;
    protected int minValue;
    protected int maxValue;
    protected int intervalSize;
    protected int time;
    protected SetSparseReversible unfixedVars;
    protected final SetSparse unmatchedVars;
    protected final int[] varToVal;
    protected int[] visitTime;
    protected int nVisitedNodes;
    protected int[] numDFS;
    protected int[] lowLink;
    protected SetSparse stackTarjan;
    protected SetSparse[] neighborsOfValues;
    protected SetSparse neighborsOfT;
    protected boolean splitSCC;
    protected SetSparse currValsSCC;
    protected SetSparse currVarsSCC;
    protected SetSparse queueBFS;
    protected int[] predBFS;

    public void restoreAtDepthBefore(int depth) {
        this.unfixedVars.restoreLimitAtLevel(depth);
    }

    public Matcher(Constraint ctr, Variable[] scp) {
        this.ctr = ctr;
        this.scp = scp;
        this.arity = scp.length;
        this.unmatchedVars = new SetSparse(this.arity);
        this.varToVal = Kit.repeat(-1, this.arity);
        this.currVarsSCC = new SetSparse(this.arity);
        this.minValue = Stream.of(scp).mapToInt(x -> x.dom.firstValue()).min().getAsInt();
        this.maxValue = Stream.of(scp).mapToInt(x -> x.dom.lastValue()).max().getAsInt();
        this.intervalSize = this.maxValue - this.minValue + 1;
        ctr.problem.head.observersConstruction.add(this);
    }

    @Override
    public void afterProblemConstruction() {
        this.unfixedVars = new SetSparseReversible(this.arity, this.ctr.problem.variables.length + 1);
        this.neighborsOfValues = SetSparse.factoryArray(this.arity + 1, this.intervalSize);
        this.neighborsOfT = new SetSparse(this.intervalSize);
        this.currValsSCC = new SetSparse(this.intervalSize);
        int nNodes = this.arity + this.intervalSize + 1;
        this.visitTime = Kit.repeat(-1, nNodes);
        this.stackTarjan = new SetSparse(nNodes);
        this.numDFS = new int[nNodes];
        this.lowLink = new int[nNodes];
    }

    protected abstract boolean findMaximumMatching();

    protected abstract void computeNeighbors();

    private void update(int adjacentNode, int node) {
        if (this.visitTime[adjacentNode] == this.time) {
            if (this.stackTarjan.isPresent(adjacentNode) && this.numDFS[adjacentNode] < this.lowLink[node]) {
                this.lowLink[node] = this.numDFS[adjacentNode];
            }
        } else {
            this.tarjanRemoveValues(adjacentNode);
            if (this.lowLink[adjacentNode] < this.lowLink[node]) {
                this.lowLink[node] = this.lowLink[adjacentNode];
            }
        }
    }

    protected final void tarjanRemoveValues(int node) {
        int i;
        assert (this.visitTime[node] < this.time);
        this.visitTime[node] = this.time;
        this.lowLink[node] = ++this.nVisitedNodes;
        this.numDFS[node] = this.nVisitedNodes;
        this.stackTarjan.add(node);
        if (node < this.arity) {
            this.update(this.arity + this.varToVal[node], node);
        } else if (node < this.arity + this.intervalSize) {
            SetSparse neighbors = this.neighborsOfValues[node - this.arity];
            for (i = 0; i <= neighbors.limit; ++i) {
                this.update(neighbors.dense[i] == this.arity ? this.arity + this.intervalSize : neighbors.dense[i], node);
            }
        } else {
            assert (node == this.arity + this.intervalSize);
            for (int i2 = 0; i2 <= this.neighborsOfT.limit; ++i2) {
                this.update(this.arity + this.neighborsOfT.dense[i2], node);
            }
        }
        if (this.lowLink[node] == this.numDFS[node]) {
            boolean bl = this.splitSCC = this.splitSCC || this.lowLink[node] > 1 || this.nVisitedNodes < this.visitTime.length;
            if (this.splitSCC) {
                this.currVarsSCC.clear();
                for (int j = 0; j <= this.unfixedVars.limit; ++j) {
                    this.currVarsSCC.add(this.unfixedVars.dense[j]);
                }
                this.currValsSCC.clear();
                int nodeSCC = -1;
                while (nodeSCC != node) {
                    nodeSCC = this.stackTarjan.pop();
                    if (nodeSCC < this.arity) {
                        this.currVarsSCC.remove(nodeSCC);
                        continue;
                    }
                    if (this.arity > nodeSCC || nodeSCC >= this.arity + this.intervalSize) continue;
                    this.currValsSCC.add(nodeSCC - this.arity);
                }
                if (this.currVarsSCC.size() > 0) {
                    for (i = 0; i <= this.currValsSCC.limit; ++i) {
                        int u = this.currValsSCC.dense[i];
                        for (int j = 0; j <= this.currVarsSCC.limit; ++j) {
                            int x = this.currVarsSCC.dense[j];
                            int a = this.scp[x].dom.toPresentIdx(this.domainValueOf(u));
                            if (a < 0 || this.varToVal[x] == u) continue;
                            this.scp[x].dom.remove(a);
                        }
                    }
                }
            }
        }
    }

    public final void removeInconsistentValues() {
        ++this.time;
        this.computeNeighbors();
        this.stackTarjan.clear();
        this.splitSCC = false;
        this.nVisitedNodes = 0;
        for (int x = 0; x < this.arity; ++x) {
            if (this.visitTime[x] < this.time) {
                this.tarjanRemoveValues(x);
            }
            Domain dom = this.scp[x].dom;
            int a = dom.first();
            while (a != -1) {
                int u = this.normalizedValueOf(dom.toVal(a));
                if (this.visitTime[this.arity + u] < this.time) {
                    this.tarjanRemoveValues(this.arity + u);
                }
                a = dom.next(a);
            }
        }
    }

    protected int domainValueOf(int normalizedValue) {
        return normalizedValue + this.minValue;
    }

    protected int normalizedValueOf(int domainValue) {
        return domainValue - this.minValue;
    }

    public static class MatcherCardinality
    extends Matcher {
        private SetSparse[] valToVars;
        private int[] keys;
        private int[] minOccs;
        private int[] maxOccs;
        private SetSparse[] possibleVars;
        private int[] predValue;

        @Override
        public void restoreAtDepthBefore(int depth) {
            super.restoreAtDepthBefore(depth);
        }

        @Override
        public void afterProblemConstruction() {
            super.afterProblemConstruction();
            this.valToVars = (SetSparse[])IntStream.range(0, this.intervalSize).mapToObj(i -> new SetSparse(this.arity, false)).toArray(SetSparse[]::new);
        }

        public MatcherCardinality(Cardinality.CardinalityConstant ctr, Variable[] scp, int[] keys, int[] minOccs, int[] maxOccs) {
            super(ctr, scp);
            this.keys = keys;
            this.minValue = Math.min(this.minValue, IntStream.of(keys).min().getAsInt());
            this.maxValue = Math.max(this.maxValue, IntStream.of(keys).max().getAsInt());
            this.intervalSize = this.maxValue - this.minValue + 1;
            this.queueBFS = new SetSparse(Math.max(this.arity, this.intervalSize));
            this.predBFS = Kit.repeat(-1, Math.max(this.arity, this.intervalSize));
            this.predValue = Kit.repeat(-1, this.intervalSize);
            this.minOccs = new int[this.intervalSize];
            this.maxOccs = Kit.repeat(Integer.MAX_VALUE, this.intervalSize);
            for (int i = 0; i < keys.length; ++i) {
                this.minOccs[this.normalizedValueOf((int)keys[i])] = minOccs[i];
                this.maxOccs[this.normalizedValueOf((int)keys[i])] = maxOccs[i];
            }
            this.possibleVars = new SetSparse[this.intervalSize];
            for (int u = 0; u < this.intervalSize; ++u) {
                this.possibleVars[u] = new SetSparse(this.arity);
                for (int x = 0; x < this.arity; ++x) {
                    if (!scp[x].dom.presentValue(this.domainValueOf(u))) continue;
                    this.possibleVars[u].add(x);
                }
            }
        }

        private void handleAugmentingPath(int x, int u) {
            while (this.predBFS[u] != -1) {
                int y = this.predBFS[u];
                this.varToVal[x] = u;
                this.valToVars[u].add(x);
                this.valToVars[u].remove(y);
                x = y;
                u = this.predValue[u];
            }
            this.varToVal[x] = u;
            this.valToVars[u].add(x);
        }

        private boolean findMatchingForValue(int u) {
            this.queueBFS.resetTo(u);
            this.predBFS[u] = -1;
            this.visitTime[u] = ++this.time;
            while (!this.queueBFS.isEmpty()) {
                int v = this.queueBFS.shift();
                for (int i = 0; i <= this.possibleVars[v].limit; ++i) {
                    int x = this.possibleVars[v].dense[i];
                    Domain dom = this.scp[x].dom;
                    if (!dom.presentValue(this.domainValueOf(v))) continue;
                    int w = this.varToVal[x];
                    if (w == -1) {
                        this.handleAugmentingPath(x, v);
                        return true;
                    }
                    if (w == v) continue;
                    if (this.valToVars[w].size() > this.minOccs[w] && this.varToVal[x] == w) {
                        this.valToVars[w].remove(x);
                        this.handleAugmentingPath(x, v);
                        return true;
                    }
                    if (this.visitTime[w] >= this.time) continue;
                    this.visitTime[w] = this.time;
                    this.queueBFS.add(w);
                    this.predBFS[w] = x;
                    this.predValue[w] = v;
                }
            }
            return false;
        }

        private boolean findMatchingForVariable(int x) {
            this.queueBFS.resetTo(x);
            this.predBFS[x] = -1;
            this.visitTime[x] = ++this.time;
            while (!this.queueBFS.isEmpty()) {
                int y = this.queueBFS.shift();
                Domain dom = this.scp[y].dom;
                int a = dom.first();
                while (a != -1) {
                    int u = this.normalizedValueOf(dom.toVal(a));
                    if (this.valToVars[u].size() < this.maxOccs[u]) {
                        while (this.predBFS[y] != -1) {
                            int v = this.varToVal[y];
                            this.varToVal[y] = u;
                            this.valToVars[u].add(y);
                            this.valToVars[v].remove(y);
                            y = this.predBFS[y];
                            u = v;
                        }
                        this.varToVal[y] = u;
                        this.valToVars[u].add(y);
                        return true;
                    }
                    for (int i = 0; i < this.valToVars[u].size(); ++i) {
                        int z = this.valToVars[u].dense[i];
                        assert (this.varToVal[z] == u);
                        if (this.visitTime[z] >= this.time) continue;
                        this.visitTime[z] = this.time;
                        this.predBFS[z] = y;
                        this.queueBFS.add(z);
                    }
                    a = dom.next(a);
                }
            }
            return false;
        }

        @Override
        public boolean findMaximumMatching() {
            int x;
            for (x = 0; x < this.arity; ++x) {
                Domain dom = this.scp[x].dom;
                int u = this.varToVal[x];
                if (u != -1 && dom.presentValue(this.domainValueOf(u))) continue;
                if (dom.size() == 1) {
                    int v = this.normalizedValueOf(dom.firstValue());
                    if (u != -1) {
                        this.valToVars[u].remove(x);
                    }
                    if (this.maxOccs[v] == this.valToVars[v].size()) {
                        this.varToVal[x] = -1;
                        continue;
                    }
                    this.varToVal[x] = v;
                    this.valToVars[v].add(x);
                    continue;
                }
                if (u == -1) continue;
                this.valToVars[u].remove(x);
                this.varToVal[x] = -1;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                int u = this.normalizedValueOf(this.keys[i]);
                while (this.valToVars[u].size() < this.minOccs[u]) {
                    if (this.findMatchingForValue(u)) continue;
                    return false;
                }
            }
            this.unmatchedVars.clear();
            for (x = 0; x < this.arity; ++x) {
                if (this.varToVal[x] == -1) {
                    this.unmatchedVars.add(x);
                    continue;
                }
                if (this.scp[x].dom.size() != 1 || !this.unfixedVars.isPresent(x)) continue;
                this.unfixedVars.remove(x, this.ctr.problem.solver.depth());
            }
            while (!this.unmatchedVars.isEmpty()) {
                if (this.findMatchingForVariable(this.unmatchedVars.pop())) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void computeNeighbors() {
            for (SetSparse set : this.neighborsOfValues) {
                set.clear();
            }
            for (int u = 0; u < this.intervalSize; ++u) {
                if (this.valToVars[u].size() < this.maxOccs[u]) {
                    this.neighborsOfT.add(u);
                } else {
                    this.neighborsOfT.remove(u);
                }
                if (this.valToVars[u].size() > this.minOccs[u]) {
                    this.neighborsOfValues[u].add(this.arity);
                } else {
                    this.neighborsOfValues[u].remove(this.arity);
                }
                for (int i = 0; i <= this.possibleVars[u].limit; ++i) {
                    int x = this.possibleVars[u].dense[i];
                    if (this.scp[x].dom.presentValue(this.domainValueOf(u)) && this.varToVal[x] != u) {
                        this.neighborsOfValues[u].add(x);
                        continue;
                    }
                    this.neighborsOfValues[u].remove(x);
                }
            }
        }

        private void checkMatchingConsistency() {
            Kit.control(IntStream.range(0, this.intervalSize).allMatch(u -> IntStream.range(0, this.valToVars[u].size()).allMatch(i -> this.varToVal[this.valToVars[u].dense[i]] == u)));
            Kit.control(IntStream.range(0, this.arity).allMatch(x -> this.varToVal[x] == -1 || this.valToVars[this.varToVal[x]].isPresent(x)));
        }

        private void checkMatchingValidity() {
            Kit.control(IntStream.range(0, this.arity).allMatch(x -> this.varToVal[x] != -1 && this.scp[x].dom.presentValue(this.domainValueOf(this.varToVal[x]))));
            Kit.control(IntStream.range(0, this.intervalSize).allMatch(u -> this.minOccs[u] <= this.valToVars[u].size() && this.valToVars[u].size() <= this.maxOccs[u]));
            this.checkMatchingConsistency();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("varToVal : " + IntStream.of(this.varToVal).mapToObj(u -> this.domainValueOf(u) + " ").collect(Collectors.joining()));
            sb.append("\nvalue2Variables :\n");
            for (int u2 = 0; u2 < this.intervalSize; ++u2) {
                sb.append("Value " + this.domainValueOf(u2) + " : ");
                for (int i = 0; i <= this.valToVars[u2].limit; ++i) {
                    sb.append(this.valToVars[u2].dense[i] + " ");
                }
                sb.append("\n");
            }
            sb.append("predVariable : " + Kit.join((Object)this.predBFS, new String[0]) + "\n");
            return sb.toString();
        }
    }

    public static class MatcherAllDifferent
    extends Matcher {
        private final int[] valToVar;

        public MatcherAllDifferent(AllDifferent.AllDifferentComplete ctr) {
            super(ctr, ctr.scp);
            this.queueBFS = new SetSparse(this.arity);
            this.predBFS = Kit.repeat(-1, this.arity);
            this.valToVar = Kit.repeat(-1, this.intervalSize);
        }

        private boolean findMatchingFor(int x) {
            ++this.time;
            this.predBFS[x] = -1;
            this.queueBFS.resetTo(x);
            while (!this.queueBFS.isEmpty()) {
                int y = this.queueBFS.shift();
                Domain dom = this.scp[y].dom;
                int a = dom.first();
                while (a != -1) {
                    int v = this.normalizedValueOf(dom.toVal(a));
                    int z = this.valToVar[v];
                    assert (z == -1 || this.varToVal[z] == v);
                    if (z == -1) {
                        while (this.predBFS[y] != -1) {
                            int w = this.varToVal[y];
                            this.varToVal[y] = v;
                            this.valToVar[v] = y;
                            v = w;
                            y = this.predBFS[y];
                        }
                        this.varToVal[y] = v;
                        this.valToVar[v] = y;
                        return true;
                    }
                    if (this.visitTime[z] < this.time) {
                        this.visitTime[z] = this.time;
                        this.predBFS[z] = y;
                        this.queueBFS.add(z);
                    }
                    a = dom.next(a);
                }
            }
            return false;
        }

        @Override
        public boolean findMaximumMatching() {
            this.unmatchedVars.clear();
            for (int x = 0; x < this.arity; ++x) {
                int u = this.varToVal[x];
                if (u == -1) {
                    this.unmatchedVars.add(x);
                    continue;
                }
                assert (this.valToVar[u] == x);
                if (!this.scp[x].dom.presentValue(this.domainValueOf(u))) {
                    this.valToVar[u] = -1;
                    this.varToVal[x] = -1;
                    this.unmatchedVars.add(x);
                }
                if (this.scp[x].dom.size() != 1 || !this.unfixedVars.isPresent(x)) continue;
                this.unfixedVars.remove(x, this.ctr.problem.solver.depth());
            }
            while (!this.unmatchedVars.isEmpty()) {
                if (this.findMatchingFor(this.unmatchedVars.pop())) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void computeNeighbors() {
            for (SetSparse set : this.neighborsOfValues) {
                set.clear();
            }
            for (int x = 0; x < this.arity; ++x) {
                Domain dom = this.scp[x].dom;
                int a = dom.first();
                while (a != -1) {
                    int u = this.normalizedValueOf(dom.toVal(a));
                    if (this.valToVar[u] == x) {
                        this.neighborsOfValues[u].add(this.arity);
                    } else if (this.valToVar[u] != -1) {
                        this.neighborsOfT.remove(u);
                    } else {
                        this.neighborsOfValues[u].remove(this.arity);
                        this.neighborsOfT.add(u);
                    }
                    this.neighborsOfValues[u].add(x);
                    a = dom.next(a);
                }
            }
        }

        public String toString() {
            return "varToVal: " + Kit.join((Object)this.varToVal, new String[0]) + "\nvalToVar: " + Kit.join((Object)this.valToVar, new String[0]);
        }
    }
}

