/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class ElementMatrix
extends Constraint.CtrGlobal
implements Tags.TagNotSymmetric,
Tags.TagAC,
Tags.TagFilteringCompleteAtEachCall {
    private Variable[][] matrix;
    private Variable rindex;
    private Variable cindex;
    private int value;
    private Domain rdom;
    private Domain cdom;
    private int rindexPosition;
    private int cindexPosition;
    private int[] rsentinels;
    private int[] csentinels;

    @Override
    public boolean checkValues(int[] t) {
        int i = t[this.rindexPosition];
        int j = t[this.cindexPosition];
        return t[i * this.matrix.length + j] == this.value;
    }

    public ElementMatrix(Problem pb, Variable[][] matrix, Variable rindex, Variable cindex, int value) {
        super(pb, Utilities.collect(Variable.class, new Object[]{matrix, rindex, cindex}));
        this.matrix = matrix;
        this.rindex = rindex;
        this.cindex = cindex;
        this.value = value;
        this.rdom = rindex.dom;
        this.cdom = cindex.dom;
        this.defineKey(value);
        this.rindexPosition = IntStream.range(0, this.scp.length).filter(i -> this.scp[i] == rindex).findFirst().getAsInt();
        this.cindexPosition = IntStream.range(0, this.scp.length).filter(i -> this.scp[i] == cindex).findFirst().getAsInt();
        this.control(rindex.dom.areInitValuesExactly(pb.api.range(0, matrix.length)), () -> "case not implemented");
        this.control(cindex.dom.areInitValuesExactly(pb.api.range(0, matrix[0].length)), () -> "case not implemented");
        this.control(Variable.areAllDistinct((Variable[])pb.vars(matrix)) && rindex != cindex, () -> Kit.join((Object)matrix, new String[0]) + " " + rindex + " " + cindex);
        this.rsentinels = new int[matrix.length];
        this.csentinels = new int[matrix[0].length];
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int sizeBefore = this.rdom.size();
        if (sizeBefore > 1) {
            int a = this.rdom.last();
            while (a != -1) {
                block12: {
                    int b = this.rsentinels[a];
                    if (!this.cdom.present(b) || !this.matrix[a][b].dom.presentValue(this.value)) {
                        b = this.cdom.last();
                        while (b != -1) {
                            if (this.matrix[a][b].dom.presentValue(this.value)) {
                                this.rsentinels[a] = b;
                                break block12;
                            }
                            b = this.cdom.prev(b);
                        }
                        this.rdom.removeElementary(a);
                    }
                }
                a = this.rdom.prev(a);
            }
            if (!this.rdom.afterElementaryCalls(sizeBefore)) {
                return false;
            }
        }
        if ((sizeBefore = this.cdom.size()) > 1) {
            int b = this.cdom.last();
            while (b != -1) {
                block13: {
                    int a = this.csentinels[b];
                    if (!this.rdom.present(a) || !this.matrix[a][b].dom.presentValue(this.value)) {
                        a = this.rdom.last();
                        while (a != -1) {
                            if (this.matrix[a][b].dom.presentValue(this.value)) {
                                this.csentinels[b] = a;
                                break block13;
                            }
                            a = this.rdom.prev(a);
                        }
                        this.cdom.removeElementary(b);
                    }
                }
                b = this.cdom.prev(b);
            }
            if (!this.cdom.afterElementaryCalls(sizeBefore)) {
                return false;
            }
        }
        return this.rdom.size() > 1 || this.cdom.size() > 1 || this.matrix[this.rdom.unique()][this.cdom.unique()].dom.reduceToValue(this.value) && this.entailed();
    }
}

