/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import interfaces.Tags;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import problem.Problem;
import sets.SetSparse;
import variables.Domain;
import variables.Variable;

public abstract class Count
extends Constraint.CtrGlobal
implements Tags.TagAC {
    protected final Variable[] list;
    protected final int value;

    public static int countIn(int value, int[] t, int from, int to) {
        int cnt = 0;
        for (int i = from; i < to; ++i) {
            if (t[i] != value) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int countIn(int value, int[] t) {
        return Count.countIn(value, t, 0, t.length);
    }

    public Count(Problem pb, Variable[] scp, Variable[] list, int value) {
        super(pb, scp);
        this.list = list;
        this.value = value;
        this.control(Stream.of(list).allMatch(x -> x.dom.presentValue(value) && x.dom.size() > 1), "Badly formed scope.");
    }

    public static abstract class CountVar
    extends Count {
        protected final Variable k;
        protected final int indexOfKInList;

        public static CountVar buildFrom(Problem pb, Variable[] scp, int value, Types.TypeConditionOperatorRel op, Variable k) {
            switch (op) {
                case EQ: {
                    return new ExactlyVarK(pb, scp, value, k);
                }
            }
            throw new AssertionError((Object)"not implemented");
        }

        public CountVar(Problem pb, Variable[] list, int value, Variable k) {
            super(pb, (Variable[])pb.vars(new Object[]{list, k}), list, value);
            this.k = k;
            this.indexOfKInList = Utilities.indexOf(k, list);
            this.defineKey(value, this.indexOfKInList);
        }

        public static final class ExactlyVarK
        extends CountVar
        implements Tags.TagFilteringCompleteAtEachCall {
            @Override
            public boolean checkValues(int[] t) {
                return this.indexOfKInList != -1 ? CountCst.countIn(this.value, t) == t[this.indexOfKInList] : CountCst.countIn(this.value, t, 0, t.length - 1) == t[t.length - 1];
            }

            @Override
            public int[] symmetryMatching() {
                return IntStream.range(0, this.scp.length).map(i -> i == this.indexOfKInList || this.indexOfKInList == -1 && i == this.scp.length - 1 ? 2 : 1).toArray();
            }

            public ExactlyVarK(Problem pb, Variable[] list, int value, Variable k) {
                super(pb, list, value, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int vk;
                int nGuaranteedOccurrences = 0;
                int nPossibleOccurrences = 0;
                for (Variable x : this.list) {
                    if (!x.dom.presentValue(this.value)) continue;
                    ++nPossibleOccurrences;
                    if (x.dom.size() != 1) continue;
                    ++nGuaranteedOccurrences;
                }
                Domain dk = this.k.dom;
                if (dk.size() == 1) {
                    vk = dk.uniqueValue();
                    if (vk < nGuaranteedOccurrences || vk > nPossibleOccurrences) {
                        return dk.fail();
                    }
                } else if (this.indexOfKInList != -1) {
                    int a = dk.toPresentIdx(this.value);
                    if (a != -1) {
                        boolean deleted = false;
                        int b = dk.first();
                        while (b != -1) {
                            if (b == a) {
                                if (this.value < nGuaranteedOccurrences + 1 || nPossibleOccurrences < this.value) {
                                    if (!dk.remove(a)) {
                                        return false;
                                    }
                                    deleted = true;
                                }
                            } else {
                                int vb = dk.toVal(b);
                                if (!(vb >= nGuaranteedOccurrences && nPossibleOccurrences - 1 >= vb || dk.remove(b))) {
                                    return false;
                                }
                            }
                            b = dk.next(b);
                        }
                        if (deleted) {
                            --nPossibleOccurrences;
                        }
                    } else if (!dk.removeValuesLT(nGuaranteedOccurrences) || !dk.removeValuesGT(nPossibleOccurrences)) {
                        return false;
                    }
                } else if (!dk.removeValuesLT(nGuaranteedOccurrences) || !dk.removeValuesGT(nPossibleOccurrences)) {
                    return false;
                }
                if (dk.size() == 1) {
                    vk = dk.uniqueValue();
                    if (vk == nGuaranteedOccurrences) {
                        int toremove = nPossibleOccurrences - vk;
                        if (toremove > 0) {
                            for (Variable x : this.list) {
                                if (x.dom.size() <= 1 || !x.dom.presentValue(this.value)) continue;
                                x.dom.removeValue(this.value);
                            }
                        }
                        return this.entailed();
                    }
                    if (vk == nPossibleOccurrences) {
                        int toassign = vk - nGuaranteedOccurrences;
                        if (toassign > 0) {
                            for (Variable x : this.list) {
                                if (x.dom.size() <= 1 || !x.dom.presentValue(this.value)) continue;
                                x.dom.reduceToValue(this.value);
                            }
                        }
                        return this.entailed();
                    }
                }
                return true;
            }
        }
    }

    public static abstract class CountCst
    extends Count {
        protected final int k;

        public static CountCst buildFrom(Problem pb, Variable[] scp, int value, Types.TypeConditionOperatorRel op, int k) {
            switch (op) {
                case LT: {
                    return k == 2 ? new AtMost1(pb, scp, value) : new AtMostK(pb, scp, value, k - 1);
                }
                case LE: {
                    return k == 1 ? new AtMost1(pb, scp, value) : new AtMostK(pb, scp, value, k);
                }
                case GE: {
                    return k == 1 ? new AtLeast1(pb, scp, value) : new AtLeastK(pb, scp, value, k);
                }
                case GT: {
                    return k == 0 ? new AtLeast1(pb, scp, value) : new AtLeastK(pb, scp, value, k + 1);
                }
                case EQ: {
                    return k == 1 ? new Exactly1(pb, scp, value) : new ExactlyK(pb, scp, value, k);
                }
            }
            throw new AssertionError((Object)"NE is not implemented");
        }

        public CountCst(Problem pb, Variable[] list, int value, int k) {
            super(pb, list, list, value);
            this.k = k;
            this.defineKey(value, k);
            this.control(0 < k && k < list.length, "Bad value of k=" + k);
        }

        public static final class Exactly1
        extends ExactlyK {
            public Exactly1(Problem pb, Variable[] list, int value) {
                super(pb, list, value, 1);
            }
        }

        public static class ExactlyK
        extends CountCst
        implements Tags.TagSymmetric {
            @Override
            public boolean checkValues(int[] t) {
                return ExactlyK.countIn(this.value, t) == this.k;
            }

            public ExactlyK(Problem pb, Variable[] list, int value, int k) {
                super(pb, list, value, k);
            }

            @Override
            public boolean runPropagator(Variable x) {
                int i;
                if (x.dom.size() > 1 && x.dom.presentValue(this.value)) {
                    return true;
                }
                int nGuaranteedOccurrences = 0;
                int nPossibleOccurrences = 0;
                for (Variable y : this.scp) {
                    if (!y.dom.presentValue(this.value)) continue;
                    ++nPossibleOccurrences;
                    if (y.dom.size() != 1 || ++nGuaranteedOccurrences <= this.k) continue;
                    return y.dom.fail();
                }
                if (nGuaranteedOccurrences == this.k) {
                    int toremove = nPossibleOccurrences - this.k;
                    for (i = this.futvars.limit; i >= 0 && toremove > 0; --i) {
                        Domain dom = this.scp[this.futvars.dense[i]].dom;
                        if (dom.size() <= 1 || !dom.presentValue(this.value)) continue;
                        dom.removeValue(this.value);
                        --toremove;
                    }
                    return this.entailed();
                }
                if (nPossibleOccurrences < this.k) {
                    return x.dom.fail();
                }
                if (nPossibleOccurrences == this.k) {
                    int toassign = this.k - nGuaranteedOccurrences;
                    for (i = this.futvars.limit; i >= 0 && toassign > 0; --i) {
                        Domain dom = this.scp[this.futvars.dense[i]].dom;
                        if (dom.size() <= 1 || !dom.presentValue(this.value)) continue;
                        dom.reduceToValue(this.value);
                        --toassign;
                    }
                    return this.entailed();
                }
                return true;
            }
        }

        public static final class AtLeast1
        extends AtLeastK {
            private Variable sentinel1;
            private Variable sentinel2;

            public AtLeast1(Problem pb, Variable[] list, int value) {
                super(pb, list, value, 1);
                this.sentinel1 = list[0];
                this.sentinel2 = list[1];
            }

            private Variable findAnotherSentinel() {
                for (Variable x : this.scp) {
                    if (x == this.sentinel1 || x == this.sentinel2 || !x.dom.presentValue(this.value)) continue;
                    return x;
                }
                return null;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean runPropagator(Variable x) {
                if (x == this.sentinel1) {
                    if (this.sentinel1.dom.presentValue(this.value)) return true;
                    Variable sentinel = this.findAnotherSentinel();
                    if (sentinel != null) {
                        this.sentinel1 = sentinel;
                        return true;
                    }
                    if (!this.sentinel2.dom.reduceToValue(this.value)) return false;
                    if (!this.entailed()) return false;
                    return true;
                }
                if (x != this.sentinel2) return true;
                if (this.sentinel2.dom.presentValue(this.value)) return true;
                Variable sentinel = this.findAnotherSentinel();
                if (sentinel != null) {
                    this.sentinel2 = sentinel;
                    return true;
                }
                if (!this.sentinel1.dom.reduceToValue(this.value)) return false;
                if (!this.entailed()) return false;
                return true;
            }
        }

        public static class AtLeastK
        extends CountCst
        implements Tags.TagSymmetric {
            protected SetSparse sentinels;

            @Override
            public boolean checkValues(int[] t) {
                return AtLeastK.countIn(this.value, t) >= this.k;
            }

            public AtLeastK(Problem pb, Variable[] list, int value, int k) {
                super(pb, list, value, k);
                if (k > 1) {
                    this.sentinels = new SetSparse(list.length);
                    IntStream.range(0, k + 1).forEach(i -> this.sentinels.add(i));
                }
            }

            @Override
            public boolean runPropagator(Variable x) {
                int i;
                int p = this.positionOf(x);
                if (!this.sentinels.isPresent(p) || x.dom.presentValue(this.value)) {
                    return true;
                }
                int[] dense = this.sentinels.dense;
                for (i = this.sentinels.limit + 1; i < dense.length; ++i) {
                    if (!this.scp[dense[i]].dom.presentValue(this.value)) continue;
                    this.sentinels.swap(p, dense[i]);
                    return true;
                }
                for (i = this.sentinels.limit; i >= 0; --i) {
                    if (dense[i] == p || this.scp[dense[i]].dom.reduceToValue(this.value)) continue;
                    return false;
                }
                return this.entailed();
            }
        }

        public static final class AtMost1
        extends AtMostK {
            public AtMost1(Problem pb, Variable[] list, int value) {
                super(pb, list, value, 1);
            }

            @Override
            public boolean runPropagator(Variable x) {
                if (!x.dom.onlyContainsValue(this.value)) {
                    return true;
                }
                for (Variable y : this.scp) {
                    if (y == x || y.dom.removeValueIfPresent(this.value)) continue;
                    return false;
                }
                return this.entailed();
            }
        }

        public static class AtMostK
        extends CountCst
        implements Tags.TagSymmetric {
            @Override
            public boolean checkValues(int[] t) {
                return AtMostK.countIn(this.value, t) <= this.k;
            }

            public AtMostK(Problem pb, Variable[] list, int value, int k) {
                super(pb, list, value, k);
            }

            @Override
            public boolean runPropagator(Variable x) {
                if (!x.dom.onlyContainsValue(this.value)) {
                    return true;
                }
                int cnt = 0;
                for (Variable y : this.scp) {
                    if (!y.dom.onlyContainsValue(this.value) || ++cnt <= this.k) continue;
                    return x.dom.fail();
                }
                if (cnt == this.k) {
                    for (int i = this.futvars.limit; i >= 0; --i) {
                        Domain dom = this.scp[this.futvars.dense[i]].dom;
                        if (dom.size() <= 1) continue;
                        dom.removeValueIfPresent(this.value);
                    }
                }
                return true;
            }
        }
    }
}

