/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.global.AllDifferent;
import java.util.TreeSet;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import sets.SetSparse;
import variables.Variable;

public final class Circuit
extends AllDifferent.AllDifferentComplete {
    private SetSparse set;

    @Override
    public boolean checkValues(int[] t) {
        int i2;
        if (!super.checkValues(t)) {
            return false;
        }
        int nLoops = (int)IntStream.range(0, t.length).filter(i -> t[i] == i).count();
        if (nLoops == t.length) {
            return false;
        }
        for (i2 = 0; i2 < this.scp.length && t[i2] == i2; ++i2) {
        }
        TreeSet<Integer> s = new TreeSet<Integer>();
        while (t[i2] != i2 && !s.contains(t[i2])) {
            s.add(t[i2]);
            i2 = t[i2];
        }
        return s.size() == t.length - nLoops;
    }

    public Circuit(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.set = new SetSparse(scp.length);
        this.control(Stream.of(scp).allMatch(x -> x.dom.areInitValuesSubsetOf(pb.api.range(scp.length))));
    }

    @Override
    public boolean isGuaranteedAC() {
        return false;
    }

    @Override
    public boolean runPropagator(Variable x) {
        int i;
        if (!super.runPropagator(x)) {
            return false;
        }
        int minimalCircuitLength = 0;
        for (i = 0; i < this.scp.length; ++i) {
            if (this.scp[i].dom.presentValue(i)) continue;
            ++minimalCircuitLength;
        }
        block1: for (i = 0; i < this.scp.length; ++i) {
            int j;
            if (this.scp[i].dom.size() != 1 || i == (j = this.scp[i].dom.uniqueValue())) continue;
            this.set.clear();
            this.set.add(i);
            if (!this.scp[j].dom.removeValueIfPresent(j)) {
                return false;
            }
            while (this.set.size() + 1 < minimalCircuitLength) {
                if (!this.scp[j].dom.removeValuesIn(this.set)) {
                    return false;
                }
                if (this.scp[j].dom.size() != 1) continue block1;
                if (this.set.isPresent(j)) {
                    return false;
                }
                this.set.add(j);
                j = this.scp[j].dom.uniqueValue();
                if (this.scp[j].dom.removeValueIfPresent(j)) continue;
                return false;
            }
        }
        return true;
    }
}

