/*
 * Decompiled with CFR 0.152.
 */
package constraints.global;

import constraints.Constraint;
import constraints.global.Matcher;
import interfaces.Observers;
import interfaces.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import problem.Problem;
import sets.SetSparse;
import sets.SetSparseReversible;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class AllDifferent
extends Constraint.CtrGlobal
implements Tags.TagSymmetric {
    @Override
    public boolean checkValues(int[] t) {
        for (int i = 0; i < t.length; ++i) {
            for (int j = i + 1; j < t.length; ++j) {
                if (t[i] != t[j]) continue;
                return false;
            }
        }
        return true;
    }

    public AllDifferent(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.defineKey(new Object[0]);
    }

    public static final class AllDifferentBound
    extends AllDifferent
    implements Observers.ObserverBacktracking.ObserverBacktrackingSystematic,
    Tags.TagNotAC {
        int timing;
        int d;
        long nDecisionsAtLastCall;
        SetSparseReversible fixedIdxs;
        BoundReasoner minReasoner;
        BoundReasoner maxReasoner;
        HallIntervalStored storer;
        int[] storedMins;
        int[] storedMaxs;

        @Override
        public void restoreBefore(int depth) {
            this.fixedIdxs.restoreLimitAtLevel(depth);
            this.storer.restoreAtDepthBefore(depth);
        }

        @Override
        public void afterProblemConstruction() {
            super.afterProblemConstruction();
            this.fixedIdxs = new SetSparseReversible(this.scp[0].dom.initSize(), false, this.problem.variables.length + 1);
            this.storer = new HallIntervalStored(this.scp[0].dom.initSize(), this.problem.variables.length + 1);
        }

        public AllDifferentBound(Problem pb, Variable[] scp) {
            super(pb, scp);
            Kit.control(Variable.haveSameDomainType(scp));
            this.d = scp[0].dom.initSize();
            this.minReasoner = new MinBoundReasoner();
            this.maxReasoner = new MaxBoundReasoner();
            this.storedMins = Stream.of(scp).mapToInt(x -> x.dom.first()).toArray();
            this.storedMaxs = Stream.of(scp).mapToInt(x -> x.dom.last()).toArray();
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (x.dom.size() == 1) {
                int a = x.dom.unique();
                if (!this.fixedIdxs.isPresent(a)) {
                    this.fixedIdxs.add(a, this.problem.solver.depth());
                }
                int v = x.dom.uniqueValue();
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Variable y = this.scp[this.futvars.dense[i]];
                    if (y == x || y.dom.removeValueIfPresent(v)) continue;
                    return false;
                }
            }
            int pos = this.positionOf(x);
            if (x.dom.first() == this.storedMins[pos] && x.dom.last() == this.storedMaxs[pos]) {
                return true;
            }
            this.nDecisionsAtLastCall = this.problem.solver.stats.nDecisions;
            ++this.timing;
            this.minReasoner.initialize();
            this.maxReasoner.initialize();
            if (!this.minReasoner.findIntervals(x)) {
                return false;
            }
            if (!this.maxReasoner.findIntervals(x)) {
                return false;
            }
            for (int i = this.futvars.limit; i >= 0; --i) {
                int y = this.futvars.dense[i];
                this.storedMins[y] = this.scp[y].dom.first();
                this.storedMaxs[y] = this.scp[y].dom.last();
            }
            return true;
        }

        class HallIntervalStored {
            boolean[][] matrix;
            ArrayList<Integer>[] t;

            void restoreAtDepthBefore(int depth) {
                ArrayList<Integer> list = this.t[depth];
                for (int i = 0; i < list.get(0); ++i) {
                    assert (this.matrix[list.get(i * 2 + 1)][list.get(i * 2 + 2)]);
                    this.matrix[list.get((int)(i * 2 + 1)).intValue()][list.get((int)(i * 2 + 2)).intValue()] = false;
                }
                list.clear();
                list.add(0);
            }

            HallIntervalStored(int d, int nLevels) {
                this.matrix = new boolean[d][d];
                this.t = (ArrayList[])IntStream.range(0, nLevels).mapToObj(i -> new ArrayList<Integer>(Arrays.asList(0))).toArray(ArrayList[]::new);
            }

            void add(int a, int b, int level) {
                assert (!this.matrix[a][b]);
                this.matrix[a][b] = true;
                ArrayList<Integer> list = this.t[level];
                list.set(0, list.get(0) + 1);
                list.add(a);
                list.add(b);
            }

            public String toString() {
                String s = IntStream.rangeClosed(0, AllDifferentBound.this.problem.solver.depth()).mapToObj(i -> this.t[i]).filter(l -> l.size() > 0).map(l -> l.toString()).collect(Collectors.joining(" "));
                return s;
            }
        }

        class MaxBoundReasoner
        extends BoundReasoner {
            MaxBoundReasoner() {
            }

            @Override
            boolean findIntervals(Variable x) {
                for (int b = this.from; b <= this.to; ++b) {
                    Fixed1 f1 = this.fixed1[b];
                    if (!f1.isPresent()) continue;
                    this.collectedVars.clear();
                    int nFixed = 0;
                    int end = b;
                    for (int a = f1.to; a >= f1.from; --a) {
                        int i;
                        assert (a < b);
                        Fixed2 edge = f1.edges[a];
                        if (!edge.isPresent()) continue;
                        edge.addCollectedVarsToSet(this.collectedVars);
                        end = a - 1;
                        this.absentIdxs.clear();
                        int nVals = b - a + 1 - (nFixed += this.nFixedBetween(a, end)) - this.absentIdxs.size();
                        if (this.collectedVars.size() > nVals) {
                            return x.dom.fail();
                        }
                        if (nVals >= AllDifferentBound.this.scp.length || this.collectedVars.size() != nVals || AllDifferentBound.this.storer.matrix[a][b]) continue;
                        AllDifferentBound.this.storer.add(a, b, AllDifferentBound.this.problem.solver.depth());
                        int nValuesBefore = AllDifferentBound.this.problem.nValuesRemoved;
                        for (i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                            int y = AllDifferentBound.this.futvars.dense[i];
                            if (this.collectedVars.isPresent(y) || AllDifferentBound.this.scp[y].dom.size() <= 1 || this.remove(AllDifferentBound.this.scp[y].dom, a, b)) continue;
                            return false;
                        }
                        i = AllDifferentBound.this.problem.nValuesRemoved - nValuesBefore;
                    }
                    int nV = b - f1.from + 1 - nFixed - this.absentIdxs.size();
                    if (nV + 1 < this.collectedVars.size()) continue;
                    int a = f1.from;
                    for (int bb = b - 1; bb > a; --bb) {
                        Fixed2 edge;
                        f1 = this.fixed1[bb];
                        if (!f1.isPresent() || !(edge = f1.edges[a]).isPresent()) continue;
                        edge.addCollectedVarsToSet(this.collectedVars);
                        this.absentIdxs.clear();
                        this.collectAbsentBetween(a, b);
                        int nVals = b - a + 1 - nFixed - this.absentIdxs.size();
                        if (this.collectedVars.size() > nVals) {
                            return x.dom.fail();
                        }
                        if (nVals >= AllDifferentBound.this.scp.length || this.collectedVars.size() != nVals || AllDifferentBound.this.storer.matrix[a][b]) continue;
                        AllDifferentBound.this.storer.add(a, b, AllDifferentBound.this.problem.solver.depth());
                        int nValuesBefore = AllDifferentBound.this.problem.nValuesRemoved;
                        for (int i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                            int y = AllDifferentBound.this.futvars.dense[i];
                            if (this.collectedVars.isPresent(y) || AllDifferentBound.this.scp[y].dom.size() <= 1 || this.remove(AllDifferentBound.this.scp[y].dom, a, b)) continue;
                            return false;
                        }
                        int n = AllDifferentBound.this.problem.nValuesRemoved - nValuesBefore;
                    }
                }
                return true;
            }
        }

        class MinBoundReasoner
        extends BoundReasoner {
            MinBoundReasoner() {
            }

            @Override
            boolean findIntervals(Variable x) {
                for (int a = this.to; a >= this.from; --a) {
                    Fixed1 f1 = this.fixed1[a];
                    if (!f1.isPresent()) continue;
                    this.collectedVars.clear();
                    int nFixed = 0;
                    int start = a;
                    for (int b = f1.from; b <= f1.to; ++b) {
                        int i;
                        Fixed2 edge = f1.edges[b];
                        if (!edge.isPresent()) continue;
                        edge.addCollectedVarsToSet(this.collectedVars);
                        start = b + 1;
                        this.absentIdxs.clear();
                        int nVals = b - a + 1 - (nFixed += this.nFixedBetween(start, b)) - this.absentIdxs.size();
                        if (this.collectedVars.size() > nVals) {
                            return x.dom.fail();
                        }
                        if (nVals >= AllDifferentBound.this.scp.length || this.collectedVars.size() != nVals || AllDifferentBound.this.storer.matrix[a][b]) continue;
                        AllDifferentBound.this.storer.add(a, b, AllDifferentBound.this.problem.solver.depth());
                        int nValuesBefore = AllDifferentBound.this.problem.nValuesRemoved;
                        for (i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                            int y = AllDifferentBound.this.futvars.dense[i];
                            if (this.collectedVars.isPresent(y) || AllDifferentBound.this.scp[y].dom.size() <= 1 || this.remove(AllDifferentBound.this.scp[y].dom, a, b)) continue;
                            return false;
                        }
                        i = AllDifferentBound.this.problem.nValuesRemoved - nValuesBefore;
                    }
                    int nV = f1.to - a + 1 - nFixed - this.absentIdxs.size();
                    if (nV + 1 < this.collectedVars.size()) continue;
                    int b = f1.to;
                    for (int aa = a + 1; aa < b; ++aa) {
                        Fixed2 edge;
                        f1 = this.fixed1[aa];
                        if (!f1.isPresent() || !(edge = f1.edges[b]).isPresent()) continue;
                        edge.addCollectedVarsToSet(this.collectedVars);
                        this.absentIdxs.clear();
                        this.collectAbsentBetween(a, b);
                        int nVals = b - a + 1 - nFixed - this.absentIdxs.size();
                        if (this.collectedVars.size() > nVals) {
                            return x.dom.fail();
                        }
                        if (nVals >= AllDifferentBound.this.scp.length || this.collectedVars.size() != nVals || AllDifferentBound.this.storer.matrix[a][b]) continue;
                        AllDifferentBound.this.storer.add(a, b, AllDifferentBound.this.problem.solver.depth());
                        int nValuesBefore = AllDifferentBound.this.problem.nValuesRemoved;
                        for (int i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                            int y = AllDifferentBound.this.futvars.dense[i];
                            if (this.collectedVars.isPresent(y) || AllDifferentBound.this.scp[y].dom.size() <= 1 || this.remove(AllDifferentBound.this.scp[y].dom, a, b)) continue;
                            return false;
                        }
                        int n = AllDifferentBound.this.problem.nValuesRemoved - nValuesBefore;
                    }
                }
                return true;
            }
        }

        abstract class BoundReasoner {
            SetSparse collectedVars;
            SetSparse absentIdxs;
            final Fixed1[] fixed1;
            int from;
            int to;

            BoundReasoner() {
                this.collectedVars = new SetSparse(AllDifferentBound.this.scp.length);
                this.absentIdxs = new SetSparse(AllDifferentBound.this.scp.length);
                this.fixed1 = new Fixed1[AllDifferentBound.this.d];
                if (this instanceof MinBoundReasoner) {
                    IntStream.range(0, AllDifferentBound.this.d - 1).forEach(i -> {
                        this.fixed1[i] = new Fixed1(i + 1, AllDifferentBound.this.d - 1);
                    });
                } else {
                    IntStream.range(1, AllDifferentBound.this.d).forEach(i -> {
                        this.fixed1[i] = new Fixed1(0, i - 1);
                    });
                }
            }

            void initialize() {
                this.from = AllDifferentBound.this.scp.length;
                this.to = -1;
                for (int i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                    int b;
                    int x = AllDifferentBound.this.futvars.dense[i];
                    if (AllDifferentBound.this.scp[x].dom.size() == 1) continue;
                    int first = AllDifferentBound.this.scp[x].dom.first();
                    int last = AllDifferentBound.this.scp[x].dom.last();
                    int a = this instanceof MinBoundReasoner ? first : last;
                    int n = b = a == first ? last : first;
                    if (a < this.from) {
                        this.from = a;
                    }
                    if (a > this.to) {
                        this.to = a;
                    }
                    this.fixed1[a].add(b, x);
                }
            }

            int nFixedBetween(int a, int b) {
                int nb = 0;
                for (int k = a; k <= b; ++k) {
                    if (!AllDifferentBound.this.fixedIdxs.isPresent(k)) continue;
                    ++nb;
                }
                return nb;
            }

            boolean isAlwaysAbsent(int k) {
                for (int i = this.collectedVars.limit; i >= 0; --i) {
                    if (!AllDifferentBound.this.scp[this.collectedVars.dense[i]].dom.present(k)) continue;
                    return false;
                }
                return true;
            }

            void collectAbsentBetween(int a, int b) {
                for (int k = a; k <= b; ++k) {
                    if (AllDifferentBound.this.fixedIdxs.isPresent(k) || !this.isAlwaysAbsent(k)) continue;
                    this.absentIdxs.add(k);
                }
            }

            abstract boolean findIntervals(Variable var1);

            public String toString() {
                return "minToMax=" + (this instanceof MinBoundReasoner) + " from=" + this.from + " to=" + this.to + "\n" + IntStream.rangeClosed(this.from, this.to).filter(i -> this.fixed1[i].isPresent()).mapToObj(i -> i + "-> " + this.fixed1[i]).collect(Collectors.joining("\n\n"));
            }

            boolean remove(Domain dom, int from, int to) {
                for (int a = from; a <= to; ++a) {
                    if (this.absentIdxs.isPresent(a) || dom.removeIfPresent(a)) continue;
                    return false;
                }
                return true;
            }
        }

        class Fixed1 {
            int time;
            int from;
            int to;
            final Fixed2[] edges;

            Fixed1(int possibleFrom, int possibleTo) {
                this.edges = (Fixed2[])IntStream.range(0, AllDifferentBound.this.d).mapToObj(i -> possibleFrom <= i && i <= possibleTo ? new Fixed2() : null).toArray(Fixed2[]::new);
            }

            boolean isPresent() {
                return this.time == AllDifferentBound.this.timing;
            }

            void add(int bnd, int x) {
                if (!this.isPresent()) {
                    this.time = AllDifferentBound.this.timing;
                    this.from = AllDifferentBound.this.scp.length;
                    this.to = -1;
                }
                if (bnd < this.from) {
                    this.from = bnd;
                }
                if (bnd > this.to) {
                    this.to = bnd;
                }
                this.edges[bnd].add(x);
            }

            public String toString() {
                return !this.isPresent() ? "" : "from=" + this.from + " to=" + this.to + "\n\t" + IntStream.rangeClosed(this.from, this.to).filter(i -> this.edges[i].isPresent()).mapToObj(i -> i + ": " + this.edges[i]).collect(Collectors.joining("\n\t"));
            }
        }

        class Fixed2 {
            int time;
            int cnt;
            int[] collectedVarPositions;

            Fixed2() {
                this.collectedVarPositions = new int[AllDifferentBound.this.scp.length];
            }

            boolean isPresent() {
                return this.time == AllDifferentBound.this.timing;
            }

            void addCollectedVarsToSet(SetSparse set) {
                for (int i = 0; i < this.cnt; ++i) {
                    set.add(this.collectedVarPositions[i]);
                }
            }

            void add(int x) {
                if (!this.isPresent()) {
                    this.time = AllDifferentBound.this.timing;
                    this.cnt = 0;
                }
                assert (!Utilities.contains(this.collectedVarPositions, x, 0, this.cnt - 1));
                this.collectedVarPositions[this.cnt++] = x;
            }

            public String toString() {
                return !this.isPresent() ? "" : "time=" + this.time + " cnt=" + this.cnt + " vars=" + Kit.join((Object)this.collectedVarPositions, this.cnt, new String[0]);
            }
        }
    }

    public static final class AllDifferentCounting
    extends AllDifferent
    implements Tags.TagNotAC,
    Tags.TagFilteringCompleteAtEachCall,
    Observers.ObserverBacktracking.ObserverBacktrackingSystematic {
        private SetSparse[] sets;
        private SetSparse workingDomSet;
        private SetSparse workingVarSet;
        private SetSparse encounteredSizes;
        private SetSparseReversible unfixedVars;

        @Override
        public void restoreBefore(int depth) {
            this.unfixedVars.restoreLimitAtLevel(depth);
        }

        @Override
        public void afterProblemConstruction() {
            super.afterProblemConstruction();
            this.unfixedVars = new SetSparseReversible(this.scp.length, this.problem.variables.length + 1);
        }

        public AllDifferentCounting(Problem pb, Variable[] scp) {
            super(pb, scp);
            Kit.control(Variable.haveSameDomainType(scp) && scp[0].dom.initSize() < 1000);
            this.sets = SetSparse.factoryArray(scp.length, scp[0].dom.initSize() + 1);
            this.workingDomSet = new SetSparse(scp[0].dom.initSize());
            this.workingVarSet = new SetSparse(scp.length);
            this.encounteredSizes = new SetSparse(scp[0].dom.initSize() + 1);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            Variable y;
            int j;
            int v;
            Variable x;
            int p;
            int i;
            for (i = 0; i < this.encounteredSizes.size(); ++i) {
                this.sets[this.encounteredSizes.dense[i]].clear();
            }
            Kit.control(Stream.of(this.sets).allMatch(s -> s.isEmpty()));
            this.encounteredSizes.clear();
            for (i = this.unfixedVars.limit; i >= 0; --i) {
                p = this.unfixedVars.dense[i];
                if (this.scp[p].dom.size() > 1) continue;
                x = this.scp[p];
                v = x.dom.uniqueValue();
                for (j = this.futvars.limit; j >= 0; --j) {
                    y = this.scp[this.futvars.dense[j]];
                    if (y == x || y.dom.removeValueIfPresent(v)) continue;
                    return false;
                }
                this.unfixedVars.remove(p, this.problem.solver.depth());
            }
            for (i = this.unfixedVars.limit; i >= 0; --i) {
                p = this.unfixedVars.dense[i];
                this.sets[this.scp[p].dom.size()].add(p);
                this.encounteredSizes.add(this.scp[p].dom.size());
            }
            Kit.control(this.sets[0].isEmpty());
            for (i = this.sets[1].limit; i >= 0; --i) {
                int vapFixed = this.sets[1].dense[i];
                x = this.scp[vapFixed];
                v = x.dom.uniqueValue();
                for (j = this.futvars.limit; j >= 0; --j) {
                    y = this.scp[this.futvars.dense[j]];
                    if (y == x || y.dom.removeValueIfPresent(v)) continue;
                    return false;
                }
                this.unfixedVars.remove(vapFixed, this.problem.solver.depth());
            }
            this.workingDomSet.clear();
            this.workingVarSet.clear();
            for (i = 2; i < this.sets.length; ++i) {
                for (int j2 = this.sets[i].limit; j2 >= 0; --j2) {
                    int vap = this.sets[i].dense[j2];
                    this.workingVarSet.add(vap);
                    Domain dom = this.scp[vap].dom;
                    int idx = dom.first();
                    while (idx != -1) {
                        this.workingDomSet.add(idx);
                        idx = dom.next(idx);
                    }
                    if (this.workingDomSet.size() < this.workingVarSet.size()) {
                        return false;
                    }
                    if (this.workingDomSet.size() == this.workingVarSet.size()) {
                        for (int k = this.workingVarSet.limit + 1; k < this.workingVarSet.capacity(); ++k) {
                            if (this.scp[this.workingVarSet.dense[k]].dom.remove(this.workingDomSet, true)) continue;
                            return false;
                        }
                    }
                    if (this.workingDomSet.size() <= this.unfixedVars.size()) continue;
                    return true;
                }
            }
            return true;
        }

        void displaySizes() {
            String s = IntStream.range(2, this.sets.length).filter(i -> this.sets[i].size() != 0).mapToObj(i -> i + ":" + this.sets[i].size()).collect(Collectors.joining(" "));
            Kit.log.info(s);
        }
    }

    public static class AllDifferentExceptWeak
    extends AllDifferent
    implements Tags.TagNotAC {
        private int[] exceptValues;

        @Override
        public boolean checkValues(int[] t) {
            return Kit.allDifferentValues(t, this.exceptValues);
        }

        public AllDifferentExceptWeak(Problem pb, Variable[] scp, int[] exceptValues) {
            super(pb, scp);
            this.exceptValues = exceptValues;
            this.defineKey(Kit.join((Object)exceptValues, new String[0]));
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (x.dom.size() == 1) {
                int v = x.dom.uniqueValue();
                if (Utilities.indexOf(v, this.exceptValues) != -1) {
                    return true;
                }
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Variable y = this.scp[this.futvars.dense[i]];
                    if (y == x || y.dom.removeValueIfPresent(v)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static final class AllDifferentWeak
    extends AllDifferent
    implements Tags.TagNotAC {
        private Set<Integer> set = this.mode == 0 ? null : new HashSet();
        private int mode = 0;

        public AllDifferentWeak(Problem problem, Variable[] scope) {
            super(problem, scope);
        }

        @Override
        public boolean runPropagator(Variable x) {
            int i;
            if (x.dom.size() == 1) {
                int v = x.dom.uniqueValue();
                for (i = this.futvars.limit; i >= 0; --i) {
                    Variable y = this.scp[this.futvars.dense[i]];
                    if (y == x || y.dom.removeValueIfPresent(v)) continue;
                    return false;
                }
            }
            if (this.set == null) {
                return true;
            }
            this.set.clear();
            int nPastVariables = this.scp.length - this.futvars.size();
            for (i = this.futvars.limit; i >= 0; --i) {
                Domain dom = this.scp[this.futvars.dense[i]].dom;
                int a = dom.first();
                while (a != -1) {
                    this.set.add(dom.toVal(a));
                    a = dom.next(a);
                }
                if (nPastVariables + this.set.size() < this.scp.length) continue;
                return true;
            }
            return nPastVariables + this.set.size() >= this.scp.length;
        }
    }

    public static final class AllDifferentPermutation
    extends AllDifferent
    implements Tags.TagNotAC,
    Observers.ObserverBacktracking.ObserverBacktrackingSystematic {
        private SetSparseReversible unfixedVars;
        private SetSparseReversible unfixedIdxs;
        private Variable[] residues1;
        private Variable[] residues2;

        @Override
        public void restoreBefore(int depth) {
            this.unfixedVars.restoreLimitAtLevel(depth);
            this.unfixedIdxs.restoreLimitAtLevel(depth);
        }

        @Override
        public void afterProblemConstruction() {
            super.afterProblemConstruction();
            this.unfixedVars = new SetSparseReversible(this.scp.length, this.problem.variables.length + 1);
            this.unfixedIdxs = new SetSparseReversible(this.scp[0].dom.initSize(), this.problem.variables.length + 1);
        }

        private Variable findAnotherWatchedUnifxedVariable(int idx, Variable otherWatchedVariable) {
            int[] dense = this.unfixedVars.dense;
            for (int i = this.unfixedVars.limit; i >= 0; --i) {
                Variable var = this.scp[dense[i]];
                if (var == otherWatchedVariable || !var.dom.present(idx)) continue;
                return var;
            }
            return null;
        }

        public AllDifferentPermutation(Problem pb, Variable[] scp) {
            super(pb, scp);
            Kit.control(Variable.isPermutationElligible(scp));
            this.residues1 = new Variable[scp[0].dom.initSize()];
            this.residues2 = new Variable[scp[0].dom.initSize()];
            Arrays.fill(this.residues1, scp[0]);
            Arrays.fill(this.residues2, scp[scp.length - 1]);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            int level = this.problem.solver.depth();
            int[] dense = this.unfixedVars.dense;
            for (i = this.unfixedVars.limit; i >= 0; --i) {
                Variable x = this.scp[dense[i]];
                if (x.dom.size() != 1) continue;
                int a = x.dom.unique();
                this.unfixedVars.remove(dense[i], level);
                this.unfixedIdxs.remove(a, level);
                for (int j = this.unfixedVars.limit; j >= 0; --j) {
                    Variable y = this.scp[dense[j]];
                    Domain dy = y.dom;
                    if (!dy.present(a)) continue;
                    if (!dy.remove(a)) {
                        return false;
                    }
                    if (dy.size() != 1) continue;
                    i = Math.max(i, j + 1);
                }
            }
            dense = this.unfixedIdxs.dense;
            for (i = this.unfixedIdxs.limit; i >= 0; --i) {
                Variable x;
                int a = dense[i];
                if (!this.residues1[a].dom.present(a)) {
                    x = this.findAnotherWatchedUnifxedVariable(a, this.residues2[a]);
                    if (x != null) {
                        this.residues1[a] = x;
                    } else {
                        x = this.residues2[a];
                        if (!x.dom.reduceTo(a)) {
                            return false;
                        }
                        this.unfixedVars.remove(this.positionOf(x), level);
                        this.unfixedIdxs.remove(a, level);
                    }
                }
                assert (this.residues1[a].dom.size() > 1) : this.residues1[a] + " " + a + " " + this.residues1[a].dom.size();
                if (this.residues2[a].dom.present(a)) continue;
                x = this.findAnotherWatchedUnifxedVariable(a, this.residues1[a]);
                if (x != null) {
                    this.residues2[a] = x;
                    continue;
                }
                x = this.residues1[a];
                x.dom.reduceTo(a);
                this.unfixedVars.remove(this.positionOf(x), level);
                this.unfixedIdxs.remove(a, level);
            }
            return true;
        }
    }

    public static class AllDifferentComplete
    extends AllDifferent
    implements Tags.TagAC,
    Tags.TagFilteringCompleteAtEachCall,
    Observers.ObserverBacktracking.ObserverBacktrackingSystematic {
        private Matcher matcher = new Matcher.MatcherAllDifferent(this);

        @Override
        public void restoreBefore(int depth) {
            this.matcher.restoreAtDepthBefore(depth);
        }

        public AllDifferentComplete(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (!this.matcher.findMaximumMatching()) {
                return x.dom.fail();
            }
            this.matcher.removeInconsistentValues();
            return true;
        }
    }
}

