/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension.structures;

import constraints.Constraint;
import constraints.extension.structures.ExtensionStructure;
import java.util.stream.IntStream;

public class Tries
extends ExtensionStructure {
    private final Node[] trieRoots;
    private boolean directAccess;
    private final int[] tmp;
    private int currentTrieIndex;
    private int[] current;

    private void addTuple(Node node, int[] tuple, int position) {
        if (position == tuple.length) {
            return;
        }
        int adjustedPosition = position == 0 ? this.currentTrieIndex : (position <= this.currentTrieIndex ? position - 1 : position);
        int a = this.firstRegisteredCtr().indexesMatchValues ? tuple[adjustedPosition] : this.firstRegisteredCtr().scp[adjustedPosition].dom.toIdx(tuple[adjustedPosition]);
        Node previousChild = null;
        Node currentChild = node.firstChild;
        while (currentChild != null && currentChild.idx <= a) {
            previousChild = currentChild;
            currentChild = currentChild.firstSibling;
        }
        Node child = null;
        if (previousChild == null) {
            node.firstChild = child = new Node(a, node, node.firstChild);
        } else if (previousChild.idx == a) {
            child = previousChild;
        } else {
            previousChild.firstSibling = child = new Node(a, node, previousChild.firstSibling);
        }
        this.addTuple(child, tuple, position + 1);
    }

    private void buildChildsArrays(Node node, int position) {
        if (position == this.trieRoots.length) {
            return;
        }
        int adjustedPosition = position == 0 ? this.currentTrieIndex : (position <= this.currentTrieIndex ? position - 1 : position);
        node.childs = new Node[this.firstRegisteredCtr().scp[adjustedPosition].dom.initSize()];
        Node child = node.firstChild;
        while (child != null) {
            node.childs[child.idx] = child;
            this.buildChildsArrays(child, position + 1);
            child = child.firstSibling;
        }
    }

    @Override
    public void storeTuples(int[][] tuples, boolean allowedTuples) {
        int i;
        for (i = 0; i < this.trieRoots.length; ++i) {
            this.currentTrieIndex = i;
            for (int[] tuple : tuples) {
                this.addTuple(this.trieRoots[i], tuple, 0);
            }
        }
        assert (this.controlNode(this.trieRoots[0].firstChild, 0));
        if (this.directAccess) {
            for (i = 0; i < this.trieRoots.length; ++i) {
                this.currentTrieIndex = i;
                this.buildChildsArrays(this.trieRoots[i], 0);
            }
        }
    }

    public Tries(Constraint ctr, boolean directAccess) {
        super(ctr);
        this.directAccess = directAccess;
        this.trieRoots = (Node[])IntStream.range(0, ctr.scp.length).mapToObj(i -> new Node(-1, null)).toArray(Node[]::new);
        this.tmp = new int[this.trieRoots.length];
    }

    @Override
    public boolean checkIdxs(int[] idxs) {
        return this.nextSupport(0, idxs[0], idxs) == idxs;
    }

    private int[] seekNextTuple(Node node, int position) {
        int i;
        int[] t;
        if (position == this.current.length) {
            return this.current;
        }
        int realPosition = position <= this.currentTrieIndex ? position - 1 : position;
        int a = this.current[realPosition];
        Node child = null;
        if (this.directAccess) {
            child = node.childs[a];
            if (child != null) {
                t = this.seekNextTuple(child, position + 1);
                if (t != null) {
                    return t;
                }
                child = child.firstSibling;
            } else {
                child = node.firstChild;
                while (child != null && child.idx < a) {
                    child = child.firstSibling;
                }
            }
        } else {
            child = node.firstChild;
            while (child != null && child.idx < a) {
                child = child.firstSibling;
            }
            if (child != null && child.idx == a) {
                t = this.seekNextTuple(child, position + 1);
                if (t != null) {
                    return t;
                }
                child = child.firstSibling;
            }
        }
        if (child == null) {
            return null;
        }
        for (i = 1; i < position; ++i) {
            realPosition = i <= this.currentTrieIndex ? i - 1 : i;
            this.tmp[realPosition] = this.current[realPosition];
        }
        for (i = position; i < this.current.length; ++i) {
            this.tmp[i <= this.currentTrieIndex ? i - 1 : i] = child.idx;
            child = child.firstChild;
        }
        return this.tmp;
    }

    @Override
    public int[] nextSupport(int x, int a, int[] current) {
        this.currentTrieIndex = x;
        this.current = current;
        this.tmp[x] = a;
        if (this.directAccess) {
            Node child = this.trieRoots[this.currentTrieIndex].childs[a];
            return child == null ? null : this.seekNextTuple(child, 1);
        }
        Node child = this.trieRoots[this.currentTrieIndex].firstChild;
        while (child != null && child.idx < a) {
            child = child.firstSibling;
        }
        return child == null || child.idx > a ? null : this.seekNextTuple(child, 1);
    }

    public int display(Node node, int position) {
        System.out.println(position + " " + node.idx);
        int cnt = position == this.trieRoots.length - 1 ? 1 : 0;
        Node child = node.firstChild;
        while (child != null) {
            cnt += this.display(child, position + 1);
            child = child.firstSibling;
        }
        return cnt;
    }

    public void display() {
        for (int i = 0; i < this.trieRoots.length; ++i) {
            System.out.println(" Position " + i + "\nNb tuples = " + this.display(this.trieRoots[i], -1));
        }
    }

    private boolean controlNode(Node node, int position) {
        if (node == null) {
            return true;
        }
        if (!this.firstRegisteredCtr().scp[position].dom.present(node.idx)) {
            return false;
        }
        return this.controlNode(node.firstSibling, position) && this.controlNode(node.firstChild, position + 1);
    }

    class Node {
        int idx;
        Node parent;
        Node firstChild;
        Node firstSibling;
        Node[] childs;

        Node(int idx, Node parent) {
            this.idx = idx;
            this.parent = parent;
        }

        Node(int idx, Node parent, Node firstSibling) {
            this(idx, parent);
            this.firstSibling = firstSibling;
        }
    }
}

