/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension.structures;

import constraints.Constraint;
import constraints.extension.structures.ExtensionStructure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.xcsp.common.Range;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public class Table
extends ExtensionStructure {
    private static Map<String, int[][]> cache = new HashMap<String, int[][]>();
    public int[][] tuples;
    public boolean positive;
    public boolean starred;
    private int[][][][] subtables;

    private static int[] tuple(int value, int ... otherValues) {
        return IntStream.range(0, otherValues.length + 1).map(i -> i == 0 ? value : otherValues[i - 1]).toArray();
    }

    public static int[][] shortTuplesForElement(Variable[] list, Variable index, int value) {
        Kit.control(Variable.areAllDistinct(list) && !Kit.isPresent(index, list));
        Kit.control(index.dom.areInitValuesExactly(new Range(list.length)) && Variable.areAllDomainsContainingValue(list, value));
        return (int[][])IntStream.range(0, list.length).mapToObj(i -> IntStream.range(0, list.length + 1).map(j -> j == 0 ? i : (j == i + 1 ? value : 0x7FFFFFFE)).toArray()).toArray(x$0 -> new int[x$0][]);
    }

    public static int[][] shortTuplesForElement(Variable[] list, Variable index, Variable value) {
        Kit.control(Variable.areAllDistinct(list) && !Kit.isPresent(index, list) && index != value);
        Kit.control(index.dom.areInitValuesExactly(new Range(list.length)));
        Domain domResult = value.dom;
        int resultPositionInVector = Utilities.indexOf(value, list);
        int arity = resultPositionInVector == -1 ? list.length + 2 : list.length + 1;
        int resultPositionInTuple = resultPositionInVector == -1 ? arity - 1 : resultPositionInVector + 1;
        ArrayList<int[]> tuples = new ArrayList<int[]>();
        for (int i = 0; i < list.length; ++i) {
            Domain dom = list[i].dom;
            int a = dom.first();
            while (a != -1) {
                int va = dom.toVal(a);
                if (domResult.presentValue(va)) {
                    int[] tuple = Kit.repeat(0x7FFFFFFE, arity);
                    tuple[0] = i;
                    tuple[i + 1] = va;
                    tuple[resultPositionInTuple] = va;
                    tuples.add(tuple);
                }
                a = dom.next(a);
            }
        }
        return Kit.intArray2D(tuples);
    }

    public static int[][] shortTuplesForDistinctVectors(Variable[] t1, Variable[] t2) {
        Kit.control(t1.length == t2.length);
        String key = "DistinctVectors " + Variable.signatureFor(t1) + " " + Variable.signatureFor(t2);
        int[][] tuples = cache.get(key);
        if (tuples == null) {
            int k = t1.length;
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i = 0; i < k; ++i) {
                Domain dom1 = t1[i].dom;
                Domain dom2 = t2[i].dom;
                int a = dom1.first();
                while (a != -1) {
                    int va = dom1.toVal(a);
                    int b = dom2.first();
                    while (b != -1) {
                        int vb = dom2.toVal(b);
                        if (va != vb) {
                            int[] tuple = Kit.repeat(0x7FFFFFFE, 2 * k);
                            tuple[i] = va;
                            tuple[i + k] = vb;
                            list.add(tuple);
                        }
                        b = dom2.next(b);
                    }
                    a = dom1.next(a);
                }
            }
            tuples = Kit.intArray2D(list);
            cache.put(key, tuples);
        }
        return tuples;
    }

    public static int[][] shortTuplesForLexicographicLt(Problem problem, Variable[] t1, Variable[] t2) {
        Kit.control(t1.length == t2.length);
        String key = "LexicographicLt " + Variable.signatureFor(t1) + " " + Variable.signatureFor(t2);
        int[][] tuples = cache.get(key);
        if (tuples == null) {
            int k = t1.length;
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i = 0; i < k; ++i) {
                Domain dom1 = t1[i].dom;
                Domain dom2 = t2[i].dom;
                int a = dom1.first();
                while (a != -1) {
                    int va = dom1.toVal(a);
                    int b = dom2.first();
                    while (b != -1) {
                        int vb = dom2.toVal(b);
                        if (va != vb) {
                            int[] tuple = Kit.repeat(0x7FFFFFFE, 2 * k);
                            tuple[i] = va;
                            tuple[i + k] = vb;
                            list.add(tuple);
                        }
                        b = dom2.next(b);
                    }
                    a = dom1.next(a);
                }
            }
            tuples = Kit.intArray2D(list);
            cache.put(key, tuples);
        }
        return tuples;
    }

    private static void addNonOverlappingTuplesFor(List<int[]> list, Domain dom1, Domain dom2, int offset, boolean first, boolean xAxis) {
        int a = dom1.first();
        while (a != -1) {
            int vb;
            int va = dom1.toVal(a);
            int b = dom2.last();
            while (b != -1 && va + offset <= (vb = dom2.toVal(b))) {
                list.add(xAxis ? Table.tuple(first ? va : vb, first ? vb : va, 0x7FFFFFFE, 0x7FFFFFFE) : Table.tuple(0x7FFFFFFE, 0x7FFFFFFE, first ? va : vb, first ? vb : va));
                b = dom2.prev(b);
            }
            a = dom1.next(a);
        }
    }

    public static int[][] shortTuplesForNoOverlap(Variable x1, Variable x2, Variable y1, Variable y2, int w1, int w2, int h1, int h2) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        Table.addNonOverlappingTuplesFor(list, x1.dom, x2.dom, w1, true, true);
        Table.addNonOverlappingTuplesFor(list, x2.dom, x1.dom, w2, false, true);
        Table.addNonOverlappingTuplesFor(list, y1.dom, y2.dom, h1, true, false);
        Table.addNonOverlappingTuplesFor(list, y2.dom, y1.dom, h2, false, false);
        return Kit.intArray2D(list);
    }

    private boolean isMatching(int[] tuple, int[] idxs) {
        for (int i = 0; i < tuple.length; ++i) {
            if (tuple[i] == 0x7FFFFFFE || tuple[i] == idxs[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkIdxs(int[] t) {
        if (this.starred) {
            for (int[] tuple : this.tuples) {
                if (!this.isMatching(tuple, t)) continue;
                return true;
            }
            return false;
        }
        return Arrays.binarySearch(this.tuples, t, Utilities.lexComparatorInt) >= 0 == this.positive;
    }

    @Override
    public void storeTuples(int[][] m, boolean positive) {
        this.starred = false;
        if (m.length == 0) {
            this.tuples = new int[0][];
        } else {
            Domain[] doms = this.firstRegisteredCtr().doms;
            this.tuples = new int[m.length][doms.length];
            for (int j = 0; j < doms.length; ++j) {
                for (int i = 0; i < m.length; ++i) {
                    int v = m[i][j];
                    assert (m[i].length == doms.length);
                    assert (v == 0x7FFFFFFE || doms[j].toIdx(v) != -1) : Kit.join((Object)m[i], new String[0]) + " j=" + j + " " + this.firstRegisteredCtr() + " " + doms[j];
                    if (v == 0x7FFFFFFE) {
                        this.starred = true;
                    }
                    this.tuples[i][j] = v == 0x7FFFFFFE ? 0x7FFFFFFE : doms[j].toIdx(v);
                }
            }
        }
        this.positive = positive;
        Arrays.sort(this.tuples, Utilities.lexComparatorInt);
        Kit.control(!this.starred || positive);
        if (this.subtables != null) {
            this.buildSubtables();
        }
    }

    public Table(Constraint c) {
        super(c);
    }

    public String toString() {
        return "Tuples :\n" + Kit.join((Object)this.tuples, new String[0]) + " (" + this.positive + ")";
    }

    public Table withSubtables() {
        this.subtables = new int[0][][][];
        return this;
    }

    @Override
    public int[] nextSupport(int x, int a, int[] current) {
        int[][] subtable = this.subtables[x][a];
        int res = Arrays.binarySearch(subtable, current, Utilities.lexComparatorInt);
        if (res >= 0) {
            return current;
        }
        int point = -res - 1;
        return point == subtable.length ? null : subtable[point];
    }

    private void buildSubtables() {
        int j;
        int i2;
        Constraint c = this.firstRegisteredCtr();
        List<E>[][] tmp = Variable.litterals(c.scp).listArray();
        for (i2 = 0; i2 < this.tuples.length; ++i2) {
            for (j = 0; j < this.tuples[i2].length; ++j) {
                tmp[j][this.tuples[i2][j]].add(this.tuples[i2]);
            }
        }
        this.subtables = new int[c.scp.length][][][];
        for (i2 = 0; i2 < this.subtables.length; ++i2) {
            this.subtables[i2] = new int[c.scp[i2].dom.initSize()][][];
            for (j = 0; j < this.subtables[i2].length; ++j) {
                this.subtables[i2][j] = (int[][])tmp[i2][j].toArray((T[])new int[tmp[i2][j].size()][]);
            }
        }
        assert (IntStream.range(0, this.subtables.length).allMatch(i -> IntStream.range(0, this.subtables[i].length).allMatch(j -> Kit.isLexIncreasing(this.subtables[i][j]))));
    }

    String printSubtables() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("Subtables\n");
        for (int i = 0; i < this.subtables.length; ++i) {
            sb.append("Variable " + this.firstRegisteredCtr().scp[i] + "\n");
            for (int j = 0; j < this.subtables[i].length; ++j) {
                sb.append("  " + j + " :");
                for (int k = 0; k < this.subtables[i][j].length; ++k) {
                    sb.append(" (" + Kit.join((Object)this.subtables[i][j][k], new String[0]) + ")");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

