/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension.structures;

import constraints.extension.structures.MDD;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;

public class MDDSplitter {
    private int[] splitMode;
    private int[][][] splitTuples;
    private Set<int[]>[] splitSets;
    private Map<Integer, Integer>[] auxiliaryLevelMaps;

    public int[] getSplitMode() {
        return this.splitMode;
    }

    public int[][] getSplitTuples(int i) {
        return this.splitTuples[i];
    }

    public int getNbAuxiliaryValues(int splitLevel) {
        return this.auxiliaryLevelMaps[splitLevel].size();
    }

    MDDSplitter(MDD mdd, int[] initialSplitMode) {
        int i2;
        this.splitMode = initialSplitMode;
        for (i2 = 0; i2 < this.splitMode.length; ++i2) {
            if (i2 == 0 || i2 == this.splitMode.length - 1) {
                int n = i2;
                this.splitMode[n] = this.splitMode[n] + 1;
                continue;
            }
            int n = i2;
            this.splitMode[n] = this.splitMode[n] + 2;
        }
        this.splitSets = (Set[])IntStream.range(0, initialSplitMode.length).mapToObj(i -> new TreeSet<int[]>(Utilities.lexComparatorInt)).toArray(Set[]::new);
        this.auxiliaryLevelMaps = (Map[])IntStream.range(0, initialSplitMode.length - 1).mapToObj(i -> new HashMap()).toArray(Map[]::new);
        this.split2(mdd.root, 0);
        this.splitTuples = new int[this.splitSets.length][][];
        for (i2 = 0; i2 < this.splitTuples.length; ++i2) {
            this.splitTuples[i2] = (int[][])this.splitSets[i2].toArray((T[])new int[this.splitSets[i2].size()][]);
            this.splitSets[i2].clear();
            this.splitSets[i2] = null;
        }
        for (i2 = 0; i2 < this.splitTuples.length; ++i2) {
            System.out.println("i=" + i2 + " size=" + this.splitTuples[i2].length);
        }
    }

    private int getAuxiliaryLevelNodeId(int nodeId, int splitLevel) {
        return this.auxiliaryLevelMaps[splitLevel].computeIfAbsent(nodeId, k -> this.auxiliaryLevelMaps[splitLevel].size());
    }

    public void split2(MDD.MDDNode startingNode, int splitLevel) {
        int[] currentTuple = new int[this.splitMode[splitLevel]];
        int currentLevel = 0;
        if (splitLevel > 0) {
            currentTuple[currentLevel++] = this.getAuxiliaryLevelNodeId(startingNode.id, splitLevel - 1);
        }
        this.getTuples(startingNode, splitLevel, currentTuple, currentLevel, splitLevel == this.splitSets.length - 1 ? -1 : this.splitMode[splitLevel] - 1);
    }

    private void getTuples(MDD.MDDNode node, int splitLevel, int[] currentTuple, int currentLevel, int stoppingLevel) {
        if (node == MDD.MDDNode.nodeF) {
            return;
        }
        if (stoppingLevel == -1) {
            if (node == MDD.MDDNode.nodeT) {
                this.splitSets[splitLevel].add((int[])currentTuple.clone());
            } else {
                for (int i = 0; i < node.sons.length; ++i) {
                    currentTuple[currentLevel] = i;
                    this.getTuples(node.sons[i], splitLevel, currentTuple, currentLevel + 1, stoppingLevel);
                }
            }
        } else {
            assert (node != MDD.MDDNode.nodeT && stoppingLevel != -1);
            if (currentLevel == stoppingLevel) {
                currentTuple[currentLevel] = this.getAuxiliaryLevelNodeId(node.id, splitLevel);
                this.splitSets[splitLevel].add((int[])currentTuple.clone());
                this.split2(node, splitLevel + 1);
            } else {
                for (int i = 0; i < node.sons.length; ++i) {
                    currentTuple[currentLevel] = i;
                    this.getTuples(node.sons[i], splitLevel, currentTuple, currentLevel + 1, stoppingLevel);
                }
            }
        }
    }
}

