/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension.structures;

import constraints.Constraint;
import constraints.extension.CMDD;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.MDDSplitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Range;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Transition;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class MDD
extends ExtensionStructure {
    public MDDNode root;
    private Integer nNodes;
    private boolean reductionWhileProcessingTuples = false;
    private int nCreatedNodes = 2;
    private boolean mustBuildSplitter = false;
    private MDDSplitter splitter;

    public Integer nNodes() {
        return this.nNodes != null ? this.nNodes : (this.nNodes = Integer.valueOf(2 + this.root.nInternalNodes(new HashSet<Integer>())));
    }

    public int nextNodeId() {
        return this.nCreatedNodes++;
    }

    public MDD(CMDD c) {
        super(c);
    }

    public MDD(CMDD c, MDDNode root) {
        this(c);
        this.root = root;
    }

    public MDD(CMDD c, Automaton automata) {
        this(c);
        this.storeTuplesFromAutomata(automata, c.scp.length, (Domain[])Stream.of(c.scp).map(x -> x.dom).toArray(Domain[]::new));
    }

    public MDD(CMDD c, Transition[] transitions) {
        this(c);
        this.storeTuplesFromTransitions(transitions, (Domain[])Stream.of(c.scp).map(x -> x.dom).toArray(Domain[]::new));
    }

    public MDD(CMDD c, int[] coeffs, Object limits) {
        this(c);
        this.storeTuplesFromKnapsack(coeffs, limits, Variable.initDomainValues(c.scp));
    }

    private MDDNode recursiveReduction(MDDNode node, Map<Kit.IntArrayHashKey, MDDNode> reductionMap) {
        if (node.isLeaf()) {
            return node;
        }
        for (int i = 0; i < node.sons.length; ++i) {
            node.sons[i] = this.recursiveReduction(node.sons[i], reductionMap);
        }
        Kit.IntArrayHashKey hk = new Kit.IntArrayHashKey(Stream.of(node.sons).mapToInt(c -> c.id).toArray());
        return reductionMap.computeIfAbsent(hk, k -> node);
    }

    private void reduce(int[] prevTuple, int[] currTuple, Map<Kit.IntArrayHashKey, MDDNode> reductionMap) {
        int i = 0;
        MDDNode node = this.root;
        while (prevTuple[i] == currTuple[i]) {
            node = node.sons[prevTuple[i++]];
        }
        node.sons[prevTuple[i]] = this.recursiveReduction(node.sons[prevTuple[i]], reductionMap);
    }

    private void finalizeStoreTuples() {
        this.root.buildSonsClasses();
        this.nNodes = this.root.renameNodes(1, new HashMap<Integer, MDDNode>()) + 1;
        assert (this.root.controlUniqueNodes(new HashMap<Integer, MDDNode>()));
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        Kit.control(positive && tuples.length > 0);
        Constraint ctr = this.firstRegisteredCtr();
        int[] domainSizes = Variable.domSizeArrayOf(ctr.scp, true);
        HashMap<Kit.IntArrayHashKey, MDDNode> reductionMap = new HashMap<Kit.IntArrayHashKey, MDDNode>(2000);
        this.root = new MDDNode(this, 0, domainSizes[0], positive);
        if (ctr.indexesMatchValues) {
            for (int i = 0; i < tuples.length; ++i) {
                this.root.addTuple(tuples[i], positive, domainSizes);
                if (!this.reductionWhileProcessingTuples || i <= 0) continue;
                this.reduce(tuples[i - 1], tuples[i], reductionMap);
            }
        } else {
            int[] previousTuple = null;
            int[] currentTuple = new int[tuples[0].length];
            for (int[] tuple : tuples) {
                for (int i = 0; i < currentTuple.length; ++i) {
                    currentTuple[i] = tuple[i] == 0x7FFFFFFE ? 0x7FFFFFFE : ctr.scp[i].dom.toIdx(tuple[i]);
                }
                this.root.addTuple(currentTuple, positive, domainSizes);
                if (!this.reductionWhileProcessingTuples) continue;
                if (previousTuple == null) {
                    previousTuple = (int[])currentTuple.clone();
                    continue;
                }
                this.reduce(previousTuple, currentTuple, reductionMap);
                int[] tmp = previousTuple;
                previousTuple = currentTuple;
                currentTuple = tmp;
            }
        }
        if (!this.reductionWhileProcessingTuples) {
            this.recursiveReduction(this.root, reductionMap);
        }
        this.finalizeStoreTuples();
    }

    public MDD storeTuplesFromTransitions(Transition[] transitions, Domain[] domains) {
        HashMap<String, MDDNode> nodes = new HashMap<String, MDDNode>();
        HashSet<String> possibleRoots = new HashSet<String>();
        HashSet<String> notRoots = new HashSet<String>();
        HashSet<String> possibleWells = new HashSet<String>();
        HashSet<String> notWells = new HashSet<String>();
        for (Transition tr : transitions) {
            String src = tr.start;
            String tgt = tr.end;
            notWells.add(src);
            notRoots.add(tgt);
            if (!notRoots.contains(src)) {
                possibleRoots.add(src);
            }
            if (!notWells.contains(tgt)) {
                possibleWells.add(tgt);
            }
            if (possibleRoots.contains(tgt)) {
                possibleRoots.remove(tgt);
            }
            if (!possibleWells.contains(src)) continue;
            possibleWells.remove(src);
        }
        Kit.control(possibleRoots.size() == 1 && possibleWells.size() == 1, () -> "sizes= " + possibleRoots.size() + " " + possibleWells.stream().collect(Collectors.joining(" ")));
        String sroot = possibleRoots.toArray(new String[1])[0];
        String swell = possibleWells.toArray(new String[1])[0];
        this.root = new MDDNode(this, 0, domains[0].initSize(), true);
        nodes.put(sroot, this.root);
        nodes.put(swell, MDDNode.nodeT);
        for (Transition tr : transitions) {
            MDDNode node2;
            MDDNode node1 = (MDDNode)nodes.get(tr.start);
            long v = tr.value instanceof Integer ? (long)((Integer)tr.value).intValue() : (Long)tr.value;
            int val = Utilities.safeInt(v);
            int idx = domains[node1.level].toIdx(val);
            Kit.control(idx != -1);
            node1.sons[idx] = node2 = nodes.computeIfAbsent(tr.end, k -> new MDDNode(this, node1.level + 1, domains[node1.level + 1].initSize(), true));
        }
        this.finalizeStoreTuples();
        return this;
    }

    private Map<String, List<Transition>> buildNextTransitions(Automaton automata) {
        HashMap<String, List<Transition>> map = new HashMap<String, List<Transition>>();
        map.put(automata.startState, new ArrayList());
        Stream.of(automata.finalStates).forEach(s -> map.put((String)s, new ArrayList()));
        Stream.of(automata.transitions).forEach(t -> {
            map.put(t.start, new ArrayList());
            map.put(t.end, new ArrayList());
        });
        Stream.of(automata.transitions).forEach(t -> ((List)map.get(t.start)).add(t));
        return map;
    }

    public MDD storeTuplesFromAutomata(Automaton automata, int arity, Domain[] domains) {
        Kit.control(arity > 1 && IntStream.range(1, domains.length).allMatch(i -> domains[i].typeIdentifier() == domains[0].typeIdentifier()));
        Map<String, List<Transition>> nextTrs = this.buildNextTransitions(automata);
        this.root = new MDDNode(this, 0, domains[0].initSize(), true, automata.startState);
        HashMap<String, MDDNode> prevs = new HashMap<String, MDDNode>();
        HashMap<String, MDDNode> nexts = new HashMap<String, MDDNode>();
        prevs.put((String)this.root.state, this.root);
        for (int i2 = 0; i2 < arity; ++i2) {
            for (MDDNode node : prevs.values()) {
                for (Transition tr : nextTrs.get(node.state)) {
                    int v = Utilities.safeInt((Long)tr.value);
                    int a = domains[i2].toIdx(v);
                    if (a == -1) continue;
                    String nextState = tr.end;
                    if (i2 == arity - 1) {
                        node.sons[a] = Utilities.indexOf(nextState, automata.finalStates) != -1 ? MDDNode.nodeT : MDDNode.nodeF;
                        continue;
                    }
                    MDDNode nextNode = (MDDNode)nexts.get(nextState);
                    if (nextNode == null) {
                        nextNode = new MDDNode(this, i2 + 1, domains[i2].initSize(), true, nextState);
                        nexts.put(nextState, nextNode);
                    }
                    node.sons[a] = nextNode;
                }
            }
            HashMap<String, MDDNode> tmp = prevs;
            prevs = nexts;
            nexts = tmp;
            nexts.clear();
        }
        this.root.canReachNodeT();
        this.finalizeStoreTuples();
        return this;
    }

    public MDD storeTuplesFromKnapsack(int[] coeffs, Object limits, int[][] values) {
        this.root = new MDDNode(this, 0, values[0].length, true, 0);
        HashMap<Integer, MDDNode> prevs = new HashMap<Integer, MDDNode>();
        HashMap<Integer, MDDNode> nexts = new HashMap<Integer, MDDNode>();
        prevs.put((Integer)this.root.state, this.root);
        for (int level = 0; level < coeffs.length; ++level) {
            for (MDDNode node : prevs.values()) {
                for (int j = 0; j < values[level].length; ++j) {
                    int nextState = (Integer)node.state + coeffs[level] * values[level][j];
                    if (level == coeffs.length - 1) {
                        if (limits instanceof Range) {
                            node.sons[j] = ((Range)limits).contains(nextState) ? MDDNode.nodeT : MDDNode.nodeF;
                            continue;
                        }
                        node.sons[j] = Utilities.indexOf(nextState, (int[])limits) != -1 ? MDDNode.nodeT : MDDNode.nodeF;
                        continue;
                    }
                    MDDNode nextNode = (MDDNode)nexts.get(nextState);
                    if (nextNode == null) {
                        nextNode = new MDDNode(this, level + 1, values[level + 1].length, true, nextState);
                        nexts.put(nextState, nextNode);
                    }
                    node.sons[j] = nextNode;
                }
            }
            HashMap<Integer, MDDNode> tmp = prevs;
            prevs = nexts;
            nexts = tmp;
            nexts.clear();
        }
        this.root.canReachNodeT();
        boolean increasing = false;
        if (!increasing) {
            this.finalizeStoreTuples();
        } else {
            this.root = this.root.filter(values, Integer.MAX_VALUE);
            this.recursiveReduction(this.root, new HashMap<Kit.IntArrayHashKey, MDDNode>(2000));
            this.finalizeStoreTuples();
            this.root.display();
            this.displayTuples();
        }
        return this;
    }

    @Override
    public boolean checkIdxs(int[] t) {
        MDDNode node = this.root;
        int i = 0;
        while (!node.isLeaf()) {
            node = node.sons[t[i]];
            ++i;
        }
        return node == MDDNode.nodeT;
    }

    public void displayTuples() {
        int cnt = this.root.displayTuples(Variable.buildDomainsArrayFor(this.firstRegisteredCtr().scp), new int[this.firstRegisteredCtr().scp.length], 0, 0);
        Kit.log.info(" => " + cnt + " tuples");
    }

    public MDDSplitter getSplitter() {
        return this.splitter;
    }

    void buildSplitter() {
        if (this.mustBuildSplitter) {
            int arity = this.firstRegisteredCtr().scp.length;
            this.splitter = new MDDSplitter(this, new int[]{(int)Math.ceil((double)arity / 2.0), (int)Math.floor((double)arity / 2.0)});
        }
    }

    public int[][][] buildCompressedTable() {
        Constraint ctr = this.firstRegisteredCtr();
        LinkedList<int[][]> list = new LinkedList<int[][]>();
        this.root.collectCompressedTuples(list, new int[ctr.scp.length][], 0);
        int[][][] compressedTuples = Kit.intArray3D(list);
        return compressedTuples;
    }

    public static void main(String[] args) {
        int length = Integer.parseInt(args[0]);
    }

    public static final class MDDNode {
        public static final MDDNode nodeF = new MDDNode(null, 0);
        public static final MDDNode nodeT = new MDDNode(null, 1);
        public static int nBuiltNodes;
        private static boolean discardClassForNodeF;
        private final MDD mdd;
        public int id;
        public final int level;
        public MDDNode[] sons;
        public int[][] sonsClasses;
        private Integer nSonsDifferentFromNodeF;
        public Object state;

        public String name() {
            return this == nodeF ? "nodeF" : (this == nodeT ? "nodeT" : (this.level == 0 ? "root" : "n" + this.id));
        }

        public int nSonsDifferentFromNodeF() {
            return this.nSonsDifferentFromNodeF != null ? this.nSonsDifferentFromNodeF : (this.nSonsDifferentFromNodeF = Integer.valueOf((int)Stream.of(this.sons).filter(c -> c != nodeF).count()));
        }

        public final boolean isLeaf() {
            return this == nodeF || this == nodeT;
        }

        private MDDNode(MDD mdd, int level) {
            this.mdd = mdd;
            if (mdd == null) {
                this.id = level;
                this.level = -1;
            } else {
                this.id = mdd.nextNodeId();
                this.level = level;
            }
        }

        public MDDNode(MDD mdd, int level, int nSons, boolean defaultNodeF) {
            this(mdd, level);
            this.sons = (MDDNode[])IntStream.range(0, nSons).mapToObj(i -> defaultNodeF ? nodeF : nodeT).toArray(MDDNode[]::new);
        }

        public MDDNode(MDD mdd, int level, int nSons, boolean defaultNodeF, Object state) {
            this(mdd, level, nSons, defaultNodeF);
            this.state = state;
        }

        private void addTuple(int level, int value, int[] tuple, boolean positive, int[] domSizes) {
            MDDNode son = this.sons[value];
            if (!son.isLeaf()) {
                son.addTuple(level + 1, tuple, positive, domSizes);
            } else if (level == tuple.length - 1) {
                this.sons[value] = positive ? nodeT : nodeF;
            } else {
                this.sons[value] = new MDDNode(this.mdd, level + 1, domSizes[level + 1], positive);
                this.sons[value].addTuple(level + 1, tuple, positive, domSizes);
            }
        }

        private void addTuple(int level, int[] tuple, boolean positive, int[] domSizes) {
            if (tuple[level] == 0x7FFFFFFE) {
                for (int i = 0; i < this.sons.length; ++i) {
                    this.addTuple(level, i, tuple, positive, domSizes);
                }
            } else {
                this.addTuple(level, tuple[level], tuple, positive, domSizes);
            }
        }

        public void addTuple(int[] tuple, boolean positive, int[] domSizes) {
            this.addTuple(0, tuple, positive, domSizes);
        }

        public void buildSonsClasses() {
            if (this.isLeaf() || this.sonsClasses != null) {
                return;
            }
            Map<MDDNode, List<Integer>> map = IntStream.range(0, this.sons.length).filter(i -> !discardClassForNodeF || this.sons[i] != nodeF).boxed().collect(Collectors.groupingBy(i -> this.sons[i]));
            this.sonsClasses = (int[][])map.values().stream().map(list -> Kit.intArray(list)).toArray(x$0 -> new int[x$0][]);
            Stream.of(this.sons).forEach(s -> s.buildSonsClasses());
        }

        public int nInternalNodes(Set<Integer> set) {
            if (this.isLeaf() || set.contains(this.id)) {
                return 0;
            }
            set.add(this.id);
            return 1 + Stream.of(this.sons).mapToInt(c -> c.nInternalNodes(set)).sum();
        }

        private boolean canReachNodeT(Set<Integer> reachingNodes, Set<Integer> unreachingNodes) {
            if (this == nodeT || reachingNodes.contains(this.id)) {
                return true;
            }
            if (this == nodeF || unreachingNodes.contains(this.id)) {
                return false;
            }
            boolean found = false;
            for (int i = 0; i < this.sons.length; ++i) {
                if (!this.sons[i].canReachNodeT(reachingNodes, unreachingNodes)) {
                    this.sons[i] = nodeF;
                    continue;
                }
                found = true;
            }
            if (found) {
                reachingNodes.add(this.id);
            } else {
                unreachingNodes.add(this.id);
            }
            return found;
        }

        public boolean canReachNodeT() {
            return this.canReachNodeT(new HashSet<Integer>(), new HashSet<Integer>());
        }

        public int renameNodes(int lastId, Map<Integer, MDDNode> map) {
            if (this.isLeaf() || map.get(this.id) == this) {
                return lastId;
            }
            this.id = ++lastId;
            map.put(this.id, this);
            for (MDDNode son : this.sons) {
                lastId = son.renameNodes(lastId, map);
            }
            return lastId;
        }

        public boolean controlUniqueNodes(Map<Integer, MDDNode> map) {
            MDDNode node = map.get(this.id);
            if (node == null) {
                map.put(this.id, this);
            } else {
                Kit.control(node == this, () -> "two nodes with the same id in the MDD " + this.id);
            }
            return this.sons == null || Stream.of(this.sons).noneMatch(child -> !child.controlUniqueNodes(map));
        }

        public void display(int[] cnts, boolean displayClasses) {
            if (this.isLeaf()) {
                return;
            }
            Kit.log.fine(this.id + "@" + this.level + " => ");
            if (cnts != null) {
                int n = this.level;
                cnts[n] = cnts[n] + 1;
            }
            if (this.sons == null) {
                return;
            }
            Kit.log.fine("{" + Stream.of(this.sons).map(child -> child.id + "").collect(Collectors.joining(",")) + "}");
            if (displayClasses) {
                if (this.sonsClasses != null) {
                    for (int i = 0; i < this.sonsClasses.length; ++i) {
                        Kit.log.fine("class " + i + " => {" + Kit.join((Object)this.sonsClasses[i], new String[0]) + "}");
                    }
                }
                Kit.log.fine("nNotFFChilds=" + this.nSonsDifferentFromNodeF);
            }
            Stream.of(this.sons).filter(s -> s.id > this.id).forEach(s -> s.display(cnts, displayClasses));
        }

        public void display() {
            this.display(null, false);
        }

        public void displayTransitionsXCSP() {
            if (this.isLeaf()) {
                return;
            }
            if (this.sons == null) {
                return;
            }
            System.out.print(IntStream.range(0, this.sons.length).filter(i -> this.sons[i] != nodeF).mapToObj(i -> "[\"q" + this.id + "\"," + i + ",\"q" + this.sons[i].id + "\"]").collect(Collectors.joining(",")) + ",\n");
            Stream.of(this.sons).filter(s -> s.id > this.id).forEach(s -> s.displayTransitionsXCSP());
        }

        public int displayTuples(Domain[] doms, int[] currTuple, int currLevel, int cnt) {
            if (this == nodeT) {
                Kit.log.info(Kit.join((Object)currTuple, new String[0]));
                ++cnt;
            }
            if (this.isLeaf()) {
                return cnt;
            }
            for (int i = 0; i < this.sons.length; ++i) {
                currTuple[currLevel] = doms[currLevel].toVal(i);
                cnt = this.sons[i].displayTuples(doms, currTuple, currLevel + 1, cnt);
            }
            return cnt;
        }

        private StringBuilder getTransitions(Domain[] doms, StringBuilder sb, Set<MDDNode> processedNodes) {
            if (this.sons != null) {
                for (int i = 0; i < this.sons.length; ++i) {
                    if (this.sons[i] == nodeF) continue;
                    sb.append("(").append(this.name()).append(",").append(doms[this.level].toVal(i)).append(",").append(this.sons[i].name()).append(")");
                }
                processedNodes.add(this);
                for (MDDNode son : this.sons) {
                    if (processedNodes.contains(son)) continue;
                    son.getTransitions(doms, sb, processedNodes);
                }
            }
            return sb;
        }

        public String getTransitions(Domain[] doms) {
            return this.getTransitions(doms, new StringBuilder(), new HashSet<MDDNode>()).toString();
        }

        public void collectCompressedTuples(List<int[][]> list, int[][] t, int level) {
            if (this == nodeT) {
                list.add(Kit.cloneDeeply(t));
            }
            if (this.isLeaf()) {
                return;
            }
            for (int i = 0; i < this.sonsClasses.length; ++i) {
                t[level] = this.sonsClasses[i];
                MDDNode representativeChild = this.sons[this.sonsClasses[i][0]];
                representativeChild.collectCompressedTuples(list, t, level + 1);
            }
        }

        public MDDNode filter(int[][] values, int prevVal) {
            int i;
            if (this.isLeaf()) {
                return this;
            }
            MDDNode node = new MDDNode(this.mdd, this.level, this.sons.length, true);
            for (i = 0; i < this.sons.length; ++i) {
                if (values[this.level][i] > prevVal) continue;
                node.sons[i] = this.sons[i];
            }
            for (i = 0; i < this.sons.length; ++i) {
                node.sons[i] = node.sons[i].filter(values, values[this.level][i]);
            }
            return node;
        }

        static {
            discardClassForNodeF = true;
        }
    }
}

