/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension.structures;

import constraints.Constraint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public abstract class ExtensionStructure
implements Constraint.RegisteringCtrs {
    public final List<Constraint> registeredCtrs = new ArrayList<Constraint>();
    public String[][] symbolicTuples;
    public int[][] originalTuples;
    public boolean originalPositive;

    @Override
    public List<Constraint> registeredCtrs() {
        return this.registeredCtrs;
    }

    public ExtensionStructure(Constraint c) {
        this.registeredCtrs.add(c);
    }

    public boolean removeTuple(int[] tupleToBeRemoved) {
        throw new AssertionError((Object)"relevant only for some subclasses when 2nd order consistencies are used");
    }

    protected final void incrementNbTuplesRemoved() {
        ++this.firstRegisteredCtr().problem.solver.propagation.nTuplesRemoved;
    }

    public abstract void storeTuples(int[][] var1, boolean var2);

    public abstract boolean checkIdxs(int[] var1);

    public int[] nextSupport(int x, int a, int[] current) {
        throw new UnsupportedOperationException();
    }

    private boolean areSymmetricPositions(Set<Kit.IntArrayHashKey> set, int[][] tuples, int i, int j) {
        Kit.IntArrayHashKey key = new Kit.IntArrayHashKey();
        for (int[] tuple : tuples) {
            key.t = Kit.swap(tuple, i, j);
            boolean b = set.contains(key);
            Kit.swap(tuple, i, j);
            if (b) continue;
            return false;
        }
        return true;
    }

    public int[] computeVariableSymmetryMatching(Constraint c) {
        assert (this.registeredCtrs.stream().anyMatch(cc -> cc == c));
        Variable[] scp = c.scp;
        if (scp.length == 1) {
            return new int[]{1};
        }
        if (!Variable.haveSameDomainType(scp)) {
            return Kit.range(1, scp.length);
        }
        if (scp.length == 2) {
            Domain dom0 = scp[0].dom;
            Domain dom1 = scp[1].dom;
            int[] tmp = c.tupleManager.localTuple;
            for (int[] tuple : this.originalTuples) {
                tmp[0] = dom0.toIdx(tuple[1]);
                tmp[1] = dom1.toIdx(tuple[0]);
                if (this.checkIdxs(tmp) == this.originalPositive) continue;
                return new int[]{1, 2};
            }
            return new int[]{1, 1};
        }
        HashSet<Kit.IntArrayHashKey> set = new HashSet<Kit.IntArrayHashKey>();
        for (int[] t : this.originalTuples) {
            set.add(new Kit.IntArrayHashKey(t));
        }
        int[] permutation = new int[scp.length];
        int color = 1;
        for (int i = 0; i < permutation.length; ++i) {
            if (permutation[i] != 0) continue;
            for (int j = i + 1; j < permutation.length; ++j) {
                if (permutation[j] != 0 || !this.areSymmetricPositions(set, this.originalTuples, i, j)) continue;
                permutation[j] = color;
            }
            permutation[i] = color++;
        }
        return permutation;
    }
}

