/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension.structures;

import constraints.Constraint;
import constraints.extension.structures.ExtensionStructure;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import main.Head;
import problem.Problem;
import utility.Bit;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class Bits
extends ExtensionStructure {
    public static final Map<Kit.LongArrayHashKey, long[]> globalMap = Collections.synchronizedMap(new HashMap(2000));
    private long[][] bitSups0;
    private long[][] bitSups1;
    private int[][] bitSups0Dense;
    private int[][] bitSups1Dense;
    private boolean sharedArrays;
    private Kit.LongArrayHashKey hashKey;

    public long[][] bitSupsFor(int vap) {
        return vap == 0 ? this.bitSups0 : this.bitSups1;
    }

    public int[][] bitSupsDenseFor(int vap) {
        return vap == 0 ? this.bitSups0Dense : this.bitSups1Dense;
    }

    private void buildArrays() {
        Domain dom0 = this.firstRegisteredCtr().scp[0].dom;
        Domain dom1 = this.firstRegisteredCtr().scp[1].dom;
        this.bitSups0 = new long[dom0.initSize()][dom1.initSize() / 64 + (dom1.initSize() % 64 != 0 ? 1 : 0)];
        this.bitSups1 = new long[dom1.initSize()][dom0.initSize() / 64 + (dom0.initSize() % 64 != 0 ? 1 : 0)];
    }

    private void fillSupports0(int[][] tuples, boolean positive) {
        Constraint ctr = this.firstRegisteredCtr();
        Domain dom0 = ctr.scp[0].dom;
        Domain dom1 = ctr.scp[1].dom;
        if (positive) {
            if (ctr.indexesMatchValues) {
                for (int[] tuple : tuples) {
                    long[] lArray = this.bitSups0[tuple[0]];
                    int n = tuple[1] / 64;
                    lArray[n] = lArray[n] | Bit.ONE_LONG_BIT_TO_1[tuple[1] % 64];
                }
            } else {
                for (int[] tuple : tuples) {
                    int val0 = dom0.toIdx(tuple[0]);
                    int val1 = dom1.toIdx(tuple[1]);
                    long[] lArray = this.bitSups0[val0];
                    int n = val1 / 64;
                    lArray[n] = lArray[n] | Bit.ONE_LONG_BIT_TO_1[val1 % 64];
                }
            }
        } else {
            for (long[] t : this.bitSups0) {
                Arrays.fill(t, -1L);
                int remainder = dom1.initSize() % 64;
                if (remainder == 0) continue;
                t[t.length - 1] = Bit.bitsA1To(remainder);
            }
            if (ctr.indexesMatchValues) {
                for (int[] tuple : tuples) {
                    long[] lArray = this.bitSups0[tuple[0]];
                    int n = tuple[1] / 64;
                    lArray[n] = lArray[n] & Bit.ONE_LONG_BIT_TO_0[tuple[1] % 64];
                }
            } else {
                for (int[] tuple : tuples) {
                    int val0 = dom0.toIdx(tuple[0]);
                    int val1 = dom1.toIdx(tuple[1]);
                    long[] lArray = this.bitSups0[val0];
                    int n = val1 / 64;
                    lArray[n] = lArray[n] & Bit.ONE_LONG_BIT_TO_0[val1 % 64];
                }
            }
        }
    }

    private void fillSupports1() {
        for (int i = 0; i < this.bitSups0.length; ++i) {
            int iByte = i / 64;
            int iPos = i % 64;
            for (int j = 0; j < this.bitSups0[i].length; ++j) {
                long support = this.bitSups0[i][j];
                for (int k = 0; k < Math.min(64, this.bitSups1.length - j * 64); ++k) {
                    if ((support & Bit.ONE_LONG_BIT_TO_1[k]) == 0L) continue;
                    long[] lArray = this.bitSups1[j * 64 + k];
                    int n = iByte;
                    lArray[n] = lArray[n] | Bit.ONE_LONG_BIT_TO_1[iPos];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSpace(long[][] supports, int id) {
        Problem problem = this.firstRegisteredCtr().problem;
        for (int i = 0; i < supports.length; ++i) {
            if (this.hashKey == null) {
                this.hashKey = new Kit.LongArrayHashKey();
            }
            this.hashKey.t = supports[i];
            long[] tt = null;
            Map<Kit.LongArrayHashKey, long[]> map = globalMap;
            synchronized (map) {
                tt = globalMap.get(this.hashKey);
            }
            if (tt == null) {
                map = globalMap;
                synchronized (map) {
                    globalMap.put(this.hashKey, supports[i]);
                }
                this.hashKey = null;
                continue;
            }
            supports[i] = tt;
            ++problem.features.nSharedBinaryRepresentations;
        }
    }

    private void saveSpace() {
        Head resolution = this.firstRegisteredCtr().problem.head;
        if (resolution.control.problem.shareBitVectors) {
            int nSharedRepresentationsBefore = this.firstRegisteredCtr().problem.features.nSharedBinaryRepresentations;
            this.saveSpace(this.bitSups0, 1);
            this.saveSpace(this.bitSups1, 0);
            this.sharedArrays = this.firstRegisteredCtr().problem.features.nSharedBinaryRepresentations - nSharedRepresentationsBefore > 0;
        }
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        this.buildArrays();
        this.fillSupports0(tuples, positive);
        this.fillSupports1();
        this.saveSpace();
        this.bitSups0Dense = (int[][])Stream.of(this.bitSups0).map(t -> IntStream.range(0, ((long[])t).length).filter(i -> t[i] != 0L).toArray()).toArray(x$0 -> new int[x$0][]);
        this.bitSups1Dense = (int[][])Stream.of(this.bitSups1).map(t -> IntStream.range(0, ((long[])t).length).filter(i -> t[i] != 0L).toArray()).toArray(x$0 -> new int[x$0][]);
    }

    @Override
    public int[] computeVariableSymmetryMatching(Constraint c) {
        if (!Variable.haveSameDomainType(c.scp)) {
            return new int[]{1, 2};
        }
        for (int i = 0; i < this.bitSups0.length; ++i) {
            for (int j = i + 1; j < this.bitSups0.length; ++j) {
                boolean b2;
                boolean b1 = (this.bitSups0[i][j / 64] & Bit.ONE_LONG_BIT_TO_1[j % 64]) != 0L;
                boolean bl = b2 = (this.bitSups0[j][i / 64] & Bit.ONE_LONG_BIT_TO_1[i % 64]) != 0L;
                if (b1 == b2) continue;
                return new int[]{1, 2};
            }
        }
        return new int[]{1, 1};
    }

    public int[][] computeValueSymmetryMatching() {
        int[][] m = Variable.litterals(this.firstRegisteredCtr().scp).intArray();
        int color = 1;
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                if (m[i][j] != 0) continue;
                long[] s1 = i == 0 ? this.bitSups0[j] : this.bitSups1[j];
                for (int k = i; k < m.length; ++k) {
                    int l;
                    int n = l = k == i ? j + 1 : 0;
                    while (l < m[k].length) {
                        if (m[k][l] == 0 && s1 == (k == 0 ? this.bitSups0[l] : this.bitSups1[l])) {
                            m[k][l] = color;
                        }
                        ++l;
                    }
                }
                m[i][j] = color++;
            }
        }
        return m;
    }

    public Bits(Constraint ctr) {
        super(ctr);
        Kit.control(ctr.scp.length == 2);
    }

    public Bits(Constraint ctr, Bits bits) {
        this(ctr);
        this.bitSups0 = Kit.cloneDeeply(bits.bitSups0);
        this.bitSups1 = Kit.cloneDeeply(bits.bitSups1);
        this.sharedArrays = bits.sharedArrays;
    }

    public boolean hasSameSupportsThan(Bits bits) {
        if (this.bitSups0.length != bits.bitSups0.length || this.bitSups1.length != bits.bitSups1.length) {
            return false;
        }
        for (int i = 0; i < this.bitSups0.length; ++i) {
            for (int j = 0; j < this.bitSups0[i].length; ++j) {
                if (this.bitSups0[i][j] == bits.bitSups0[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean checkIdxs(int[] idxs) {
        return (this.bitSups0[idxs[0]][idxs[1] / 64] & Bit.ONE_LONG_BIT_TO_1[idxs[1] % 64]) != 0L;
    }

    @Override
    public boolean removeTuple(int[] tuple) {
        assert (this.registeredCtrs().size() == 1 && !this.sharedArrays);
        if ((this.bitSups0[tuple[0]][tuple[1] / 64] & Bit.ONE_LONG_BIT_TO_1[tuple[1] % 64]) == 0L) {
            return false;
        }
        assert (this.bitSups1 == null || (this.bitSups1[tuple[1]][tuple[0] / 64] & Bit.ONE_LONG_BIT_TO_1[tuple[0] % 64]) != 0L);
        long[] lArray = this.bitSups0[tuple[0]];
        int n = tuple[1] / 64;
        lArray[n] = lArray[n] & Bit.ONE_LONG_BIT_TO_0[tuple[1] % 64];
        if (this.bitSups1 != null) {
            long[] lArray2 = this.bitSups1[tuple[1]];
            int n2 = tuple[0] / 64;
            lArray2[n2] = lArray2[n2] & Bit.ONE_LONG_BIT_TO_0[tuple[0] % 64];
        }
        this.incrementNbTuplesRemoved();
        return true;
    }

    public String toString() {
        int size0 = this.firstRegisteredCtr().scp[0].dom.initSize();
        int size1 = this.firstRegisteredCtr().scp[1].dom.initSize();
        String s0 = "Bits of " + this.firstRegisteredCtr() + "\n" + IntStream.range(0, this.bitSups0.length).mapToObj(i -> "\t" + i + " : " + Bit.decrypt(this.bitSups0[i], size1) + "\n").collect(Collectors.joining());
        String sd0 = "Dense Bits of " + this.firstRegisteredCtr() + "\n" + IntStream.range(0, this.bitSups0Dense.length).mapToObj(i -> "\t" + i + " : " + Kit.join((Object)this.bitSups0Dense[i], new String[0]) + "\n").collect(Collectors.joining());
        String s1 = "Bits of " + this.firstRegisteredCtr() + "\n" + IntStream.range(0, this.bitSups1.length).mapToObj(i -> "\t" + i + " : " + Bit.decrypt(this.bitSups1[i], size0) + "\n").collect(Collectors.joining());
        String sd1 = "Dense Bits of " + this.firstRegisteredCtr() + "\n" + IntStream.range(0, this.bitSups1Dense.length).mapToObj(i -> "\t" + i + " : " + Kit.join((Object)this.bitSups1Dense[i], new String[0]) + "\n").collect(Collectors.joining());
        return s0 + sd0 + s1 + sd1;
    }
}

