/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.Extension;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.Table;
import interfaces.Tags;
import java.util.Arrays;
import java.util.stream.Stream;
import problem.Problem;
import propagation.StrongConsistency;
import sets.SetDenseReversible;
import utility.Kit;
import variables.Variable;

public final class STR2S
extends Extension.ExtensionGlobal
implements Tags.TagStarred {
    private static final int UNITIALIZED = -2;
    protected int[][] tuples;
    public SetDenseReversible set;
    protected boolean[][] ac;
    protected int[] cnts;
    protected int cnt;
    protected boolean decremental;
    protected int sValSize;
    protected int[] sVal;
    protected int sSupSize;
    protected int[] sSup;
    protected long lastCallLimit;
    protected int[] lastSizes;
    protected int[][] lastSizesStack;
    protected int lastDepth;

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        this.tuples = ((Table)this.extStructure).tuples;
        this.set = new SetDenseReversible(this.tuples.length, this.problem.variables.length + 1);
        this.ac = Variable.litterals(this.scp).booleanArray();
        this.cnts = new int[this.scp.length];
        this.sVal = new int[this.scp.length];
        this.sSup = new int[this.scp.length];
        this.control(this.tuples.length > 0);
        if (this.decremental) {
            this.lastSizesStack = new int[this.problem.variables.length + 1][this.scp.length];
            Arrays.fill(this.lastSizesStack[0], -2);
        } else {
            this.lastSizes = Kit.repeat(-2, this.scp.length);
        }
    }

    @Override
    public void restoreBefore(int depth) {
        this.set.restoreLimitAtLevel(depth);
        if (this.decremental) {
            this.lastDepth = Math.max(0, Math.min(this.lastDepth, depth - 1));
        } else {
            Arrays.fill(this.lastSizes, -2);
        }
    }

    public STR2S(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.decremental = pb.head.control.extension.decremental;
        Kit.control(scp.length > 1, () -> "Arity must be at least 2");
    }

    @Override
    protected ExtensionStructure buildExtensionStructure() {
        return new Table(this);
    }

    protected void initRestorationStructuresBeforeFiltering() {
        if (this.decremental) {
            int depth = this.problem.solver.depth();
            assert (0 <= this.lastDepth && this.lastDepth <= depth) : depth + " " + this.lastDepth + " " + this;
            for (int i = this.lastDepth + 1; i <= depth; ++i) {
                System.arraycopy(this.lastSizesStack[this.lastDepth], 0, this.lastSizesStack[i], 0, this.scp.length);
            }
            this.lastSizes = this.lastSizesStack[depth];
            this.lastDepth = depth;
        }
    }

    protected void manageLastPastVar() {
        if (this.lastCallLimit != this.problem.solver.stats.nAssignments || this.problem.solver.propagation instanceof StrongConsistency) {
            int x;
            this.lastCallLimit = this.problem.solver.stats.nAssignments;
            Variable lastPast = this.problem.solver.futVars.lastPast();
            int n = x = lastPast == null ? -1 : this.positionOf(lastPast);
            if (x != -1) {
                this.sVal[this.sValSize++] = x;
                this.lastSizes[x] = 1;
            }
        }
    }

    protected void beforeFiltering() {
        this.initRestorationStructuresBeforeFiltering();
        this.sSupSize = 0;
        this.sValSize = 0;
        this.manageLastPastVar();
        for (int i = this.futvars.limit; i >= 0; --i) {
            int domSize;
            int x = this.futvars.dense[i];
            this.cnts[x] = domSize = this.doms[x].size();
            if (this.lastSizes[x] != domSize) {
                this.sVal[this.sValSize++] = x;
                this.lastSizes[x] = domSize;
            }
            this.sSup[this.sSupSize++] = x;
            Arrays.fill(this.ac[x], false);
        }
    }

    protected boolean updateDomains() {
        for (int i = this.sSupSize - 1; i >= 0; --i) {
            int x = this.sSup[i];
            int nRemovals = this.cnts[x];
            assert (nRemovals > 0);
            if (!this.scp[x].dom.remove(this.ac[x], nRemovals)) {
                return false;
            }
            this.lastSizes[x] = this.scp[x].dom.size();
        }
        return true;
    }

    protected boolean isValidTuple(int[] tuple) {
        for (int i = this.sValSize - 1; i >= 0; --i) {
            int x = this.sVal[i];
            if (tuple[x] == 0x7FFFFFFE || this.doms[x].present(tuple[x])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int depth = this.problem.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValidTuple(tuple)) {
                for (int j = this.sSupSize - 1; j >= 0; --j) {
                    int x = this.sSup[j];
                    int a = tuple[x];
                    if (a == 0x7FFFFFFE) {
                        this.cnts[x] = 0;
                        this.sSup[j] = this.sSup[--this.sSupSize];
                        continue;
                    }
                    if (this.ac[x][a]) continue;
                    this.ac[x][a] = true;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    if (this.cnts[n] != 0) continue;
                    this.sSup[j] = this.sSup[--this.sSupSize];
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        assert (this.controlValidTuples());
        return this.updateDomains();
    }

    private boolean controlValidTuples() {
        int[] dense = this.set.dense;
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[dense[i]];
            for (int j = tuple.length - 1; j >= 0; --j) {
                if (tuple[j] == 0x7FFFFFFE || this.doms[j].present(tuple[j])) continue;
                System.out.println(this + " at " + this.problem.solver.depth() + "\n" + Kit.join((Object)tuple, new String[0]));
                Stream.of(this.scp).forEach(x -> x.display(true));
                return false;
            }
        }
        return true;
    }
}

