/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.STR1Optimized;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.Table;
import interfaces.Tags;
import java.util.stream.Stream;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public class STR2
extends STR1Optimized
implements Tags.TagStarred {
    boolean starred;

    public STR2(Problem pb, Variable ... scp) {
        super(pb, scp);
    }

    @Override
    protected ExtensionStructure buildExtensionStructure() {
        Table table = new Table(this);
        this.starred = table.starred;
        return table;
    }

    protected boolean isValidTuple(int[] tuple) {
        for (int i = this.sValSize - 1; i >= 0; --i) {
            int x = this.sVal[i];
            if (tuple[x] == 0x7FFFFFFE || this.doms[x].present(tuple[x])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int depth = this.problem.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValidTuple(tuple)) {
                for (int j = this.sSupSize - 1; j >= 0; --j) {
                    int x = this.sSup[j];
                    int a = tuple[x];
                    if (a == 0x7FFFFFFE) {
                        this.cnts[x] = 0;
                        this.sSup[j] = this.sSup[--this.sSupSize];
                        continue;
                    }
                    if (this.ac[x][a]) continue;
                    this.ac[x][a] = true;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    if (this.cnts[n] != 0) continue;
                    this.sSup[j] = this.sSup[--this.sSupSize];
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        assert (this.controlValidTuples());
        return this.updateDomains();
    }

    private boolean controlValidTuples() {
        int[] dense = this.set.dense;
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[dense[i]];
            for (int j = tuple.length - 1; j >= 0; --j) {
                if (tuple[j] == 0x7FFFFFFE || this.doms[j].present(tuple[j])) continue;
                System.out.println(this + " at " + this.problem.solver.depth() + "\n" + Kit.join((Object)tuple, new String[0]));
                Stream.of(this.scp).forEach(x -> x.display(true));
                return false;
            }
        }
        return true;
    }
}

