/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.STR1;
import java.util.Arrays;
import problem.Problem;
import propagation.StrongConsistency;
import utility.Kit;
import variables.Variable;

public abstract class STR1Optimized
extends STR1 {
    private static final int UNITIALIZED = -2;
    protected boolean decremental;
    protected int sValSize;
    protected int[] sVal;
    protected int sSupSize;
    protected int[] sSup;
    protected long lastCallLimit;
    protected int[] lastSizes;
    protected int[][] lastSizesStack;
    protected int lastDepth;

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        this.sVal = new int[this.scp.length];
        this.sSup = new int[this.scp.length];
        if (this.decremental) {
            this.lastSizesStack = new int[this.problem.variables.length + 1][this.scp.length];
            Arrays.fill(this.lastSizesStack[0], -2);
        } else {
            this.lastSizes = Kit.repeat(-2, this.scp.length);
        }
    }

    @Override
    public void restoreBefore(int depth) {
        super.restoreBefore(depth);
        if (this.decremental && depth > 0) {
            this.lastDepth = Math.max(0, Math.min(this.lastDepth, depth - 1));
        } else {
            Arrays.fill(this.lastSizes, -2);
        }
    }

    public STR1Optimized(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.decremental = pb.head.control.extension.decremental;
    }

    protected void initRestorationStructuresBeforeFiltering() {
        if (this.decremental) {
            int depth = this.problem.solver.depth();
            assert (0 <= this.lastDepth && this.lastDepth <= depth) : depth + " " + this.lastDepth + " " + this;
            for (int i = this.lastDepth + 1; i <= depth; ++i) {
                System.arraycopy(this.lastSizesStack[this.lastDepth], 0, this.lastSizesStack[i], 0, this.scp.length);
            }
            this.lastSizes = this.lastSizesStack[depth];
            this.lastDepth = depth;
        }
    }

    protected void manageLastPastVar() {
        if (this.lastCallLimit != this.problem.solver.stats.numberSafe() || this.problem.solver.propagation instanceof StrongConsistency) {
            int x;
            this.lastCallLimit = this.problem.solver.stats.numberSafe();
            Variable lastPast = this.problem.solver.futVars.lastPast();
            int n = x = lastPast == null ? -1 : this.positionOf(lastPast);
            if (x != -1) {
                this.sVal[this.sValSize++] = x;
                this.lastSizes[x] = 1;
            }
        }
    }

    @Override
    protected void beforeFiltering() {
        this.initRestorationStructuresBeforeFiltering();
        this.sSupSize = 0;
        this.sValSize = 0;
        this.manageLastPastVar();
        for (int i = this.futvars.limit; i >= 0; --i) {
            int domSize;
            int x = this.futvars.dense[i];
            this.cnts[x] = domSize = this.doms[x].size();
            if (this.lastSizes[x] != domSize) {
                this.sVal[this.sValSize++] = x;
                this.lastSizes[x] = domSize;
            }
            this.sSup[this.sSupSize++] = x;
            Arrays.fill(this.ac[x], false);
        }
    }

    @Override
    protected boolean updateDomains() {
        for (int i = this.sSupSize - 1; i >= 0; --i) {
            int x = this.sSup[i];
            int nRemovals = this.cnts[x];
            assert (nRemovals > 0);
            if (!this.doms[x].remove(this.ac[x], nRemovals)) {
                return false;
            }
            this.lastSizes[x] = this.doms[x].size();
        }
        return true;
    }
}

