/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.STR1Optimized;
import constraints.extension.structures.Table;
import interfaces.Tags;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import problem.Problem;
import sets.SetDenseReversible;
import utility.Bit;
import variables.Domain;
import variables.Variable;

public class CT
extends STR1Optimized
implements Tags.TagStarred {
    private long[] current;
    private long[][][] masks;
    private long[][][] masksS;
    private long[] tmp;
    private long[] tmp2;
    private long lastWord0Then1;
    private long lastWord1Then0;
    int factorStacked = 10;
    int factorStack = 10;
    long[] stackedWords;
    int[] stackedIndexes;
    int[] stackStructure;
    int topStacked = -1;
    int topStack = -1;
    boolean[] modifiedWords;
    int[] deltaSizes;
    public SetDenseReversible nonZeros;
    private int[][] residues;
    private boolean firstCall = true;
    private long lastCallNode = -1L;
    private boolean starred;

    protected void maskCompression(long[][] masks) {
    }

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        int nWords = (int)Math.ceil((double)this.tuples.length / 64.0);
        this.current = new long[nWords];
        this.tmp = new long[nWords];
        this.tmp2 = new long[nWords];
        this.lastWord1Then0 = this.tuples.length % 64 != 0 ? Bit.bitsA1To(this.tuples.length % 64) : -1L;
        this.lastWord0Then1 = this.tuples.length % 64 != 0 ? Bit.bitsAt1From(this.tuples.length % 64) : 0L;
        this.fillTo1(this.current);
        this.starred = ((Table)this.extStructure).starred;
        this.masks = Variable.litterals(this.scp).longArray(nWords);
        if (!this.starred) {
            for (int x = 0; x < this.scp.length; ++x) {
                long[][] mask = this.masks[x];
                for (int j = 0; j < this.tuples.length; ++j) {
                    Bit.setTo1(mask[this.tuples[j][x]], j);
                }
                this.maskCompression(mask);
            }
        } else {
            int j;
            long[][] mask;
            int x;
            for (x = 0; x < this.scp.length; ++x) {
                mask = this.masks[x];
                for (j = 0; j < this.tuples.length; ++j) {
                    if (this.tuples[j][x] != 0x7FFFFFFE) {
                        Bit.setTo1(mask[this.tuples[j][x]], j);
                        continue;
                    }
                    for (int a = 0; a < mask.length; ++a) {
                        Bit.setTo1(mask[a], j);
                    }
                }
                this.maskCompression(mask);
            }
            this.masksS = Variable.litterals(this.scp).longArray(nWords);
            for (x = 0; x < this.scp.length; ++x) {
                mask = this.masksS[x];
                for (j = 0; j < this.tuples.length; ++j) {
                    if (this.tuples[j][x] == 0x7FFFFFFE) continue;
                    Bit.setTo1(mask[this.tuples[j][x]], j);
                }
                this.maskCompression(mask);
            }
        }
        this.stackedWords = new long[nWords * this.factorStacked];
        this.stackedIndexes = new int[nWords * this.factorStacked];
        this.stackStructure = new int[nWords * this.factorStack];
        this.modifiedWords = new boolean[nWords];
        this.deltaSizes = new int[this.scp.length];
        this.nonZeros = new SetDenseReversible(this.current.length, this.problem.variables.length + 1);
        this.residues = Variable.litterals(this.scp).intArray();
        this.firstCall = true;
    }

    @Override
    public void restoreBefore(int depth) {
        super.restoreBefore(depth);
        if (this.topStack != -1 && this.stackStructure[this.topStack - 1] == depth) {
            for (int i = this.stackStructure[this.topStack] - 1; i >= 0; --i) {
                this.current[this.stackedIndexes[this.topStacked - i]] = this.stackedWords[this.topStacked - i];
            }
            this.topStacked -= this.stackStructure[this.topStack];
            this.topStack -= 2;
        }
        this.nonZeros.restoreLimitAtLevel(depth);
        this.lastCallNode = -1L;
    }

    public CT(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.control(this.decremental);
    }

    private void fillTo1(long[] t) {
        Arrays.fill(t, -1L);
        t[t.length - 1] = this.lastWord1Then0;
    }

    private void fillTo0(long[] t) {
        for (int i = this.nonZeros.limit; i >= 0; --i) {
            t[this.nonZeros.dense[i]] = 0L;
        }
        t[t.length - 1] = this.lastWord0Then1;
    }

    private void wordModified(int index, long oldValue) {
        if (this.modifiedWords[index]) {
            assert (this.stackStructure[this.topStack - 1] == this.problem.solver.depth() && IntStream.range(0, this.stackStructure[this.topStack]).anyMatch(i -> this.stackedIndexes[this.topStacked - i] == index));
            return;
        }
        int depth = this.problem.solver.depth();
        if (this.topStack == -1 || this.stackStructure[this.topStack - 1] != depth) {
            if (this.topStack + 3 >= this.stackStructure.length) {
                this.stackStructure = Arrays.copyOf(this.stackStructure, this.current.length * (this.factorStack *= 2));
            }
            this.stackStructure[++this.topStack] = depth;
            this.stackStructure[++this.topStack] = 1;
        } else {
            int n = this.topStack;
            this.stackStructure[n] = this.stackStructure[n] + 1;
        }
        if (this.topStacked + 3 >= this.stackedWords.length) {
            this.stackedWords = Arrays.copyOf(this.stackedWords, this.current.length * (this.factorStacked *= 2));
            this.stackedIndexes = Arrays.copyOf(this.stackedIndexes, this.current.length * this.factorStacked);
        }
        this.stackedWords[++this.topStacked] = oldValue;
        this.stackedIndexes[this.topStacked] = index;
        this.modifiedWords[index] = true;
    }

    @Override
    protected void manageLastPastVar() {
        int x;
        Variable lastPast = this.problem.solver.futVars.lastPast();
        int n = x = lastPast == null ? -1 : this.positionOf(lastPast);
        if (x != -1 && this.lastSizes[x] != 1) {
            this.deltaSizes[x] = this.lastSizes[x] - 1;
            this.sVal[this.sValSize++] = x;
            this.lastSizes[x] = 1;
        }
    }

    @Override
    protected void beforeFiltering() {
        int i;
        if (this.lastCallNode != this.problem.solver.stats.numberSafe()) {
            for (i = this.nonZeros.limit; i >= 0; --i) {
                this.modifiedWords[this.nonZeros.dense[i]] = false;
            }
            if (this.topStack != -1 && this.stackStructure[this.topStack - 1] == this.problem.solver.depth()) {
                for (i = this.stackStructure[this.topStack] - 1; i >= 0; --i) {
                    this.modifiedWords[this.stackedIndexes[this.topStacked - i]] = true;
                }
            }
            this.lastCallNode = this.problem.solver.stats.numberSafe();
        }
        this.initRestorationStructuresBeforeFiltering();
        this.sSupSize = 0;
        this.sValSize = 0;
        this.manageLastPastVar();
        for (i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            int domSize = this.doms[x].size();
            if (this.lastSizes[x] != domSize) {
                this.deltaSizes[x] = this.lastSizes[x] - domSize;
                this.sVal[this.sValSize++] = x;
                this.lastSizes[x] = domSize;
            }
            if (domSize <= 1) continue;
            this.sSup[this.sSupSize++] = x;
        }
        if (this.sValSize == 1) {
            int x = this.sVal[0];
            for (int i2 = 0; i2 < this.sSupSize; ++i2) {
                if (this.sSup[i2] != x) continue;
                this.sSup[i2] = this.sSup[--this.sSupSize];
                break;
            }
        }
    }

    private boolean firstCall() {
        int x;
        this.firstCall = false;
        this.lastSizes = this.lastSizesStack[0];
        this.lastDepth = 0;
        this.fillTo0(this.tmp);
        for (x = 0; x < this.scp.length; ++x) {
            Domain dom = this.doms[x];
            int a = dom.lastRemoved();
            while (a != -1) {
                Bit.or2(this.tmp, !this.starred ? this.masks[x][a] : this.masksS[x][a], this.nonZeros);
                a = dom.prevRemoved(a);
            }
        }
        Bit.inverse(this.tmp, this.nonZeros);
        for (int i = this.nonZeros.limit; i >= 0; --i) {
            int j = this.nonZeros.dense[i];
            long l = this.current[j] & this.tmp[j];
            if (this.current[j] == l) continue;
            this.current[j] = l;
            if (l != 0L) continue;
            this.nonZeros.removeAtPosition(i, 0);
        }
        for (x = 0; x < this.scp.length; ++x) {
            Domain dom = this.doms[x];
            int a = dom.first();
            while (a != -1) {
                int r = Bit.firstNonNullWord2(this.current, this.masks[x][a], this.nonZeros);
                if (r != -1) {
                    this.residues[x][a] = r;
                } else if (!dom.remove(a)) {
                    return false;
                }
                a = dom.next(a);
            }
            this.lastSizes[x] = dom.size();
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable z) {
        int i;
        int a;
        if (this.firstCall) {
            return this.firstCall();
        }
        this.beforeFiltering();
        this.fillTo0(this.tmp);
        for (int i2 = this.sValSize - 1; i2 >= 0; --i2) {
            int x = this.sVal[i2];
            Domain dom = this.doms[x];
            if (this.deltaSizes[x] <= dom.size()) {
                a = dom.lastRemoved();
                for (int cnt = this.deltaSizes[x] - 1; cnt >= 0; --cnt) {
                    Bit.or2(this.tmp, !this.starred ? this.masks[x][a] : this.masksS[x][a], this.nonZeros);
                    a = dom.prevRemoved(a);
                }
                continue;
            }
            if (dom.size() == 1) {
                Bit.orInverse2(this.tmp, this.masks[x][dom.first()], this.nonZeros);
                continue;
            }
            this.fillTo0(this.tmp2);
            int a2 = dom.first();
            while (a2 != -1) {
                Bit.or2(this.tmp2, this.masks[x][a2], this.nonZeros);
                a2 = dom.next(a2);
            }
            Bit.orInverse2(this.tmp, this.tmp2, this.nonZeros);
        }
        int depth = this.problem.solver.depth();
        for (i = this.nonZeros.limit; i >= 0; --i) {
            int j = this.nonZeros.dense[i];
            long l = this.current[j] & (this.tmp[j] ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.current[j] == l) continue;
            this.wordModified(j, this.current[j]);
            this.current[j] = l;
            if (l != 0L) continue;
            this.nonZeros.removeAtPosition(i, depth);
        }
        if (this.nonZeros.size() == 0) {
            return z.dom.fail();
        }
        for (i = this.sSupSize - 1; i >= 0; --i) {
            int x = this.sSup[i];
            Domain dom = this.doms[x];
            a = dom.first();
            while (a != -1) {
                int r = this.residues[x][a];
                if (!Bit.nonNullIntersection2(this.current, this.masks[x][a], r)) {
                    r = Bit.firstNonNullWord2(this.current, this.masks[x][a], this.nonZeros);
                    if (r != -1) {
                        this.residues[x][a] = r;
                    } else {
                        dom.removeSafely(a);
                    }
                }
                a = dom.next(a);
            }
            this.lastSizes[x] = dom.size();
        }
        return true;
    }

    public static final class CT2
    extends CT
    implements Tags.TagStarred {
        static final int MASK_COMPRESION_LIMIT = 12;
        static final int MASK_COMPRESION_TRIGGER_SIZE = 300;
        long[] maskCollect = new long[24];

        @Override
        protected void maskCompression(long[][] masks) {
            if (masks[0].length <= 300) {
                return;
            }
            for (int a = 0; a < masks.length; ++a) {
                long[] mask = masks[a];
                int cnt = 0;
                Long defaultWord = null;
                boolean compressible = true;
                for (int i2 = 0; compressible && i2 < mask.length; ++i2) {
                    if (mask[i2] == 0L && defaultWord == null) {
                        defaultWord = 0L;
                        continue;
                    }
                    if (mask[i2] == -1L && defaultWord == null) {
                        defaultWord = -1L;
                        continue;
                    }
                    if (defaultWord != null && mask[i2] == defaultWord) continue;
                    if (cnt + 1 >= this.maskCollect.length) {
                        compressible = false;
                        continue;
                    }
                    this.maskCollect[cnt++] = i2;
                    this.maskCollect[cnt++] = mask[i2];
                }
                if (!compressible) continue;
                long def = defaultWord == null ? 0L : defaultWord;
                long way = 0L;
                masks[a] = LongStream.range(0L, 2 + cnt).map(i -> i == 0L ? def : (i == 1L ? way : this.maskCollect[(int)i - 2])).toArray();
            }
        }

        public CT2(Problem pb, Variable[] scp) {
            super(pb, scp);
        }
    }
}

