from sqlalchemy.engine import create_engine
from sqlalchemy.ext.asyncio import AsyncSession, create_async_engine
from sqlalchemy.orm import Session, sessionmaker

from fidesctl.ctl.core.config import get_config

config = get_config()
engine = create_async_engine(
    config.database.async_database_uri,
    echo=False,
)
async_session = sessionmaker(engine, class_=AsyncSession, expire_on_commit=False)

sync_engine = create_engine(config.database.sync_database_uri, echo=False)
sync_session = sessionmaker(
    sync_engine, class_=Session, expire_on_commit=False, autocommit=False
)
