"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MergeBranchesFunction = void 0;
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_iam_1 = require("@aws-cdk/aws-iam");
class MergeBranchesFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'merge-branches')),
        });
        if (props.crossAccountRole) {
            this.addToRolePolicy(new aws_iam_1.PolicyStatement({
                resources: [props.crossAccountRole.roleArn],
                actions: ['sts:AssumeRole'],
            }));
        }
        else {
            this.addToRolePolicy(new aws_iam_1.PolicyStatement({
                resources: [props.repository.repositoryArn],
                actions: ['codecommit:MergeBranchesByFastForward'],
            }));
        }
    }
}
exports.MergeBranchesFunction = MergeBranchesFunction;
//# sourceMappingURL=data:application/json;base64,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