// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles
parcelRequire = (function (modules, cache, entry, globalName) {
  // Save the require from previous bundle to this closure if any
  var previousRequire = typeof parcelRequire === 'function' && parcelRequire;
  var nodeRequire = typeof require === 'function' && require;

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire = typeof parcelRequire === 'function' && parcelRequire;
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error('Cannot find module \'' + name + '\'');
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = cache[name] = new newRequire.Module(name);

      modules[name][0].call(module.exports, localRequire, module, module.exports, this);
    }

    return cache[name].exports;

    function localRequire(x){
      return newRequire(localRequire.resolve(x));
    }

    function resolve(x){
      return modules[name][1][x] || x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [function (require, module) {
      module.exports = exports;
    }, {}];
  };

  var error;
  for (var i = 0; i < entry.length; i++) {
    try {
      newRequire(entry[i]);
    } catch (e) {
      // Save first error but execute all entries
      if (!error) {
        error = e;
      }
    }
  }

  if (entry.length) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(entry[entry.length - 1]);

    // CommonJS
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = mainExports;

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
     define(function () {
       return mainExports;
     });

    // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }

  // Override the current require with this new one
  parcelRequire = newRequire;

  if (error) {
    // throw error from earlier, _after updating parcelRequire_
    throw error;
  }

  return newRequire;
})({"../../../../../../../../../../aws-sdk.external":[function(require,module,exports) {
module.exports=require('aws-sdk');
},{}],"index.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handler = void 0;

const aws_sdk_1 = require("aws-sdk"); // default session


const codePipeline = new aws_sdk_1.CodePipeline();
const sts = new aws_sdk_1.STS();

exports.handler = async event => {
  const {
    id: jobId,
    data: jobData
  } = event['CodePipeline.job'];

  try {
    const {
      repositoryName,
      sourceCommitSpecifier,
      destinationCommitSpecifier
    } = getUserParams(jobData);
    const codeCommitRoleArn = process.env.CODE_COMMIT_ROLE_ARN;
    const codeCommit = await (async () => {
      if (!codeCommitRoleArn) {
        return new aws_sdk_1.CodeCommit();
      }

      const {
        Credentials: credentials
      } = await sts.assumeRole({
        RoleArn: codeCommitRoleArn,
        RoleSessionName: `Merge-${repositoryName}-${sourceCommitSpecifier}-${destinationCommitSpecifier}`
      }).promise();
      return new aws_sdk_1.CodeCommit({
        accessKeyId: credentials.AccessKeyId,
        secretAccessKey: credentials.SecretAccessKey,
        sessionToken: credentials.SessionToken
      });
    })();
    const {
      commitId
    } = await codeCommit.mergeBranchesByFastForward({
      repositoryName,
      sourceCommitSpecifier,
      destinationCommitSpecifier
    }).promise();
    await putJobSuccess(jobId, commitId);
  } catch (error) {
    console.log(error);
    await putJobFailure(jobId, 'Function exception: ' + error.message);
  }

  console.log('Function complete.');
  return 'Complete.';
};
/**
 * Decodes the JSON user parameters and validates the required properties
 *
 * @param jobData The job data structure containing the UserParameters string which should be a valid JSON structure
 */


const getUserParams = jobData => {
  const {
    UserParameters: userParameters
  } = jobData.actionConfiguration.configuration;
  const {
    repositoryName,
    sourceCommitSpecifier,
    destinationCommitSpecifier
  } = JSON.parse(userParameters);

  if (!repositoryName) {
    throw new Error('Your UserParameters JSON must include the repository name');
  }

  if (!sourceCommitSpecifier) {
    throw new Error('Your UserParameters JSON must include the sourceCommitSpecifier');
  }

  if (!destinationCommitSpecifier) {
    throw new Error('Your UserParameters JSON must include the destinationCommitSpecifier');
  }

  return {
    repositoryName,
    sourceCommitSpecifier,
    destinationCommitSpecifier
  };
};
/**
 * Notify CodePipeline of a successful job
 *
 * @param jobId The CodePipeline job ID
 * @param message A message to be logged relating to the job status
 */


const putJobSuccess = async (jobId, message) => {
  console.log('Putting job success');

  if (message) {
    console.log(message);
  }

  await codePipeline.putJobSuccessResult({
    jobId
  }).promise();
};
/**
 * Notify CodePipeline of a failed job
 *
 * @param jobId The CodePipeline job ID
 * @param message A message to be logged relating to the job status
 */


const putJobFailure = async (jobId, message) => {
  console.log('Putting job failure');
  console.log(message);
  await codePipeline.putJobFailureResult({
    jobId,
    failureDetails: {
      message,
      type: 'JobFailed'
    }
  }).promise();
};
},{"aws-sdk":"../../../../../../../../../../aws-sdk.external"}]},{},["index.ts"], null)
//# sourceMappingURL=/index.js.map