"""v2.1.0

Revision ID: a06c97c98d2c
Revises: 126892076499
Create Date: 2024-02-07 09:44:10.077909

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy import text, Column, func
from geoalchemy2 import Geometry

# revision identifiers, used by Alembic.
revision: str = "a06c97c98d2c"
down_revision: Union[str, None] = "126892076499"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        constraint_name="scenario_id_time_range_excl", table_name="Event"
    )
    op.create_exclude_constraint(
        "scenario_id_time_range_excl",
        "Event",
        (Column("scenario_id"), "="),
        (Column("vehicle_id"), "="),
        (func.tstzrange(Column("time_start"), Column("time_end"), "()"), "&&"),
        using="gist",
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        constraint_name="scenario_id_time_range_excl", table_name="Event"
    )
    op.create_exclude_constraint(
        "scenario_id_time_range_excl",
        "Event",
        (Column("scenario_id"), "="),
        (Column("vehicle_id"), "="),
        (func.tstzrange(Column("time_start"), Column("time_end"), "[]"), "&&"),
        using="gist",
    )
    # ### end Alembic commands ###
