"""5.1.0

Revision ID: 3ed40e170361
Revises: 1d0f22ea5789
Create Date: 2024-08-05 18:27:22.436740

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "3ed40e170361"
down_revision: Union[str, None] = "1d0f22ea5789"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "ConsumptionLut",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("scenario_id", sa.BigInteger(), nullable=False),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("vehicle_class_id", sa.BigInteger(), nullable=False),
        sa.Column("columns", postgresql.JSONB(astext_type=sa.Text()), nullable=True),  # type: ignore
        sa.Column(
            "data_points", postgresql.ARRAY(sa.Float(), dimensions=2), nullable=False
        ),
        sa.Column("values", postgresql.ARRAY(sa.Float(), dimensions=1), nullable=False),
        sa.ForeignKeyConstraint(
            ["scenario_id"],
            ["Scenario.id"],
        ),
        sa.ForeignKeyConstraint(
            ["vehicle_class_id"],
            ["VehicleClass.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("scenario_id", "vehicle_class_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("ConsumptionLut")
    # ### end Alembic commands ###
