"""
The transformation module consits of sklearn type classes to transform and
inverse transform data. The enhancement is that these transformations have a
config and from_config methods. Therefore we can save the transformation objects
in a json file and load from a json file. At the lowest level there are individual
transformations which perform transformation on single data. Then on top of that
is Transformation class, which does some data cleaning and preprocessing to perform
transformation on single array like. Then, at the highest level, there is
Transformations class which can be used to perform multiple transformation on
single array or multiple arrays.
"""

from ._main import Transformation

from ._wrapper import Transformations

from ._transformations import ScalerWithConfig
from ._transformations import MinMaxScaler
from ._transformations import StandardScaler
from ._transformations import MaxAbsScaler
from ._transformations import RobustScaler
from ._transformations import QuantileTransformer
from ._transformations import PowerTransformer
from ._transformations import SqrtScaler
from ._transformations import LogScaler
from ._transformations import Log2Scaler
from ._transformations import Log10Scaler
from ._transformations import TanScaler
from ._transformations import CumsumScaler
from ._transformations import Center
from ._transformations import FunctionTransformer
from ._transformations import ParetoTransformer
from ._transformations import VastTransformer
from ._transformations import MmadTransformer