# generated by datamodel-codegen:
#   filename:  citation.json
#   timestamp: 2022-01-18T11:10:50+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from easyDataverse.core import DataverseBase
from pydantic import Field


class SubjectEnum(Enum):
    agricultural__sciences = 'Agricultural Sciences'
    arts_and__humanities = 'Arts and Humanities'
    astronomy_and__astrophysics = 'Astronomy and Astrophysics'
    business_and__management = 'Business and Management'
    chemistry = 'Chemistry'
    computer_and__information__science = 'Computer and Information Science'
    earth_and__environmental__sciences = 'Earth and Environmental Sciences'
    engineering = 'Engineering'
    law = 'Law'
    mathematical__sciences = 'Mathematical Sciences'
    medicine___health_and__life__sciences = 'Medicine, Health and Life Sciences'
    physics = 'Physics'
    social__sciences = 'Social Sciences'
    other = 'Other'


class Language(Enum):
    """
    Language of the Dataset
    """

    abkhaz = 'Abkhaz'
    afar = 'Afar'
    afrikaans = 'Afrikaans'
    akan = 'Akan'
    albanian = 'Albanian'
    amharic = 'Amharic'
    arabic = 'Arabic'
    aragonese = 'Aragonese'
    armenian = 'Armenian'
    assamese = 'Assamese'
    avaric = 'Avaric'
    avestan = 'Avestan'
    aymara = 'Aymara'
    azerbaijani = 'Azerbaijani'
    bambara = 'Bambara'
    bashkir = 'Bashkir'
    basque = 'Basque'
    belarusian = 'Belarusian'
    bengali___bangla = 'Bengali, Bangla'
    bihari = 'Bihari'
    bislama = 'Bislama'
    bosnian = 'Bosnian'
    breton = 'Breton'
    bulgarian = 'Bulgarian'
    burmese = 'Burmese'
    catalan__valencian = 'Catalan,Valencian'
    chamorro = 'Chamorro'
    chechen = 'Chechen'
    chichewa___chewa___nyanja = 'Chichewa, Chewa, Nyanja'
    chinese = 'Chinese'
    chuvash = 'Chuvash'
    cornish = 'Cornish'
    corsican = 'Corsican'
    cree = 'Cree'
    croatian = 'Croatian'
    czech = 'Czech'
    danish = 'Danish'
    divehi___dhivehi___maldivian = 'Divehi, Dhivehi, Maldivian'
    dutch = 'Dutch'
    dzongkha = 'Dzongkha'
    english = 'English'
    esperanto = 'Esperanto'
    estonian = 'Estonian'
    ewe = 'Ewe'
    faroese = 'Faroese'
    fijian = 'Fijian'
    finnish = 'Finnish'
    french = 'French'
    fula___fulah___pulaar___pular = 'Fula, Fulah, Pulaar, Pular'
    galician = 'Galician'
    georgian = 'Georgian'
    german = 'German'
    greek__modern_ = 'Greek (modern)'
    guaraní = 'Guaraní'
    gujarati = 'Gujarati'
    haitian___haitian__creole = 'Haitian, Haitian Creole'
    hausa = 'Hausa'
    hebrew__modern_ = 'Hebrew (modern)'
    herero = 'Herero'
    hindi = 'Hindi'
    hiri__motu = 'Hiri Motu'
    hungarian = 'Hungarian'
    interlingua = 'Interlingua'
    indonesian = 'Indonesian'
    interlingue = 'Interlingue'
    irish = 'Irish'
    igbo = 'Igbo'
    inupiaq = 'Inupiaq'
    ido = 'Ido'
    icelandic = 'Icelandic'
    italian = 'Italian'
    inuktitut = 'Inuktitut'
    japanese = 'Japanese'
    javanese = 'Javanese'
    kalaallisut___greenlandic = 'Kalaallisut, Greenlandic'
    kannada = 'Kannada'
    kanuri = 'Kanuri'
    kashmiri = 'Kashmiri'
    kazakh = 'Kazakh'
    khmer = 'Khmer'
    kikuyu___gikuyu = 'Kikuyu, Gikuyu'
    kinyarwanda = 'Kinyarwanda'
    kyrgyz = 'Kyrgyz'
    komi = 'Komi'
    kongo = 'Kongo'
    korean = 'Korean'
    kurdish = 'Kurdish'
    kwanyama___kuanyama = 'Kwanyama, Kuanyama'
    latin = 'Latin'
    luxembourgish___letzeburgesch = 'Luxembourgish, Letzeburgesch'
    ganda = 'Ganda'
    limburgish___limburgan___limburger = 'Limburgish, Limburgan, Limburger'
    lingala = 'Lingala'
    lao = 'Lao'
    lithuanian = 'Lithuanian'
    luba__katanga = 'Luba-Katanga'
    latvian = 'Latvian'
    manx = 'Manx'
    macedonian = 'Macedonian'
    malagasy = 'Malagasy'
    malay = 'Malay'
    malayalam = 'Malayalam'
    maltese = 'Maltese'
    māori = 'Māori'
    marathi___marāṭhī_ = 'Marathi (Marāṭhī)'
    marshallese = 'Marshallese'
    mixtepec__mixtec = 'Mixtepec Mixtec'
    mongolian = 'Mongolian'
    nauru = 'Nauru'
    navajo___navaho = 'Navajo, Navaho'
    northern__ndebele = 'Northern Ndebele'
    nepali = 'Nepali'
    ndonga = 'Ndonga'
    norwegian__bokmål = 'Norwegian Bokmål'
    norwegian__nynorsk = 'Norwegian Nynorsk'
    norwegian = 'Norwegian'
    nuosu = 'Nuosu'
    southern__ndebele = 'Southern Ndebele'
    occitan = 'Occitan'
    ojibwe___ojibwa = 'Ojibwe, Ojibwa'
    old__church__slavonic__church__slavonic__old__bulgarian = (
        'Old Church Slavonic,Church Slavonic,Old Bulgarian'
    )
    oromo = 'Oromo'
    oriya = 'Oriya'
    ossetian___ossetic = 'Ossetian, Ossetic'
    panjabi___punjabi = 'Panjabi, Punjabi'
    pāli = 'Pāli'
    persian___farsi_ = 'Persian (Farsi)'
    polish = 'Polish'
    pashto___pushto = 'Pashto, Pushto'
    portuguese = 'Portuguese'
    quechua = 'Quechua'
    romansh = 'Romansh'
    kirundi = 'Kirundi'
    romanian = 'Romanian'
    russian = 'Russian'
    sanskrit___saṁskṛta_ = 'Sanskrit (Saṁskṛta)'
    sardinian = 'Sardinian'
    sindhi = 'Sindhi'
    northern__sami = 'Northern Sami'
    samoan = 'Samoan'
    sango = 'Sango'
    serbian = 'Serbian'
    scottish__gaelic___gaelic = 'Scottish Gaelic, Gaelic'
    shona = 'Shona'
    sinhala___sinhalese = 'Sinhala, Sinhalese'
    slovak = 'Slovak'
    slovene = 'Slovene'
    somali = 'Somali'
    southern__sotho = 'Southern Sotho'
    spanish___castilian = 'Spanish, Castilian'
    sundanese = 'Sundanese'
    swahili = 'Swahili'
    swati = 'Swati'
    swedish = 'Swedish'
    tamil = 'Tamil'
    telugu = 'Telugu'
    tajik = 'Tajik'
    thai = 'Thai'
    tigrinya = 'Tigrinya'
    tibetan__standard___tibetan___central = 'Tibetan Standard, Tibetan, Central'
    turkmen = 'Turkmen'
    tagalog = 'Tagalog'
    tswana = 'Tswana'
    tonga___tonga__islands_ = 'Tonga (Tonga Islands)'
    turkish = 'Turkish'
    tsonga = 'Tsonga'
    tatar = 'Tatar'
    twi = 'Twi'
    tahitian = 'Tahitian'
    uyghur___uighur = 'Uyghur, Uighur'
    ukrainian = 'Ukrainian'
    urdu = 'Urdu'
    uzbek = 'Uzbek'
    venda = 'Venda'
    vietnamese = 'Vietnamese'
    volapük = 'Volapük'
    walloon = 'Walloon'
    welsh = 'Welsh'
    wolof = 'Wolof'
    western__frisian = 'Western Frisian'
    xhosa = 'Xhosa'
    yiddish = 'Yiddish'
    yoruba = 'Yoruba'
    zhuang___chuang = 'Zhuang, Chuang'
    zulu = 'Zulu'
    not_applicable = 'Not applicable'


class IdType(Enum):
    """
    The type of digital identifier used for this publication (e.g., Digital Object Identifier (DOI)).
    """

    ark = 'ark'
    ar_xiv = 'arXiv'
    bibcode = 'bibcode'
    doi = 'doi'
    ean13 = 'ean13'
    eissn = 'eissn'
    handle = 'handle'
    isbn = 'isbn'
    issn = 'issn'
    istc = 'istc'
    lissn = 'lissn'
    lsid = 'lsid'
    pmid = 'pmid'
    purl = 'purl'
    upc = 'upc'
    url = 'url'
    urn = 'urn'


class RelatedPublication(DataverseBase):
    citation: Optional[str] = Field(
        None,
        description='The full bibliographic citation for this related publication.',
        multiple=False,
        typeClass='primitive',
        typeName='publicationCitation',
    )
    id_type: Optional[IdType] = Field(
        None,
        description='The type of digital identifier used for this publication (e.g., Digital Object Identifier (DOI)).',
        multiple=False,
        typeClass='controlledVocabulary',
        typeName='publicationIDType',
    )
    id_number: Optional[str] = Field(
        None,
        description='The identifier for the selected ID type.',
        multiple=False,
        typeClass='primitive',
        typeName='publicationIDNumber',
    )
    url: Optional[str] = Field(
        None,
        description='Link to the publication web page (e.g., journal article page, archive record page, or other).',
        multiple=False,
        typeClass='primitive',
        typeName='publicationURL',
    )


class Series(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of the dataset series to which the Dataset belongs.',
        multiple=False,
        typeClass='primitive',
        typeName='seriesName',
    )
    information: Optional[str] = Field(
        None,
        description='History of the series and summary of those features that apply to the series as a whole.',
        multiple=False,
        typeClass='primitive',
        typeName='seriesInformation',
    )


class Project(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of the project.',
        multiple=False,
        typeClass='primitive',
        typeName='projectName',
    )
    level: Optional[int] = Field(
        None,
        description='The main project should get level zero. Subprojects can get higher levels.',
        multiple=False,
        typeClass='primitive',
        typeName='projectLevel',
    )


class Contact(DataverseBase):
    name: Optional[str] = Field(
        None,
        description="The contact's Family Name, Given Name or the name of the organization.",
        multiple=False,
        typeClass='primitive',
        typeName='datasetContactName',
    )
    affiliation: Optional[str] = Field(
        None,
        description='The organization with which the contact is affiliated.',
        multiple=False,
        typeClass='primitive',
        typeName='datasetContactAffiliation',
    )
    email: Optional[str] = Field(
        None,
        description='The e-mail address(es) of the contact(s) for the Dataset. This will not be displayed.',
        multiple=False,
        typeClass='primitive',
        typeName='datasetContactEmail',
    )


class Producer(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Producer name',
        multiple=False,
        typeClass='primitive',
        typeName='producerName',
    )
    affiliation: Optional[str] = Field(
        None,
        description='The organization with which the producer is affiliated.',
        multiple=False,
        typeClass='primitive',
        typeName='producerAffiliation',
    )
    abbreviation: Optional[str] = Field(
        None,
        description='The abbreviation by which the producer is commonly known. (ex. IQSS, ICPSR)',
        multiple=False,
        typeClass='primitive',
        typeName='producerAbbreviation',
    )
    url: Optional[str] = Field(
        None,
        description="Producer URL points to the producer's web presence, if appropriate. Enter an absolute URL where the producer's web site is found, such as http://www.my.org.  ",
        multiple=False,
        typeClass='primitive',
        typeName='producerURL',
    )
    logo_url: Optional[str] = Field(
        None,
        description="URL for the producer's logo, which points to this  producer's web-accessible logo image. Enter an absolute URL where the producer's logo image is found, such as http://www.my.org/images/logo.gif.",
        multiple=False,
        typeClass='primitive',
        typeName='producerLogoURL',
    )


class Distributor(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Distributor name',
        multiple=False,
        typeClass='primitive',
        typeName='distributorName',
    )
    affiliation: Optional[str] = Field(
        None,
        description='The organization with which the distributor contact is affiliated.',
        multiple=False,
        typeClass='primitive',
        typeName='distributorAffiliation',
    )
    abbreviation: Optional[str] = Field(
        None,
        description='The abbreviation by which this distributor is commonly known (e.g., IQSS, ICPSR).',
        multiple=False,
        typeClass='primitive',
        typeName='distributorAbbreviation',
    )
    url: Optional[str] = Field(
        None,
        description="Distributor URL points to the distributor's web presence, if appropriate. Enter an absolute URL where the distributor's web site is found, such as http://www.my.org.",
        multiple=False,
        typeClass='primitive',
        typeName='distributorURL',
    )
    logo_url: Optional[str] = Field(
        None,
        description="URL of the distributor's logo, which points to this  distributor's web-accessible logo image. Enter an absolute URL where the distributor's logo image is found, such as http://www.my.org/images/logo.gif.",
        multiple=False,
        typeClass='primitive',
        typeName='distributorLogoURL',
    )


class DateOfCollection(DataverseBase):
    start: Optional[str] = Field(
        None,
        description='Date when the data collection started.',
        multiple=False,
        typeClass='primitive',
        typeName='dateOfCollectionStart',
    )
    end: Optional[str] = Field(
        None,
        description='Date when the data collection ended.',
        multiple=False,
        typeClass='primitive',
        typeName='dateOfCollectionEnd',
    )


class Software(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='Name of software used to generate the Dataset.',
        multiple=False,
        typeClass='controlledVocabulary',
        typeName='softwareName',
    )
    version: Optional[str] = Field(
        None,
        description='Version of the software used to generate the Dataset.',
        multiple=False,
        typeClass='primitive',
        typeName='softwareVersion',
    )


class IdentifierScheme(Enum):
    """
    Name of the identifier scheme (ORCID, ISNI).
    """

    orcid = 'ORCID'
    isni = 'ISNI'
    lcna = 'LCNA'
    viaf = 'VIAF'
    gnd = 'GND'
    dai = 'DAI'
    researcher_id = 'ResearcherID'
    scopus_id = 'ScopusID'


class Author(DataverseBase):
    name: Optional[str] = Field(
        None,
        description="The author's Family Name, Given Name or the name of the organization responsible for this Dataset.",
        multiple=False,
        typeClass='primitive',
        typeName='authorName',
    )
    affiliation: Optional[str] = Field(
        None,
        description='The organization with which the author is affiliated.',
        multiple=False,
        typeClass='primitive',
        typeName='authorAffiliation',
    )
    identifier_scheme: Optional[IdentifierScheme] = Field(
        None,
        description='Name of the identifier scheme (ORCID, ISNI).',
        multiple=False,
        typeClass='controlledVocabulary',
        typeName='authorIdentifierScheme',
    )
    identifier: Optional[str] = Field(
        None,
        description='Uniquely identifies an individual author or organization, according to various schemes.',
        multiple=False,
        typeClass='primitive',
        typeName='authorIdentifier',
    )


class OtherId(DataverseBase):
    agency: Optional[str] = Field(
        None,
        description='Name of agency which generated this identifier.',
        multiple=False,
        typeClass='primitive',
        typeName='otherIdAgency',
    )
    identifier: Optional[str] = Field(
        None,
        description='Other identifier that corresponds to this Dataset.',
        multiple=False,
        typeClass='primitive',
        typeName='otherIdValue',
    )


class TimePeriodCovered(DataverseBase):
    start: Optional[str] = Field(
        None,
        description='Start date which reflects the time period covered by the data, not the dates of coding or making documents machine-readable or the dates the data were collected.',
        multiple=False,
        typeClass='primitive',
        typeName='timePeriodCoveredStart',
    )
    end: Optional[str] = Field(
        None,
        description='End date which reflects the time period covered by the data, not the dates of coding or making documents machine-readable or the dates the data were collected.',
        multiple=False,
        typeClass='primitive',
        typeName='timePeriodCoveredEnd',
    )


class Storage(DataverseBase):
    name: Optional[str] = Field(
        None,
        description='The name of the file, directory or archive.',
        multiple=False,
        typeClass='primitive',
        typeName='storageFile',
    )
    location: Optional[str] = Field(
        None,
        description='The dns, path or url of the location the object is stored. ',
        multiple=False,
        typeClass='primitive',
        typeName='storageLocation',
    )
    size: Optional[str] = Field(
        None,
        description='The approximated size of the object. Give also Units.',
        multiple=False,
        typeClass='primitive',
        typeName='storageSize',
    )


class GrantInformation(DataverseBase):
    grant_agency: Optional[str] = Field(
        None,
        description='Grant Number Agency',
        multiple=False,
        typeClass='primitive',
        typeName='grantNumberAgency',
    )
    grant_number: Optional[str] = Field(
        None,
        description='The grant or contract number of the project that  sponsored the effort.',
        multiple=False,
        typeClass='primitive',
        typeName='grantNumberValue',
    )


class Description(DataverseBase):
    text: Optional[str] = Field(
        None,
        description='A summary describing the purpose, nature, and scope of the Dataset.',
        multiple=False,
        typeClass='primitive',
        typeName='dsDescriptionValue',
    )
    date: Optional[str] = Field(
        None,
        description='In cases where a Dataset contains more than one description (for example, one might be supplied by the data producer and another prepared by the data repository where the data are deposited), the date attribute is used to distinguish between the two descriptions. The date attribute follows the ISO convention of YYYY-MM-DD.',
        multiple=False,
        typeClass='primitive',
        typeName='dsDescriptionDate',
    )


class Type(Enum):
    """
    The type of contributor of the  resource.
    """

    data__collector = 'Data Collector'
    data__curator = 'Data Curator'
    data__manager = 'Data Manager'
    editor = 'Editor'
    funder = 'Funder'
    hosting__institution = 'Hosting Institution'
    project__leader = 'Project Leader'
    project__manager = 'Project Manager'
    project__member = 'Project Member'
    related__person = 'Related Person'
    researcher = 'Researcher'
    research__group = 'Research Group'
    rights__holder = 'Rights Holder'
    sponsor = 'Sponsor'
    supervisor = 'Supervisor'
    work__package__leader = 'Work Package Leader'
    other = 'Other'


class Contributor(DataverseBase):
    type: Optional[Type] = Field(
        None,
        description='The type of contributor of the  resource.  ',
        multiple=False,
        typeClass='controlledVocabulary',
        typeName='contributorType',
    )
    name: Optional[str] = Field(
        None,
        description='The Family Name, Given Name or organization name of the contributor.',
        multiple=False,
        typeClass='primitive',
        typeName='contributorName',
    )


class TopicClassification(DataverseBase):
    term: Optional[str] = Field(
        None,
        description='Topic or Subject term that is relevant to this Dataset.',
        multiple=False,
        typeClass='primitive',
        typeName='topicClassValue',
    )
    vocabulary: Optional[str] = Field(
        None,
        description='Provided for specification of the controlled vocabulary in use, e.g., LCSH, MeSH, etc.',
        multiple=False,
        typeClass='primitive',
        typeName='topicClassVocab',
    )
    vocabulary_url: Optional[str] = Field(
        None,
        description='Specifies the URL location for the full controlled vocabulary.',
        multiple=False,
        typeClass='primitive',
        typeName='topicClassVocabURI',
    )


class Keyword(DataverseBase):
    term: Optional[str] = Field(
        None,
        description='Key terms that describe important aspects of the Dataset. Can be used for building keyword indexes and for classification and retrieval purposes. A controlled vocabulary can be employed. The vocab attribute is provided for specification of the controlled vocabulary in use, such as LCSH, MeSH, or others. The vocabURI attribute specifies the location for the full controlled vocabulary.',
        multiple=False,
        typeClass='primitive',
        typeName='keywordValue',
    )
    vocabulary: Optional[str] = Field(
        None,
        description='For the specification of the keyword controlled vocabulary in use, such as LCSH, MeSH, or others.',
        multiple=False,
        typeClass='primitive',
        typeName='keywordVocabulary',
    )
    vocabulary_url: Optional[str] = Field(
        None,
        description='Keyword vocabulary URL points to the web presence that describes the keyword vocabulary, if appropriate. Enter an absolute URL where the keyword vocabulary web site is found, such as http://www.my.org.',
        multiple=False,
        typeClass='primitive',
        typeName='keywordVocabularyURI',
    )


class Citation(DataverseBase):
    title: Optional[str] = Field(
        None,
        description='Full title by which the Dataset is known.',
        multiple=False,
        typeClass='primitive',
        typeName='title',
    )
    subtitle: Optional[str] = Field(
        None,
        description='A secondary title used to amplify or state certain limitations on the main title.',
        multiple=False,
        typeClass='primitive',
        typeName='subtitle',
    )
    alternative_title: Optional[str] = Field(
        None,
        description='A title by which the work is commonly referred, or an abbreviation of the title.',
        multiple=False,
        typeClass='primitive',
        typeName='alternativeTitle',
    )
    alternative_url: Optional[str] = Field(
        None,
        description='A URL where the dataset can be viewed, such as a personal or project website.  ',
        multiple=False,
        typeClass='primitive',
        typeName='alternativeURL',
    )
    subject: Optional[list[SubjectEnum]] = Field(
        None,
        description='Domain-specific Subject Categories that are topically relevant to the Dataset.',
        multiple=True,
        typeClass='controlledVocabulary',
        typeName='subject',
    )
    notes: Optional[str] = Field(
        None,
        description='Additional important information about the Dataset.',
        multiple=False,
        typeClass='primitive',
        typeName='notesText',
    )
    language: Optional[Union[list, Language]] = Field(
        None,
        description='Language of the Dataset',
        multiple=True,
        typeClass='controlledVocabulary',
        typeName='language',
    )
    production_date: Optional[str] = Field(
        None,
        description='Date when the data collection or other materials were produced (not distributed, published or archived).',
        multiple=False,
        typeClass='primitive',
        typeName='productionDate',
    )
    production_place: Optional[str] = Field(
        None,
        description='The location where the data collection and any other related materials were produced.',
        multiple=False,
        typeClass='primitive',
        typeName='productionPlace',
    )
    distribution_date: Optional[str] = Field(
        None,
        description='Date that the work was made available for distribution/presentation.',
        multiple=False,
        typeClass='primitive',
        typeName='distributionDate',
    )
    depositor: Optional[str] = Field(
        None,
        description='The person (Family Name, Given Name) or the name of the organization that deposited this Dataset to the repository.',
        multiple=False,
        typeClass='primitive',
        typeName='depositor',
    )
    deposit_date: Optional[str] = Field(
        None,
        description='Date that the Dataset was deposited into the repository.',
        multiple=False,
        typeClass='primitive',
        typeName='dateOfDeposit',
    )
    kind_of_data: Optional[list] = Field(
        None,
        description='Type of data included in the file: survey data, census/enumeration data, aggregate data, clinical data, event/transaction data, program source code, machine-readable text, administrative records data, experimental data, psychological test, textual data, coded textual, coded documents, time budget diaries, observation data/ratings, process-produced data, or other.',
        multiple=True,
        typeClass='primitive',
        typeName='kindOfData',
    )
    related_material: Optional[list] = Field(
        None,
        description='Any material related to this Dataset.',
        multiple=True,
        typeClass='primitive',
        typeName='relatedMaterial',
    )
    related_datasets: Optional[list] = Field(
        None,
        description='Any Datasets that are related to this Dataset, such as previous research on this subject.',
        multiple=True,
        typeClass='primitive',
        typeName='relatedDatasets',
    )
    other_references: Optional[list] = Field(
        None,
        description='Any references that would serve as background or supporting material to this Dataset.',
        multiple=True,
        typeClass='primitive',
        typeName='otherReferences',
    )
    data_sources: Optional[list] = Field(
        None,
        description='List of books, articles, serials, or machine-readable data files that served as the sources of the data collection.',
        multiple=True,
        typeClass='primitive',
        typeName='dataSources',
    )
    origin_of_sources: Optional[str] = Field(
        None,
        description='For historical materials, information about the origin of the sources and the rules followed in establishing the sources should be specified.',
        multiple=False,
        typeClass='primitive',
        typeName='originOfSources',
    )
    characteristic_of_sources_noted: Optional[str] = Field(
        None,
        description='Assessment of characteristics and source material.',
        multiple=False,
        typeClass='primitive',
        typeName='characteristicOfSources',
    )
    documentation_and_access_to_sources: Optional[str] = Field(
        None,
        description='Level of documentation of the original sources.',
        multiple=False,
        typeClass='primitive',
        typeName='accessToSources',
    )
    did_it_work: Optional[str] = Field(
        None,
        description='Not only positive analyses are worthwhile to share. Negative results prevent others from doing the same mistakes.',
        multiple=False,
        typeClass='primitive',
        typeName='worked',
    )
    explanation: Optional[str] = Field(
        None,
        description='Description of your last answer. Explanation why it worked or not.',
        multiple=False,
        typeClass='primitive',
        typeName='workedNote',
    )
    related_publication: list[RelatedPublication] = Field(
        default_factory=list,
        description='Publications that use the data from this Dataset. The full list of Related Publications will be displayed on the metadata tab.',
        multiple=True,
        typeClass='compound',
        typeName='publication',
    )
    series: list[Series] = Field(
        default_factory=list,
        description='Information about the Dataset series.',
        multiple=True,
        typeClass='compound',
        typeName='series',
    )
    project: list[Project] = Field(
        default_factory=list,
        description='Information about the project as context of the data.',
        multiple=True,
        typeClass='compound',
        typeName='project',
    )
    contact: list[Contact] = Field(
        default_factory=list,
        description='The contact(s) for this Dataset.',
        multiple=True,
        typeClass='compound',
        typeName='datasetContact',
    )
    producer: list[Producer] = Field(
        default_factory=list,
        description='Person or organization with the financial or administrative responsibility over this Dataset',
        multiple=True,
        typeClass='compound',
        typeName='producer',
    )
    distributor: list[Distributor] = Field(
        default_factory=list,
        description='The organization designated by the author or producer to generate copies of the particular work including any necessary editions or revisions.',
        multiple=True,
        typeClass='compound',
        typeName='distributor',
    )
    date_of_collection: list[DateOfCollection] = Field(
        default_factory=list,
        description='Contains the date(s) when the data were collected.',
        multiple=True,
        typeClass='compound',
        typeName='dateOfCollection',
    )
    software: list[Software] = Field(
        default_factory=list,
        description='Information about the software used to generate the Dataset.',
        multiple=True,
        typeClass='compound',
        typeName='software',
    )
    author: list[Author] = Field(
        default_factory=list,
        description='The person(s), corporate body(ies), or agency(ies) responsible for creating the work.',
        multiple=True,
        typeClass='compound',
        typeName='author',
    )
    other_id: list[OtherId] = Field(
        default_factory=list,
        description="Another unique identifier that identifies this Dataset (e.g., producer's or another repository's number).",
        multiple=True,
        typeClass='compound',
        typeName='otherId',
    )
    time_period_covered: list[TimePeriodCovered] = Field(
        default_factory=list,
        description='Time period to which the data refer. This item reflects the time period covered by the data, not the dates of coding or making documents machine-readable or the dates the data were collected. Also known as span.',
        multiple=True,
        typeClass='compound',
        typeName='timePeriodCovered',
    )
    storage: list[Storage] = Field(
        default_factory=list,
        description='Information about data that could NOT be uploaded into the system.',
        multiple=True,
        typeClass='compound',
        typeName='storage',
    )
    grant_information: list[GrantInformation] = Field(
        default_factory=list,
        description='Grant Information',
        multiple=True,
        typeClass='compound',
        typeName='grantNumber',
    )
    description: list[Description] = Field(
        default_factory=list,
        description='A summary describing the purpose, nature, and scope of the Dataset.',
        multiple=True,
        typeClass='compound',
        typeName='dsDescription',
    )
    contributor: list[Contributor] = Field(
        default_factory=list,
        description='The organization or person responsible for either collecting, managing, or otherwise contributing in some form to the development of the resource.',
        multiple=True,
        typeClass='compound',
        typeName='contributor',
    )
    topic_classification: list[TopicClassification] = Field(
        default_factory=list,
        description='The classification field indicates the broad important topic(s) and subjects that the data cover. Library of Congress subject terms may be used here.  ',
        multiple=True,
        typeClass='compound',
        typeName='topicClassification',
    )
    keyword: list[Keyword] = Field(
        default_factory=list,
        description='Key terms that describe important aspects of the Dataset.',
        multiple=True,
        typeClass='compound',
        typeName='keyword',
    )
    _metadatablock_name: Optional[str] = 'citation'


    def add_author(
        self,
        name: Optional[str] = None,
        affiliation: Optional[str] = None,
        identifier_scheme: Optional[IdentifierScheme] = None,
        identifier: Optional[str] = None,
    ):
        """Function used to add an instance of Author to the metadatablock.

        Args:
        
            name (string): The author's Family Name, Given Name or the name of the organization responsible for this Dataset.
            affiliation (string): The organization with which the author is affiliated.
            identifier_scheme (Enum): Name of the identifier scheme (ORCID, ISNI).
            identifier (string): Uniquely identifies an individual author or organization, according to various schemes.

        """

        self.author.append(
            Author(
                name=name, affiliation=affiliation, identifier_scheme=identifier_scheme, identifier=identifier
            )
        )


    def add_contact(
        self,
        name: Optional[str] = None,
        affiliation: Optional[str] = None,
        email: Optional[str] = None,
    ):
        """Function used to add an instance of Contact to the metadatablock.

        Args:
        
            name (string): The contact's Family Name, Given Name or the name of the organization.
            affiliation (string): The organization with which the contact is affiliated.
            email (string): The e-mail address(es) of the contact(s) for the Dataset. This will not be displayed.

        """

        self.contact.append(
            Contact(
                name=name, affiliation=affiliation, email=email
            )
        )


    def add_contributor(
        self,
        type: Optional[Type] = None,
        name: Optional[str] = None,
    ):
        """Function used to add an instance of Contributor to the metadatablock.

        Args:
        
            type (Enum): The type of contributor of the  resource.  
            name (string): The Family Name, Given Name or organization name of the contributor.

        """

        self.contributor.append(
            Contributor(
                type=type, name=name
            )
        )


    def add_date_of_collection(
        self,
        start: Optional[str] = None,
        end: Optional[str] = None,
    ):
        """Function used to add an instance of DateOfCollection to the metadatablock.

        Args:
        
            start (string): Date when the data collection started.
            end (string): Date when the data collection ended.

        """

        self.date_of_collection.append(
            DateOfCollection(
                start=start, end=end
            )
        )


    def add_description(
        self,
        text: Optional[str] = None,
        date: Optional[str] = None,
    ):
        """Function used to add an instance of Description to the metadatablock.

        Args:
        
            text (string): A summary describing the purpose, nature, and scope of the Dataset.
            date (string): In cases where a Dataset contains more than one description (for example, one might be supplied by the data producer and another prepared by the data repository where the data are deposited), the date attribute is used to distinguish between the two descriptions. The date attribute follows the ISO convention of YYYY-MM-DD.

        """

        self.description.append(
            Description(
                text=text, date=date
            )
        )


    def add_distributor(
        self,
        name: Optional[str] = None,
        affiliation: Optional[str] = None,
        abbreviation: Optional[str] = None,
        url: Optional[str] = None,
        logo_url: Optional[str] = None,
    ):
        """Function used to add an instance of Distributor to the metadatablock.

        Args:
        
            name (string): Distributor name
            affiliation (string): The organization with which the distributor contact is affiliated.
            abbreviation (string): The abbreviation by which this distributor is commonly known (e.g., IQSS, ICPSR).
            url (string): Distributor URL points to the distributor's web presence, if appropriate. Enter an absolute URL where the distributor's web site is found, such as http://www.my.org.
            logo_url (string): URL of the distributor's logo, which points to this  distributor's web-accessible logo image. Enter an absolute URL where the distributor's logo image is found, such as http://www.my.org/images/logo.gif.

        """

        self.distributor.append(
            Distributor(
                name=name, affiliation=affiliation, abbreviation=abbreviation, url=url, logo_url=logo_url
            )
        )


    def add_grant_information(
        self,
        grant_agency: Optional[str] = None,
        grant_number: Optional[str] = None,
    ):
        """Function used to add an instance of GrantInformation to the metadatablock.

        Args:
        
            grant_agency (string): Grant Number Agency
            grant_number (string): The grant or contract number of the project that  sponsored the effort.

        """

        self.grant_information.append(
            GrantInformation(
                grant_agency=grant_agency, grant_number=grant_number
            )
        )


    def add_keyword(
        self,
        term: Optional[str] = None,
        vocabulary: Optional[str] = None,
        vocabulary_url: Optional[str] = None,
    ):
        """Function used to add an instance of Keyword to the metadatablock.

        Args:
        
            term (string): Key terms that describe important aspects of the Dataset. Can be used for building keyword indexes and for classification and retrieval purposes. A controlled vocabulary can be employed. The vocab attribute is provided for specification of the controlled vocabulary in use, such as LCSH, MeSH, or others. The vocabURI attribute specifies the location for the full controlled vocabulary.
            vocabulary (string): For the specification of the keyword controlled vocabulary in use, such as LCSH, MeSH, or others.
            vocabulary_url (string): Keyword vocabulary URL points to the web presence that describes the keyword vocabulary, if appropriate. Enter an absolute URL where the keyword vocabulary web site is found, such as http://www.my.org.

        """

        self.keyword.append(
            Keyword(
                term=term, vocabulary=vocabulary, vocabulary_url=vocabulary_url
            )
        )


    def add_other_id(
        self,
        agency: Optional[str] = None,
        identifier: Optional[str] = None,
    ):
        """Function used to add an instance of OtherId to the metadatablock.

        Args:
        
            agency (string): Name of agency which generated this identifier.
            identifier (string): Other identifier that corresponds to this Dataset.

        """

        self.other_id.append(
            OtherId(
                agency=agency, identifier=identifier
            )
        )


    def add_producer(
        self,
        name: Optional[str] = None,
        affiliation: Optional[str] = None,
        abbreviation: Optional[str] = None,
        url: Optional[str] = None,
        logo_url: Optional[str] = None,
    ):
        """Function used to add an instance of Producer to the metadatablock.

        Args:
        
            name (string): Producer name
            affiliation (string): The organization with which the producer is affiliated.
            abbreviation (string): The abbreviation by which the producer is commonly known. (ex. IQSS, ICPSR)
            url (string): Producer URL points to the producer's web presence, if appropriate. Enter an absolute URL where the producer's web site is found, such as http://www.my.org.  
            logo_url (string): URL for the producer's logo, which points to this  producer's web-accessible logo image. Enter an absolute URL where the producer's logo image is found, such as http://www.my.org/images/logo.gif.

        """

        self.producer.append(
            Producer(
                name=name, affiliation=affiliation, abbreviation=abbreviation, url=url, logo_url=logo_url
            )
        )


    def add_project(
        self,
        name: Optional[str] = None,
        level: Optional[int] = None,
    ):
        """Function used to add an instance of Project to the metadatablock.

        Args:
        
            name (string): Name of the project.
            level (integer): The main project should get level zero. Subprojects can get higher levels.

        """

        self.project.append(
            Project(
                name=name, level=level
            )
        )


    def add_related_publication(
        self,
        citation: Optional[str] = None,
        id_type: Optional[IdType] = None,
        id_number: Optional[str] = None,
        url: Optional[str] = None,
    ):
        """Function used to add an instance of RelatedPublication to the metadatablock.

        Args:
        
            citation (string): The full bibliographic citation for this related publication.
            id_type (Enum): The type of digital identifier used for this publication (e.g., Digital Object Identifier (DOI)).
            id_number (string): The identifier for the selected ID type.
            url (string): Link to the publication web page (e.g., journal article page, archive record page, or other).

        """

        self.related_publication.append(
            RelatedPublication(
                citation=citation, id_type=id_type, id_number=id_number, url=url
            )
        )


    def add_series(
        self,
        name: Optional[str] = None,
        information: Optional[str] = None,
    ):
        """Function used to add an instance of Series to the metadatablock.

        Args:
        
            name (string): Name of the dataset series to which the Dataset belongs.
            information (string): History of the series and summary of those features that apply to the series as a whole.

        """

        self.series.append(
            Series(
                name=name, information=information
            )
        )


    def add_software(
        self,
        name: Optional[str] = None,
        version: Optional[str] = None,
    ):
        """Function used to add an instance of Software to the metadatablock.

        Args:
        
            name (string): Name of software used to generate the Dataset.
            version (string): Version of the software used to generate the Dataset.

        """

        self.software.append(
            Software(
                name=name, version=version
            )
        )


    def add_storage(
        self,
        name: Optional[str] = None,
        location: Optional[str] = None,
        size: Optional[str] = None,
    ):
        """Function used to add an instance of Storage to the metadatablock.

        Args:
        
            name (string): The name of the file, directory or archive.
            location (string): The dns, path or url of the location the object is stored. 
            size (string): The approximated size of the object. Give also Units.

        """

        self.storage.append(
            Storage(
                name=name, location=location, size=size
            )
        )


    def add_time_period_covered(
        self,
        start: Optional[str] = None,
        end: Optional[str] = None,
    ):
        """Function used to add an instance of TimePeriodCovered to the metadatablock.

        Args:
        
            start (string): Start date which reflects the time period covered by the data, not the dates of coding or making documents machine-readable or the dates the data were collected.
            end (string): End date which reflects the time period covered by the data, not the dates of coding or making documents machine-readable or the dates the data were collected.

        """

        self.time_period_covered.append(
            TimePeriodCovered(
                start=start, end=end
            )
        )


    def add_topic_classification(
        self,
        term: Optional[str] = None,
        vocabulary: Optional[str] = None,
        vocabulary_url: Optional[str] = None,
    ):
        """Function used to add an instance of TopicClassification to the metadatablock.

        Args:
        
            term (string): Topic or Subject term that is relevant to this Dataset.
            vocabulary (string): Provided for specification of the controlled vocabulary in use, e.g., LCSH, MeSH, etc.
            vocabulary_url (string): Specifies the URL location for the full controlled vocabulary.

        """

        self.topic_classification.append(
            TopicClassification(
                term=term, vocabulary=vocabulary, vocabulary_url=vocabulary_url
            )
        )
