# generated by datamodel-codegen:
#   filename:  archive.json
#   timestamp: 2022-01-18T11:10:50+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from easyDataverse.core import DataverseBase
from pydantic import Field


class ArchivedFor(Enum):
    """
    The period for which the record is to be archived.
    """

    field_1_year = '1 year'
    field_3_years = '3 years'
    field_5_years = '5 years'
    field_10_years = '10 years'


class Archive(DataverseBase):
    active_until: Optional[str] = Field(
        None,
        description='A date (YYYY-MM-DD) up to which the data set is in the active state',
        multiple=False,
        typeClass='primitive',
        typeName='archiveActiveUntil',
    )
    archived_from: Optional[str] = Field(
        None,
        description='A date (YYYY-MM-DD) from whith the data set is archived',
        multiple=False,
        typeClass='primitive',
        typeName='archiveArchivedFrom',
    )
    archived_for: Optional[ArchivedFor] = Field(
        None,
        description='The period for which the record is to be archived. ',
        multiple=False,
        typeClass='controlledVocabulary',
        typeName='archiveArchivedFor',
    )
    archived_at: Optional[list] = Field(
        None,
        description='The location where the files are archived',
        multiple=True,
        typeClass='primitive',
        typeName='archiveArchivedAt',
    )
    _metadatablock_name: Optional[str] = 'archive'
