# Generated by Django 4.0.5 on 2022-06-25 20:57

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        (
            "edc_protocol_violation",
            "0005_protocolincident_historicalprotocolincident_and_more",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="ProtocolIncidents",
            fields=[
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        help_text="This is the stored value, required",
                        max_length=250,
                        unique=True,
                        verbose_name="Stored value",
                    ),
                ),
                (
                    "display_name",
                    models.CharField(
                        db_index=True,
                        help_text="(suggest 40 characters max.)",
                        max_length=250,
                        unique=True,
                        verbose_name="Name",
                    ),
                ),
                (
                    "display_index",
                    models.IntegerField(
                        db_index=True,
                        default=0,
                        help_text="Index to control display order if not alphabetical, not required",
                        verbose_name="display index",
                    ),
                ),
                (
                    "field_name",
                    models.CharField(
                        blank=True,
                        editable=False,
                        help_text="Not required",
                        max_length=25,
                        null=True,
                    ),
                ),
                ("version", models.CharField(default="1.0", editable=False, max_length=35)),
                ("id", models.AutoField(primary_key=True, serialize=False)),
            ],
            options={
                "verbose_name": "Protocol Incidents",
                "verbose_name_plural": "Protocol Incidents",
                "ordering": ["display_index", "display_name"],
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
        ),
        migrations.AddIndex(
            model_name="protocolincidents",
            index=models.Index(
                fields=["id", "display_name", "display_index"],
                name="edc_protoco_id_7ee7c7_idx",
            ),
        ),
    ]
