"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeployAssert = void 0;
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const assertions_1 = require("../assertions");
const hash_1 = require("../private/hash");
const sdk_1 = require("../sdk");
const DEPLOY_ASSERT_SYMBOL = Symbol.for('@aws-cdk/integ-tests.DeployAssert');
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Construct that allows for registering a list of assertions
 * that should be performed on a construct
 */
class DeployAssert extends core_2.Construct {
    constructor(scope) {
        super(scope, 'Default');
        this.scope = new core_1.Stack(scope, 'DeployAssert');
        Object.defineProperty(this, DEPLOY_ASSERT_SYMBOL, { value: true });
    }
    /**
     * Returns whether the construct is a DeployAssert construct
     */
    static isDeployAssert(x) {
        return x !== null && typeof (x) === 'object' && DEPLOY_ASSERT_SYMBOL in x;
    }
    /**
     * Finds a DeployAssert construct in the given scope
     */
    static of(construct) {
        const scopes = constructs_1.Node.of(constructs_1.Node.of(construct).root).findAll();
        const deployAssert = scopes.find(s => DeployAssert.isDeployAssert(s));
        if (!deployAssert) {
            throw new Error('No DeployAssert construct found in scopes');
        }
        return deployAssert;
    }
    awsApiCall(service, api, parameters) {
        return new sdk_1.AwsApiCall(this.scope, `AwsApiCall${service}${api}`, {
            api,
            service,
            parameters,
        });
    }
    invokeFunction(props) {
        const hash = hash_1.md5hash(this.scope.resolve(props));
        return new sdk_1.LambdaInvokeFunction(this.scope, `LambdaInvoke${hash}`, props);
    }
    expect(id, expected, actual) {
        new assertions_1.EqualsAssertion(this.scope, `EqualsAssertion${id}`, {
            expected,
            actual,
        });
    }
}
exports.DeployAssert = DeployAssert;
//# sourceMappingURL=data:application/json;base64,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