# -*- coding: utf-8 -*-

from setuptools import setup, find_packages

version = '2.0.0'

long_description = '\n\n'.join([
    open('README.rst').read(),
    open('CONTRIBUTORS.rst').read(),
    open('CHANGES.rst').read(),
])

setup(
    name='plone.formwidget.masterselect',
    version=version,
    description='A z3c.form widget that controls the vocabulary or '
                'display of other fields on an edit page',
    long_description=long_description,
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Web Environment',
        'Framework :: Plone',
        'Framework :: Plone :: 5.2',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Operating System :: OS Independent',
        'Programming Language :: JavaScript',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Software Development :: Widget Sets',
    ],
    keywords='plone widget',
    author='Jason Mehring',
    author_email='nrgaway@yahoo.com',
    url='https://github.com/collective/plone.formwidget.masterselect',
    license='GPL',
    packages=find_packages(exclude=['ez_setup']),
    namespace_packages=['plone', 'plone.formwidget'],
    include_package_data=True,
    zip_safe=False,
    install_requires=[
        'setuptools',
        'z3c.form',
        'plone.supermodel',
        'plone.z3cform',
    ],
    extras_require={
        'test': [
            'plone.app.testing [robot] >= 4.2.2',
            'plone.app.robotframework',
            'plone.app.dexterity',
        ],
    },
    entry_points="""
    # -*- Entry points: -*-
    [z3c.autoinclude.plugin]
    target = plone
    """,
)
