Thank you for your contribution to OpenAGI!
Before submitting the pull request, please ensure **the PR meets the following criteria**! This helps improve the efficiency of the review process.

### Code Quality
Before submitting your PR, you need to follow the steps below to maintain code quality.
- Use `pip install -r requirements-dev.txt` to install the extra dependencies in requirements-dev.txt for the following checks.
- Use `pre-commit install` to install pre-commit locally before you commit messages. The pre-commit can help correct the style that are added or modified.
- Use `pytest -v tests/` to run the test code and make sure it passes all the checks.

### PR title and classification
Only specific types of PRs will be reviewed. The PR title is prefixed appropriately (i.e., "prefix: description") to indicate the type of change. Please use one of the prefixs as below:
- `feat` Add new features
- `fix`  Fix bugs
- `docs` Modify documents like README, CONTRIBUTE
- `style` Modify code format like space and comma without changing code logic
- `refactor` Refactor code structure without adding new features or fixing new bugs
- `perf` Improve performance or user experience
- `test` Test features, including unit test and integration test
- `chore` Change the build procedure or add dependencies
- `revert` Revert to the previous version

### PR messages
- **Description:** a description of the change
- **Issue:** the issue # it fixes, if applicable
- **Dependencies:** any dependencies required for this change

### For the Reviews
- After the PR is submitted, the PR will be assigned to a reviewer. Every reviewer will pick up the PRs based on their expertise and availability.
- If no one reviews your PR within a few days, please @-mention one of [dongyuanjushi](https://github.com/dongyuanjushi/), [evison](https://github.com/evison), [Wenyueh](https://github.com/Wenyueh), [BRama10](https://github.com/BRama10).
