# coding: utf-8

"""
    Marketing Events Extension

    These APIs allow you to interact with HubSpot's Marketing Events Extension. It allows you to: * Create, Read or update Marketing Event information in HubSpot * Specify whether a HubSpot contact has registered, attended or cancelled a registration to a Marketing Event. * Specify a URL that can be called to get the details of a Marketing Event.   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.marketing.events.api_client import ApiClient
from hubspot.marketing.events.exceptions import ApiTypeError, ApiValueError


class AttendanceSubscriberStateChangesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, external_event_id, subscriber_state, batch_input_marketing_event_subscriber, **kwargs):  # noqa: E501
        """Record  # noqa: E501

        Record a subscription state between multiple HubSpot contacts and a marketing event, using HubSpot contact ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(external_event_id, subscriber_state, batch_input_marketing_event_subscriber, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: The id of the marketing event (required)
        :param str subscriber_state: The new subscriber state for the HubSpot contacts and the specified marketing event. For example: 'register', 'attend' or 'cancel'. (required)
        :param BatchInputMarketingEventSubscriber batch_input_marketing_event_subscriber: The details of the contacts to subscribe to the event. Parameters of join and left time if state is Attended. (required)
        :param str external_account_id: The account id associated with the marketing event
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchResponseSubscriberVidResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_with_http_info(external_event_id, subscriber_state, batch_input_marketing_event_subscriber, **kwargs)  # noqa: E501

    def create_with_http_info(self, external_event_id, subscriber_state, batch_input_marketing_event_subscriber, **kwargs):  # noqa: E501
        """Record  # noqa: E501

        Record a subscription state between multiple HubSpot contacts and a marketing event, using HubSpot contact ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(external_event_id, subscriber_state, batch_input_marketing_event_subscriber, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: The id of the marketing event (required)
        :param str subscriber_state: The new subscriber state for the HubSpot contacts and the specified marketing event. For example: 'register', 'attend' or 'cancel'. (required)
        :param BatchInputMarketingEventSubscriber batch_input_marketing_event_subscriber: The details of the contacts to subscribe to the event. Parameters of join and left time if state is Attended. (required)
        :param str external_account_id: The account id associated with the marketing event
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchResponseSubscriberVidResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "subscriber_state", "batch_input_marketing_event_subscriber", "external_account_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method create" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `create`")  # noqa: E501
        # verify the required parameter 'subscriber_state' is set
        if self.api_client.client_side_validation and ("subscriber_state" not in local_var_params or local_var_params["subscriber_state"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscriber_state` when calling `create`")  # noqa: E501
        # verify the required parameter 'batch_input_marketing_event_subscriber' is set
        if self.api_client.client_side_validation and (
            "batch_input_marketing_event_subscriber" not in local_var_params or local_var_params["batch_input_marketing_event_subscriber"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_marketing_event_subscriber` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501
        if "subscriber_state" in local_var_params:
            path_params["subscriberState"] = local_var_params["subscriber_state"]  # noqa: E501

        query_params = []
        if "external_account_id" in local_var_params and local_var_params["external_account_id"] is not None:  # noqa: E501
            query_params.append(("externalAccountId", local_var_params["external_account_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_marketing_event_subscriber" in local_var_params:
            body_params = local_var_params["batch_input_marketing_event_subscriber"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/attendance/{externalEventId}/{subscriberState}/create",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BatchResponseSubscriberVidResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_by_email(self, external_event_id, subscriber_state, batch_input_marketing_event_email_subscriber, **kwargs):  # noqa: E501
        """Record  # noqa: E501

        Record a subscription state between multiple HubSpot contacts and a marketing event, using contact email addresses. If contact is not present it will be automatically created. If you set params   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_by_email(external_event_id, subscriber_state, batch_input_marketing_event_email_subscriber, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: The id of the marketing event (required)
        :param str subscriber_state: The new subscriber state for the HubSpot contacts and the specified marketing event. For example: 'register', 'attend' or 'cancel'. (required)
        :param BatchInputMarketingEventEmailSubscriber batch_input_marketing_event_email_subscriber: The details of the contacts to subscribe to the event. Parameters of join and left time if state is Attended. (required)
        :param str external_account_id: The account id associated with the marketing event
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchResponseSubscriberEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_by_email_with_http_info(external_event_id, subscriber_state, batch_input_marketing_event_email_subscriber, **kwargs)  # noqa: E501

    def create_by_email_with_http_info(self, external_event_id, subscriber_state, batch_input_marketing_event_email_subscriber, **kwargs):  # noqa: E501
        """Record  # noqa: E501

        Record a subscription state between multiple HubSpot contacts and a marketing event, using contact email addresses. If contact is not present it will be automatically created. If you set params   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_by_email_with_http_info(external_event_id, subscriber_state, batch_input_marketing_event_email_subscriber, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: The id of the marketing event (required)
        :param str subscriber_state: The new subscriber state for the HubSpot contacts and the specified marketing event. For example: 'register', 'attend' or 'cancel'. (required)
        :param BatchInputMarketingEventEmailSubscriber batch_input_marketing_event_email_subscriber: The details of the contacts to subscribe to the event. Parameters of join and left time if state is Attended. (required)
        :param str external_account_id: The account id associated with the marketing event
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchResponseSubscriberEmailResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "subscriber_state", "batch_input_marketing_event_email_subscriber", "external_account_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method create_by_email" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `create_by_email`")  # noqa: E501
        # verify the required parameter 'subscriber_state' is set
        if self.api_client.client_side_validation and ("subscriber_state" not in local_var_params or local_var_params["subscriber_state"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscriber_state` when calling `create_by_email`")  # noqa: E501
        # verify the required parameter 'batch_input_marketing_event_email_subscriber' is set
        if self.api_client.client_side_validation and (
            "batch_input_marketing_event_email_subscriber" not in local_var_params or local_var_params["batch_input_marketing_event_email_subscriber"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_marketing_event_email_subscriber` when calling `create_by_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501
        if "subscriber_state" in local_var_params:
            path_params["subscriberState"] = local_var_params["subscriber_state"]  # noqa: E501

        query_params = []
        if "external_account_id" in local_var_params and local_var_params["external_account_id"] is not None:  # noqa: E501
            query_params.append(("externalAccountId", local_var_params["external_account_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_marketing_event_email_subscriber" in local_var_params:
            body_params = local_var_params["batch_input_marketing_event_email_subscriber"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/attendance/{externalEventId}/{subscriberState}/email-create",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BatchResponseSubscriberEmailResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
