# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .leiaute_nfe_v4_00 import Tendereco
from .tipos_basico_v4_00 import (
    TCODUFIBGE,
    TUF,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/nfe"

"Tipo Sigla da UF consultada"
TUFCONS = [
    ("AC", "AC"),
    ("AL", "AL"),
    ("AM", "AM"),
    ("AP", "AP"),
    ("BA", "BA"),
    ("CE", "CE"),
    ("DF", "DF"),
    ("ES", "ES"),
    ("GO", "GO"),
    ("MA", "MA"),
    ("MG", "MG"),
    ("MS", "MS"),
    ("MT", "MT"),
    ("PA", "PA"),
    ("PB", "PB"),
    ("PE", "PE"),
    ("PI", "PI"),
    ("PR", "PR"),
    ("RJ", "RJ"),
    ("RN", "RN"),
    ("RO", "RO"),
    ("RR", "RR"),
    ("RS", "RS"),
    ("SC", "SC"),
    ("SE", "SE"),
    ("SP", "SP"),
    ("TO", "TO"),
    ("SU", "SU"),
]

"Situação cadastral do contribuinte"
INFCAD_CSIT = [
    ("0", "não habilitado"),
    ("1", "habilitado"),
]

"Indicador de contribuinte credenciado a emitir CT-e"
INFCAD_INDCREDCTE = [
    ("0", "Não credenciado para emissão da CT-e"),
    ("1", "Credenciado"),
    ("2", "Credenciado com obrigatoriedade para todas operações"),
    ("3", "Credenciado com obrigatoriedade parcial"),
    ("4", "a SEFAZ não fornece a informação."),
]

"Indicador de contribuinte credenciado a emitir NF-e"
INFCAD_INDCREDNFE = [
    ("0", "Não credenciado para emissão da NF-e"),
    ("1", "Credenciado"),
    ("2", "Credenciado com obrigatoriedade para todas operações"),
    ("3", "Credenciado com obrigatoriedade parcial"),
    ("4", "a SEFAZ não fornece a informação."),
]

"Serviço Solicitado"
INFCONS_XSERV = [
    ("CONS-CAD", "CONS-CAD"),
]


class TconsCad(models.AbstractModel):
    "Tipo Pedido de Consulta de cadastro de contribuintes"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tconscad"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TconsCad"

    nfe40_infCons = fields.Many2one(
        comodel_name="nfe.40.tconscad_infcons",
        string="Dados do Pedido de Consulta de cadastro",
        xsd_required=True,
        help="Dados do Pedido de Consulta de cadastro de contribuintes",
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsCad"
    )


class TconsCadInfCons(models.AbstractModel):
    "Dados do Pedido de Consulta de cadastro de contribuintes"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tconscad_infcons"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TconsCad.InfCons"

    nfe40_xServ = fields.Selection(
        INFCONS_XSERV, string="Serviço Solicitado", xsd_required=True
    )

    nfe40_UF = fields.Selection(
        TUFCONS,
        string="sigla da UF consultada",
        xsd_required=True,
        xsd_type="TUfCons",
        help="sigla da UF consultada, utilizar SU para SUFRAMA",
    )

    nfe40_IE = fields.Char(
        string="Inscrição Estadual do contribuinte",
        choice="infcons",
        xsd_choice_required=True,
        xsd_type="TIe",
    )

    nfe40_CNPJ = fields.Char(
        string="CNPJ do contribuinte",
        choice="infcons",
        xsd_choice_required=True,
        xsd_type="TCnpjVar",
    )

    nfe40_CPF = fields.Char(
        string="CPF do contribuinte",
        choice="infcons",
        xsd_choice_required=True,
        xsd_type="TCpfVar",
    )


class TretConsCad(models.AbstractModel):
    "Tipo Retorno Pedido de Consulta de cadastro de contribuintes"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tretconscad"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretConsCad"

    nfe40_infCons = fields.Many2one(
        comodel_name="nfe.40.tretconscad_infcons",
        string="Dados do Resultado doDados do Pedido",
        xsd_required=True,
        help=(
            "Dados do Resultado doDados do Pedido de Consulta de cadastro de "
            "contribuintes"
        ),
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsCad"
    )


class TretConsCadInfCons(models.AbstractModel):
    "Dados do Pedido de Consulta de cadastro de contribuintes"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tretconscad_infcons"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretConsCad.InfCons"

    nfe40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help=(
            "Versão do Aplicativo que processou o pedido de consulta de "
            "cadastro"
        ),
    )

    nfe40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    nfe40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    nfe40_UF = fields.Selection(
        TUFCONS,
        string="sigla da UF consultada",
        xsd_required=True,
        xsd_type="TUfCons",
        help="sigla da UF consultada, utilizar SU para SUFRAMA",
    )

    nfe40_IE = fields.Char(
        string="Inscrição Estadual do contribuinte",
        choice="infcons",
        xsd_choice_required=True,
        xsd_type="TIe",
    )

    nfe40_CNPJ = fields.Char(
        string="CNPJ do contribuinte",
        choice="infcons",
        xsd_choice_required=True,
        xsd_type="TCnpjVar",
    )

    nfe40_CPF = fields.Char(
        string="CPF do contribuinte",
        choice="infcons",
        xsd_choice_required=True,
        xsd_type="TCpfVar",
    )

    nfe40_dhCons = fields.Datetime(
        string="Data da Consulta", xsd_required=True, xsd_type="xs:dateTime"
    )

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="código da UF de atendimento",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    nfe40_infCad = fields.One2many(
        "nfe.40.infcad",
        "nfe40_infCad_infCons_id",
        string="Informações cadastrais",
        help="Informações cadastrais do contribuinte consultado",
    )


class InfCad(models.AbstractModel):
    "Informações cadastrais do contribuinte consultado"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infcad"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretConsCad.InfCons.InfCad"

    nfe40_infCad_infCons_id = fields.Many2one(
        comodel_name="nfe.40.tretconscad_infcons",
        xsd_implicit=True,
        ondelete="cascade",
    )
    nfe40_IE = fields.Char(
        string="Número da Inscrição Estadual",
        xsd_required=True,
        xsd_type="TIe",
        help="Número da Inscrição Estadual do contribuinte",
    )

    nfe40_CNPJ = fields.Char(
        string="Número do CNPJ do contribuinte",
        choice="infcad",
        xsd_choice_required=True,
        xsd_type="TCnpjVar",
        help="Número do CNPJ  do contribuinte",
    )

    nfe40_CPF = fields.Char(
        string="Número do CPF do contribuinte",
        choice="infcad",
        xsd_choice_required=True,
        xsd_type="TCpfVar",
    )

    nfe40_UF = fields.Selection(
        TUF,
        string="Sigla da UF de localização",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "Sigla da UF de localização do contribuinte. Em algumas situações,"
            " a UF de localização pode ser diferente da UF consultada. Ex. IE "
            "de Substituto Tributário."
        ),
    )

    nfe40_cSit = fields.Selection(
        INFCAD_CSIT,
        string="Situação cadastral do contribuinte",
        xsd_required=True,
        help=(
            "Situação cadastral do contribuinte:\n0 - não habilitado\n1 - "
            "habilitado"
        ),
    )

    nfe40_indCredNFe = fields.Selection(
        INFCAD_INDCREDNFE,
        string="Indicador de contribuinte credenciado",
        xsd_required=True,
        help=(
            "Indicador de contribuinte credenciado a emitir NF-e.\n0 - Não "
            "credenciado para emissão da NF-e;\n1 - Credenciado;\n2 - "
            "Credenciado com obrigatoriedade para todas operações;\n3 - "
            "Credenciado com obrigatoriedade parcial;\n4 – a SEFAZ não fornece"
            " a informação.\nEste indicador significa apenas que o "
            "contribuinte é credenciado para emitir NF-e na SEFAZ consultada."
        ),
    )

    nfe40_indCredCTe = fields.Selection(
        INFCAD_INDCREDCTE,
        string="indCredCTe",
        xsd_required=True,
        help=(
            "Indicador de contribuinte credenciado a emitir CT-e.\n0 - Não "
            "credenciado para emissão da CT-e;\n1 - Credenciado;\n2 - "
            "Credenciado com obrigatoriedade para todas operações;\n3 - "
            "Credenciado com obrigatoriedade parcial;\n4 – a SEFAZ não fornece"
            " a informação.\nEste indicador significa apenas que o "
            "contribuinte é credenciado para emitir CT-e na SEFAZ consultada."
        ),
    )

    nfe40_xNome = fields.Char(
        string="Razão Social ou nome do contribuinte", xsd_required=True
    )

    nfe40_xFant = fields.Char(string="xFant")

    nfe40_CNAE = fields.Char(string="CNAE Fiscal do contribuinte")

    nfe40_dIniAtiv = fields.Date(
        string="Data de início de atividades",
        xsd_type="xs:date",
        help="Data de início de atividades do contribuinte",
    )

    nfe40_dUltSit = fields.Date(
        string="Data da última modificação",
        xsd_type="xs:date",
        help=(
            "Data da última modificação da situação cadastral do contribuinte."
        ),
    )

    nfe40_dBaixa = fields.Date(
        string="Data de ocorrência da baixa",
        xsd_type="xs:date",
        help="Data de ocorrência da baixa do contribuinte.",
    )

    nfe40_IEUnica = fields.Char(
        string="Inscrição Estadual Única", xsd_type="TIe"
    )

    nfe40_IEAtual = fields.Char(
        string="Inscrição Estadual atual", xsd_type="TIe"
    )

    nfe40_ender = fields.Many2one(
        comodel_name="nfe.40.tendereco",
        string="Endereço",
        xsd_type="TEndereco",
    )
