# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_basico_v4_00 import (
    TAMB,
    TCORGAOIBGE,
    TCODUFIBGE,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/nfe"

"Serviço Solicitado"
TCONSSITNFE_XSERV = [
    ("CONSULTAR", "CONSULTAR"),
]

"Tipo Versão do Leiaute da Cosulta situação NF-e - 4.00"
TVERCONSSITNFE = [
    ("4.00", "4.00"),
]


class TconsSitNfe(models.AbstractModel):
    "Tipo Pedido de Consulta da Situação Atual da Nota Fiscal Eletrônica"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tconssitnfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TconsSitNfe"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_xServ = fields.Selection(
        TCONSSITNFE_XSERV, string="Serviço Solicitado", xsd_required=True
    )

    nfe40_chNFe = fields.Char(
        string="Chaves de acesso da NF-e",
        xsd_required=True,
        xsd_type="TChNFe",
        help=(
            "Chaves de acesso da NF-e, compostas por: UF do emitente, AAMM da "
            "emissão da NFe, CNPJ do emitente, modelo, série e número da NF-e "
            "e código numérico + DV."
        ),
    )

    nfe40_versao = fields.Selection(
        TVERCONSSITNFE,
        string="versao",
        xsd_required=True,
        xsd_type="TVerConsSitNFe",
    )


class Tevento(models.AbstractModel):
    "Tipo Evento"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tevento"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tevento"

    nfe40_infEvento = fields.Many2one(
        comodel_name="nfe.40.tevento_infevento",
        string="infEvento",
        xsd_required=True,
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerEvento"
    )


class TeventoInfEvento(models.AbstractModel):
    _description = "infEvento"
    _name = "nfe.40.tevento_infevento"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tevento.InfEvento"

    nfe40_cOrgao = fields.Selection(
        TCORGAOIBGE,
        string="Código do órgão de recepção do Evento",
        xsd_required=True,
        xsd_type="TCOrgaoIBGE",
        help=(
            "Código do órgão de recepção do Evento. Utilizar a Tabela do IBGE "
            "extendida, utilizar 90 para identificar o Ambiente Nacional"
        ),
    )

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_CNPJ = fields.Char(
        string="CNPJ",
        choice="infevento",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
    )

    nfe40_CPF = fields.Char(
        string="CPF",
        choice="infevento",
        xsd_choice_required=True,
        xsd_type="TCpf",
    )

    nfe40_chNFe = fields.Char(
        string="Chave de Acesso da NF-e vinculada",
        xsd_required=True,
        xsd_type="TChNFe",
        help="Chave de Acesso da NF-e vinculada ao evento",
    )

    nfe40_dhEvento = fields.Datetime(
        string="Data e Hora do Evento",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=(
            "Data e Hora do Evento, formato UTC (AAAA-MM-DDThh:mm:ssTZD, onde "
            "TZD = +hh:mm ou -hh:mm)"
        ),
    )

    nfe40_tpEvento = fields.Char(string="Tipo do Evento", xsd_required=True)

    nfe40_nSeqEvento = fields.Char(
        string="Seqüencial do evento para o mesmo tipo",
        xsd_required=True,
        help=(
            "Seqüencial do evento para o mesmo tipo de evento.  Para maioria "
            "dos eventos será 1, nos casos em que possa existir mais de um "
            "evento, como é o caso da carta de correção, o autor do evento "
            "deve numerar de forma seqüencial."
        ),
    )

    nfe40_verEvento = fields.Char(
        string="Versão do Tipo do Evento", xsd_required=True
    )

    nfe40_detEvento = fields.Many2one(
        comodel_name="nfe.40.detevento",
        string="Detalhe Específico do Evento",
        xsd_required=True,
    )

    nfe40_Id = fields.Char(
        string="Identificador da TAG a ser assinada",
        xsd_required=True,
        help=(
            "Identificador da TAG a ser assinada, a regra de formação do Id "
            "é:\n“ID” + tpEvento +  chave da NF-e + nSeqEvento"
        ),
    )


class DetEvento(models.AbstractModel):
    "Detalhe Específico do Evento"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.detevento"
    _inherit = "spec.mixin.nfe"
    _binding_type = "Tevento.InfEvento.DetEvento"


class TprotNfe(models.AbstractModel):
    "Tipo Protocolo de status resultado do processamento da NF-e"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tprotnfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TprotNfe"

    nfe40_protNFe_TRetConsReciNFe_id = fields.Many2one(
        comodel_name="nfe.40.tretconsrecinfe",
        xsd_implicit=True,
        ondelete="cascade",
    )
    nfe40_infProt = fields.Many2one(
        comodel_name="nfe.40.infprot",
        string="Dados do protocolo de status",
        xsd_required=True,
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerNFe"
    )


class InfProt(models.AbstractModel):
    "Dados do protocolo de status"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infprot"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TprotNfe.InfProt"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a NF-e",
    )

    nfe40_chNFe = fields.Char(
        string="Chaves de acesso da NF-e",
        xsd_required=True,
        xsd_type="TChNFe",
        help=(
            "Chaves de acesso da NF-e, compostas por: UF do emitente, AAMM da "
            "emissão da NFe, CNPJ do emitente, modelo, série e número da NF-e "
            "e código numérico+DV."
        ),
    )

    nfe40_dhRecbto = fields.Datetime(
        string="Data e hora de processamento",
        xsd_required=True,
        xsd_type="xs:dateTime",
        help=(
            "Data e hora de processamento, no formato AAAA-MM-DDTHH:MM:SS (ou "
            "AAAA-MM-DDTHH:MM:SSTZD, de acordo com versão). Deve ser "
            "preenchida com data e hora da gravação no Banco em caso de "
            "Confirmação. Em caso de Rejeição, com data e hora do recebimento "
            "do Lote de NF-e enviado."
        ),
    )

    nfe40_nProt = fields.Char(
        string="Número do Protocolo de Status da NF-e",
        xsd_type="TProt",
        help=(
            "Número do Protocolo de Status da NF-e. 1 posição (1 – Secretaria "
            "de Fazenda Estadual 2 – Receita Federal); 2 - códiga da UF - 2 "
            "posições ano; 10 seqüencial no ano."
        ),
    )

    nfe40_digVal = fields.Char(
        string="Digest Value da NF-e processada",
        xsd_type="ds:DigestValueType",
        help=(
            "Digest Value da NF-e processada. Utilizado para conferir a "
            "integridade da NF-e original."
        ),
    )

    nfe40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    nfe40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    nfe40_Id = fields.Char(string="Id", xsd_type="xs:ID")


class TretCancNfe(models.AbstractModel):
    "Tipo retorno Pedido de Cancelamento da Nota Fiscal Eletrônica"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tretcancnfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretCancNfe"

    nfe40_infCanc = fields.Many2one(
        comodel_name="nfe.40.infcanc",
        string="Dados do Resultado do Pedido",
        xsd_required=True,
        help=(
            "Dados do Resultado do Pedido de Cancelamento da Nota Fiscal "
            "Eletrônica"
        ),
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerCancNFe"
    )


class InfCanc(models.AbstractModel):
    """Dados do Resultado do Pedido de Cancelamento da Nota Fiscal
    Eletrônica"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.infcanc"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretCancNfe.InfCanc"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou o pedido de cancelamento",
    )

    nfe40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    nfe40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="código da UF de atendimento",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    nfe40_chNFe = fields.Char(
        string="Chaves de acesso da NF-e",
        xsd_type="TChNFe",
        help=(
            "Chaves de acesso da NF-e, compostas por: UF do emitente, AAMM da "
            "emissão da NFe, CNPJ do emitente, modelo, série e número da NF-e "
            "e código numérico + DV."
        ),
    )

    nfe40_dhRecbto = fields.Datetime(
        string="Data e hora de recebimento",
        xsd_type="xs:dateTime",
        help=(
            "Data e hora de recebimento, no formato AAAA-MM-DDTHH:MM:SS. Deve "
            "ser preenchida com data e hora da gravação no Banco em caso de "
            "Confirmação."
        ),
    )

    nfe40_nProt = fields.Char(
        string="Número do Protocolo de Status da NF-e",
        xsd_type="TProt",
        help=(
            "Número do Protocolo de Status da NF-e. 1 posição (1 – Secretaria "
            "de Fazenda Estadual 2 – Receita Federal); 2 - código da UF - 2 "
            "posições ano; 10 seqüencial no ano."
        ),
    )

    nfe40_Id = fields.Char(string="Id", xsd_type="xs:ID")


class TretEvento(models.AbstractModel):
    "Tipo retorno do Evento"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tretevento"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretEvento"

    nfe40_infEvento = fields.Many2one(
        comodel_name="nfe.40.tretevento_infevento",
        string="infEvento",
        xsd_required=True,
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TRetVerEvento"
    )


class TretEventoInfEvento(models.AbstractModel):
    _description = "infEvento"
    _name = "nfe.40.tretevento_infevento"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretEvento.InfEvento"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_verAplic = fields.Char(
        string="Versão do Aplicativo que recebeu",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que recebeu o Evento",
    )

    nfe40_cOrgao = fields.Selection(
        TCORGAOIBGE,
        string="Código do órgão de recepção do Evento",
        xsd_required=True,
        xsd_type="TCOrgaoIBGE",
        help=(
            "Código do órgão de recepção do Evento. Utilizar a Tabela do IBGE "
            "extendida, utilizar 90 para identificar o Ambiente Nacional"
        ),
    )

    nfe40_cStat = fields.Char(
        string="Código do status da registro do Evento",
        xsd_required=True,
        xsd_type="TStat",
    )

    nfe40_xMotivo = fields.Char(
        string="Descrição literal do status do registro",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do registro do Evento",
    )

    nfe40_chNFe = fields.Char(
        string="Chave de Acesso NF-e vinculada", xsd_type="TChNFe"
    )

    nfe40_tpEvento = fields.Char(string="Tipo do Evento vinculado")

    nfe40_xEvento = fields.Char(string="Descrição do Evento")

    nfe40_nSeqEvento = fields.Char(string="Seqüencial do evento")

    nfe40_CNPJDest = fields.Char(
        string="CNPJ Destinatário", choice="infevento", xsd_type="TCnpjOpc"
    )

    nfe40_CPFDest = fields.Char(
        string="CPF Destiantário", choice="infevento", xsd_type="TCpf"
    )

    nfe40_emailDest = fields.Char(string="email do destinatário")

    nfe40_dhRegEvento = fields.Datetime(
        string="Data e Hora de registro",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=(
            "Data e Hora de registro do evento formato UTC AAAA-MM-"
            "DDTHH:MM:SSTZD"
        ),
    )

    nfe40_nProt = fields.Char(
        string="Número do protocolo de registro",
        xsd_type="TProt",
        help="Número do protocolo de registro do evento",
    )

    nfe40_Id = fields.Char(string="Id")


class TprocEvento(models.AbstractModel):
    "Tipo procEvento"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tprocevento"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TprocEvento"

    nfe40_procEventoNFe_TRetConsSitNFe_id = fields.Many2one(
        comodel_name="nfe.40.tretconssitnfe",
        xsd_implicit=True,
        ondelete="cascade",
    )
    nfe40_evento = fields.Many2one(
        comodel_name="nfe.40.tevento",
        string="evento",
        xsd_required=True,
        xsd_type="TEvento",
    )

    nfe40_retEvento = fields.Many2one(
        comodel_name="nfe.40.tretevento",
        string="retEvento",
        xsd_required=True,
        xsd_type="TRetEvento",
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerEvento"
    )


class TretConsSitNfe(models.AbstractModel):
    """Tipo Retorno de Pedido de Consulta da Situação Atual da Nota Fiscal
    Eletrônica"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tretconssitnfe"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretConsSitNfe"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a NF-e",
    )

    nfe40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    nfe40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="código da UF de atendimento",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    nfe40_dhRecbto = fields.Datetime(
        string="AAAA-MM-DDTHH:MM:SSTZD",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
    )

    nfe40_chNFe = fields.Char(
        string="Chaves de acesso da NF-e consultada",
        xsd_required=True,
        xsd_type="TChNFe",
    )

    nfe40_protNFe = fields.Many2one(
        comodel_name="nfe.40.tprotnfe",
        string="Protocolo de autorização de uso da NF-e",
        xsd_type="TProtNFe",
    )

    nfe40_retCancNFe = fields.Many2one(
        comodel_name="nfe.40.tretcancnfe",
        string="Protocolo de homologação de cancelamento",
        xsd_type="TRetCancNFe",
        help="Protocolo de homologação de cancelamento de uso da NF-e",
    )

    nfe40_procEventoNFe = fields.One2many(
        "nfe.40.tprocevento",
        "nfe40_procEventoNFe_TRetConsSitNFe_id",
        string="Protocolo de registro de evento da NF-e",
        xsd_type="TProcEvento",
    )

    nfe40_versao = fields.Selection(
        TVERCONSSITNFE,
        string="versao",
        xsd_required=True,
        xsd_type="TVerConsSitNFe",
    )
