# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_geral_mdfe_v3_00 import (
    TAMB,
    TCODUFIBGE,
    TEMIT,
    TMODMD,
    TTRANSP,
    TUF,
    TTIPOUNIDCARGA,
    TTIPOUNIDTRANSP,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"

"Tipo Modal Manifesto"
TMODALMD = [
    ("1", "1"),
    ("2", "2"),
    ("3", "3"),
    ("4", "4"),
]

"Tipo processo de emissão do MDF-e"
TPROCEMI = [
    ("0", "0"),
]

"Indicador de participação do Canal Verde"
IDE_INDCANALVERDE = [
    ("1", "1"),
]

"""Indicador de MDF-e com inclusão da Carga posterior a emissão por evento
    de inclusão de DF-e"""
IDE_INDCARREGAPOSTERIOR = [
    ("1", "1"),
]

"Forma de emissão do Manifesto"
IDE_TPEMIS = [
    ("1", "Normal"),
    ("2", "Contingência"),
    ("3", "Regime Especial NFF"),
]

"Indicador de Reentrega"
INFCTE_INDREENTREGA = [
    ("1", "1"),
]

"Indicador de Reentrega"
INFMDFETRANSP_INDREENTREGA = [
    ("1", "1"),
]

"Indicador de Reentrega"
INFNFE_INDREENTREGA = [
    ("1", "1"),
]

"Responsável pelo seguro"
INFRESP_RESPSEG = [
    ("1", " Emitente do MDF-e"),
    ("2", "Responsável pela contratação do serviço de transporte (contratante)	"),
]

"Tipo de Carga"
PRODPRED_TPCARGA = [
    ("01", "Granel sólido"),
    ("02", "Granel líquido"),
    ("03", "Frigorificada"),
    ("04", "Conteinerizada"),
    ("05", "Carga Geral"),
    ("06", "Neogranel"),
    ("07", "Perigosa (granel sólido)"),
    ("08", "Perigosa (granel líquido)"),
    ("09", "Perigosa (carga frigorificada)"),
    ("10", "Perigosa (conteinerizada)"),
    ("11", "Perigosa (carga geral)."),
]

"""Código da unidade de medida do Peso Bruto da Carga / Mercadorias
    transportadas"""
TOT_CUNID = [
    ("01", "KG"),
    ("02", "TON"),
]


class TrespTec(models.AbstractModel):
    "Tipo Dados da Responsável Técnico"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tresptec"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TrespTec"

    mdfe30_CNPJ = fields.Char(
        string="CNPJ",
        xsd_required=True,
        xsd_type="TCnpj",
        help=(
            "CNPJ da pessoa jurídica responsável técnica pelo sistema "
            "utilizado na emissão do documento fiscal eletrônico\nInformar o "
            "CNPJ da pessoa jurídica desenvolvedora do sistema utilizado na "
            "emissão do documento fiscal eletrônico."
        ),
    )

    mdfe30_xContato = fields.Char(
        string="Nome da pessoa a ser contatada",
        xsd_required=True,
        help=(
            "Nome da pessoa a ser contatada\nInformar o nome da pessoa a ser "
            "contatada na empresa desenvolvedora do sistema utilizado na "
            "emissão do documento fiscal eletrônico. No caso de pessoa física,"
            " informar o respectivo nome."
        ),
    )

    mdfe30_email = fields.Char(
        string="Email da pessoa jurídica a ser contatada",
        xsd_required=True,
        xsd_type="TEmail",
    )

    mdfe30_fone = fields.Char(
        string="Telefone da pessoa jurídica",
        xsd_required=True,
        help=(
            "Telefone da pessoa jurídica a ser contatada\nPreencher com o "
            "Código DDD + número do telefone."
        ),
    )

    mdfe30_idCSRT = fields.Char(
        string="Identificador do código de segurança",
        help=(
            "Identificador do código de segurança do responsável "
            "técnico\nIdentificador do CSRT utilizado para geração do hash"
        ),
    )

    mdfe30_hashCSRT = fields.Char(
        string="Hash do token do código de segurança",
        help=(
            "Hash do token do código de segurança do responsável técnico\nO "
            "hashCSRT é o resultado das funções SHA-1 e base64 do token CSRT "
            "fornecido pelo fisco + chave de acesso do DF-e. (Implementação em"
            " futura NT)\n\nObservação: 28 caracteres são representados no "
            "schema como 20 bytes do tipo base64Binary"
        ),
    )


class TendOrg(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tendorg"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TendOrg"

    mdfe30_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    mdfe30_nro = fields.Char(string="Número", xsd_required=True)

    mdfe30_xCpl = fields.Char(string="Complemento")

    mdfe30_xBairro = fields.Char(string="Bairro", xsd_required=True)

    mdfe30_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE), informar 9999999"
            " para operações com o exterior."
        ),
    )

    mdfe30_xMun = fields.Char(
        string="Nome do município, ",
        xsd_required=True,
        help=(
            "Nome do município, , informar EXTERIOR para operações com o " "exterior."
        ),
    )

    mdfe30_CEP = fields.Char(string="CEP")

    mdfe30_UF = fields.Selection(
        TUF,
        string="Sigla da UF, ",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF, , informar EX para operações com o exterior.",
    )

    mdfe30_cPais = fields.Char(string="Código do país")

    mdfe30_xPais = fields.Char(string="Nome do país")

    mdfe30_fone = fields.Char(string="Telefone")


class TendReEnt(models.AbstractModel):
    "Tipo Dados do Local de Retirada ou Entrega"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tendreent"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TendReEnt"

    mdfe30_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="tendreent",
        xsd_choice_required=True,
        xsd_type="TCnpj",
    )

    mdfe30_CPF = fields.Char(
        string="Número do CPF",
        choice="tendreent",
        xsd_choice_required=True,
        xsd_type="TCpf",
    )

    mdfe30_xNome = fields.Char(string="Razão Social ou Nome", xsd_required=True)

    mdfe30_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    mdfe30_nro = fields.Char(string="Número", xsd_required=True)

    mdfe30_xCpl = fields.Char(string="Complemento")

    mdfe30_xBairro = fields.Char(string="Bairro", xsd_required=True)

    mdfe30_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE), informar 9999999"
            " para operações com o exterior."
        ),
    )

    mdfe30_xMun = fields.Char(
        string="Nome do município, ",
        xsd_required=True,
        help=(
            "Nome do município, , informar EXTERIOR para operações com o " "exterior."
        ),
    )

    mdfe30_UF = fields.Selection(
        TUF,
        string="Sigla da UF, ",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF, , informar EX para operações com o exterior.",
    )


class TendeEmi(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tendeemi"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TendeEmi"

    mdfe30_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    mdfe30_nro = fields.Char(string="Número", xsd_required=True)

    mdfe30_xCpl = fields.Char(string="Complemento")

    mdfe30_xBairro = fields.Char(string="Bairro", xsd_required=True)

    mdfe30_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE), informar 9999999"
            " para operações com o exterior."
        ),
    )

    mdfe30_xMun = fields.Char(
        string="Nome do município, ",
        xsd_required=True,
        help=(
            "Nome do município, , informar EXTERIOR para operações com o " "exterior."
        ),
    )

    mdfe30_CEP = fields.Char(
        string="CEP", help="CEP\nInformar zeros não significativos"
    )

    mdfe30_UF = fields.Selection(
        TUF,
        string="Sigla da UF, ",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF, , informar EX para operações com o exterior.",
    )

    mdfe30_fone = fields.Char(string="Telefone")

    mdfe30_email = fields.Char(string="Endereço de E-mail", xsd_type="TEmail")


class TenderFer(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tenderfer"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TenderFer"

    mdfe30_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    mdfe30_nro = fields.Char(string="Número")

    mdfe30_xCpl = fields.Char(string="Complemento")

    mdfe30_xBairro = fields.Char(string="Bairro")

    mdfe30_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE), informar 9999999"
            " para operações com o exterior."
        ),
    )

    mdfe30_xMun = fields.Char(
        string="Nome do município, ",
        xsd_required=True,
        help=(
            "Nome do município, , informar EXTERIOR para operações com o " "exterior."
        ),
    )

    mdfe30_CEP = fields.Char(string="CEP", xsd_required=True)

    mdfe30_UF = fields.Selection(
        TUF,
        string="Sigla da UF, ",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF, , informar EX para operações com o exterior.",
    )


class Tendereco(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tendereco"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tendereco"

    mdfe30_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    mdfe30_nro = fields.Char(string="Número", xsd_required=True)

    mdfe30_xCpl = fields.Char(string="Complemento")

    mdfe30_xBairro = fields.Char(string="Bairro", xsd_required=True)

    mdfe30_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE), informar 9999999"
            " para operações com o exterior."
        ),
    )

    mdfe30_xMun = fields.Char(
        string="Nome do município",
        xsd_required=True,
        help=("Nome do município, informar EXTERIOR para operações com o " "exterior."),
    )

    mdfe30_CEP = fields.Char(
        string="CEP", help="CEP\nInformar os zeros não significativos"
    )

    mdfe30_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF, informar EX para operações com o exterior.",
    )

    mdfe30_cPais = fields.Char(
        string="Código do país", help="Código do país\nUtilizar a tabela do BACEN"
    )

    mdfe30_xPais = fields.Char(string="Nome do país")


class Tendernac(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tendernac"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tendernac"

    mdfe30_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    mdfe30_nro = fields.Char(string="Número", xsd_required=True)

    mdfe30_xCpl = fields.Char(string="Complemento")

    mdfe30_xBairro = fields.Char(string="Bairro", xsd_required=True)

    mdfe30_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE), informar 9999999"
            " para operações com o exterior."
        ),
    )

    mdfe30_xMun = fields.Char(
        string="Nome do município, ",
        xsd_required=True,
        help=(
            "Nome do município, , informar EXTERIOR para operações com o " "exterior."
        ),
    )

    mdfe30_CEP = fields.Char(string="CEP")

    mdfe30_UF = fields.Selection(
        TUF,
        string="Sigla da UF, ",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF, , informar EX para operações com o exterior.",
    )


class Tlocal(models.AbstractModel):
    "Tipo Dados do Local de Origem ou Destino"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tlocal"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tlocal"

    mdfe30_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help="Código do município (utilizar a tabela do IBGE)",
    )

    mdfe30_xMun = fields.Char(string="Nome do município", xsd_required=True)

    mdfe30_UF = fields.Selection(
        TUF, string="Sigla da UF", xsd_required=True, xsd_type="TUf"
    )


class TnfeNf(models.AbstractModel):
    "Tipo de Dados das Notas Fiscais Papel e Eletrônica"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tnfenf"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TnfeNf"

    mdfe30_infNFe = fields.Many2one(
        comodel_name="mdfe.30.tnfenf_infnfe",
        string="Informações da NF-e",
        choice="tnfenf",
        xsd_choice_required=True,
    )

    mdfe30_infNF = fields.Many2one(
        comodel_name="mdfe.30.infnf",
        string="Informações da NF mod 1 e 1A",
        choice="tnfenf",
        xsd_choice_required=True,
    )


class TnfeNfInfNfe(models.AbstractModel):
    "Nota Fiscal Eletronica"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tnfenf_infnfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TnfeNf.InfNfe"

    mdfe30_chNFe = fields.Char(
        string="Chave de acesso da NF-e", xsd_required=True, xsd_type="TChNFe"
    )

    mdfe30_PIN = fields.Char(
        string="PIN SUFRAMA",
        xsd_type="TPIN",
        help="PIN SUFRAMA\nPIN atribuído pela SUFRAMA para a operação.",
    )


class InfNf(models.AbstractModel):
    "Informações da NF mod 1 e 1A"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infnf"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TnfeNf.InfNf"

    mdfe30_emi = fields.Many2one(
        comodel_name="mdfe.30.emi",
        string="Informações do Emitente da NF",
        xsd_required=True,
    )

    mdfe30_dest = fields.Many2one(
        comodel_name="mdfe.30.dest",
        string="Informações do Destinatário da NF",
        xsd_required=True,
    )

    mdfe30_serie = fields.Char(string="Série", xsd_required=True)

    mdfe30_nNF = fields.Char(string="Número", xsd_required=True)

    mdfe30_dEmi = fields.Date(
        string="Data de Emissão",
        xsd_required=True,
        xsd_type="TData",
        help="Data de Emissão\nFormato AAAA-MM-DD",
    )

    mdfe30_vNF = fields.Monetary(
        string="Valor Total da NF",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    mdfe30_PIN = fields.Char(
        string="PIN SUFRAMA",
        xsd_type="TPIN",
        help="PIN SUFRAMA\nPIN atribuído pela SUFRAMA para a operação.",
    )


class Emi(models.AbstractModel):
    "Informações do Emitente da NF"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.emi"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TnfeNf.InfNf.Emi"

    mdfe30_CNPJ = fields.Char(
        string="CNPJ do emitente", xsd_required=True, xsd_type="TCnpj"
    )

    mdfe30_xNome = fields.Char(string="Razão Social ou Nome", xsd_required=True)

    mdfe30_UF = fields.Selection(
        TUF,
        string="UF do Emitente",
        xsd_required=True,
        xsd_type="TUf",
        help="UF do Emitente\nInformar 'EX' para operações com o exterior.",
    )


class Dest(models.AbstractModel):
    "Informações do Destinatário da NF"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.dest"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TnfeNf.InfNf.Dest"

    mdfe30_CNPJ = fields.Char(
        string="CNPJ do Destinatário",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "CNPJ do Destinatário\nInformar o CNPJ ou o CPF do destinatário, "
            "preenchendo os\nzeros não significativos.\nNão informar o "
            "conteúdo da TAG se a operação for realizada com o Exterior."
        ),
    )

    mdfe30_CPF = fields.Char(
        string="CPF do Destinatário",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="CPF do Destinatário\nInformar os zeros não significativos.",
    )

    mdfe30_xNome = fields.Char(string="Razão Social ou Nome", xsd_required=True)

    mdfe30_UF = fields.Selection(
        TUF,
        string="UF do Destinatário",
        xsd_required=True,
        xsd_type="TUf",
        help=("UF do Destinatário\nInformar 'EX' para operações com o exterior."),
    )


class TprotMdfe(models.AbstractModel):
    "Tipo Protocolo de status resultado do processamento do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tprotmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TprotMdfe"

    mdfe30_infProt = fields.Many2one(
        comodel_name="mdfe.30.infprot",
        string="Dados do protocolo de status",
        xsd_required=True,
    )

    mdfe30_infFisco = fields.Many2one(
        comodel_name="mdfe.30.inffisco", string="Mensagem do Fisco"
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerMDe")


class InfProt(models.AbstractModel):
    "Dados do protocolo de status"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infprot"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TprotMdfe.InfProt"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a NF-3e",
    )

    mdfe30_chMDFe = fields.Char(
        string="Chave de acesso do MDF-e", xsd_required=True, xsd_type="TChMDFe"
    )

    mdfe30_dhRecbto = fields.Datetime(
        string="Data e hora de processamento",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=("Data e hora de processamento, no formato AAAA-MM-DDTHH:MM:SS TZD."),
    )

    mdfe30_nProt = fields.Char(
        string="Número do Protocolo de Status do MDF-e", xsd_type="TProt"
    )

    mdfe30_digVal = fields.Char(
        string="Digest Value do MDF-e processado",
        xsd_type="ds:DigestValueType",
        help=(
            "Digest Value do MDF-e processado. Utilizado para conferir a "
            "integridade do MDF-e original."
        ),
    )

    mdfe30_cStat = fields.Char(string="Código do status do MDF-e", xsd_required=True)

    mdfe30_xMotivo = fields.Char(
        string="Descrição literal do status do MDF-e",
        xsd_required=True,
        xsd_type="TMotivo",
    )

    mdfe30_Id = fields.Char(string="Id", xsd_type="xs:ID")


class InfFisco(models.AbstractModel):
    "Mensagem do Fisco"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.inffisco"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TprotMdfe.InfFisco"

    mdfe30_cMsg = fields.Char(
        string="Código do status da mensagem do fisco", xsd_required=True
    )

    mdfe30_xMsg = fields.Char(
        string="Mensagem do Fisco", xsd_required=True, xsd_type="TMotivo"
    )


class TretEnviMdfe(models.AbstractModel):
    "Tipo Retorno do Recibo do Pedido de Autorização do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tretenvimdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretEnviMdfe"

    mdfe30_cUF = fields.Selection(
        TCODUFIBGE,
        string="Identificação da UF",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que recebeu",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que recebeu o Arquivo.",
    )

    mdfe30_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    mdfe30_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    mdfe30_infRec = fields.Many2one(
        comodel_name="mdfe.30.infrec", string="Dados do Recibo do Arquivo"
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerMDe")


class InfRec(models.AbstractModel):
    "Dados do Recibo do Arquivo"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infrec"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretEnviMdfe.InfRec"

    mdfe30_nRec = fields.Char(
        string="Número do Recibo", xsd_required=True, xsd_type="TRec"
    )

    mdfe30_dhRecbto = fields.Datetime(
        string="Data e hora do recebimento",
        xsd_required=True,
        xsd_type="xs:dateTime",
        help="Data e hora do recebimento, no formato AAAA-MM-DDTHH:MM:SS",
    )

    mdfe30_tMed = fields.Char(
        string="Tempo médio de resposta do serviço",
        xsd_required=True,
        help=(
            "Tempo médio de resposta do serviço (em segundos) dos últimos 5 " "minutos"
        ),
    )


class TunidCarga(models.AbstractModel):
    "Tipo Dados Unidade de Carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tunidcarga"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TunidCarga"

    mdfe30_infUnidCarga_TUnidadeTransp_id = fields.Many2one(
        comodel_name="mdfe.30.tunidadetransp", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_tpUnidCarga = fields.Selection(
        TTIPOUNIDCARGA,
        string="Tipo da Unidade de Carga",
        xsd_required=True,
        xsd_type="TtipoUnidCarga",
        help=(
            "Tipo da Unidade de Carga\n1 - Container;\n\n2 - ULD;\n\n3 - "
            "Pallet;\n\n4 - Outros;"
        ),
    )

    mdfe30_idUnidCarga = fields.Char(
        string="Identificação da Unidade de Carga",
        xsd_required=True,
        xsd_type="TContainer",
        help=(
            "Identificação da Unidade de Carga\nInformar a identificação da "
            "unidade de carga, por exemplo: número do container."
        ),
    )

    mdfe30_lacUnidCarga = fields.One2many(
        "mdfe.30.lacunidcarga",
        "mdfe30_lacUnidCarga_TUnidCarga_id",
        string="Lacres das Unidades de Carga",
    )

    mdfe30_qtdRat = fields.Char(string="Quantidade rateada (Peso,Volume)")


class LacUnidCarga(models.AbstractModel):
    "Lacres das Unidades de Carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.lacunidcarga"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TunidCarga.LacUnidCarga"

    mdfe30_lacUnidCarga_TUnidCarga_id = fields.Many2one(
        comodel_name="mdfe.30.tunidcarga", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_nLacre = fields.Char(string="Número do lacre", xsd_required=True)


class TretMdfe(models.AbstractModel):
    "Tipo Retorno do Pedido de Autorização do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tretmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretMdfe"

    mdfe30_cUF = fields.Selection(
        TCODUFIBGE,
        string="Identificação da UF",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que recebeu",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que recebeu o Arquivo.",
    )

    mdfe30_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    mdfe30_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    mdfe30_protMDFe = fields.Many2one(
        comodel_name="mdfe.30.tprotmdfe",
        string="Dados do Recibo do Arquivo",
        xsd_type="TProtMDFe",
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerMDe")


class TunidadeTransp(models.AbstractModel):
    "Tipo Dados Unidade de Transporte"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tunidadetransp"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TunidadeTransp"

    mdfe30_infUnidTransp_infCTe_id = fields.Many2one(
        comodel_name="mdfe.30.infcte", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_infUnidTransp_infNFe_id = fields.Many2one(
        comodel_name="mdfe.30.tmdfe_infnfe", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_infUnidTransp_infMDFeTransp_id = fields.Many2one(
        comodel_name="mdfe.30.infmdfetransp", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_tpUnidTransp = fields.Selection(
        TTIPOUNIDTRANSP,
        string="Tipo da Unidade de Transporte",
        xsd_required=True,
        xsd_type="TtipoUnidTransp",
        help=(
            "Tipo da Unidade de Transporte\n1 - Rodoviário Tração;\n\n2 - "
            "Rodoviário Reboque;\n\n3 - Navio;\n\n4 - Balsa;\n\n5 - "
            "Aeronave;\n\n6 - Vagão;\n\n7 - Outros"
        ),
    )

    mdfe30_idUnidTransp = fields.Char(
        string="Identificação da Unidade de Transporte",
        xsd_required=True,
        xsd_type="TContainer",
        help=(
            "Identificação da Unidade de Transporte\nInformar a identificação "
            "conforme o tipo de unidade de transporte.\nPor exemplo: para "
            "rodoviário tração ou reboque deverá preencher com a placa do "
            "veículo."
        ),
    )

    mdfe30_lacUnidTransp = fields.One2many(
        "mdfe.30.lacunidtransp",
        "mdfe30_lacUnidTransp_TUnidadeTransp_id",
        string="Lacres das Unidades de Transporte",
    )

    mdfe30_infUnidCarga = fields.One2many(
        "mdfe.30.tunidcarga",
        "mdfe30_infUnidCarga_TUnidadeTransp_id",
        string="Informações das Unidades de Carga",
        xsd_type="TUnidCarga",
        help=(
            "Informações das Unidades de Carga "
            "(Containeres/ULD/Outros)\nDispositivo de carga utilizada (Unit "
            "Load Device - ULD) significa todo tipo de contêiner de carga, "
            "vagão, contêiner de avião, palete de aeronave com rede ou palete "
            "de aeronave com rede sobre um iglu."
        ),
    )

    mdfe30_qtdRat = fields.Monetary(
        string="Quantidade rateada (Peso,Volume)",
        xsd_type="TDec_0302_0303",
        currency_field="brl_currency_id",
    )


class LacUnidTransp(models.AbstractModel):
    "Lacres das Unidades de Transporte"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.lacunidtransp"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TunidadeTransp.LacUnidTransp"

    mdfe30_lacUnidTransp_TUnidadeTransp_id = fields.Many2one(
        comodel_name="mdfe.30.tunidadetransp", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_nLacre = fields.Char(string="Número do lacre", xsd_required=True)


class Tmdfe(models.AbstractModel):
    "Tipo Manifesto de Documentos Fiscais Eletrônicos"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe"

    mdfe30_infMDFe = fields.Many2one(
        comodel_name="mdfe.30.tmdfe_infmdfe",
        string="Informações do MDF-e",
        xsd_required=True,
    )

    mdfe30_infMDFeSupl = fields.Many2one(
        comodel_name="mdfe.30.infmdfesupl", string="Informações suplementares do MDF-e"
    )


class TmdfeInfMdfe(models.AbstractModel):
    "Informações do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tmdfe_infmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe"

    mdfe30_ide = fields.Many2one(
        comodel_name="mdfe.30.ide", string="Identificação do MDF-e", xsd_required=True
    )

    mdfe30_emit = fields.Many2one(
        comodel_name="mdfe.30.emit",
        string="Identificação do Emitente do Manifesto",
        xsd_required=True,
    )

    mdfe30_infModal = fields.Many2one(
        comodel_name="mdfe.30.infmodal",
        string="Informações do modal",
        xsd_required=True,
    )

    mdfe30_infDoc = fields.Many2one(
        comodel_name="mdfe.30.tmdfe_infdoc",
        string="Informações",
        xsd_required=True,
        help="Informações dos Documentos fiscais vinculados ao manifesto",
    )

    mdfe30_seg = fields.One2many(
        "mdfe.30.seg", "mdfe30_seg_infMDFe_id", string="Informações de Seguro da Carga"
    )

    mdfe30_prodPred = fields.Many2one(
        comodel_name="mdfe.30.prodpred",
        string="Produto predominante",
        help=("Produto predominante\nInformar a descrição do produto " "predominante"),
    )

    mdfe30_tot = fields.Many2one(
        comodel_name="mdfe.30.tot",
        string="Totalizadores da carga transportada",
        xsd_required=True,
        help=("Totalizadores da carga transportada e seus documentos fiscais"),
    )

    mdfe30_lacres = fields.One2many(
        "mdfe.30.lacres",
        "mdfe30_lacres_infMDFe_id",
        string="Lacres do MDF-e",
        help=(
            "Lacres do MDF-e\nPreechimento opcional para os modais Rodoviário "
            "e Ferroviário"
        ),
    )

    mdfe30_autXML = fields.One2many(
        "mdfe.30.autxml",
        "mdfe30_autXML_infMDFe_id",
        string="Autorizados para download do XML do DF-e",
        help=(
            "Autorizados para download do XML do DF-e\nInformar CNPJ ou CPF. "
            "Preencher os zeros não significativos."
        ),
    )

    mdfe30_infAdic = fields.Many2one(
        comodel_name="mdfe.30.infadic", string="Informações Adicionais"
    )

    mdfe30_infRespTec = fields.Many2one(
        comodel_name="mdfe.30.tresptec",
        string="Informações do Responsável Técnico",
        xsd_type="TRespTec",
        help="Informações do Responsável Técnico pela emissão do DF-e",
    )

    mdfe30_infSolicNFF = fields.Many2one(
        comodel_name="mdfe.30.infsolicnff",
        string="Grupo de informações do pedido",
        help=("Grupo de informações do pedido de emissão da Nota Fiscal Fácil"),
    )

    mdfe30_versao = fields.Char(
        string="Versão do leiaute",
        xsd_required=True,
        xsd_type="TVerMDe",
        help="Versão do leiaute\nEx: '3.00'",
    )

    mdfe30_Id = fields.Char(
        string="Identificador da tag a ser assinada",
        xsd_required=True,
        help=(
            "Identificador da tag a ser assinada\nInformar a chave de acesso "
            "do MDF-e e precedida do literal 'MDFe'"
        ),
    )


class Ide(models.AbstractModel):
    "Identificação do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.ide"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.Ide"

    mdfe30_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF do emitente do MDF-e",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
        help=(
            "Código da UF do emitente do MDF-e\nCódigo da UF do emitente do "
            "Documento Fiscal. Utilizar a\nTabela do IBGE de código de "
            "unidades da federação."
        ),
    )

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Tipo do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Tipo do Ambiente\n1 - Produção\n2 - Homologação",
    )

    mdfe30_tpEmit = fields.Selection(
        TEMIT,
        string="Tipo do Emitente",
        xsd_required=True,
        xsd_type="TEmit",
        help=(
            "Tipo do Emitente\n1 - Prestador de serviço de transporte \n2 - "
            "Transportador de Carga Própria 3 - Prestador de serviço de "
            "transporte que emitirá CT-e Globalizado \n\nOBS: Deve ser "
            "preenchido com 2 para emitentes de NF-e e pelas transportadoras "
            "quando estiverem fazendo transporte de carga própria. Deve ser "
            "preenchido com 3 para transportador de carga que emitirá à "
            "posteriori CT-e Globalizado relacionando as NF-e."
        ),
    )

    mdfe30_tpTransp = fields.Selection(
        TTRANSP,
        string="Tipo do Transportador",
        xsd_type="TTransp",
        help="Tipo do Transportador\n1 - ETC\n\n2 - TAC\n\n3 - CTC",
    )

    mdfe30_mod = fields.Selection(
        TMODMD,
        string="Modelo do Manifesto Eletrônico",
        xsd_required=True,
        xsd_type="TModMD",
        help=(
            "Modelo do Manifesto Eletrônico\nUtilizar o código 58 para "
            "identificação do MDF-e"
        ),
    )

    mdfe30_serie = fields.Char(
        string="Série do Manifesto",
        xsd_required=True,
        xsd_type="TSerie",
        help=(
            "Série do Manifesto\nInformar a série do documento fiscal "
            "(informar zero se inexistente).\nSérie na faixa [920-969]: "
            "Reservada para emissão por contribuinte pessoa física com "
            "inscrição estadual."
        ),
    )

    mdfe30_nMDF = fields.Char(
        string="Número do Manifesto",
        xsd_required=True,
        xsd_type="TNF",
        help=(
            "Número do Manifesto\nNúmero que identifica o Manifesto. 1 a " "999999999."
        ),
    )

    mdfe30_cMDF = fields.Char(
        string="Código numérico que compõe a Chave",
        xsd_required=True,
        help=(
            "Código numérico que compõe a Chave de Acesso.\nCódigo aleatório "
            "gerado pelo emitente, com o objetivo de evitar acessos indevidos "
            "ao documento."
        ),
    )

    mdfe30_cDV = fields.Char(
        string="Digito verificador da chave de acesso",
        xsd_required=True,
        help=(
            "Digito verificador da chave de acesso do Manifesto\nInformar o "
            "dígito  de controle da chave de acesso do MDF-e, que deve ser "
            "calculado com a aplicação do algoritmo módulo 11 (base 2,9) da "
            "chave de acesso."
        ),
    )

    mdfe30_modal = fields.Selection(
        TMODALMD,
        string="Modalidade de transporte",
        xsd_required=True,
        xsd_type="TModalMD",
        help=(
            "Modalidade de transporte\n1 - Rodoviário;\n2 - Aéreo; 3 - "
            "Aquaviário; 4 - Ferroviário."
        ),
    )

    mdfe30_dhEmi = fields.Datetime(
        string="Data e hora de emissão do Manifesto",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=(
            "Data e hora de emissão do Manifesto\nFormato AAAA-MM-DDTHH:MM:DD " "TZD"
        ),
    )

    mdfe30_tpEmis = fields.Selection(
        IDE_TPEMIS,
        string="Forma de emissão do Manifesto",
        xsd_required=True,
        help=(
            "Forma de emissão do Manifesto\n1 - Normal\n; 2 - Contingência; "
            "3-Regime Especial NFF"
        ),
    )

    mdfe30_procEmi = fields.Selection(
        TPROCEMI,
        string="Identificação do processo de emissão",
        xsd_required=True,
        help=(
            "Identificação do processo de emissão do Manifesto\n0 - emissão de"
            " MDF-e com aplicativo do contribuinte"
        ),
    )

    mdfe30_verProc = fields.Char(
        string="Versão do processo de emissão",
        xsd_required=True,
        help=(
            "Versão do processo de emissão\nInformar a versão do aplicativo "
            "emissor de MDF-e."
        ),
    )

    mdfe30_UFIni = fields.Selection(
        TUF,
        string="Sigla da UF do Carregamento",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "Sigla da UF do Carregamento\nUtilizar a Tabela do IBGE de código "
            "de unidades da federação.\nInformar 'EX' para operações com o "
            "exterior."
        ),
    )

    mdfe30_UFFim = fields.Selection(
        TUF,
        string="Sigla da UF do Descarregamento",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "Sigla da UF do Descarregamento\nUtilizar a Tabela do IBGE de "
            "código de unidades da federação.\nInformar 'EX' para operações "
            "com o exterior."
        ),
    )

    mdfe30_infMunCarrega = fields.One2many(
        "mdfe.30.infmuncarrega",
        "mdfe30_infMunCarrega_ide_id",
        string="Informações dos Municípios",
        help="Informações dos Municípios de Carregamento",
    )

    mdfe30_infPercurso = fields.One2many(
        "mdfe.30.infpercurso",
        "mdfe30_infPercurso_ide_id",
        string="Informações do Percurso do MDF-e",
    )

    mdfe30_dhIniViagem = fields.Datetime(
        string="Data e hora previstos de inicio",
        xsd_type="TDateTimeUTC",
        help=(
            "Data e hora previstos de inicio da viagem\nFormato AAAA-MM-"
            "DDTHH:MM:DD TZD"
        ),
    )

    mdfe30_indCanalVerde = fields.Selection(
        IDE_INDCANALVERDE, string="Indicador de participação do Canal Verde"
    )

    mdfe30_indCarregaPosterior = fields.Selection(
        IDE_INDCARREGAPOSTERIOR,
        string="Indicador de MDF-e com inclusão",
        help=(
            "Indicador de MDF-e com inclusão da Carga posterior a emissão por "
            "evento de inclusão de DF-e"
        ),
    )


class InfMunCarrega(models.AbstractModel):
    "Informações dos Municípios de Carregamento"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infmuncarrega"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.Ide.InfMunCarrega"

    mdfe30_infMunCarrega_ide_id = fields.Many2one(
        comodel_name="mdfe.30.ide", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_cMunCarrega = fields.Char(
        string="Código do Município de Carregamento",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
    )

    mdfe30_xMunCarrega = fields.Char(
        string="Nome do Município de Carregamento", xsd_required=True
    )


class InfPercurso(models.AbstractModel):
    "Informações do Percurso do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infpercurso"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.Ide.InfPercurso"

    mdfe30_infPercurso_ide_id = fields.Many2one(
        comodel_name="mdfe.30.ide", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_UFPer = fields.Selection(
        TUF,
        string="Sigla das Unidades da Federação",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "Sigla das Unidades da Federação do percurso do veículo.\nNão é "
            "necessário repetir as UF de Início e Fim"
        ),
    )


class Emit(models.AbstractModel):
    "Identificação do Emitente do Manifesto"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.emit"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.Emit"

    mdfe30_CNPJ = fields.Char(
        string="CNPJ do emitente",
        choice="emit",
        xsd_choice_required=True,
        xsd_type="TCnpj",
        help="CNPJ do emitente\nInformar zeros não significativos",
    )

    mdfe30_CPF = fields.Char(
        string="CPF do emitente",
        choice="emit",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help=(
            "CPF do emitente\nInformar zeros não significativos.\n\nUsar com "
            "série específica 920-969 para emitente pessoa física com "
            "inscrição estadual.\nPoderá ser usado também para emissão do "
            "Regime Especial da Nota Fiscal Fácil"
        ),
    )

    mdfe30_IE = fields.Char(string="Inscrição Estadual do emitemte")

    mdfe30_xNome = fields.Char(
        string="Razão social ou Nome do emitente", xsd_required=True
    )

    mdfe30_xFant = fields.Char(string="Nome fantasia do emitente")

    mdfe30_enderEmit = fields.Many2one(
        comodel_name="mdfe.30.tendeemi",
        string="Endereço do emitente",
        xsd_required=True,
        xsd_type="TEndeEmi",
    )


class InfModal(models.AbstractModel):
    "Informações do modal"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infmodal"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfModal"

    mdfe30_versaoModal = fields.Char(
        string="Versão do leiaute específico",
        xsd_required=True,
        help="Versão do leiaute específico para o Modal",
    )


class TmdfeInfDoc(models.AbstractModel):
    "Informações dos Documentos fiscais vinculados ao manifesto"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tmdfe_infdoc"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfDoc"

    mdfe30_infMunDescarga = fields.One2many(
        "mdfe.30.infmundescarga",
        "mdfe30_infMunDescarga_infDoc_id",
        string="Informações dos Municípios",
        help="Informações dos Municípios de descarregamento",
    )


class InfMunDescarga(models.AbstractModel):
    "Informações dos Municípios de descarregamento"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infmundescarga"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfDoc.InfMunDescarga"

    mdfe30_infMunDescarga_infDoc_id = fields.Many2one(
        comodel_name="mdfe.30.tmdfe_infdoc", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_cMunDescarga = fields.Char(
        string="Código do Município de Descarregamento",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
    )

    mdfe30_xMunDescarga = fields.Char(
        string="Nome do Município de Descarregamento", xsd_required=True
    )

    mdfe30_infCTe = fields.One2many(
        "mdfe.30.infcte",
        "mdfe30_infCTe_infMunDescarga_id",
        string="Conhecimentos de Tranporte",
        help=(
            "Conhecimentos de Tranporte - usar este grupo quando for prestador"
            " de serviço de transporte"
        ),
    )

    mdfe30_infNFe = fields.One2many(
        "mdfe.30.tmdfe_infnfe",
        "mdfe30_infNFe_infMunDescarga_id",
        string="Nota Fiscal Eletronica",
    )

    mdfe30_infMDFeTransp = fields.One2many(
        "mdfe.30.infmdfetransp",
        "mdfe30_infMDFeTransp_infMunDescarga_id",
        string="Manifesto Eletrônico",
        help=(
            "Manifesto Eletrônico de Documentos Fiscais. Somente para modal "
            "Aquaviário (vide regras MOC)"
        ),
    )


class InfCte(models.AbstractModel):
    """Conhecimentos de Tranporte - usar este grupo quando for prestador de
    serviço de transporte"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infcte"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfDoc.InfMunDescarga.InfCte"

    mdfe30_infCTe_infMunDescarga_id = fields.Many2one(
        comodel_name="mdfe.30.infmundescarga", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_chCTe = fields.Char(
        string="Conhecimento Eletrônico",
        xsd_required=True,
        xsd_type="TChCTe",
        help="Conhecimento Eletrônico - Chave de Acesso",
    )

    mdfe30_SegCodBarra = fields.Char(
        string="Segundo código de barras", xsd_type="TSegCodBarra"
    )

    mdfe30_indReentrega = fields.Selection(
        INFCTE_INDREENTREGA, string="Indicador de Reentrega"
    )

    mdfe30_infUnidTransp = fields.One2many(
        "mdfe.30.tunidadetransp",
        "mdfe30_infUnidTransp_infCTe_id",
        string="Informações das Unidades de Transporte",
        xsd_type="TUnidadeTransp",
        help=(
            "Informações das Unidades de Transporte "
            "(Carreta/Reboque/Vagão)\nDeve ser preenchido com as informações "
            "das unidades de transporte utilizadas."
        ),
    )

    mdfe30_peri = fields.One2many(
        "mdfe.30.infcte_peri",
        "mdfe30_peri_infCTe_id",
        string="Preenchido quando for transporte",
        help=(
            "Preenchido quando for  transporte de produtos classificados pela "
            "ONU como perigosos."
        ),
    )

    mdfe30_infEntregaParcial = fields.Many2one(
        comodel_name="mdfe.30.infentregaparcial",
        string="Grupo de informações da Entrega Parcial",
        help="Grupo de informações da Entrega Parcial (Corte de Voo)",
    )


class InfCtePeri(models.AbstractModel):
    """Preenchido quando for transporte de produtos classificados pela ONU como
    perigosos."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infcte_peri"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfDoc.InfMunDescarga.InfCte.Peri"

    mdfe30_peri_infCTe_id = fields.Many2one(
        comodel_name="mdfe.30.infcte", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_nONU = fields.Char(
        string="Número ONU/UN",
        xsd_required=True,
        help=(
            "Número ONU/UN\nVer a legislação de transporte de produtos "
            "perigosos aplicadas ao modal"
        ),
    )

    mdfe30_xNomeAE = fields.Char(
        string="Nome apropriado para embarque do produto",
        help=(
            "Nome apropriado para embarque do produto\nVer a legislação de "
            "transporte de produtos perigosos aplicada ao modo de transporte"
        ),
    )

    mdfe30_xClaRisco = fields.Char(
        string="Classe ou subclasse/divisão",
        help=(
            "Classe ou subclasse/divisão, e risco subsidiário/risco "
            "secundário\nVer a legislação de transporte de produtos perigosos "
            "aplicadas ao modal"
        ),
    )

    mdfe30_grEmb = fields.Char(
        string="Grupo de Embalagem",
        help=(
            "Grupo de Embalagem\nVer a legislação de transporte de produtos "
            "perigosos aplicadas ao "
            "modal\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPreenchimento obrigatório "
            "para o modal aéreo.\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tA legislação "
            "para o modal rodoviário e ferroviário não atribui grupo de "
            "embalagem para todos os produtos, portanto haverá casos de não "
            "preenchimento desse campo."
        ),
    )

    mdfe30_qTotProd = fields.Char(
        string="Quantidade total por produto",
        xsd_required=True,
        help=(
            "Quantidade total por produto\nPreencher conforme a legislação de "
            "transporte de produtos perigosos aplicada ao modal"
        ),
    )

    mdfe30_qVolTipo = fields.Char(
        string="Quantidade e Tipo de volumes",
        help=(
            "Quantidade e Tipo de volumes\nPreencher conforme a legislação de "
            "transporte de produtos perigosos aplicada ao modal"
        ),
    )


class InfEntregaParcial(models.AbstractModel):
    "Grupo de informações da Entrega Parcial (Corte de Voo)"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infentregaparcial"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfDoc.InfMunDescarga.InfCte.InfEntregaParcial"

    mdfe30_qtdTotal = fields.Float(
        string="Quantidade total de volumes",
        xsd_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
    )

    mdfe30_qtdParcial = fields.Float(
        string="Quantidade de volumes enviados no MDF-e",
        xsd_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
    )


class TmdfeInfNfe(models.AbstractModel):
    "Nota Fiscal Eletronica"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tmdfe_infnfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfDoc.InfMunDescarga.InfNfe"

    mdfe30_infNFe_infMunDescarga_id = fields.Many2one(
        comodel_name="mdfe.30.infmundescarga", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_chNFe = fields.Char(
        string="Nota Fiscal Eletrônica", xsd_required=True, xsd_type="TChNFe"
    )

    mdfe30_SegCodBarra = fields.Char(
        string="Segundo código de barras", xsd_type="TSegCodBarra"
    )

    mdfe30_indReentrega = fields.Selection(
        INFNFE_INDREENTREGA, string="Indicador de Reentrega"
    )

    mdfe30_infUnidTransp = fields.One2many(
        "mdfe.30.tunidadetransp",
        "mdfe30_infUnidTransp_infNFe_id",
        string="Informações das Unidades de Transporte",
        xsd_type="TUnidadeTransp",
        help=(
            "Informações das Unidades de Transporte "
            "(Carreta/Reboque/Vagão)\nDeve ser preenchido com as informações "
            "das unidades de transporte utilizadas."
        ),
    )

    mdfe30_peri = fields.One2many(
        "mdfe.30.infnfe_peri",
        "mdfe30_peri_infNFe_id",
        string="Preenchido quando for transporte",
        help=(
            "Preenchido quando for  transporte de produtos classificados pela "
            "ONU como perigosos."
        ),
    )


class InfNfePeri(models.AbstractModel):
    """Preenchido quando for transporte de produtos classificados pela ONU como
    perigosos."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infnfe_peri"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfDoc.InfMunDescarga.InfNfe.Peri"

    mdfe30_peri_infNFe_id = fields.Many2one(
        comodel_name="mdfe.30.tmdfe_infnfe", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_nONU = fields.Char(
        string="Número ONU/UN",
        xsd_required=True,
        help=(
            "Número ONU/UN\nVer a legislação de transporte de produtos "
            "perigosos aplicadas ao modal"
        ),
    )

    mdfe30_xNomeAE = fields.Char(
        string="Nome apropriado para embarque do produto",
        help=(
            "Nome apropriado para embarque do produto\nVer a legislação de "
            "transporte de produtos perigosos aplicada ao modo de transporte"
        ),
    )

    mdfe30_xClaRisco = fields.Char(
        string="Classe ou subclasse/divisão",
        help=(
            "Classe ou subclasse/divisão, e risco subsidiário/risco "
            "secundário\nVer a legislação de transporte de produtos perigosos "
            "aplicadas ao modal"
        ),
    )

    mdfe30_grEmb = fields.Char(
        string="Grupo de Embalagem",
        help=(
            "Grupo de Embalagem\nVer a legislação de transporte de produtos "
            "perigosos aplicadas ao "
            "modal\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPreenchimento obrigatório "
            "para o modal aéreo.\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tA legislação "
            "para o modal rodoviário e ferroviário não atribui grupo de "
            "embalagem para todos os produtos, portanto haverá casos de não "
            "preenchimento desse campo."
        ),
    )

    mdfe30_qTotProd = fields.Char(
        string="Quantidade total por produto",
        xsd_required=True,
        help=(
            "Quantidade total por produto\nPreencher conforme a legislação de "
            "transporte de produtos perigosos aplicada ao modal"
        ),
    )

    mdfe30_qVolTipo = fields.Char(
        string="Quantidade e Tipo de volumes",
        help=(
            "Quantidade e Tipo de volumes\nPreencher conforme a legislação de "
            "transporte de produtos perigosos aplicada ao modal"
        ),
    )


class InfMdfeTransp(models.AbstractModel):
    """Manifesto Eletrônico de Documentos Fiscais. Somente para modal
    Aquaviário (vide regras MOC)"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infmdfetransp"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfDoc.InfMunDescarga.InfMdfeTransp"

    mdfe30_infMDFeTransp_infMunDescarga_id = fields.Many2one(
        comodel_name="mdfe.30.infmundescarga", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_chMDFe = fields.Char(
        string="Manifesto Eletrônico",
        xsd_required=True,
        xsd_type="TChNFe",
        help="Manifesto Eletrônico de Documentos Fiscais",
    )

    mdfe30_indReentrega = fields.Selection(
        INFMDFETRANSP_INDREENTREGA, string="Indicador de Reentrega"
    )

    mdfe30_infUnidTransp = fields.One2many(
        "mdfe.30.tunidadetransp",
        "mdfe30_infUnidTransp_infMDFeTransp_id",
        string="Informações das Unidades de Transporte",
        xsd_type="TUnidadeTransp",
        help=(
            "Informações das Unidades de Transporte "
            "(Carreta/Reboque/Vagão)\nDispositivo de carga utilizada (Unit "
            "Load Device - ULD) significa todo tipo de contêiner de carga, "
            "vagão, contêiner de avião, palete de aeronave com rede ou palete "
            "de aeronave com rede sobre um iglu."
        ),
    )

    mdfe30_peri = fields.One2many(
        "mdfe.30.infmdfetransp_peri",
        "mdfe30_peri_infMDFeTransp_id",
        string="Preenchido quando for transporte",
        help=(
            "Preenchido quando for  transporte de produtos classificados pela "
            "ONU como perigosos."
        ),
    )


class InfMdfeTranspPeri(models.AbstractModel):
    """Preenchido quando for transporte de produtos classificados pela ONU como
    perigosos."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infmdfetransp_peri"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfDoc.InfMunDescarga.InfMdfeTransp.Peri"

    mdfe30_peri_infMDFeTransp_id = fields.Many2one(
        comodel_name="mdfe.30.infmdfetransp", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_nONU = fields.Char(
        string="Número ONU/UN",
        xsd_required=True,
        help=(
            "Número ONU/UN\nVer a legislação de transporte de produtos "
            "perigosos aplicadas ao modal"
        ),
    )

    mdfe30_xNomeAE = fields.Char(
        string="Nome apropriado para embarque do produto",
        help=(
            "Nome apropriado para embarque do produto\nVer a legislação de "
            "transporte de produtos perigosos aplicada ao modo de transporte"
        ),
    )

    mdfe30_xClaRisco = fields.Char(
        string="Classe ou subclasse/divisão",
        help=(
            "Classe ou subclasse/divisão, e risco subsidiário/risco "
            "secundário\nVer a legislação de transporte de produtos perigosos "
            "aplicadas ao modal"
        ),
    )

    mdfe30_grEmb = fields.Char(
        string="Grupo de Embalagem",
        help=(
            "Grupo de Embalagem\nVer a legislação de transporte de produtos "
            "perigosos aplicadas ao "
            "modal\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPreenchimento obrigatório "
            "para o modal aéreo.\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tA legislação "
            "para o modal rodoviário e ferroviário não atribui grupo de "
            "embalagem para todos os produtos, portanto haverá casos de não "
            "preenchimento desse campo."
        ),
    )

    mdfe30_qTotProd = fields.Char(
        string="Quantidade total por produto",
        xsd_required=True,
        help=(
            "Quantidade total por produto\nPreencher conforme a legislação de "
            "transporte de produtos perigosos aplicada ao modal"
        ),
    )

    mdfe30_qVolTipo = fields.Char(
        string="Quantidade e Tipo de volumes",
        help=(
            "Quantidade e Tipo de volumes\nPreencher conforme a legislação de "
            "transporte de produtos perigosos aplicada ao modal"
        ),
    )


class Seg(models.AbstractModel):
    "Informações de Seguro da Carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.seg"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.Seg"

    mdfe30_seg_infMDFe_id = fields.Many2one(
        comodel_name="mdfe.30.tmdfe_infmdfe", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_infResp = fields.Many2one(
        comodel_name="mdfe.30.infresp",
        string="Informações do responsável pelo seguro",
        xsd_required=True,
        help="Informações do responsável pelo seguro da carga",
    )

    mdfe30_infSeg = fields.Many2one(
        comodel_name="mdfe.30.infseg", string="Informações da seguradora"
    )

    mdfe30_nApol = fields.Char(
        string="Número da Apólice",
        help="Número da Apólice\nObrigatório pela lei 11.442/07 (RCTRC)",
    )

    mdfe30_nAver = fields.Char(
        string="Número da Averbação",
        help="Número da Averbação\nInformar as averbações do seguro",
    )


class InfResp(models.AbstractModel):
    "Informações do responsável pelo seguro da carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infresp"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.Seg.InfResp"

    mdfe30_respSeg = fields.Selection(
        INFRESP_RESPSEG,
        string="Responsável pelo seguro",
        xsd_required=True,
        help=(
            "Responsável pelo seguro\nPreencher "
            "com:\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1- Emitente do MDF-e;\n\n22 -"
            " Responsável pela contratação do serviço de transporte "
            "(contratante)\t\n\n\nDados obrigatórios apenas no modal "
            "Rodoviário, depois da lei 11.442/07. Para os demais modais esta "
            "informação é opcional."
        ),
    )

    mdfe30_CNPJ = fields.Char(
        string="Número do CNPJ do responsável",
        choice="infresp",
        xsd_type="TCnpj",
        help=(
            "Número do CNPJ do responsável pelo seguro\nObrigatório apenas se "
            "responsável pelo seguro for (2) responsável pela contratação do "
            "transporte - pessoa jurídica"
        ),
    )

    mdfe30_CPF = fields.Char(
        string="Número do CPF do responsável pelo seguro",
        choice="infresp",
        xsd_type="TCpf",
        help=(
            "Número do CPF do responsável pelo seguro\nObrigatório apenas se "
            "responsável pelo seguro for (2) responsável pela contratação do "
            "transporte - pessoa física"
        ),
    )


class InfSeg(models.AbstractModel):
    "Informações da seguradora"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infseg"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.Seg.InfSeg"

    mdfe30_xSeg = fields.Char(string="Nome da Seguradora", xsd_required=True)

    mdfe30_CNPJ = fields.Char(
        string="Número do CNPJ da seguradora",
        xsd_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ da seguradora\nObrigatório apenas se responsável "
            "pelo seguro for (2) responsável pela contratação do transporte - "
            "pessoa jurídica"
        ),
    )


class ProdPred(models.AbstractModel):
    """Produto predominante
    Informar a descrição do produto predominante"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.prodpred"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.ProdPred"

    mdfe30_tpCarga = fields.Selection(
        PRODPRED_TPCARGA,
        string="Tipo de Carga",
        xsd_required=True,
        help=(
            "Tipo de Carga\nConforme Resolução ANTT nº.  "
            "5.849/2019.\n\n01-Granel sólido;\n02-Granel "
            "líquido;\n03-Frigorificada;\n04-Conteinerizada;\n05-Carga "
            "Geral;\n06-Neogranel;\n07-Perigosa (granel sólido);\n08-Perigosa "
            "(granel líquido);\n09-Perigosa (carga "
            "frigorificada);\n10-Perigosa (conteinerizada);\n11-Perigosa "
            "(carga geral)."
        ),
    )

    mdfe30_xProd = fields.Char(string="Descrição do produto", xsd_required=True)

    mdfe30_cEAN = fields.Char(
        string="GTIN",
        help=(
            "GTIN (Global Trade Item Number) do produto, antigo código EAN ou "
            "código de barras"
        ),
    )

    mdfe30_NCM = fields.Char(string="Código NCM")

    mdfe30_infLotacao = fields.Many2one(
        comodel_name="mdfe.30.inflotacao",
        string="Informações da carga lotação",
        help=(
            "Informações da carga lotação. Informar somente quando MDF-e for "
            "de carga lotação"
        ),
    )


class InfLotacao(models.AbstractModel):
    """Informações da carga lotação. Informar somente quando MDF-e for de carga
    lotação"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.inflotacao"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.ProdPred.InfLotacao"

    mdfe30_infLocalCarrega = fields.Many2one(
        comodel_name="mdfe.30.inflocalcarrega",
        string="Informações da localização",
        xsd_required=True,
        help=(
            "Informações da localização de carregamento do MDF-e de carga " "lotação"
        ),
    )

    mdfe30_infLocalDescarrega = fields.Many2one(
        comodel_name="mdfe.30.inflocaldescarrega",
        string="infLocalDescarrega",
        xsd_required=True,
        help=(
            "Informações da localização de descarregamento do MDF-e de carga " "lotação"
        ),
    )


class InfLocalCarrega(models.AbstractModel):
    """Informações da localização de carregamento do MDF-e de carga lotação"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.inflocalcarrega"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.ProdPred.InfLotacao.InfLocalCarrega"

    mdfe30_CEP = fields.Char(
        string="CEP onde foi carregado o MDF-e",
        choice="inflocalcarrega",
        xsd_choice_required=True,
        help=("CEP onde foi carregado o MDF-e\nInformar zeros não significativos"),
    )

    mdfe30_latitude = fields.Char(
        string="Latitude do ponto geográfico onde",
        choice="inflocalcarrega",
        xsd_choice_required=True,
        xsd_type="TLatitude",
        help="Latitude do ponto geográfico onde foi carregado o MDF-e",
    )

    mdfe30_longitude = fields.Char(
        string="longitude",
        choice="inflocalcarrega",
        xsd_choice_required=True,
        xsd_type="TLongitude",
        help="Latitude do ponto geográfico onde foi carregado o MDF-e",
    )


class InfLocalDescarrega(models.AbstractModel):
    """Informações da localização de descarregamento do MDF-e de carga
    lotação"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.inflocaldescarrega"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.ProdPred.InfLotacao.InfLocalDescarrega"

    mdfe30_CEP = fields.Char(
        string="CEP onde foi descarregado o MDF-e",
        choice="inflocaldescarrega",
        xsd_choice_required=True,
        help=(
            "CEP onde foi descarregado o MDF-e\nInformar zeros não " "significativos"
        ),
    )

    mdfe30_latitude = fields.Char(
        string="Latitude do ponto geográfico onde",
        choice="inflocaldescarrega",
        xsd_choice_required=True,
        xsd_type="TLatitude",
        help="Latitude do ponto geográfico onde foi descarregado o MDF-e",
    )

    mdfe30_longitude = fields.Char(
        string="longitude",
        choice="inflocaldescarrega",
        xsd_choice_required=True,
        xsd_type="TLongitude",
        help="Latitude do ponto geográfico onde foi descarregado o MDF-e",
    )


class Tot(models.AbstractModel):
    "Totalizadores da carga transportada e seus documentos fiscais"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tot"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.Tot"

    mdfe30_qCTe = fields.Char(
        string="Quantidade total de CT-e relacionados",
        help="Quantidade total de CT-e relacionados no Manifesto",
    )

    mdfe30_qNFe = fields.Char(
        string="Quantidade total de NF-e relacionadas",
        help="Quantidade total de NF-e relacionadas no Manifesto",
    )

    mdfe30_qMDFe = fields.Char(
        string="Quantidade total de MDF-e relacionados",
        help=("Quantidade total de MDF-e relacionados no Manifesto Aquaviário"),
    )

    mdfe30_vCarga = fields.Monetary(
        string="Valor total",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor total da carga / mercadorias transportadas",
    )

    mdfe30_cUnid = fields.Selection(
        TOT_CUNID,
        string="Código da unidade de medida",
        xsd_required=True,
        help=(
            "Código da unidade de medida do Peso Bruto da Carga / Mercadorias "
            "transportadas\n01 – KG;  02 - TON"
        ),
    )

    mdfe30_qCarga = fields.Float(
        string="Peso Bruto Total",
        xsd_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
        help="Peso Bruto Total da Carga / Mercadorias transportadas",
    )


class Lacres(models.AbstractModel):
    """Lacres do MDF-e
    Preechimento opcional para os modais Rodoviário e Ferroviário"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.lacres"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.Lacres"

    mdfe30_lacres_infMDFe_id = fields.Many2one(
        comodel_name="mdfe.30.tmdfe_infmdfe", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_nLacre = fields.Char(string="número do lacre", xsd_required=True)


class AutXml(models.AbstractModel):
    """Autorizados para download do XML do DF-e
    Informar CNPJ ou CPF. Preencher os zeros não significativos."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.autxml"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.AutXml"

    mdfe30_autXML_infMDFe_id = fields.Many2one(
        comodel_name="mdfe.30.tmdfe_infmdfe", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_CNPJ = fields.Char(
        string="CNPJ do autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCnpj",
        help="CNPJ do autorizado\nInformar zeros não significativos",
    )

    mdfe30_CPF = fields.Char(
        string="CPF do autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="CPF do autorizado\nInformar zeros não significativos",
    )


class InfAdic(models.AbstractModel):
    "Informações Adicionais"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infadic"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfAdic"

    mdfe30_infAdFisco = fields.Char(
        string="Informações adicionais de interesse",
        help=(
            "Informações adicionais de interesse do Fisco\nNorma referenciada,"
            " informações complementares, etc"
        ),
    )

    mdfe30_infCpl = fields.Char(
        string="Informações complementares de interesse",
        help="Informações complementares de interesse do Contribuinte",
    )


class InfSolicNff(models.AbstractModel):
    "Grupo de informações do pedido de emissão da Nota Fiscal Fácil"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infsolicnff"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfe.InfSolicNff"

    mdfe30_xSolic = fields.Char(
        string="Solicitação do pedido de emissão da NFF",
        xsd_required=True,
        help=(
            "Solicitação do pedido de emissão da NFF.\nSerá preenchido com a "
            "totalidade de campos informados no aplicativo emissor "
            "serializado."
        ),
    )


class InfMdfeSupl(models.AbstractModel):
    "Informações suplementares do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infmdfesupl"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tmdfe.InfMdfeSupl"

    mdfe30_qrCodMDFe = fields.Char(
        string="Texto com o QR-Code para consulta",
        xsd_required=True,
        help="Texto com o QR-Code para consulta do MDF-e",
    )


class TenviMdfe(models.AbstractModel):
    "Tipo Pedido de Autorização Assíncrona de MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tenvimdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TenviMdfe"

    mdfe30_idLote = fields.Char(string="idLote", xsd_required=True, xsd_type="TIdLote")

    mdfe30_MDFe = fields.Many2one(
        comodel_name="mdfe.30.tmdfe", string="MDFe", xsd_required=True, xsd_type="TMDFe"
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerMDe")
