# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_geral_mdfe_v3_00 import (
    TAMB,
    TCORGAOIBGE,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"


class Tevento(models.AbstractModel):
    "Tipo Evento"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tevento"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tevento"

    mdfe30_infEvento = fields.Many2one(
        comodel_name="mdfe.30.tevento_infevento", string="infEvento", xsd_required=True
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerEvento"
    )


class TeventoInfEvento(models.AbstractModel):
    _description = "infEvento"
    _name = "mdfe.30.tevento_infevento"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tevento.InfEvento"

    mdfe30_cOrgao = fields.Selection(
        TCORGAOIBGE,
        string="Código do órgão de recepção do Evento",
        xsd_required=True,
        xsd_type="TCOrgaoIBGE",
        help=(
            "Código do órgão de recepção do Evento. Utilizar a Tabela do IBGE "
            "extendida, utilizar 90 para identificar SUFRAMA, 91 para RFB, 92 "
            "para BackOffice BRId e 93 para ONE"
        ),
    )

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_CNPJ = fields.Char(
        string="CNPJ do autor",
        choice="infevento",
        xsd_choice_required=True,
        xsd_type="TCnpj",
        help="CNPJ do autor\nInformar zeros não significativos",
    )

    mdfe30_CPF = fields.Char(
        string="CPF do Autor",
        choice="infevento",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help=(
            "CPF do Autor\nInformar zeros não significativos. \nUsar com serie"
            " específica 920-969 para emitente pessoa física com inscrição "
            "estadual, ou para emissor TAC do Regime Especial da Nota Fiscal "
            "Fácil"
        ),
    )

    mdfe30_chMDFe = fields.Char(
        string="Chave de Acesso do MDF-e vinculado",
        xsd_required=True,
        xsd_type="TChMDFe",
        help="Chave de Acesso do MDF-e vinculado ao evento",
    )

    mdfe30_dhEvento = fields.Datetime(
        string="Data e Hora do Evento",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help="Data e Hora do Evento, formato AAAA-MM-DDThh:mm:ss TZD",
    )

    mdfe30_tpEvento = fields.Char(
        string="Tipo do Evento",
        xsd_required=True,
        xsd_type="xs:string",
        help=(
            "Tipo do Evento:\n110111 - Cancelamento\n110112 - "
            "Encerramento\n110114 - Inclusão de Condutor\n310620 - Registro de"
            " Passagem\n510620 - Registro de Passagem BRId"
        ),
    )

    mdfe30_nSeqEvento = fields.Char(
        string="Seqüencial do evento para o mesmo tipo",
        xsd_required=True,
        help=(
            "Seqüencial do evento para o mesmo tipo de evento.  Para maioria "
            "dos eventos será 1, nos casos em que possa existir mais de um "
            "evento o autor do evento deve numerar de forma seqüencial."
        ),
    )

    mdfe30_detEvento = fields.Many2one(
        comodel_name="mdfe.30.detevento",
        string="Detalhamento do evento específico",
        xsd_required=True,
    )

    mdfe30_Id = fields.Char(
        string="Identificador da TAG a ser assinada",
        xsd_required=True,
        help=(
            "Identificador da TAG a ser assinada, a regra de formação do Id "
            "é:\n“ID” + tpEvento +  chave do MDF-e + nSeqEvento"
        ),
    )


class DetEvento(models.AbstractModel):
    "Detalhamento do evento específico"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.detevento"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Tevento.InfEvento.DetEvento"

    mdfe30_versaoEvento = fields.Char(
        string="versaoEvento", xsd_required=True, xsd_type="TVerEvento"
    )


class TretEvento(models.AbstractModel):
    "Tipo retorno do Evento"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tretevento"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretEvento"

    mdfe30_infEvento = fields.Many2one(
        comodel_name="mdfe.30.tretevento_infevento",
        string="infEvento",
        xsd_required=True,
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerEvento"
    )


class TretEventoInfEvento(models.AbstractModel):
    _description = "infEvento"
    _name = "mdfe.30.tretevento_infevento"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretEvento.InfEvento"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que recebeu",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que recebeu o Evento",
    )

    mdfe30_cOrgao = fields.Selection(
        TCORGAOIBGE,
        string="Código do órgão de recepção do Evento",
        xsd_required=True,
        xsd_type="TCOrgaoIBGE",
        help=(
            "Código do órgão de recepção do Evento. Utilizar a Tabela do IBGE "
            "extendida, utilizar 90 para identificar SUFRAMA, 91 RFB, 92 "
            "BackOffice BRId e 93 ONE"
        ),
    )

    mdfe30_cStat = fields.Char(
        string="Código do status da registro do Evento",
        xsd_required=True,
        xsd_type="TStat",
    )

    mdfe30_xMotivo = fields.Char(
        string="Descrição literal do status do registro",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do registro do Evento",
    )

    mdfe30_chMDFe = fields.Char(
        string="Chave de Acesso MDF-e vinculado", xsd_type="TChMDFe"
    )

    mdfe30_tpEvento = fields.Char(
        string="Tipo do Evento vinculado", xsd_type="xs:string"
    )

    mdfe30_xEvento = fields.Char(string="Descrição do Evento")

    mdfe30_nSeqEvento = fields.Char(string="Seqüencial do evento")

    mdfe30_dhRegEvento = fields.Datetime(
        string="Data e Hora de do recebimento",
        xsd_type="TDateTimeUTC",
        help=(
            "Data e Hora de do recebimento do evento ou do registro do evento "
            "formato AAAA-MM-DDThh:mm:ss TZD"
        ),
    )

    mdfe30_nProt = fields.Char(
        string="Número do protocolo de registro",
        xsd_type="TProt",
        help="Número do protocolo de registro do evento",
    )

    mdfe30_Id = fields.Char(string="Id")


class TprocEvento(models.AbstractModel):
    "Tipo procEvento"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tprocevento"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TprocEvento"

    mdfe30_eventoMDFe = fields.Many2one(
        comodel_name="mdfe.30.tevento",
        string="eventoMDFe",
        xsd_required=True,
        xsd_type="TEvento",
    )

    mdfe30_retEventoMDFe = fields.Many2one(
        comodel_name="mdfe.30.tretevento",
        string="retEventoMDFe",
        xsd_required=True,
        xsd_type="TRetEvento",
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerEvento"
    )

    mdfe30_ipTransmissor = fields.Char(
        string="IP do transmissor",
        xsd_type="TIPv4",
        help=("IP do transmissor do documento fiscal para o ambiente autorizador"),
    )

    mdfe30_nPortaCon = fields.Char(
        string="Porta de origem utilizada na conexão",
        help="Porta de origem utilizada na conexão (De 0 a 65535)",
    )

    mdfe30_dhConexao = fields.Datetime(
        string="Data e Hora da Conexão de Origem", xsd_type="TDateTimeUTC"
    )
