# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"

"Descrição do Evento - “Inclusão DF-e”"
EVINCDFEMDFE_DESCEVENTO = [
    ("Inclusão DF-e", "Inclusão DF-e"),
    ("Inclusao DF-e", "Inclusao DF-e"),
]


class EvIncDfeMdfe(models.AbstractModel):
    """Schema XML de validação do evento de inclusão de DFe
    110115"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.evincdfemdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "EvIncDfeMdfe"

    mdfe30_descEvento = fields.Selection(
        EVINCDFEMDFE_DESCEVENTO,
        string="Descrição do Evento",
        xsd_required=True,
        help="Descrição do Evento - “Inclusão DF-e”",
    )

    mdfe30_nProt = fields.Char(
        string="Número do Protocolo de Status do MDF-e",
        xsd_required=True,
        xsd_type="TProt",
        help=(
            "Número do Protocolo de Status do MDF-e. \n1 posição tipo de "
            "autorizador (9 - SEFAZ Nacional ); \n2 posições ano;\n10 "
            "seqüencial no ano."
        ),
    )

    mdfe30_cMunCarrega = fields.Char(
        string="Código do Município de Carregamento",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
    )

    mdfe30_xMunCarrega = fields.Char(
        string="Nome do Município de Carregamento", xsd_required=True
    )

    mdfe30_infDoc = fields.One2many(
        "mdfe.30.evincdfemdfe_infdoc",
        "mdfe30_infDoc_evIncDFeMDFe_id",
        string="Informações",
        help="Informações dos Documentos fiscais vinculados ao manifesto",
    )


class EvIncDfeMdfeInfDoc(models.AbstractModel):
    "Informações dos Documentos fiscais vinculados ao manifesto"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.evincdfemdfe_infdoc"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "EvIncDfeMdfe.InfDoc"

    mdfe30_infDoc_evIncDFeMDFe_id = fields.Many2one(
        comodel_name="mdfe.30.evincdfemdfe", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_cMunDescarga = fields.Char(
        string="Código do Município de Descarregamento",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
    )

    mdfe30_xMunDescarga = fields.Char(
        string="Nome do Município de Descarregamento", xsd_required=True
    )

    mdfe30_chNFe = fields.Char(
        string="Nota Fiscal Eletrônica", xsd_required=True, xsd_type="TChNFe"
    )
